/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.transform.count;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.controls.BasicACREvent;
import com.spss.java_client.ui.controls.BasicACRWidget;
import com.spss.java_client.ui.controls.FixedLengthDocument;
import com.spss.java_client.ui.controls.FixedLengthNumericDocument;
import com.spss.java_client.ui.controls.IBasicACRListener;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.StringTextField;
import com.spss.java_client.ui.dialogs.base.transform.count.CountDlg;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.uitools.controls.ContextEnabledTextField;
import com.spss.uitools.res.UIToolResUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class CountValuesWithinCases
extends BaseSubDialog
implements ItemListener,
DocumentListener,
IBasicACRListener,
FocusListener {
    static final String BASIC_ACR_WIDGET_KEY = "BASIC_ACR_WIDGET_KEY";
    static final String VALUE_SYSTEM_LIST_IDENTIFIER = "GroupOneIdentifier";
    static final String RANGE_LIST_IDENTIFIER = "GroupTwoIdentifier";
    private static final String SYSTEM_MISSING_STR = "SYSMIS";
    private static final String SYSTEM_OR_USER_MISSING_STR = "MISSING";
    private static final String LOWEST_THRU_STR = "Lowest thru ";
    private static final String THRU_HIGHEST_STR = " thru Highest";
    private static final String THRU_STR = " thru ";
    private static final String DEFAULT_TEXT = "";
    private JRadioButton mValueRadio;
    private JRadioButton mSystemMissingRadio;
    private JRadioButton mSystemOrUserMissingradio;
    private JRadioButton mRangeRadio;
    private JRadioButton mRangeLowestRadio;
    private JRadioButton mRangeHighestRadio;
    private SpssButtonGroup mRadioButtonGroup;
    private ContextEnabledTextField mValueText;
    private ContextEnabledTextField mRangeMinText;
    private ContextEnabledTextField mRangeMaxText;
    private ContextEnabledTextField mRangeLowestText;
    private JTextField mRangeHighestText;
    private JLabel mThroughLabel;
    private JLabel mValuesToCountLabel;
    private BasicACRWidget mBasicACRWidget;
    private LinkedList<String> mValueSystemList;
    private LinkedList<String> mRangeList;
    private boolean mInACREvent = false;

    CountValuesWithinCases(CountDlg countDlg) {
        super(countDlg, countDlg.getResString("IDS_COUNT_VALUES"), true);
    }

    @Override
    public String getDialogHelpID() {
        return "idh_coun_values";
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        boolean bl;
        Object object = itemEvent.getItem();
        boolean bl2 = bl = itemEvent.getStateChange() == 1;
        if (object.equals(this.mValueRadio)) {
            if (bl) {
                this.disableAllTextFields((JTextField)this.mValueText);
                this.mBasicACRWidget.setAddEnabled(false);
                this.mBasicACRWidget.setChangeEnabled(false);
                this.mBasicACRWidget.setRemoveEnabled(false);
            }
        } else if (object.equals(this.mSystemMissingRadio)) {
            if (bl) {
                this.disableAllTextFields();
                this.mBasicACRWidget.setAddEnabled(true);
                this.mBasicACRWidget.setChangeEnabled(this.mBasicACRWidget.getListSelectedIndex() != -1);
                this.mBasicACRWidget.setRemoveEnabled(false);
            }
        } else if (object.equals(this.mSystemOrUserMissingradio)) {
            if (bl) {
                this.disableAllTextFields();
                this.mBasicACRWidget.setAddEnabled(true);
                this.mBasicACRWidget.setChangeEnabled(this.mBasicACRWidget.getListSelectedIndex() != -1);
                this.mBasicACRWidget.setRemoveEnabled(false);
            }
        } else if (object.equals(this.mRangeRadio)) {
            if (bl) {
                this.disableAllTextFields((JTextField)this.mRangeMinText, (JTextField)this.mRangeMaxText);
                this.mThroughLabel.setEnabled(true);
                this.mBasicACRWidget.setAddEnabled(false);
                this.mBasicACRWidget.setChangeEnabled(false);
                this.mBasicACRWidget.setRemoveEnabled(false);
            }
        } else if (object.equals(this.mRangeLowestRadio)) {
            if (bl) {
                this.disableAllTextFields((JTextField)this.mRangeLowestText);
                this.mBasicACRWidget.setAddEnabled(false);
                this.mBasicACRWidget.setChangeEnabled(false);
                this.mBasicACRWidget.setRemoveEnabled(false);
            }
        } else if (object.equals(this.mRangeHighestRadio) && bl) {
            this.disableAllTextFields(this.mRangeHighestText);
            this.mBasicACRWidget.setAddEnabled(false);
            this.mBasicACRWidget.setChangeEnabled(false);
            this.mBasicACRWidget.setRemoveEnabled(false);
        }
        this.clearAllTextFields();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateAddChangeButton();
        this.mBasicACRWidget.setRemoveEnabled(false);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateAddChangeButton();
        this.mBasicACRWidget.setRemoveEnabled(false);
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public void acrEventOccured(BasicACREvent basicACREvent) {
        if (this.mInACREvent) {
            return;
        }
        this.mInACREvent = true;
        if (basicACREvent.getEventType() == BasicACREvent.EventType.addButtonPress) {
            if (!this.processAddButtonPress()) {
                this.mBasicACRWidget.setAddEnabled(false);
                this.mBasicACRWidget.setChangeEnabled(false);
                this.mBasicACRWidget.setRemoveEnabled(false);
                this.mBasicACRWidget.clearItemListSelection();
            }
        } else if (basicACREvent.getEventType() == BasicACREvent.EventType.changeButtonPress) {
            if (!this.processChangeButtonPress()) {
                this.mBasicACRWidget.setAddEnabled(false);
                this.mBasicACRWidget.setChangeEnabled(false);
                this.mBasicACRWidget.setRemoveEnabled(false);
            }
        } else if (basicACREvent.getEventType() == BasicACREvent.EventType.removeButtonPress) {
            this.processRemoveButtonPress();
            this.mBasicACRWidget.removeListItemAt(this.mBasicACRWidget.getListSelectedIndex());
            this.mBasicACRWidget.setRemoveEnabled(false);
        } else if (basicACREvent.getEventType() == BasicACREvent.EventType.listSelectionValueChange) {
            this.processListSelectionValueChange();
            this.mBasicACRWidget.setAddEnabled(false);
            this.mBasicACRWidget.setChangeEnabled(false);
            this.mBasicACRWidget.setRemoveEnabled(this.mBasicACRWidget.getList().getModel().getSize() > 0);
        }
        this.mInACREvent = false;
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource().equals(this.mValueText)) {
            this.mValueText.selectAll();
        } else if (focusEvent.getSource().equals(this.mRangeMinText)) {
            this.mRangeMinText.selectAll();
        } else if (focusEvent.getSource().equals(this.mRangeMaxText)) {
            this.mRangeMaxText.selectAll();
        } else if (focusEvent.getSource().equals(this.mRangeLowestText)) {
            this.mRangeLowestText.selectAll();
        } else if (focusEvent.getSource().equals(this.mRangeHighestText)) {
            this.mRangeHighestText.selectAll();
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public boolean continuePressed() {
        boolean bl = true;
        if ((this.mBasicACRWidget.isAddEnabled() || this.mBasicACRWidget.isChangeEnabled()) && 0 != SpssAlertOptionPane.showConfirmDialog((Window)((Object)this), this.getResString("ERR_COUNT_WARNING_PENDING_OPERATION_LOST"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eInformation, SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION)) {
            bl = false;
        }
        return bl;
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        super.loadState(dialogDataModel);
        if (!((CountDlg)this.mParentDlg).getClearValuesToCountList()) {
            Object[] objectArray = dialogDataModel.getArray(VALUE_SYSTEM_LIST_IDENTIFIER);
            Object[] objectArray2 = dialogDataModel.getArray(RANGE_LIST_IDENTIFIER);
            if (objectArray != null) {
                for (Object object : objectArray) {
                    this.mValueSystemList.add((String)object);
                }
            }
            if (objectArray2 != null) {
                for (Object object : objectArray2) {
                    this.mRangeList.add((String)object);
                }
            }
        }
        this.setDefaults();
    }

    @Override
    protected boolean saveState(DialogDataModel dialogDataModel) {
        dialogDataModel.putArray(VALUE_SYSTEM_LIST_IDENTIFIER, this.mValueSystemList.toArray());
        dialogDataModel.putArray(RANGE_LIST_IDENTIFIER, this.mRangeList.toArray());
        return super.saveState(dialogDataModel);
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefaults();
        JPanel jPanel = this.getViewPanel();
        JPanel jPanel2 = this.setupValuePanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, null);
        JPanel jPanel3 = this.setupACRPanel();
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        Insets insets = new Insets(0, DialogUtil.getComponentGroupGap(), 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 1, 0, 1, 1, n, insets);
        this.setFocusTraversalPolicy();
        this.pack();
    }

    private void disableAllTextFields() {
        this.mValueText.setEnabled(false);
        this.mValueText.setOpaque(false);
        this.mRangeMinText.setEnabled(false);
        this.mRangeMinText.setOpaque(false);
        this.mThroughLabel.setEnabled(false);
        this.mRangeMaxText.setEnabled(false);
        this.mRangeMaxText.setOpaque(false);
        this.mRangeLowestText.setEnabled(false);
        this.mRangeLowestText.setOpaque(false);
        this.mRangeHighestText.setEnabled(false);
        this.mRangeHighestText.setOpaque(false);
    }

    private void disableAllTextFields(JTextField jTextField) {
        this.mValueText.setEnabled(false);
        this.mValueText.setOpaque(false);
        this.mRangeMinText.setEnabled(false);
        this.mRangeMinText.setOpaque(false);
        this.mThroughLabel.setEnabled(false);
        this.mRangeMaxText.setEnabled(false);
        this.mRangeMaxText.setOpaque(false);
        this.mRangeLowestText.setEnabled(false);
        this.mRangeLowestText.setOpaque(false);
        this.mRangeHighestText.setEnabled(false);
        this.mRangeHighestText.setOpaque(false);
        jTextField.setEnabled(true);
        jTextField.setOpaque(true);
    }

    private void disableAllTextFields(JTextField jTextField, JTextField jTextField2) {
        this.mValueText.setEnabled(false);
        this.mValueText.setOpaque(false);
        jTextField.setEnabled(true);
        jTextField.setOpaque(true);
        jTextField2.setEnabled(true);
        jTextField2.setOpaque(true);
        this.mRangeLowestText.setEnabled(false);
        this.mRangeLowestText.setOpaque(false);
        this.mRangeHighestText.setEnabled(false);
        this.mRangeHighestText.setOpaque(false);
    }

    private boolean processAddButtonPress() {
        boolean bl = false;
        if (this.mValueText.isEnabled()) {
            if (this.isAlreadyPresent(this.mValueText.getText())) {
                this.showWarningMessage(true);
                bl = true;
            } else if (this.isValueValid(this.mValueText.getText())) {
                if (((CountDlg)this.mParentDlg).getFilterType()) {
                    this.mValueSystemList.add(this.mValueText.getText());
                } else {
                    this.mValueSystemList.add("'" + this.mValueText.getText() + "'");
                }
            } else {
                SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this), ResUtil.getString("ERR_WARNING_INVALID_NUMBER"), VersionInfo.getAppVersionString());
                this.mValueText.requestFocusInWindow();
                bl = true;
            }
            this.mValueText.setText(DEFAULT_TEXT);
        } else if (this.mSystemMissingRadio.isSelected()) {
            if (this.isAlreadyPresent(SYSTEM_MISSING_STR)) {
                this.showWarningMessage(true);
                bl = true;
            } else {
                this.mValueSystemList.add(SYSTEM_MISSING_STR);
            }
        } else if (this.mSystemOrUserMissingradio.isSelected()) {
            if (this.isAlreadyPresent(SYSTEM_OR_USER_MISSING_STR)) {
                this.showWarningMessage(true);
                bl = true;
            } else {
                this.mValueSystemList.add(SYSTEM_OR_USER_MISSING_STR);
            }
        } else if (this.mRangeMinText.isEnabled() && this.mRangeMaxText.isEnabled()) {
            boolean bl2 = this.isValueValid(this.mRangeMinText.getText());
            boolean bl3 = this.isValueValid(this.mRangeMaxText.getText());
            if (bl2 && bl3) {
                if (this.isAlreadyPresent(this.mRangeMinText.getText() + THRU_STR + this.mRangeMaxText.getText())) {
                    this.showWarningMessage(true);
                    bl = true;
                    this.mRangeMinText.setText(DEFAULT_TEXT);
                    this.mRangeMaxText.setText(DEFAULT_TEXT);
                } else if (!this.isRangeValid()) {
                    this.showWarningMessage(false);
                    bl = true;
                    this.mRangeMinText.selectAll();
                    this.mRangeMinText.requestFocusInWindow();
                } else {
                    this.mRangeList.add(this.mRangeMinText.getText() + THRU_STR + this.mRangeMaxText.getText());
                    this.mRangeMinText.setText(DEFAULT_TEXT);
                    this.mRangeMaxText.setText(DEFAULT_TEXT);
                }
            } else {
                SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this), ResUtil.getString("ERR_WARNING_INVALID_NUMBER"), VersionInfo.getAppVersionString());
                if (!bl2) {
                    this.mRangeMinText.selectAll();
                    this.mRangeMinText.requestFocusInWindow();
                } else {
                    this.mRangeMaxText.selectAll();
                    this.mRangeMaxText.requestFocusInWindow();
                }
                bl = true;
            }
        } else if (this.mRangeLowestText.isEnabled()) {
            if (this.isAlreadyPresent(LOWEST_THRU_STR + this.mRangeLowestText.getText())) {
                this.showWarningMessage(true);
                bl = true;
            } else if (this.isValueValid(this.mRangeLowestText.getText())) {
                this.mRangeList.add(LOWEST_THRU_STR + this.mRangeLowestText.getText());
            } else {
                SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this), ResUtil.getString("ERR_WARNING_INVALID_NUMBER"), VersionInfo.getAppVersionString());
                this.mRangeLowestText.requestFocusInWindow();
                bl = true;
            }
            this.mRangeLowestText.setText(DEFAULT_TEXT);
        } else if (this.mRangeHighestText.isEnabled()) {
            if (this.isAlreadyPresent(this.mRangeHighestText.getText() + THRU_HIGHEST_STR)) {
                this.showWarningMessage(true);
                bl = true;
            } else if (this.isValueValid(this.mRangeHighestText.getText())) {
                this.mRangeList.add(this.mRangeHighestText.getText() + THRU_HIGHEST_STR);
            } else {
                SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this), ResUtil.getString("ERR_WARNING_INVALID_NUMBER"), VersionInfo.getAppVersionString());
                this.mRangeHighestText.requestFocusInWindow();
                bl = true;
            }
            this.mRangeHighestText.setText(DEFAULT_TEXT);
        }
        if (!bl) {
            this.addListItems();
        }
        return bl;
    }

    private boolean processChangeButtonPress() {
        boolean bl = false;
        String string = (String)this.mBasicACRWidget.getListItemAt(this.mBasicACRWidget.getListSelectedIndex());
        boolean bl2 = this.isItemInGroupOne(string);
        if (this.mValueText.isEnabled()) {
            if (this.isAlreadyPresent(this.mValueText.getText())) {
                this.showWarningMessage(true);
                bl = true;
            } else if (this.isValueValid(this.mValueText.getText())) {
                this.removeFromGroup(string, bl2);
                if (((CountDlg)this.mParentDlg).getFilterType()) {
                    this.mValueSystemList.add(this.mValueText.getText());
                } else {
                    this.mValueSystemList.add("'" + this.mValueText.getText() + "'");
                }
            } else {
                SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this), ResUtil.getString("ERR_WARNING_INVALID_NUMBER"), VersionInfo.getAppVersionString());
                this.mValueText.requestFocusInWindow();
                bl = true;
            }
            this.mValueText.setText(DEFAULT_TEXT);
        } else if (this.mSystemMissingRadio.isSelected()) {
            if (this.isAlreadyPresent(SYSTEM_MISSING_STR)) {
                this.showWarningMessage(true);
                bl = true;
            } else {
                this.removeFromGroup(string, bl2);
                this.mValueSystemList.add(SYSTEM_MISSING_STR);
            }
        } else if (this.mSystemOrUserMissingradio.isSelected()) {
            if (this.isAlreadyPresent(SYSTEM_OR_USER_MISSING_STR)) {
                this.showWarningMessage(true);
                bl = true;
            } else {
                this.removeFromGroup(string, bl2);
                this.mValueSystemList.add(SYSTEM_OR_USER_MISSING_STR);
            }
        } else if (this.mRangeMinText.isEnabled() && this.mRangeMaxText.isEnabled()) {
            boolean bl3 = this.isValueValid(this.mRangeMinText.getText());
            boolean bl4 = this.isValueValid(this.mRangeMaxText.getText());
            if (bl3 && bl4) {
                if (this.isAlreadyPresent(this.mRangeMinText.getText() + THRU_STR + this.mRangeMaxText.getText())) {
                    this.showWarningMessage(true);
                    bl = true;
                    this.mRangeMinText.setText(DEFAULT_TEXT);
                    this.mRangeMaxText.setText(DEFAULT_TEXT);
                } else if (!this.isRangeValid()) {
                    this.showWarningMessage(false);
                    bl = true;
                    this.mRangeMinText.selectAll();
                    this.mRangeMinText.requestFocus();
                } else {
                    this.removeFromGroup(string, bl2);
                    this.mRangeList.add(this.mRangeMinText.getText() + THRU_STR + this.mRangeMaxText.getText());
                    this.mRangeMinText.setText(DEFAULT_TEXT);
                    this.mRangeMaxText.setText(DEFAULT_TEXT);
                }
            } else {
                SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this), ResUtil.getString("ERR_WARNING_INVALID_NUMBER"), VersionInfo.getAppVersionString());
                if (!bl3) {
                    this.mRangeMinText.selectAll();
                    this.mRangeMinText.requestFocus();
                } else {
                    this.mRangeMaxText.selectAll();
                    this.mRangeMaxText.requestFocus();
                }
                bl = true;
            }
        } else if (this.mRangeLowestText.isEnabled()) {
            if (this.isAlreadyPresent(LOWEST_THRU_STR + this.mRangeLowestText.getText())) {
                this.showWarningMessage(true);
                bl = true;
            } else if (this.isValueValid(this.mRangeLowestText.getText())) {
                this.removeFromGroup(string, bl2);
                this.mRangeList.add(LOWEST_THRU_STR + this.mRangeLowestText.getText());
            } else {
                SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this), ResUtil.getString("ERR_WARNING_INVALID_NUMBER"), VersionInfo.getAppVersionString());
                this.mRangeLowestText.requestFocusInWindow();
                bl = true;
            }
            this.mRangeLowestText.setText(DEFAULT_TEXT);
        } else if (this.mRangeHighestText.isEnabled()) {
            if (this.isAlreadyPresent(this.mRangeHighestText.getText() + THRU_HIGHEST_STR)) {
                this.showWarningMessage(true);
                bl = true;
            } else if (this.isValueValid(this.mRangeHighestText.getText())) {
                this.removeFromGroup(string, bl2);
                this.mRangeList.add(this.mRangeHighestText.getText() + THRU_HIGHEST_STR);
            } else {
                SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this), ResUtil.getString("ERR_WARNING_INVALID_NUMBER"), VersionInfo.getAppVersionString());
                this.mRangeHighestText.requestFocusInWindow();
                bl = true;
            }
            this.mRangeHighestText.setText(DEFAULT_TEXT);
        }
        if (!bl) {
            this.addListItems();
        }
        return bl;
    }

    private void processRemoveButtonPress() {
        if (this.mBasicACRWidget.getListSelectedIndex() != -1) {
            String string = (String)this.mBasicACRWidget.getListItemAt(this.mBasicACRWidget.getListSelectedIndex());
            if (string.contains(LOWEST_THRU_STR)) {
                this.mRangeList.remove(string);
                this.mRangeLowestRadio.setSelected(true);
                this.mRangeLowestText.setEnabled(true);
                this.mRangeLowestText.setText(DEFAULT_TEXT);
            } else if (string.contains(THRU_HIGHEST_STR)) {
                this.mRangeList.remove(string);
                this.mRangeHighestRadio.setSelected(true);
                this.mRangeHighestText.setEnabled(true);
                this.mRangeHighestText.setText(DEFAULT_TEXT);
            } else if (string.contains(THRU_STR)) {
                this.mRangeList.remove(string);
                this.mRangeRadio.setSelected(true);
                this.mRangeMinText.setEnabled(true);
                this.mRangeMaxText.setEnabled(true);
                this.mRangeMinText.setText(DEFAULT_TEXT);
                this.mRangeMaxText.setText(DEFAULT_TEXT);
            } else if (string.equalsIgnoreCase(SYSTEM_MISSING_STR)) {
                this.mValueSystemList.remove(string);
            } else if (string.equalsIgnoreCase(SYSTEM_OR_USER_MISSING_STR)) {
                this.mValueSystemList.remove(string);
            } else {
                this.mValueSystemList.remove(string);
                this.mValueRadio.setSelected(true);
                this.mValueText.setEnabled(true);
                this.mValueText.setText(DEFAULT_TEXT);
            }
        }
    }

    private void processListSelectionValueChange() {
        if (this.mBasicACRWidget.getListSelectedIndex() != -1) {
            String string = (String)this.mBasicACRWidget.getListItemAt(this.mBasicACRWidget.getListSelectedIndex());
            if (string.equalsIgnoreCase(SYSTEM_MISSING_STR)) {
                this.mSystemMissingRadio.setSelected(true);
            } else if (string.equalsIgnoreCase(SYSTEM_OR_USER_MISSING_STR)) {
                this.mSystemOrUserMissingradio.setSelected(true);
            } else if (string.contains(LOWEST_THRU_STR)) {
                this.mRangeLowestRadio.setSelected(true);
                this.mRangeLowestText.setEnabled(true);
                String[] stringArray = string.split(LOWEST_THRU_STR);
                this.mRangeLowestText.setText(stringArray[1]);
            } else if (string.contains(THRU_HIGHEST_STR)) {
                this.mRangeHighestRadio.setSelected(true);
                this.mRangeHighestText.setEnabled(true);
                String[] stringArray = string.split(THRU_HIGHEST_STR);
                this.mRangeHighestText.setText(stringArray[0]);
            } else if (string.contains(THRU_STR)) {
                this.mRangeRadio.setSelected(true);
                this.mRangeMinText.setEnabled(true);
                String[] stringArray = string.split(THRU_STR);
                this.mRangeMinText.setText(stringArray[0]);
                this.mRangeMaxText.setEnabled(true);
                this.mRangeMaxText.setText(stringArray[1]);
            } else {
                this.mValueRadio.setSelected(true);
                this.mValueText.setEnabled(true);
                if (((CountDlg)this.mParentDlg).getFilterType()) {
                    this.mValueText.setText(string);
                } else {
                    this.mValueText.setText(string.substring(string.indexOf("'") + 1, string.lastIndexOf("'")));
                }
            }
        }
    }

    private boolean isRangeValid() {
        BigDecimal bigDecimal;
        BigDecimal bigDecimal2 = new BigDecimal(this.mRangeMinText.getText());
        return bigDecimal2.compareTo(bigDecimal = new BigDecimal(this.mRangeMaxText.getText())) == -1;
    }

    private boolean isAlreadyPresent(String string) {
        Object[] objectArray;
        if (!((CountDlg)this.mParentDlg).getFilterType()) {
            string = "'" + string + "'";
        }
        for (Object object : objectArray = this.mBasicACRWidget.getListItems()) {
            if (!object.equals(string)) continue;
            return true;
        }
        return false;
    }

    private boolean isValueValid(String string) {
        try {
            if (((CountDlg)this.mParentDlg).getFilterType()) {
                Double.parseDouble(string);
            }
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private boolean isItemInGroupOne(String string) {
        if (string.contains(LOWEST_THRU_STR)) {
            return false;
        }
        if (string.contains(THRU_HIGHEST_STR)) {
            return false;
        }
        return !string.contains(THRU_STR);
    }

    private void showWarningMessage(boolean bl) {
        if (bl) {
            SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this), this.getResString("ERR_COUNT_WARNING_VALUE_ALREADY_EXISTS"), VersionInfo.getAppVersionString());
        } else {
            SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this), this.getResString("ERR_COUNT_WARNING_INVALID_RANGE"), VersionInfo.getAppVersionString());
        }
    }

    private void removeFromGroup(String string, boolean bl) {
        if (bl) {
            this.mValueSystemList.remove(string);
        } else {
            this.mRangeList.remove(string);
        }
    }

    private void addListItems() {
        int n;
        ((DefaultListModel)this.mBasicACRWidget.getList().getModel()).clear();
        for (n = 0; n < this.mValueSystemList.size(); ++n) {
            ((DefaultListModel)this.mBasicACRWidget.getList().getModel()).addElement(this.mValueSystemList.get(n));
        }
        for (n = 0; n < this.mRangeList.size(); ++n) {
            ((DefaultListModel)this.mBasicACRWidget.getList().getModel()).addElement(this.mRangeList.get(n));
        }
    }

    private void clearAllTextFields() {
        this.mValueText.setText(DEFAULT_TEXT);
        this.mRangeMinText.setText(DEFAULT_TEXT);
        this.mRangeMaxText.setText(DEFAULT_TEXT);
        this.mRangeLowestText.setText(DEFAULT_TEXT);
        this.mRangeHighestText.setText(DEFAULT_TEXT);
    }

    private void updateAddChangeButton() {
        if (this.mValueText.isEnabled()) {
            this.mBasicACRWidget.setAddEnabled(this.mValueText.getText().length() > 0);
            this.mBasicACRWidget.setChangeEnabled(this.mValueText.getText().length() > 0 && this.mBasicACRWidget.getListSelectedIndex() != -1);
        } else if (this.mRangeMinText.isEnabled() && this.mRangeMaxText.isEnabled()) {
            this.mBasicACRWidget.setAddEnabled(this.mRangeMinText.getText().length() > 0 && this.mRangeMaxText.getText().length() > 0);
            this.mBasicACRWidget.setChangeEnabled(this.mRangeMinText.getText().length() > 0 && this.mRangeMaxText.getText().length() > 0 && this.mBasicACRWidget.getListSelectedIndex() != -1);
        } else if (this.mRangeLowestText.isEnabled()) {
            this.mBasicACRWidget.setAddEnabled(this.mRangeLowestText.getText().length() > 0);
            this.mBasicACRWidget.setChangeEnabled(this.mRangeLowestText.getText().length() > 0 && this.mBasicACRWidget.getListSelectedIndex() != -1);
        } else if (this.mRangeHighestText.isEnabled()) {
            this.mBasicACRWidget.setAddEnabled(this.mRangeHighestText.getText().length() > 0);
            this.mBasicACRWidget.setChangeEnabled(this.mRangeHighestText.getText().length() > 0 && this.mBasicACRWidget.getListSelectedIndex() != -1);
        }
    }

    private void initVars() {
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, "IDS_COUNT_VALUE");
        this.mValueRadio = new JRadioButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_COUNT_SYSTEM_MISSING");
        this.mSystemMissingRadio = new JRadioButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_COUNT_SYSTEM_OR_USER_MISSING");
        this.mSystemOrUserMissingradio = new JRadioButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_COUNT_RANGE");
        this.mRangeRadio = new JRadioButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_COUNT_RANGE_LOWEST");
        this.mRangeLowestRadio = new JRadioButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_COUNT_RANGE_HIGHEST");
        this.mRangeHighestRadio = new JRadioButton(toggleButtonAction);
        if (((CountDlg)this.mParentDlg).getFilterType()) {
            this.mValueText = new ContextEnabledTextField((Document)new FixedLengthNumericDocument(20, false, true), DEFAULT_TEXT, 15);
            this.mRangeMinText = new ContextEnabledTextField((Document)new FixedLengthNumericDocument(20, false, true), DEFAULT_TEXT, 15);
            this.mRangeMaxText = new ContextEnabledTextField((Document)new FixedLengthNumericDocument(20, false, true), DEFAULT_TEXT, 15);
            this.mRangeLowestText = new ContextEnabledTextField((Document)new FixedLengthNumericDocument(20, false, true), DEFAULT_TEXT, 15);
            this.mRangeHighestText = new ContextEnabledTextField((Document)new FixedLengthNumericDocument(20, false, true), DEFAULT_TEXT, 15);
            this.mSystemMissingRadio.addItemListener(this);
            this.mSystemOrUserMissingradio.addItemListener(this);
            this.mRangeRadio.addItemListener(this);
            this.mRangeLowestRadio.addItemListener(this);
            this.mRangeHighestRadio.addItemListener(this);
            this.mRangeMinText.addFocusListener((FocusListener)this);
            this.mRangeMinText.getDocument().addDocumentListener(this);
            this.mRangeMaxText.addFocusListener((FocusListener)this);
            this.mRangeMaxText.getDocument().addDocumentListener(this);
            this.mRangeLowestText.addFocusListener((FocusListener)this);
            this.mRangeLowestText.getDocument().addDocumentListener(this);
            this.mRangeHighestText.addFocusListener(this);
            this.mRangeHighestText.getDocument().addDocumentListener(this);
        } else {
            this.mValueText = new StringTextField(DEFAULT_TEXT, 15);
            this.mValueText.setDocument((Document)new FixedLengthDocument(1024));
            this.mRangeMinText = new StringTextField(DEFAULT_TEXT, 15);
            this.mRangeMinText.setDocument((Document)new FixedLengthDocument(255));
            this.mRangeMaxText = new StringTextField(DEFAULT_TEXT, 15);
            this.mRangeMaxText.setDocument((Document)new FixedLengthDocument(255));
            this.mRangeLowestText = new StringTextField(DEFAULT_TEXT, 15);
            this.mRangeLowestText.setDocument((Document)new FixedLengthDocument(255));
            this.mRangeHighestText = new StringTextField(DEFAULT_TEXT, 15);
            this.mRangeHighestText.setDocument(new FixedLengthDocument(255));
        }
        this.mValueRadio.addItemListener(this);
        this.mValueText.addFocusListener((FocusListener)this);
        this.mValueText.getDocument().addDocumentListener(this);
        this.mThroughLabel = DialogUtil.createLabel(this, "IDS_COUNT_THROUGH");
        this.mThroughLabel.setLabelFor((Component)this.mRangeMaxText);
        this.mBasicACRWidget = new BasicACRWidget(BASIC_ACR_WIDGET_KEY);
        this.mBasicACRWidget.getList().setCellRenderer(new CustomWidgetListCellRenderer());
        this.mBasicACRWidget.setListPreferredSize(this.mBasicACRWidget.getMinimumSize());
        if (!((CountDlg)this.mParentDlg).getFilterType()) {
            this.mBasicACRWidget.setAllowDuplicates(true);
        }
        this.mBasicACRWidget.addBasicACRListener(this);
        this.mValuesToCountLabel = DialogUtil.createLabel(this, "IDS_COUNT_VALUES_TO_COUNT");
        this.mValuesToCountLabel.setLabelFor(this.mBasicACRWidget.getList());
        this.mValueSystemList = new LinkedList();
        this.mRangeList = new LinkedList();
    }

    private void setDefaults() {
        if (((CountDlg)this.mParentDlg).getFilterType()) {
            this.mValueRadio.setSelected(true);
            this.mRangeMinText.setEnabled(false);
            this.mRangeMaxText.setEnabled(false);
            this.mThroughLabel.setEnabled(false);
            this.mRangeLowestText.setEnabled(false);
            this.mRangeHighestText.setEnabled(false);
        } else {
            this.mValueRadio.setSelected(true);
            this.mSystemMissingRadio.setEnabled(false);
            this.mSystemMissingRadio.setOpaque(false);
            this.mSystemOrUserMissingradio.setEnabled(false);
            this.mSystemOrUserMissingradio.setOpaque(false);
            this.mRangeRadio.setEnabled(false);
            this.mRangeRadio.setOpaque(false);
            this.mRangeMinText.setEnabled(false);
            this.mRangeMinText.setOpaque(false);
            this.mThroughLabel.setEnabled(false);
            this.mRangeMaxText.setEnabled(false);
            this.mRangeMaxText.setOpaque(false);
            this.mRangeLowestRadio.setEnabled(false);
            this.mRangeLowestRadio.setOpaque(false);
            this.mRangeLowestText.setEnabled(false);
            this.mRangeLowestText.setOpaque(false);
            this.mRangeHighestRadio.setEnabled(false);
            this.mRangeHighestRadio.setOpaque(false);
            this.mRangeHighestText.setEnabled(false);
            this.mRangeHighestText.setOpaque(false);
        }
    }

    private JPanel setupValuePanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_COUNT_VALUE_PANEL")));
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        int n = 21;
        DialogUtil.addUsingGBL(jPanel, this.mValueRadio, gridBagConstraints, 0, 0, 1, 1, n, null);
        Insets insets = new Insets(0, DialogUtil.getGroupBoxInnerMargin() * 4, 0, 0);
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mValueText, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mSystemMissingRadio, gridBagConstraints, 0, 2, 1, 1, n, null);
        DialogUtil.addUsingGBL(jPanel, this.mSystemOrUserMissingradio, gridBagConstraints, 0, 3, 1, 1, n, null);
        DialogUtil.addUsingGBL(jPanel, this.mRangeRadio, gridBagConstraints, 0, 4, 1, 1, n, null);
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mRangeMinText, gridBagConstraints, 0, 5, 1, 1, n, insets);
        insets.set(DialogUtil.getGroupBoxInnerMargin(), DialogUtil.getGroupBoxInnerMargin() * 4, 0, 0);
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mThroughLabel, gridBagConstraints, 0, 6, 1, 1, n, insets);
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mRangeMaxText, gridBagConstraints, 0, 7, 1, 1, n, insets);
        gridBagConstraints.fill = 2;
        insets.set(DialogUtil.getComponentGroupGap(), 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mRangeLowestRadio, gridBagConstraints, 0, 8, 1, 1, n, insets);
        gridBagConstraints.fill = 0;
        insets.set(0, DialogUtil.getGroupBoxInnerMargin() * 4, 0, 0);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mRangeLowestText, gridBagConstraints, 0, 9, 1, 1, n, insets);
        gridBagConstraints.fill = 2;
        insets.set(DialogUtil.getComponentGroupGap(), 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mRangeHighestRadio, gridBagConstraints, 0, 10, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        insets.set(0, DialogUtil.getGroupBoxInnerMargin() * 4, DialogUtil.getGroupBoxInnerMargin(), 0);
        gridBagConstraints.fill = 0;
        n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mRangeHighestText, gridBagConstraints, 0, 11, 1, 1, n, insets);
        this.mRadioButtonGroup = DialogUtil.createButtonGroup(jPanel);
        return jPanel;
    }

    private JPanel setupACRPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(new GridBagLayout());
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        int n = 21;
        Insets insets = new Insets(0, DialogUtil.getGroupBoxInnerMargin() * 18, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mValuesToCountLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.ipadx = 75;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        n = 21;
        DialogUtil.addUsingGBL(jPanel, this.mBasicACRWidget, gridBagConstraints, 0, 1, 1, 1, n, null);
        return jPanel;
    }

    private void setFocusTraversalPolicy() {
        int n;
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mRadioButtonGroup);
        vector.add(this.mValueText);
        vector.add(this.mRangeMinText);
        vector.add(this.mRangeMaxText);
        vector.add(this.mRangeLowestText);
        vector.add(this.mRangeHighestText);
        for (n = 0; n < this.mBasicACRWidget.getComponentCount(); ++n) {
            if (!(this.mBasicACRWidget.getComponent(n) instanceof JPanel)) continue;
            JPanel jPanel = (JPanel)this.mBasicACRWidget.getComponent(n);
            vector.addAll(Arrays.asList(jPanel.getComponents()));
            break;
        }
        vector.add(this.mBasicACRWidget.getList());
        n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    class CustomWidgetListCellRenderer
    extends JLabel
    implements ListCellRenderer {
        protected Border mNoFocusBorder = new EmptyBorder(1, 1, 1, 1);

        CustomWidgetListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Object object2;
            String string = object.toString();
            if (((CountDlg)CountValuesWithinCases.this.mParentDlg).getFilterType()) {
                if (string.contains(CountValuesWithinCases.LOWEST_THRU_STR)) {
                    object2 = string.substring(string.lastIndexOf(" ") + 1, string.length());
                    string = CountValuesWithinCases.LOWEST_THRU_STR + UIToolResUtil.addLocale((String)object2);
                } else if (string.contains(CountValuesWithinCases.THRU_HIGHEST_STR)) {
                    object2 = string.substring(0, string.indexOf(" "));
                    string = UIToolResUtil.addLocale((String)object2) + CountValuesWithinCases.THRU_HIGHEST_STR;
                } else if (string.contains(CountValuesWithinCases.THRU_STR)) {
                    object2 = string.substring(0, string.indexOf(" "));
                    String string2 = string.substring(string.lastIndexOf(" ") + 1, string.length());
                    string = UIToolResUtil.addLocale((String)object2) + CountValuesWithinCases.THRU_STR + UIToolResUtil.addLocale((String)string2);
                } else if (!string.equals(CountValuesWithinCases.SYSTEM_MISSING_STR) && !string.equals(CountValuesWithinCases.SYSTEM_OR_USER_MISSING_STR)) {
                    string = UIToolResUtil.addLocale((String)string);
                }
            }
            this.setText(string);
            if (jList.isEnabled()) {
                this.setOpaque(true);
                if (bl) {
                    if (jList.hasFocus()) {
                        this.setBackground(jList.getSelectionBackground());
                        this.setForeground(jList.getSelectionForeground());
                    } else {
                        this.setBackground(Color.lightGray);
                        this.setForeground(Color.black);
                    }
                } else {
                    this.setBackground(jList.getBackground());
                    this.setForeground(jList.getForeground());
                }
            } else {
                this.setOpaque(false);
            }
            this.setEnabled(jList.isEnabled());
            this.setFont(jList.getFont());
            object2 = null;
            if (bl2 && jList.isEnabled()) {
                if (bl) {
                    object2 = UIManager.getBorder("List.focusSelectedCellHighlightBorder");
                }
                if (object2 == null) {
                    object2 = UIManager.getBorder("List.focusCellHighlightBorder");
                }
            } else {
                object2 = this.mNoFocusBorder;
            }
            this.setBorder((Border)object2);
            return this;
        }

        @Override
        public void setText(String string) {
            if (ComponentState.isBtdRtlOrLtr() && string != null && string.length() > 0) {
                super.setText(ComponentState.prepareStringForBidiRendering((String)string));
            } else {
                super.setText(string);
            }
        }
    }
}

