/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.transform.count;

import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.VarNameValidator;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.SPSS_Format;
import com.spss.java_client.core.documents.data.dictionary.SpssVariable;
import com.spss.java_client.ui.controls.AdjustableTextField;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.FixedLengthDocument;
import com.spss.java_client.ui.controls.IVarFilter;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.StringTextField;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.base.transform.IfCases;
import com.spss.java_client.ui.dialogs.base.transform.count.CountValuesWithinCases;
import com.spss.java_client.ui.dialogs.base.transform.res.TransformResBundle;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.IVarMoveHandler;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.uitools.util.CharacterUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class CountDlg
extends BaseProcedureDialog
implements ListDataListener,
KeyListener,
FocusListener,
IVarMoveHandler {
    private static final String VARIABLES_LABEL = "IDS_COUNT_VARIABLES_LABEL";
    private static final String OPTIONAL_CASE_SELECTION = "IDS_COUNT_OPTIONAL_CASE_SELECTION";
    private static final String INFO_CLEARING_VALUES_TO_COUNT_LIST = "ERR_COUNT_INFO_CLEARING_VALUES_TO_COUNT_LIST";
    private static final String WARNING_CHANGE_EXISTING_VARIABLE = "ERR_COUNT_WARNING_CHANGE_EXISTING_VARIABLE";
    private static final String IF_CONDITION_TEXT = "IF_CONDITION_TEXT";
    private static final String IF_CONDITION_TEXT_FIELD = "IF_CONDITION_TEXT_FIELD";
    private JLabel mTargetVariableLabel;
    private StringTextField mTargetVariableText;
    private SrcVariableList mSrcVarList;
    private JLabel mTargetLabel;
    private StringTextField mTargetLabelText;
    private JLabel mVariablesLabel;
    private TargetVariableList mTargetVarList;
    private ArrowButton mArrowButton;
    private JButton mDefinevaluesButton;
    private JButton mIfButton;
    private AdjustableTextField mIfTextField;
    private IVarFilter mTargetVarFilter;
    private boolean mFilterTypeInteger;
    private boolean mValidVariableName;
    private boolean mValuesDefined;
    private boolean mClearValuesToCount;

    public CountDlg(JFrame jFrame) throws HeadlessException {
        super(jFrame, false, TransformResBundle.getDefaultResourceBundleName(), TransformResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_COUNT_OCCURRENCES_TITLE"));
    }

    @Override
    public String generateSyntax() {
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        String string = this.mTargetVarList.getVariablesStringList();
        Boolean bl = this.getDialogDataModel().getBoolean("IDS_IF_CASES_INCLUDE_IF_CASE_SATISFIES_CONDITION");
        if (bl != null && bl.booleanValue()) {
            stringBuffer.append(SyntaxUtil.getMainCommand("DO IF"));
            stringBuffer.append(SyntaxUtil.getMainCommandParamters(" ("));
            stringBuffer.append(this.getDialogDataModel().getString(IF_CONDITION_TEXT));
            stringBuffer.append(")");
            stringBuffer.append(SyntaxUtil.terminateSyntax());
        }
        stringBuffer.append(SyntaxUtil.getMainCommand("COUNT"));
        stringBuffer.append(SyntaxUtil.getMainCommandParamters(this.mTargetVariableText.getText()) + "=");
        Object[] objectArray = this.getDialogDataModel().getArray("BASIC_ACR_WIDGET_KEY");
        for (int i = 0; i < objectArray.length; ++i) {
            if (i != 0) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(string);
            stringBuffer.append("(");
            stringBuffer.append((String)objectArray[i]);
            stringBuffer.append(")");
        }
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        if (this.mTargetLabelText.getText().length() > 0) {
            stringBuffer.append(SyntaxUtil.getMainCommand("VARIABLE LABELS "));
            stringBuffer.append(SyntaxUtil.getMainCommandParamters(this.mTargetVariableText.getText()));
            stringBuffer.append(" " + CharacterUtil.smartQuote((String)this.mTargetLabelText.getText()));
            stringBuffer.append(SyntaxUtil.terminateSyntax());
        }
        if (bl != null && bl.booleanValue()) {
            stringBuffer.append(SyntaxUtil.getMainCommand("END IF"));
            stringBuffer.append(SyntaxUtil.terminateSyntax());
        }
        if (SyntaxUtil.readTransformationMergePrefs()) {
            stringBuffer.append(SyntaxUtil.getMainCommand("EXECUTE"));
            stringBuffer.append(SyntaxUtil.terminateSyntax());
        }
        return stringBuffer.toString();
    }

    @Override
    public final String getIActionKey() {
        return "transform_count_values";
    }

    @Override
    public String getDialogHelpID() {
        return "idh_coun";
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        this.updateOkPaste();
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        if (listDataEvent.getSource().equals(this.mTargetVarList.getModel())) {
            this.updateVariablesLabel();
            this.mDefinevaluesButton.setEnabled(true);
        }
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        if (listDataEvent.getSource().equals(this.mTargetVarList.getModel())) {
            if (this.mTargetVarList.getModel().getSize() == 0) {
                this.mTargetVarList.removeVarFilter(this.mTargetVarFilter);
                this.mVariablesLabel.setText(this.getResString(VARIABLES_LABEL));
                this.mTargetVarFilter = null;
                this.mDefinevaluesButton.setEnabled(false);
            }
            this.updateOkPaste();
        }
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource().equals(this.mTargetVariableText)) {
            this.mTargetVariableText.selectAll();
        } else if (focusEvent.getSource().equals(this.mTargetLabelText)) {
            this.mTargetLabelText.selectAll();
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public boolean preMoveVariables(ISpssVariable[] iSpssVariableArray, VariableList variableList) {
        if (variableList.equals(this.mTargetVarList)) {
            SpssVariable spssVariable = (SpssVariable)iSpssVariableArray[0];
            for (int i = 1; i < iSpssVariableArray.length; ++i) {
                SpssVariable spssVariable2 = (SpssVariable)iSpssVariableArray[i];
                if (spssVariable.getType() != spssVariable2.getType()) {
                    SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this), this.getResString("ERR_COUNT_LIST_FILTER_INFO_MESSAGE"), VersionInfo.getAppVersionString());
                    return false;
                }
                spssVariable = spssVariable2;
            }
        }
        return true;
    }

    @Override
    public boolean okPastePressed() {
        if (!this.isValidVariableName()) {
            return false;
        }
        LocallyUniqueId locallyUniqueId = ProcedureDlgMgr.getMgr().getActiveDatasetId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        if (iSpssDataSrc.findVarIndex(this.mTargetVariableText.getText()) != -1 && 1 != SpssAlertOptionPane.showConfirmDialog((Window)((Object)this), this.getResString(WARNING_CHANGE_EXISTING_VARIABLE), VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eQuestion, SpssAlertOptionPane.OptionType.YES_NO_OPTION)) {
            return false;
        }
        if (this.isValueLong() && 0 != SpssAlertOptionPane.showConfirmDialog((Window)((Object)this), this.getResString("ERR_COUNT_LONG_VALUE_ERROR_MESSAGE"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eQuestion, SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION)) {
            return false;
        }
        if (this.getDialogDataModel().getString(IF_CONDITION_TEXT) != null && !DialogUtil.isValidIfExpression(this.mIfTextField.getText(), this)) {
            return false;
        }
        return super.okPastePressed() && this.mValuesDefined;
    }

    @Override
    public void reset() {
        super.reset();
        this.setDefaults();
        this.enableOkPaste(false);
    }

    public void paint(Graphics graphics) {
        this.mIfTextField.setText(this.mIfTextField.getText());
        super.paint(graphics);
        super.validate();
    }

    boolean getFilterType() {
        return this.mFilterTypeInteger;
    }

    boolean getClearValuesToCountList() {
        return this.mClearValuesToCount;
    }

    @Override
    protected void loadDialogState() {
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        Boolean bl = dialogDataModel.getBoolean("COUNT_FILTER_INTEGER_TYPE");
        if (bl != null) {
            this.mFilterTypeInteger = bl;
        }
        super.loadDialogState();
        this.mTargetVariableText.selectAll();
        String string = dialogDataModel.getString(IF_CONDITION_TEXT_FIELD);
        string = string != null ? string : this.getResString(OPTIONAL_CASE_SELECTION);
        this.mIfTextField.setText(string);
        this.isValueDefined();
        this.updateOkPaste();
    }

    @Override
    protected void saveDialogState() {
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        dialogDataModel.putString(IF_CONDITION_TEXT_FIELD, this.mIfTextField.getText());
        dialogDataModel.putBoolean("COUNT_FILTER_INTEGER_TYPE", this.mFilterTypeInteger);
        super.saveDialogState();
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        this.addComponents(jPanel);
        this.mArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mArrowButton.registerVariableList(this.mTargetVarList, SpssArrowButton.ButtonOrientation.left);
        this.setFocusTraversalPolicy();
        this.setDefaults();
        this.pack();
    }

    private boolean isValueLong() {
        int n;
        if (this.mFilterTypeInteger) {
            return false;
        }
        int n2 = 0;
        Object[] objectArray = this.getDialogDataModel().getArray("BASIC_ACR_WIDGET_KEY");
        for (n = 0; n < objectArray.length; ++n) {
            String string = (String)objectArray[n];
            if ((string = string.substring(1, string.length() - 1)).length() <= n2) continue;
            n2 = string.length();
        }
        n = 0;
        for (int i = 0; i < this.mTargetVarList.getModel().getSize(); ++i) {
            ISpssVariable iSpssVariable = this.mTargetVarList.getModel().getElementAt(i);
            SPSS_Format sPSS_Format = iSpssVariable.getFormat();
            if (sPSS_Format.getWidth() <= n) continue;
            n = sPSS_Format.getWidth();
        }
        return n2 > n;
    }

    private boolean isValidVariableName() {
        if (this.mTargetVariableText.getText().length() > 0) {
            int n = VarNameValidator.validateSPSSName((String)this.mTargetVariableText.getText(), (boolean)true).asInt();
            if (n > 0 && n != 100) {
                DialogUtil.showBadSpssVarNameWarning(n, this);
                this.mValidVariableName = false;
                this.mTargetVariableText.selectAll();
                this.mTargetVariableText.requestFocus();
            } else {
                this.mValidVariableName = true;
            }
        } else {
            this.mValidVariableName = false;
        }
        return this.mValidVariableName;
    }

    private void updateOkPaste() {
        this.enableOkPaste(this.mValuesDefined && this.mTargetVarList.getModel().getSize() > 0 && this.mTargetVariableText.getText().length() > 0);
    }

    private void updateVariablesLabel() {
        if (this.mTargetVarFilter == null) {
            SpssVariable spssVariable = (SpssVariable)this.mTargetVarList.getModel().getElementAt(0);
            short s = spssVariable.getType();
            if (s == 0) {
                boolean bl;
                this.mVariablesLabel.setText(this.getResString("IDS_COUNT_NUMERIC_VARIABLES"));
                this.mTargetVarFilter = new SpssVarFilter(8, true, false);
                Object[] objectArray = this.getDialogDataModel().getArray("BASIC_ACR_WIDGET_KEY");
                boolean bl2 = bl = objectArray != null && objectArray.length > 0;
                if (!this.mFilterTypeInteger && bl) {
                    SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this), this.getResString(INFO_CLEARING_VALUES_TO_COUNT_LIST), VersionInfo.getAppVersionString());
                    this.mClearValuesToCount = true;
                    this.getDialogDataModel().putArray("BASIC_ACR_WIDGET_KEY", null);
                    this.getDialogDataModel().putArray("GroupOneIdentifier", null);
                    this.getDialogDataModel().putArray("GroupTwoIdentifier", null);
                } else {
                    this.mClearValuesToCount = false;
                }
                this.mTargetVarList.addVarFilter(this.mTargetVarFilter);
                this.mFilterTypeInteger = true;
            } else {
                boolean bl;
                this.mVariablesLabel.setText(this.getResString("IDS_COUNT_STRING_VARIABLES"));
                this.mTargetVarFilter = new SpssVarFilter(8, false, false);
                Object[] objectArray = this.getDialogDataModel().getArray("BASIC_ACR_WIDGET_KEY");
                boolean bl3 = bl = objectArray != null && objectArray.length > 0;
                if (this.mFilterTypeInteger && bl) {
                    SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this), this.getResString(INFO_CLEARING_VALUES_TO_COUNT_LIST), VersionInfo.getAppVersionString());
                    this.mClearValuesToCount = true;
                    this.getDialogDataModel().putArray("BASIC_ACR_WIDGET_KEY", null);
                    this.getDialogDataModel().putArray("GroupOneIdentifier", null);
                    this.getDialogDataModel().putArray("GroupTwoIdentifier", null);
                } else {
                    this.mClearValuesToCount = false;
                }
                this.mTargetVarList.addVarFilter(this.mTargetVarFilter);
                this.mFilterTypeInteger = false;
            }
        } else {
            this.mClearValuesToCount = false;
        }
    }

    private void initVars() {
        this.mTargetVariableText = new StringTextField();
        this.mTargetVariableText.setPreferredSize(new Dimension(DialogUtil.getVarListWidth(), 20));
        this.mTargetVariableText.addKeyListener(this);
        this.mTargetVariableText.setAction(new TextFieldAction(this, "TARGET_VARIABLE_TEXT_KEY"));
        this.mTargetVariableText.addFocusListener(this);
        this.mTargetVariableLabel = DialogUtil.createLabel(this, "IDS_COUNT_TARGET_VARIABLE_LABEL");
        this.mTargetVariableLabel.setLabelFor((Component)((Object)this.mTargetVariableText));
        this.mSrcVarList = new SrcVariableList();
        this.mTargetLabelText = new StringTextField();
        this.mTargetLabelText.setPreferredSize(new Dimension(DialogUtil.getVarListWidth(), 20));
        this.mTargetLabelText.setDocument(new FixedLengthDocument(120));
        this.mTargetLabelText.setAction(new TextFieldAction(this, "TARGET_LABEL_TEXT_KEY"));
        this.mTargetLabelText.addFocusListener(this);
        this.mTargetLabel = DialogUtil.createLabel(this, "IDS_COUNT_TARGET_LABEL");
        this.mTargetLabel.setLabelFor((Component)((Object)this.mTargetLabelText));
        this.mTargetVarList = new TargetVariableList();
        this.mTargetVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mTargetVarList.getModel().addListDataListener(this);
        this.mVariablesLabel = DialogUtil.createLabel(this, VARIABLES_LABEL);
        this.mVariablesLabel.setLabelFor(this.mTargetVarList);
        this.mArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mArrowButton.setVarMoveHandler(this);
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, "IDS_COUNT_DEFINE_VALUES"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CountDlg.this.runCountDefineValuesSubDialog();
            }
        };
        this.mDefinevaluesButton = new JButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction("IDS_COMMON_IF_BUTTON"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CountDlg.this.runIfCasesSubDialog();
            }
        };
        this.mIfButton = new JButton(toggleButtonAction);
        this.mIfTextField = new AdjustableTextField();
        this.mIfTextField.setOpaque(false);
        this.mIfTextField.setBorder(BorderFactory.createEmptyBorder());
        this.mVarMoveHandler = this;
    }

    private void runCountDefineValuesSubDialog() {
        this.runSubDialog(new CountValuesWithinCases(this));
        this.isValueDefined();
        this.updateOkPaste();
    }

    private void runIfCasesSubDialog() {
        this.runSubDialog(new IfCases((BaseProcedureDialog)this, "IDS_COUNT_IF", "idh_coun_if"));
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        String string = dialogDataModel.getString(IF_CONDITION_TEXT);
        string = string != null ? string : this.getResString(OPTIONAL_CASE_SELECTION);
        this.mIfTextField.setText(string);
        this.updateOkPaste();
    }

    private void isValueDefined() {
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        if (dialogDataModel != null) {
            Object[] objectArray = dialogDataModel.getArray("BASIC_ACR_WIDGET_KEY");
            this.mValuesDefined = objectArray != null && objectArray.length > 0;
        }
    }

    private void setDefaults() {
        this.mTargetVariableText.setText("");
        this.mTargetVariableText.setFocusable(true);
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcVarList.setSelectedIndex(0);
        this.mSrcVarList.requestFocus();
        this.mTargetLabelText.setText("");
        if (this.mTargetVarFilter != null) {
            this.mTargetVarList.removeVarFilter(this.mTargetVarFilter);
            this.mTargetVarFilter = null;
        }
        this.mVariablesLabel.setText(this.getResString(VARIABLES_LABEL));
        this.mTargetVarList.removeAll();
        this.mDefinevaluesButton.setEnabled(this.mTargetVarList.getModel().getSize() > 0);
        this.mIfTextField.setEditable(false);
        this.mIfTextField.setText(this.getResString(OPTIONAL_CASE_SELECTION));
    }

    private void addComponents(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel2 = this.setupSrcListPanel();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, null);
        JPanel jPanel3 = this.setupTargetListPanel();
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 2, 0, 1, 1, n, null);
    }

    private JPanel setupSrcListPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(new GridBagLayout());
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mTargetVariableLabel, gridBagConstraints, 0, 0, 1, 1, n, null);
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mTargetVariableText), gridBagConstraints, 0, 1, 1, 1, n, null);
        JScrollPane jScrollPane = new JScrollPane(this.mSrcVarList);
        jScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets = new Insets(DialogUtil.getGroupBoxInnerMargin(), 0, 0, 0);
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_COUNT_SRCLIST_LABEL");
        jLabel.setLabelFor(this.mSrcVarList);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 2, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 3, 1, 1, n, null);
        return jPanel;
    }

    private JPanel setupTargetListPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(new GridBagLayout());
        int n = 10;
        Insets insets = DialogUtil.getArrowButtonInsets();
        DialogUtil.addUsingGBL(jPanel, this.mArrowButton, gridBagConstraints, 0, 3, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mTargetLabel, gridBagConstraints, 1, 0, 1, 1, n, null);
        Insets insets2 = new Insets(0, 0, 0, DialogUtil.getComponentGroupGap() * 10);
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mTargetLabelText), gridBagConstraints, 1, 1, 1, 1, n, insets2);
        insets2.set(DialogUtil.getGroupBoxInnerMargin(), 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mVariablesLabel, gridBagConstraints, 1, 2, 1, 1, n, insets2);
        this.mTargetVarList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mTargetVarList.getFixedCellHeight() * 4 + 2));
        JScrollPane jScrollPane = new JScrollPane(this.mTargetVarList);
        jScrollPane.setPreferredSize(this.mTargetVarList.getMinimumSize());
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        n = 23;
        insets2.set(0, 0, 0, DialogUtil.getComponentGroupGap() * 10);
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 1, 3, 1, 1, n, insets2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        n = 21;
        insets2.set(DialogUtil.getGroupBoxInnerMargin(), 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mDefinevaluesButton, gridBagConstraints, 1, 4, 1, 1, n, insets2);
        JPanel jPanel2 = this.setupOptionalCasePanel();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        n = 25;
        insets2.set(DialogUtil.getComponentGroupGap(), 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 1, 5, 1, 2, n, insets2);
        return jPanel;
    }

    private JPanel setupOptionalCasePanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        int n = 21;
        DialogUtil.addUsingGBL(jPanel, this.mIfButton, gridBagConstraints, 0, 0, 1, 1, n, null);
        Insets insets = new Insets(0, DialogUtil.getGroupBoxInnerMargin(), 0, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mIfTextField, gridBagConstraints, 1, 0, 1, 1, n, insets);
        return jPanel;
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mTargetVariableText);
        vector.add(this.mSrcVarList);
        vector.add(this.mArrowButton);
        vector.add(this.mTargetLabelText);
        vector.add(this.mTargetVarList);
        vector.add(this.mDefinevaluesButton);
        vector.add(this.mIfButton);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }
}

