/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.transform.compute;

import com.spss.java_client.ui.controls.FixedLengthDocument;
import com.spss.java_client.ui.controls.FixedLengthNumericDocument;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.StringTextField;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.dialogs.base.transform.compute.ComputeDlg;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.uitools.controls.IntTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class ComputeTypeLabel
extends BaseSubDialog
implements DocumentListener,
ItemListener {
    private IntTextField mWidthTextField;
    private StringTextField mLabelTextField;
    private JRadioButton mNumericRadioButton;
    private JRadioButton mStringRadioButton;
    private JRadioButton mLabelRadioButton;
    private JRadioButton mUseExpressionRadioButton;
    private JLabel mWidthLabel;
    private GridBagConstraints mConstraints;
    private Insets mInsets;
    private Object[] mFocusOrder;

    public ComputeTypeLabel(BaseProcedureDialog baseProcedureDialog, String string, boolean bl) {
        super(baseProcedureDialog, string, bl);
        this.setLocationRelativeTo(this.getParent());
    }

    public void setUpUI(JPanel jPanel) {
        JPanel jPanel2 = this.setupLabelPanel();
        JPanel jPanel3 = this.setupTypePanel();
        this.mConstraints.weightx = 1.0;
        this.mConstraints.weighty = 1.0;
        this.mConstraints.fill = 1;
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, jPanel2, this.mConstraints, 0, 0, 1, 1, n, null);
        DialogUtil.addUsingGBL(jPanel, jPanel3, this.mConstraints, 0, 1, 1, 1, n, null);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.mLabelRadioButton.isSelected()) {
            this.mLabelTextField.setEnabled(true);
            this.mLabelTextField.setOpaque(true);
        } else {
            this.mLabelTextField.setEnabled(false);
            this.mLabelTextField.setOpaque(false);
        }
        this.enableContinue(true);
        if (this.mStringRadioButton.isSelected()) {
            this.mWidthLabel.setEnabled(true);
            this.mWidthTextField.setEnabled(true);
            this.mWidthTextField.setOpaque(true);
            if (this.mWidthTextField.getText().length() == 0) {
                this.enableContinue(false);
            } else {
                this.enableContinue(true);
            }
        } else {
            this.mWidthLabel.setEnabled(false);
            this.mWidthTextField.setEnabled(false);
            this.mWidthTextField.setOpaque(false);
            this.enableContinue(true);
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.enableContinue(true);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        if (this.mWidthTextField.getText().length() == 0) {
            this.enableContinue(false);
        } else {
            this.enableContinue(true);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public String getDialogHelpID() {
        return "idh_comp_typlab";
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        String string = dialogDataModel.getString("IDS_COMPUTE_TARGET_VARIABLE_LABEL");
        SrcVariableList srcVariableList = ((ComputeDlg)this.mParentDlg).getSourceList();
        VarListModel varListModel = srcVariableList.getModel();
        for (int i = 0; i < varListModel.getSize(); ++i) {
            if (!varListModel.getElementAt(i).getName().equalsIgnoreCase(string)) continue;
            String string2 = dialogDataModel.getString("IDS_CTL_OLDER_COMPUTE_TARGET_VARIABLE_LABEL");
            if (string2 != null && string2.equals(dialogDataModel.getString("IDS_COMPUTE_TARGET_VARIABLE_LABEL"))) {
                this.mLabelTextField.setText(dialogDataModel.getString("IDS_LABEL_TEXTFIELD"));
            } else {
                this.mLabelTextField.setText(varListModel.getElementAt(i).getLabel());
            }
            this.mLabelRadioButton.setSelected(true);
            this.mStringRadioButton.setEnabled(false);
            this.mNumericRadioButton.setEnabled(false);
            this.mWidthTextField.setOpaque(false);
            this.mWidthTextField.setEnabled(false);
            short s = varListModel.getElementAt(i).getType();
            this.mStringRadioButton.setSelected(s != 0);
            return;
        }
        super.loadState(dialogDataModel);
    }

    @Override
    protected boolean saveState(DialogDataModel dialogDataModel) {
        super.saveState(dialogDataModel);
        dialogDataModel.putString("IDS_CTL_OLDER_COMPUTE_TARGET_VARIABLE_LABEL", dialogDataModel.getString("IDS_COMPUTE_TARGET_VARIABLE_LABEL"));
        ((ComputeDlg)this.mParentDlg).updateExpressionLabel();
        return true;
    }

    @Override
    protected void init() {
        super.init();
        JPanel jPanel = this.getViewPanel();
        this.initVars();
        this.setDefaults();
        this.setUpUI(jPanel);
        Vector<Object> vector = new Vector<Object>();
        for (Object object : this.mFocusOrder) {
            vector.add(object);
        }
        vector.add(this.mCmdButtonPanel.getComponent(0));
        vector.add(this.mCmdButtonPanel.getComponent(1));
        vector.add(this.mCmdButtonPanel.getComponent(2));
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
        this.pack();
    }

    void resetCTLDataModel(DialogDataModel dialogDataModel, boolean bl) {
        dialogDataModel.putString("IDS_LABEL_TEXTFIELD", "");
        dialogDataModel.putBoolean("IDS_COMPUTE_TYPELABEL_LABEL_RADIO", true);
        dialogDataModel.putString("IDS_COMPUTE_TYPELABEL_WIDTH_TEXT", "8");
        dialogDataModel.putBoolean("IDS_COMPUTE_TYPELABEL_NUMERIC_RADIO", true);
        dialogDataModel.putString("IDS_CTL_OLDER_COMPUTE_TARGET_VARIABLE_LABEL", "");
        dialogDataModel.putBoolean("IDS_COMPUTE_TYPELABEL_STRING_RADIO", bl);
    }

    private JPanel setupLabelPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_COMPUTE_TYPELABEL_LABEL_PANEL")));
        int n = DialogUtil.getGroupBoxInnerMargin();
        int n2 = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        this.mInsets.set(n, n, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mLabelRadioButton, this.mConstraints, 0, 0, 1, 1, n2, this.mInsets);
        this.mInsets.set(n, insets.left, 0, n);
        this.mConstraints.weightx = 1.0;
        this.mConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mLabelTextField), this.mConstraints, 1, 0, 1, 1, n2, this.mInsets);
        this.mInsets.set(insets.top, n, n, n);
        this.mConstraints.weighty = 1.0;
        this.mConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mUseExpressionRadioButton, this.mConstraints, 0, 1, 2, 1, n2, this.mInsets);
        return jPanel;
    }

    private JPanel setupTypePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_COMPUTE_TYPELABEL_TYPE_PANEL")));
        int n = DialogUtil.getGroupBoxInnerMargin();
        int n2 = 23;
        this.mConstraints.weightx = 0.0;
        this.mConstraints.weighty = 0.0;
        this.mConstraints.fill = 0;
        Insets insets = DialogUtil.getStandardControlInsets();
        this.mInsets.set(n, n, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mNumericRadioButton, this.mConstraints, 0, 0, 1, 1, n2, this.mInsets);
        this.mInsets.set(insets.top, n, n, n);
        this.mConstraints.weightx = 0.0;
        this.mConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mStringRadioButton, this.mConstraints, 0, 1, 1, 1, n2, this.mInsets);
        this.mInsets.set(n, insets.left, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mWidthLabel, this.mConstraints, 1, 1, 1, 1, n2, this.mInsets);
        this.mInsets.set(n, insets.left, n, n);
        this.mConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mWidthTextField, this.mConstraints, 2, 1, 1, 1, n2, this.mInsets);
        return jPanel;
    }

    private void setDefaults() {
        this.mLabelRadioButton.setSelected(true);
        this.mNumericRadioButton.setSelected(true);
        this.mWidthTextField.setText("8");
        this.mWidthTextField.setEnabled(false);
        this.mWidthTextField.setOpaque(false);
        this.mWidthLabel.setEnabled(false);
    }

    private void initVars() {
        this.mFocusOrder = new Object[4];
        this.mLabelTextField = new StringTextField();
        this.mLabelTextField.setAction(new TextFieldAction(this.mParentDlg, "IDS_LABEL_TEXTFIELD"));
        this.mLabelTextField.setDocument(new FixedLengthDocument(120));
        this.mFocusOrder[1] = this.mLabelTextField;
        this.mWidthLabel = DialogUtil.createLabel(this, "IDS_COMPUTE_TYPELABEL_WIDTH_LABEL");
        this.mWidthTextField = new IntTextField(1, Short.MAX_VALUE);
        this.mWidthTextField.setAction((Action)new TextFieldAction(this.mParentDlg, "IDS_COMPUTE_TYPELABEL_WIDTH_TEXT"));
        this.mWidthTextField.setDocument((Document)new FixedLengthNumericDocument(5, true, false));
        this.mWidthTextField.setColumns(5);
        this.mWidthTextField.getDocument().addDocumentListener(this);
        this.mWidthLabel.setLabelFor((Component)this.mWidthTextField);
        this.mFocusOrder[3] = this.mWidthTextField;
        this.mNumericRadioButton = new JRadioButton(new ToggleButtonAction(this.mParentDlg, "IDS_COMPUTE_TYPELABEL_NUMERIC_RADIO"));
        this.mStringRadioButton = new JRadioButton(new ToggleButtonAction(this.mParentDlg, "IDS_COMPUTE_TYPELABEL_STRING_RADIO"));
        this.mLabelRadioButton = new JRadioButton(new ToggleButtonAction(this.mParentDlg, "IDS_COMPUTE_TYPELABEL_LABEL_RADIO"));
        this.mUseExpressionRadioButton = new JRadioButton(new ToggleButtonAction(this.mParentDlg, "IDS_COMPUTE_TYPELABEL_USE_EXPRESSION_RADIO"));
        this.mConstraints = new GridBagConstraints();
        this.mInsets = new Insets(0, 0, 0, 0);
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        spssButtonGroup.add(this.mLabelRadioButton);
        spssButtonGroup.add(this.mUseExpressionRadioButton);
        this.mFocusOrder[0] = spssButtonGroup;
        SpssButtonGroup spssButtonGroup2 = new SpssButtonGroup();
        spssButtonGroup2.add(this.mNumericRadioButton);
        spssButtonGroup2.add(this.mStringRadioButton);
        this.mFocusOrder[2] = spssButtonGroup2;
        this.mNumericRadioButton.addItemListener(this);
        this.mStringRadioButton.addItemListener(this);
        this.mLabelRadioButton.addItemListener(this);
        this.mUseExpressionRadioButton.addItemListener(this);
    }
}

