/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.transform.compute;

import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.CalcWidget;
import com.spss.java_client.ui.controls.ExpressionAreaArrowButton;
import com.spss.java_client.ui.controls.ExpressionBuilderTextArea;
import com.spss.java_client.ui.controls.FunctionListControls;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TextAreaKeyListener;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.base.transform.compute.ComputeDlg;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.ExpressionBuilderUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.uitools.controls.drag_drop.DragPane;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ComputeIf
extends BaseSubDialog
implements ItemListener {
    private SrcVariableList mSrcVarList;
    private JRadioButton mIncludeAllCasesRadio;
    private JRadioButton mIncludeIfRadio;
    private SpssButtonGroup mComputeIfButtonGroup;
    private ExpressionAreaArrowButton mExpressionArrowButton;
    private ArrowButton mFunctionListArrowButton;
    private ExpressionBuilderTextArea mExpressionTextArea;
    private JScrollPane mExpressionTextAreaScrollPane;
    private JTextArea mDescriptionTextArea;
    private JScrollPane mDescriptionTextAreaScrollPane;
    private JLabel mFunctionGrpLabel;
    private JLabel mFunctionSpecialVarsLabel;
    private JList mFunctionGrpList;
    private JScrollPane mFunctionGrpListScrollPane;
    private JList mFunctionSpecialVarsList;
    private JScrollPane mFunctionSpecialVarsListScrollPane;
    private JScrollPane mSrcScrollPane;
    private CalcWidget mCalcPanel;
    private FunctionListControls mFunctionListControls;

    public ComputeIf(ComputeDlg computeDlg) {
        super(computeDlg, computeDlg.getResString("IDS_TC_COMPUTEIF_TITLE"), true);
    }

    @Override
    public boolean continuePressed() {
        if (!(!this.mIncludeIfRadio.isSelected() || this.mExpressionTextArea.validateContents() && DialogUtil.isValidIfExpression(this.mExpressionTextArea.getText(), this))) {
            this.mExpressionTextArea.requestFocus();
            this.mExpressionTextArea.selectAll();
            return false;
        }
        return super.continuePressed();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        this.enableComponents(this.mIncludeIfRadio.isSelected());
        if (object == this.mIncludeIfRadio) {
            String string = this.mExpressionTextArea.getText();
            if (string.equals("")) {
                this.enableContinue(false);
            } else if (string.contains("?")) {
                this.enableContinue(false);
            } else {
                this.enableContinue(true);
            }
            this.mDescriptionTextArea.setEnabled(true);
        } else {
            this.mDescriptionTextArea.setEnabled(false);
        }
    }

    @Override
    public String getDialogHelpID() {
        return "idh_comp_if";
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefaults();
        JPanel jPanel = this.getViewPanel();
        this.setupViewPanel(jPanel);
        if (this.getGlassPane() instanceof DragPane) {
            ExpressionBuilderUtil.addExpressionTextAreaDragAdapter((DragPane)this.getGlassPane(), this.mExpressionTextArea);
            ExpressionBuilderUtil.addDragAdapterToList((DragPane)this.getGlassPane(), this.mFunctionSpecialVarsList);
        }
        this.pack();
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        super.loadState(dialogDataModel);
        this.mExpressionTextArea.setText(dialogDataModel.getString("IDS_TC_TOP_TEXTAREA_VALUE"));
        this.mFunctionListControls.loadFunctionState(dialogDataModel);
        boolean bl = dialogDataModel.getBoolean("IDS_TC_INCLUDE_IF") == null ? false : dialogDataModel.getBoolean("IDS_TC_INCLUDE_IF");
        this.mExpressionArrowButton.setEnabled(bl);
    }

    @Override
    protected boolean saveState(DialogDataModel dialogDataModel) {
        super.saveState(dialogDataModel);
        if (this.mIncludeIfRadio.isSelected()) {
            dialogDataModel.putString("IDS_COMPUTE_OPTIONAL_CASE_SELECTION_LABEL", this.mExpressionTextArea.getText());
            dialogDataModel.putString("IDS_TC_TOP_TEXTAREA_VALUE", this.mExpressionTextArea.getText());
        } else {
            dialogDataModel.putString("IDS_COMPUTE_OPTIONAL_CASE_SELECTION_LABEL", this.getResString("IDS_COMPUTE_OPTIONAL_CASE_SELECTION_LABEL"));
        }
        this.mFunctionListControls.saveFunctionState(dialogDataModel);
        return true;
    }

    private void initVars() {
        this.mFunctionListControls = new FunctionListControls(true, true);
        this.mSrcVarList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        this.mSrcVarList.setIdentifier("SourceListIdentifier");
        this.mSrcVarList.setSelectionMode(0);
        this.mSrcVarList.setDragType(VariableList.VarMoveType.eDoNothing);
        this.mSrcScrollPane = new JScrollPane(this.mSrcVarList);
        this.mSrcScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        this.mFunctionListControls.setSrcList(this.mSrcVarList);
        this.mExpressionArrowButton = new ExpressionAreaArrowButton();
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, "IDS_TC_ALL_CASES");
        this.mIncludeAllCasesRadio = new JRadioButton(toggleButtonAction);
        ToggleButtonAction toggleButtonAction2 = new ToggleButtonAction(this, "IDS_TC_INCLUDE_IF");
        this.mIncludeIfRadio = new JRadioButton(toggleButtonAction2);
        this.mComputeIfButtonGroup = new SpssButtonGroup();
        this.mComputeIfButtonGroup.add(this.mIncludeAllCasesRadio);
        this.mComputeIfButtonGroup.add(this.mIncludeIfRadio);
        this.mComputeIfButtonGroup.setSelected(this.mIncludeAllCasesRadio.getModel(), true);
        this.mIncludeAllCasesRadio.addItemListener(this);
        this.mIncludeIfRadio.addItemListener(this);
        this.mFunctionListArrowButton = this.mFunctionListControls.getFunctionArrow();
        this.mExpressionTextArea = new ExpressionBuilderTextArea();
        this.mExpressionTextArea.setLineWrap(true);
        this.mExpressionTextArea.setWrapStyleWord(true);
        this.mExpressionTextArea.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                if (ComputeIf.this.mExpressionTextArea.getText().contains("?")) {
                    ComputeIf.this.enableContinue(false);
                } else {
                    ComputeIf.this.enableContinue(true);
                }
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                if (ComputeIf.this.mExpressionTextArea.getText().equals("")) {
                    ComputeIf.this.enableContinue(false);
                }
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
            }
        });
        this.mExpressionTextAreaScrollPane = new JScrollPane((Component)((Object)this.mExpressionTextArea));
        this.mExpressionTextAreaScrollPane.setVerticalScrollBarPolicy(20);
        this.mCalcPanel = new CalcWidget((JTextArea)((Object)this.mExpressionTextArea));
        this.mFunctionListControls.setExpressionArea((JTextArea)((Object)this.mExpressionTextArea));
        this.mDescriptionTextArea = this.mFunctionListControls.getFunctionDescArea();
        this.mDescriptionTextArea.setLineWrap(true);
        this.mDescriptionTextArea.setWrapStyleWord(true);
        this.mDescriptionTextArea.setOpaque(false);
        this.mDescriptionTextArea.setEnabled(false);
        this.mDescriptionTextAreaScrollPane = new JScrollPane(this.mDescriptionTextArea);
        this.mDescriptionTextAreaScrollPane.setVerticalScrollBarPolicy(20);
        this.mFunctionGrpList = this.mFunctionListControls.getFunctionGroupList();
        this.mFunctionGrpList.setSelectionMode(0);
        this.mFunctionGrpListScrollPane = new JScrollPane(this.mFunctionGrpList);
        this.mFunctionGrpListScrollPane.setVerticalScrollBarPolicy(20);
        this.mFunctionGrpListScrollPane.setPreferredSize(new Dimension(DialogUtil.getFunctionGroupListWidth(), DialogUtil.getFunctionGroupListHeight()));
        this.mFunctionListControls.setFunctionGroupIdentifier("Function Grp in If");
        this.mFunctionSpecialVarsList = this.mFunctionListControls.getFunctionList();
        this.mFunctionSpecialVarsList.setSelectionMode(0);
        this.mFunctionSpecialVarsListScrollPane = new JScrollPane(this.mFunctionSpecialVarsList);
        this.mFunctionSpecialVarsListScrollPane.setVerticalScrollBarPolicy(20);
        this.mFunctionSpecialVarsListScrollPane.setPreferredSize(new Dimension(DialogUtil.getFunctionGroupListWidth(), DialogUtil.getFunctionGroupListHeight() * 2));
        this.mFunctionListControls.setFunctionListIdentifier("Function list in If");
        this.mFunctionGrpLabel = DialogUtil.createLabel("IDS_FUNCTION_GROUP_LABEL");
        this.mFunctionGrpLabel.setLabelFor(this.mFunctionGrpList);
        this.mFunctionSpecialVarsLabel = DialogUtil.createLabel("IDS_FUNCTION_SPECIAL_VARIABLES_LABEL");
        this.mFunctionSpecialVarsLabel.setLabelFor(this.mFunctionSpecialVarsList);
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(this.setTabTraversal(), false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
        this.mExpressionTextArea.addKeyListener(new TextAreaKeyListener(this.mDescriptionTextArea, this, dialogFocusTraversalPolicy));
        this.mDescriptionTextArea.addKeyListener(new TextAreaKeyListener(this.mDescriptionTextArea, this, dialogFocusTraversalPolicy, false));
        this.mExpressionArrowButton.registerComponents(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mExpressionArrowButton.registerComponents((JComponent)((Object)this.mExpressionTextArea), SpssArrowButton.ButtonOrientation.left);
    }

    private void setDefaults() {
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcVarList.setSelectedIndex(0);
        this.mSrcVarList.requestFocus();
        this.enableComponents(false);
    }

    private void setupViewPanel(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getGroupBoxInnerMargin();
        gridBagConstraints.weightx = 0.75;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n2 = 23;
        DialogUtil.addUsingGBL(jPanel, this.mSrcScrollPane, gridBagConstraints, 0, 0, 1, 6, n2, null);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        n2 = 10;
        Insets insets = DialogUtil.getArrowButtonInsets();
        DialogUtil.addUsingGBL(jPanel, this.mExpressionArrowButton, gridBagConstraints, 1, 0, 1, 1, n2, insets);
        JPanel jPanel2 = this.createExpressionPanel();
        gridBagConstraints.weightx = 0.25;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 2, 0, 3, 1, n2, null);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        n2 = 21;
        DialogUtil.addUsingGBL(jPanel, this.mCalcPanel, gridBagConstraints, 2, 2, 1, 1, n2, DialogUtil.getStandardControlInsets());
        Insets insets2 = DialogUtil.getArrowButtonInsets();
        n2 = 22;
        Insets insets3 = new Insets(n * 2, insets2.left, 0, n * 3);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mFunctionListArrowButton, gridBagConstraints, 3, 3, 1, 1, n2, insets3);
        n2 = 23;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mDescriptionTextAreaScrollPane, gridBagConstraints, 1, 4, 3, 1, n2, insets3);
        n2 = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mFunctionGrpLabel, gridBagConstraints, 4, 1, 1, 1, n2, null);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mFunctionGrpListScrollPane, gridBagConstraints, 4, 2, 1, 1, n2, null);
        insets3.set(n, 0, 0, 0);
        n2 = 21;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mFunctionSpecialVarsLabel, gridBagConstraints, 4, 3, 1, 1, n2, insets3);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mFunctionSpecialVarsListScrollPane, gridBagConstraints, 4, 4, 1, 4, n2, null);
    }

    private JPanel createCalcPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        gridBagConstraints.fill = 0;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel, this.mCalcPanel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, new JPanel(), gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 3;
        DialogUtil.addUsingGBL(jPanel, new JPanel(), gridBagConstraints, 1, 1, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel createExpressionPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        JScrollPane jScrollPane = new JScrollPane((Component)((Object)this.mExpressionTextArea));
        jScrollPane.setVerticalScrollBarPolicy(20);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setPreferredSize(new Dimension(400, 100));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        gridBagConstraints.fill = 0;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel, this.mIncludeAllCasesRadio, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mIncludeIfRadio, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 2, 1, 1, n, null);
        return jPanel;
    }

    private void enableComponents(boolean bl) {
        this.mSrcVarList.setEnabled(bl);
        this.mExpressionArrowButton.setEnabled(bl);
        this.mFunctionListArrowButton.setEnabled(bl && this.mFunctionListControls.getFunctionList().getSelectedIndex() > -1);
        this.setComponentEnableState(this.mCalcPanel, bl);
        this.mExpressionTextArea.setEnabled(bl);
        this.mExpressionTextArea.setOpaque(bl);
        this.mFunctionGrpList.setEnabled(bl);
        this.mFunctionSpecialVarsList.setEnabled(bl);
        this.mFunctionGrpLabel.setEnabled(bl);
        this.mFunctionSpecialVarsLabel.setEnabled(bl);
        this.mExpressionTextAreaScrollPane.getVerticalScrollBar().setEnabled(bl);
        this.mExpressionTextAreaScrollPane.getHorizontalScrollBar().setEnabled(bl);
        this.mExpressionTextAreaScrollPane.setWheelScrollingEnabled(bl);
        this.mDescriptionTextAreaScrollPane.getVerticalScrollBar().setEnabled(bl);
        this.mDescriptionTextAreaScrollPane.getHorizontalScrollBar().setEnabled(bl);
        this.mDescriptionTextAreaScrollPane.setWheelScrollingEnabled(bl);
        this.mDescriptionTextAreaScrollPane.setOpaque(bl);
        if (this.mIncludeIfRadio.isSelected() && this.mExpressionTextArea.getText().equals("")) {
            this.enableContinue(false);
        } else {
            this.enableContinue(true);
        }
    }

    private Vector<Object> setTabTraversal() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mComputeIfButtonGroup);
        vector.add(this.mSrcVarList);
        vector.add(this.mExpressionArrowButton);
        vector.add((Object)this.mExpressionTextArea);
        vector.add(this.mCalcPanel.getDefaultFocusButton());
        vector.add(this.mFunctionGrpList);
        vector.add(this.mFunctionSpecialVarsList);
        vector.add(this.mFunctionListArrowButton);
        vector.add(this.mDescriptionTextArea);
        for (int i = 0; i < this.mCmdButtonPanel.getComponentCount(); ++i) {
            if (!(this.mCmdButtonPanel.getComponent(i) instanceof JButton)) continue;
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        return vector;
    }
}

