/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.transform.compute;

import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.comp_util.ExpressionValidator;
import com.spss.java_client.core.comp_util.OSCheck;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.VarNameValidator;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.ui.SpssMgr;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.CalcWidget;
import com.spss.java_client.ui.controls.ExpressionAreaArrowButton;
import com.spss.java_client.ui.controls.ExpressionBuilderDescArea;
import com.spss.java_client.ui.controls.ExpressionBuilderTextArea;
import com.spss.java_client.ui.controls.FunctionListControls;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.StringTextField;
import com.spss.java_client.ui.controls.TextAreaKeyListener;
import com.spss.java_client.ui.dialogs.base.transform.compute.ComputeIf;
import com.spss.java_client.ui.dialogs.base.transform.compute.ComputeTypeLabel;
import com.spss.java_client.ui.dialogs.base.transform.res.TransformResBundle;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.ExpressionBuilderUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.controls.drag_drop.DragPane;
import com.spss.uitools.util.CharacterUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang.StringUtils;

public class ComputeDlg
extends BaseProcedureDialog
implements DocumentListener {
    private GridBagConstraints mConstraints;
    private Insets mInsets;
    private StringTextField mTargetTextField;
    private ExpressionBuilderTextArea mNumericTextArea;
    private ExpressionBuilderDescArea mDescriptionTextArea;
    private JButton mTypeLabelButton;
    private SrcVariableList mSrcList;
    private ExpressionAreaArrowButton mNumericArrowButton;
    private CalcWidget mCalcPanel;
    private ArrowButton mFunctionArrowButton;
    private JList mFunctionGroupList;
    private JList mSpecialVariableList;
    private ExpressionTextField mIfTextField;
    private FunctionListControls mFunctionControls;
    private String mOriginalExpression;
    private JButton mIfButton;
    private ComputeTypeLabel mComputeTypeLabel;
    private JLabel mNumericExpressionLabel;

    public ComputeDlg(JFrame jFrame) throws HeadlessException {
        super(jFrame, false, TransformResBundle.getDefaultResourceBundleName(), TransformResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_COMPUTE_DIALOG_TITLE"));
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        if (this.mComputeTypeLabel != null) {
            short s = 0;
            for (int i = 0; i < this.mSrcList.getModel().getSize(); ++i) {
                if (!this.mSrcList.getModel().getElementAt(i).getName().equalsIgnoreCase(this.mTargetTextField.getText())) continue;
                s = this.mSrcList.getModel().getElementAt(i).getType();
            }
            this.mComputeTypeLabel.resetCTLDataModel(this.getDialogDataModel(), s != 0);
        }
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        if (this.mComputeTypeLabel != null) {
            short s = 0;
            for (int i = 0; i < this.mSrcList.getModel().getSize(); ++i) {
                if (!this.mSrcList.getModel().getElementAt(i).getName().equalsIgnoreCase(this.mTargetTextField.getText())) continue;
                s = this.mSrcList.getModel().getElementAt(i).getType();
            }
            this.mComputeTypeLabel.resetCTLDataModel(this.getDialogDataModel(), s != 0);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        if (this.mComputeTypeLabel != null) {
            short s = 0;
            for (int i = 0; i < this.mSrcList.getModel().getSize(); ++i) {
                if (!this.mSrcList.getModel().getElementAt(i).getName().equalsIgnoreCase(this.mTargetTextField.getText())) continue;
                s = this.mSrcList.getModel().getElementAt(i).getType();
            }
            this.mComputeTypeLabel.resetCTLDataModel(this.getDialogDataModel(), s != 0);
        }
    }

    @Override
    public String generateSyntax() {
        String string;
        String string2;
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        String string3 = dialogDataModel.getString("IDS_COMPUTE_OPTIONAL_CASE_SELECTION_LABEL");
        String string4 = dialogDataModel.getString("IDS_COMPUTE_TARGET_VARIABLE_LABEL");
        Boolean bl = dialogDataModel.getBoolean("IDS_COMPUTE_TYPELABEL_LABEL_RADIO");
        Boolean bl2 = dialogDataModel.getBoolean("IDS_COMPUTE_TYPELABEL_USE_EXPRESSION_RADIO");
        String string5 = dialogDataModel.getString("IDS_LABEL_TEXTFIELD");
        Boolean bl3 = dialogDataModel.getBoolean("IDS_COMPUTE_TYPELABEL_STRING_RADIO");
        if (bl3 != null && bl3.booleanValue() && (string2 = DataMgr.getDataMgr().getDataSource(DataMgr.getDataMgr().getActiveDocumentId())).findVarIndex(string4) < 0) {
            string = dialogDataModel.getString("IDS_COMPUTE_TYPELABEL_WIDTH_TEXT");
            stringBuffer.append(SyntaxUtil.getMainCommand("STRING "));
            stringBuffer.append(SyntaxUtil.getMainCommandParamters(string4)).append(" (");
            stringBuffer.append("A").append(string);
            stringBuffer.append(")");
            stringBuffer.append(SyntaxUtil.terminateSyntax());
        }
        if (string3.equals(string2 = this.getResString("IDS_COMPUTE_OPTIONAL_CASE_SELECTION_LABEL"))) {
            char c;
            stringBuffer.append(SyntaxUtil.getMainCommand("COMPUTE"));
            stringBuffer.append(SyntaxUtil.getMainCommandParamters(string4));
            stringBuffer.append("=");
            string = dialogDataModel.getString("IDS_COMPUTE_NUMERIC_EXPRESSION_LABEL");
            for (int i = string.length() - 1; i >= 0 && (c = string.charAt(i)) == '\n'; --i) {
                string = string.substring(0, i);
            }
            stringBuffer.append(string);
            stringBuffer.append(SyntaxUtil.terminateSyntax());
            if (bl != null && bl.booleanValue() && string5 != null && !string5.equals("")) {
                stringBuffer.append(SyntaxUtil.getMainCommand("VARIABLE LABELS "));
                stringBuffer.append(SyntaxUtil.getMainCommandParamters(string4)).append(" ");
                stringBuffer.append(CharacterUtil.smartQuote((String)string5));
                stringBuffer.append(SyntaxUtil.terminateSyntax());
            } else if (bl2 != null && bl2.booleanValue()) {
                stringBuffer.append(SyntaxUtil.getMainCommand("VARIABLE LABELS "));
                stringBuffer.append(SyntaxUtil.getMainCommandParamters(string4)).append(" ");
                String string6 = "COMPUTE";
                string6 = string6 + " " + string4;
                string6 = string6 + "=";
                string = string.replaceAll("\n", "");
                string6 = string6 + string;
                string6 = CharacterUtil.smartQuote((String)string6);
                stringBuffer.append(string6);
                stringBuffer.append(SyntaxUtil.terminateSyntax());
            }
        } else {
            int n;
            stringBuffer.append(SyntaxUtil.getMainCommand("IF "));
            stringBuffer.append(SyntaxUtil.getMainCommandParamters("("));
            stringBuffer.append(string3);
            stringBuffer.append(")");
            stringBuffer.append(" ").append(string4);
            stringBuffer.append("=");
            string = dialogDataModel.getString("IDS_COMPUTE_NUMERIC_EXPRESSION_LABEL");
            for (int i = string.length() - 1; i >= 0 && (n = string.charAt(i)) == 10; --i) {
                string = string.substring(0, i);
            }
            stringBuffer.append(string);
            stringBuffer.append(SyntaxUtil.terminateSyntax());
            if (bl != null && bl.booleanValue() && string5 != null && !string5.equals("")) {
                stringBuffer.append(SyntaxUtil.getMainCommand("VARIABLE LABELS "));
                stringBuffer.append(SyntaxUtil.getMainCommandParamters(string4)).append(" ");
                stringBuffer.append(CharacterUtil.smartQuote((String)string5));
                stringBuffer.append(SyntaxUtil.terminateSyntax());
            } else if (bl2 != null && bl2.booleanValue()) {
                char c;
                stringBuffer.append(SyntaxUtil.getMainCommand("VARIABLE LABELS "));
                stringBuffer.append(SyntaxUtil.getMainCommandParamters(string4)).append(" ");
                String string7 = "IF";
                string7 = string7 + " (";
                string7 = string7 + string3;
                string7 = string7 + ")";
                string7 = string7 + " " + string4;
                string7 = string7 + "=";
                string = dialogDataModel.getString("IDS_COMPUTE_NUMERIC_EXPRESSION_LABEL");
                for (n = string.length() - 1; n >= 0 && (c = string.charAt(n)) == '\n'; --n) {
                    string = string.substring(0, n);
                }
                string7 = string7 + string + " ";
                string7 = CharacterUtil.smartQuote((String)string7);
                stringBuffer.append(string7);
                stringBuffer.append(SyntaxUtil.terminateSyntax());
            }
        }
        if (SyntaxUtil.readTransformationMergePrefs()) {
            stringBuffer.append(SyntaxUtil.getMainCommand("EXECUTE"));
            stringBuffer.append(SyntaxUtil.terminateSyntax());
        }
        return stringBuffer.toString();
    }

    @Override
    public String getIActionKey() {
        return "transform_compute_variable";
    }

    @Override
    protected boolean okPastePressed() {
        if (!this.mNumericTextArea.validateContents() || !this.mTargetTextField.validateContents()) {
            return false;
        }
        String string = this.mNumericTextArea.getText();
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        String string2 = this.mTargetTextField.getText();
        int n = VarNameValidator.validateSPSSName((String)string2, (boolean)true).asInt();
        boolean bl = DialogUtil.showBadSpssVarNameWarning(n, this);
        if (bl) {
            ComputeDlg.closeUnNamedDataset();
            boolean bl2 = dialogDataModel.getBoolean("IDS_COMPUTE_TYPELABEL_STRING_RADIO") != null && dialogDataModel.getBoolean("IDS_COMPUTE_TYPELABEL_STRING_RADIO") != false;
            boolean bl3 = this.isValidExpression(string, string2, bl2);
            if (bl3) {
                this.mTargetTextField.requestFocus();
                this.mTargetTextField.selectAll();
                for (int i = 0; i < this.mSrcList.getModel().getSize(); ++i) {
                    int n2;
                    if (!this.mSrcList.getModel().getElementAt(i).getName().equalsIgnoreCase(this.mTargetTextField.getText()) || 3 != (n2 = SpssAlertOptionPane.showConfirmDialog(this.getOwner(), this.getResString("ERR_COMPUTE_CHANGE_VARIABLE_ERROR"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eQuestion, SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION)) && n2 != -1) continue;
                    return false;
                }
                return super.okPastePressed();
            }
            this.mNumericTextArea.requestFocus();
            this.mNumericTextArea.selectAll();
        }
        return false;
    }

    public static void closeUnNamedDataset() {
        int n = DataMgr.getDataMgr().dataSourceCount();
        LocallyUniqueId locallyUniqueId = SpssMgr.getSpssMgr().getActiveClientDatasetId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        if (iSpssDataSrc.getDatasetName().length() != 0 && n > 1) {
            for (int i = 0; i < n; ++i) {
                ISpssDataSrc iSpssDataSrc2 = DataMgr.getDataMgr().getDataSource(i);
                if (iSpssDataSrc2.getDatasetName().length() != 0) continue;
                DataMgr.getDataMgr().destroyClientDataSet(iSpssDataSrc2.getDataSetId(), true);
                break;
            }
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.setDefaults();
        this.mTargetTextField.setText("");
        this.mFunctionControls.reset();
        this.mIfTextField.setText(this.getResString("IDS_COMPUTE_OPTIONAL_CASE_SELECTION_LABEL"));
        if (this.mNumericArrowButton != null) {
            this.mNumericArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
            this.mNumericArrowButton.setEnabled(true);
        }
        this.updateExpressionLabel();
    }

    public void paint(Graphics graphics) {
        if (this.mOriginalExpression != null) {
            this.mIfTextField.setText(this.mOriginalExpression);
        }
        super.paint(graphics);
    }

    public SrcVariableList getSourceList() {
        return this.mSrcList;
    }

    public boolean isValidExpression(String string, String string2, boolean bl) {
        ExpressionValidator expressionValidator = new ExpressionValidator();
        boolean bl2 = expressionValidator.validateComputeExpression(string, string2, bl);
        if (!bl2) {
            String string3 = expressionValidator.checkError();
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), string3, VersionInfo.getAppVersionString());
            return bl2;
        }
        return bl2;
    }

    @Override
    public String getDialogHelpID() {
        return "idh_comp";
    }

    public void updateExpressionLabel() {
        int n;
        String string;
        Boolean bl = this.getDialogDataModel().getBoolean("IDS_COMPUTE_TYPELABEL_NUMERIC_RADIO");
        if (bl != null) {
            string = bl != false ? this.getResString("IDS_COMPUTE_NUMERIC_EXPRESSION_LABEL") : this.getResString("IDS_COMPUTE_STRING_EXPRESSION_LABEL");
            n = bl != false ? this.getDlgAccessKey("IDK_COMPUTE_NUMERIC_EXPRESSION_LABEL_KEY") : this.getDlgAccessKey("IDK_COMPUTE_STRING_EXPRESSION_LABEL_KEY");
        } else {
            string = this.getResString("IDS_COMPUTE_NUMERIC_EXPRESSION_LABEL");
            n = this.getDlgAccessKey("IDK_COMPUTE_NUMERIC_EXPRESSION_LABEL_KEY");
        }
        this.mNumericExpressionLabel.setText(string);
        if (OSCheck.getOSType() != OSInfo.OSType.MAC) {
            this.mNumericExpressionLabel.setDisplayedMnemonic(n);
        }
    }

    @Override
    protected void init() {
        super.init();
        JPanel jPanel = this.getViewPanel();
        this.initVars();
        this.setDefaults();
        this.setUpUI(jPanel);
        if (this.getGlassPane() instanceof DragPane) {
            ExpressionBuilderUtil.addExpressionTextAreaDragAdapter((DragPane)this.getGlassPane(), this.mNumericTextArea);
            ExpressionBuilderUtil.addDragAdapterToList((DragPane)this.getGlassPane(), this.mSpecialVariableList);
        }
        this.pack();
    }

    @Override
    protected void loadDialogState() {
        super.loadDialogState();
        this.enableOkPaste(this.isTextPresentInTextComponent((JTextComponent)((Object)this.mNumericTextArea)) && this.isTextPresentInTextComponent((JTextComponent)((Object)this.mTargetTextField)));
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        this.mNumericTextArea.setText(dialogDataModel.getString("IDS_COMPUTE_NUMERIC_EXPRESSION_LABEL"));
        this.mTargetTextField.setText(dialogDataModel.getString("IDS_COMPUTE_TARGET_VARIABLE_LABEL"));
        if (dialogDataModel.getString("IDS_COMPUTE_OPTIONAL_CASE_SELECTION_LABEL") != null) {
            this.mIfTextField.setText(dialogDataModel.getString("IDS_COMPUTE_OPTIONAL_CASE_SELECTION_LABEL"));
        } else {
            this.mIfTextField.setText(this.getResString("IDS_COMPUTE_OPTIONAL_CASE_SELECTION_LABEL"));
        }
        this.mFunctionControls.loadFunctionState(dialogDataModel);
        this.mTargetTextField.requestFocus();
        this.mTargetTextField.selectAll();
        this.updateExpressionLabel();
    }

    @Override
    protected void saveDialogState() {
        super.saveDialogState();
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        dialogDataModel.putString("IDS_COMPUTE_NUMERIC_EXPRESSION_LABEL", this.mNumericTextArea.getText());
        dialogDataModel.putString("IDS_COMPUTE_OPTIONAL_CASE_SELECTION_LABEL", this.mIfTextField.getText());
        this.mFunctionControls.saveFunctionState(dialogDataModel);
    }

    private boolean isTextPresentInTextComponent(JTextComponent jTextComponent) {
        return jTextComponent.getText().length() > 0 && (jTextComponent != this.mNumericTextArea || this.isValidExpression());
    }

    private boolean isValidExpression() {
        boolean bl = true;
        String string = this.mNumericTextArea.getText();
        int n = string.indexOf(40);
        String string2 = string;
        while (n > -1) {
            int n2;
            String string3 = StringUtils.substringBetween((String)string2, (String)"(", (String)")");
            if (string3 != null && (n2 = string3.indexOf(63)) > -1) {
                bl = false;
                break;
            }
            if ((n = string.indexOf(40, n + 1)) <= -1) continue;
            string2 = string.substring(n);
        }
        return bl;
    }

    private void initVars() {
        this.mFunctionControls = new FunctionListControls(true, true);
        this.mConstraints = new GridBagConstraints();
        this.mInsets = new Insets(0, 0, 0, 0);
        this.mTargetTextField = new StringTextField();
        this.mTargetTextField.setValidateOnFocusLost(false);
        this.mTargetTextField.setAction(new TextFieldAction(this, "IDS_COMPUTE_TARGET_VARIABLE_LABEL"));
        this.mTargetTextField.getDocument().addDocumentListener(new TextDocumentListener());
        this.mNumericTextArea = new ExpressionBuilderTextArea(3, 30);
        this.mNumericTextArea.setLineWrap(true);
        this.mDescriptionTextArea = (ExpressionBuilderDescArea)this.mFunctionControls.getFunctionDescArea();
        this.mDescriptionTextArea.setLineWrap(true);
        this.mDescriptionTextArea.setWrapStyleWord(true);
        this.setHelpAreaBackgroundColor();
        this.mTypeLabelButton = new JButton(new ToggleButtonAction(this, "IDS_COMPUTE_TYPE_LABEL_BUTTON"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ComputeDlg.this.mComputeTypeLabel = new ComputeTypeLabel(ComputeDlg.this, ComputeDlg.this.getResString("IDS_COMPUTE_TYPELABEL_DIALOG_TITLE"), true);
                ComputeDlg.this.runSubDialog(ComputeDlg.this.mComputeTypeLabel);
            }
        });
        this.mSrcList = new SrcVariableList();
        this.mSrcList.setIdentifier("SourceList");
        this.mSrcList.setSelectionMode(0);
        this.mNumericArrowButton = new ExpressionAreaArrowButton();
        this.mCalcPanel = new CalcWidget((JTextArea)((Object)this.mNumericTextArea), CalcWidget.CalcType.eRelationalWithTilde);
        this.mFunctionArrowButton = this.mFunctionControls.getFunctionArrow();
        this.mSpecialVariableList = this.mFunctionControls.getFunctionList();
        this.mSpecialVariableList.setSelectionMode(0);
        this.mIfTextField = new ExpressionTextField(this.getResString("IDS_COMPUTE_OPTIONAL_CASE_SELECTION_LABEL"));
        this.mIfTextField.setEditable(false);
        this.mIfTextField.setBorder(BorderFactory.createEmptyBorder());
        if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
            this.mIfTextField.setBackground(this.getBackground());
        }
        this.mFunctionGroupList = this.mFunctionControls.getFunctionGroupList();
        this.mFunctionGroupList.setSelectionMode(0);
        this.mFunctionControls.setExpressionArea((JTextArea)((Object)this.mNumericTextArea));
        this.mFunctionControls.setSrcList(this.mSrcList);
        this.mFunctionControls.setFunctionGroupIdentifier("Function Grp");
        this.mFunctionControls.setFunctionListIdentifier("Function list");
        this.mIfButton = new JButton(new ToggleButtonAction("IDS_COMMON_IF_BUTTON"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ComputeDlg.this.runSubDialog(new ComputeIf(ComputeDlg.this));
                DialogDataModel dialogDataModel = ComputeDlg.this.getDialogDataModel();
                ComputeDlg.this.mIfTextField.setText(dialogDataModel.getString("IDS_COMPUTE_OPTIONAL_CASE_SELECTION_LABEL"));
            }
        });
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(this.setTabTraversal(), false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
        this.mNumericTextArea.addKeyListener(new TextAreaKeyListener((JTextArea)((Object)this.mNumericTextArea), this, dialogFocusTraversalPolicy, true));
        this.mNumericTextArea.getDocument().addDocumentListener(new TextDocumentListener());
        this.mDescriptionTextArea.addKeyListener(new TextAreaKeyListener(this.mDescriptionTextArea, this, dialogFocusTraversalPolicy, false));
        this.mNumericArrowButton.registerComponents(this.mSrcList, SpssArrowButton.ButtonOrientation.right);
        this.mNumericArrowButton.registerComponents((JComponent)((Object)this.mNumericTextArea), SpssArrowButton.ButtonOrientation.left);
        this.mTargetTextField.getDocument().addDocumentListener(this);
    }

    private void setHelpAreaBackgroundColor() {
        if (OSCheck.getOSType() == OSInfo.OSType.WIN) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Object object = toolkit.getDesktopProperty("win.highContrast.on");
            if (object != null && ((Boolean)object).booleanValue()) {
                this.mDescriptionTextArea.setBackground(Color.black);
            } else {
                this.mDescriptionTextArea.setBackground(Color.white);
            }
        }
    }

    private Vector<Object> setTabTraversal() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mTargetTextField);
        vector.add(this.mTypeLabelButton);
        vector.add(this.mSrcList);
        vector.add(this.mNumericArrowButton);
        vector.add((Object)this.mNumericTextArea);
        vector.add(this.mCalcPanel.getDefaultFocusButton());
        vector.add(this.mFunctionGroupList);
        vector.add(this.mFunctionArrowButton);
        vector.add(this.mFunctionControls.getFunctionList());
        vector.add(this.mDescriptionTextArea);
        vector.add(this.mIfButton);
        for (int i = 0; i < this.mCmdButtonPanel.getComponentCount(); ++i) {
            if (!(this.mCmdButtonPanel.getComponent(i) instanceof JButton)) continue;
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        return vector;
    }

    private void setDefaults() {
        this.mNumericTextArea.setText("");
        this.mTypeLabelButton.setEnabled(false);
        this.mFunctionArrowButton.setEnabled(false);
        this.mSrcList.loadFromActiveDataset();
        this.mSrcList.setSelectedIndex(0);
        this.mTargetTextField.requestFocus();
    }

    private void setUpUI(JPanel jPanel) {
        JPanel jPanel2 = this.setupIfPanel();
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = DialogUtil.getArrowButtonInsets();
        this.mConstraints.weightx = 0.0;
        this.mConstraints.weighty = 0.0;
        this.mConstraints.fill = 0;
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_COMPUTE_TARGET_VARIABLE_LABEL");
        jLabel.setLabelFor((Component)((Object)this.mTargetTextField));
        this.mNumericExpressionLabel = DialogUtil.createLabel(this, "IDS_COMPUTE_NUMERIC_EXPRESSION_LABEL");
        this.mNumericExpressionLabel.setLabelFor((Component)((Object)this.mNumericTextArea));
        JLabel jLabel2 = new JLabel("    =");
        JScrollPane jScrollPane = new JScrollPane((Component)((Object)this.mNumericTextArea));
        jScrollPane.setVerticalScrollBarPolicy(20);
        JScrollPane jScrollPane2 = new JScrollPane(this.mSrcList);
        jScrollPane2.setPreferredSize(this.mSrcList.getMinimumSize());
        JScrollPane jScrollPane3 = new JScrollPane(this.mDescriptionTextArea);
        jScrollPane3.setVerticalScrollBarPolicy(20);
        jScrollPane3.setPreferredSize(new Dimension(110, 110));
        JLabel jLabel3 = DialogUtil.createLabel("IDS_FUNCTION_GROUP_LABEL");
        jLabel3.setLabelFor(this.mFunctionGroupList);
        JScrollPane jScrollPane4 = new JScrollPane(this.mFunctionGroupList);
        jScrollPane4.setVerticalScrollBarPolicy(20);
        jScrollPane4.setPreferredSize(new Dimension(DialogUtil.getFunctionGroupListWidth(), DialogUtil.getFunctionGroupListHeight()));
        JLabel jLabel4 = DialogUtil.createLabel("IDS_FUNCTION_SPECIAL_VARIABLES_LABEL");
        jLabel4.setLabelFor(this.mSpecialVariableList);
        JScrollPane jScrollPane5 = new JScrollPane(this.mSpecialVariableList);
        jScrollPane5.setPreferredSize(new Dimension(DialogUtil.getFunctionGroupListWidth(), DialogUtil.getFunctionGroupListHeight() * 2));
        this.mInsets.set(n2, n2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jLabel, this.mConstraints, 0, 0, 1, 1, n, this.mInsets);
        this.mConstraints.weightx = 1.0;
        this.mInsets.set(n2, insets.left, 0, n2);
        DialogUtil.addUsingGBL(jPanel, this.mNumericExpressionLabel, this.mConstraints, 2, 0, 1, 1, n, this.mInsets);
        this.mConstraints.weightx = 0.0;
        this.mConstraints.fill = 2;
        this.mInsets.set(insets.top, n2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mTargetTextField), this.mConstraints, 0, 1, 1, 1, n, this.mInsets);
        this.mInsets.set(n2, insets2.left, 0, insets2.right);
        DialogUtil.addUsingGBL(jPanel, jLabel2, this.mConstraints, 1, 1, 1, 1, n, this.mInsets);
        this.mConstraints.weightx = 1.0;
        this.mConstraints.weighty = 1.0;
        this.mConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jScrollPane, this.mConstraints, 2, 1, 3, 3, n, null);
        this.mConstraints.weightx = 0.0;
        this.mConstraints.weighty = 0.0;
        this.mConstraints.fill = 0;
        this.mInsets.set(n2, n2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mTypeLabelButton, this.mConstraints, 0, 2, 1, 1, n, this.mInsets);
        this.mConstraints.weightx = 1.0;
        this.mConstraints.weighty = 1.0;
        this.mConstraints.fill = 1;
        this.mInsets.set(n2, n2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jScrollPane2, this.mConstraints, 0, 3, 1, 7, n, this.mInsets);
        this.mConstraints.weightx = 0.0;
        this.mConstraints.weighty = 0.0;
        this.mConstraints.fill = 0;
        this.mInsets.set(n2, insets2.left, 0, insets2.right);
        DialogUtil.addUsingGBL(jPanel, this.mNumericArrowButton, this.mConstraints, 1, 3, 1, 1, 19, this.mInsets);
        DialogUtil.addUsingGBL(jPanel, this.mCalcPanel, this.mConstraints, 2, 6, 1, 3, n, null);
        this.mConstraints.weightx = 0.0;
        this.mConstraints.weighty = 0.0;
        this.mConstraints.fill = 0;
        this.mInsets.set(n2 * 2, insets2.left, 0, n2 * 3);
        n = 21;
        DialogUtil.addUsingGBL(jPanel, this.mFunctionArrowButton, this.mConstraints, 3, 7, 1, 2, n, this.mInsets);
        this.mConstraints.weightx = 1.0;
        this.mConstraints.weighty = 1.0;
        this.mConstraints.fill = 1;
        this.mInsets.set(n2 * 2, insets2.left, 0, n2 * 3);
        n = 23;
        DialogUtil.addUsingGBL(jPanel, jScrollPane3, this.mConstraints, 1, 9, 3, 1, n, this.mInsets);
        this.mConstraints.fill = 0;
        this.mConstraints.weightx = 1.0;
        this.mConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, jLabel3, this.mConstraints, 4, 5, 1, 1, n, null);
        this.mConstraints.weightx = 1.0;
        this.mConstraints.weighty = 1.0;
        this.mConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jScrollPane4, this.mConstraints, 4, 6, 1, 1, n, null);
        this.mConstraints.fill = 0;
        this.mConstraints.weightx = 1.0;
        this.mConstraints.weighty = 0.0;
        this.mInsets.set(n2, 0, 0, 0);
        n = 21;
        DialogUtil.addUsingGBL(jPanel, jLabel4, this.mConstraints, 4, 7, 1, 1, n, this.mInsets);
        this.mConstraints.weightx = 1.0;
        this.mConstraints.weighty = 1.0;
        this.mConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jScrollPane5, this.mConstraints, 4, 8, 1, 3, n, null);
        this.mInsets.set(n2 * 2, insets.left, 0, n2 * 3);
        DialogUtil.addUsingGBL(jPanel, jPanel2, this.mConstraints, 0, 10, 4, 1, n, this.mInsets);
    }

    private JPanel setupIfPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(""));
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = DialogUtil.getStandardControlInsets();
        this.mConstraints.weightx = 0.0;
        this.mConstraints.weighty = 1.0;
        this.mConstraints.fill = 0;
        this.mInsets.set(n2, n2, n2, 0);
        DialogUtil.addUsingGBL(jPanel, this.mIfButton, this.mConstraints, 0, 0, 1, 1, n, this.mInsets);
        this.mInsets.set(n2, insets.left, n2, n2);
        this.mConstraints.weightx = 1.0;
        this.mConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mIfTextField, this.mConstraints, 1, 0, 1, 1, n, this.mInsets);
        return jPanel;
    }

    private class ExpressionTextField
    extends JTextField {
        public ExpressionTextField(String string) {
            super(string);
        }

        @Override
        public void setText(String string) {
            ComputeDlg.this.mOriginalExpression = string;
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            int n = fontMetrics.stringWidth(string);
            if (n <= this.getWidth()) {
                super.setText(string);
                return;
            }
            String string2 = "...";
            int n2 = 1;
            int n3 = 0;
            String string3 = "";
            while (n3 < this.getWidth() - 10) {
                string3 = ComputeDlg.this.mOriginalExpression.substring(0, n2);
                string3 = string3 + string2;
                n3 = fontMetrics.stringWidth(string3);
                ++n2;
            }
            super.setText(string3);
        }

        @Override
        public String getText() {
            return ComputeDlg.this.mOriginalExpression;
        }
    }

    private class TextDocumentListener
    implements DocumentListener {
        private TextDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            if (documentEvent.getDocument() == ComputeDlg.this.mTargetTextField.getDocument()) {
                ComputeDlg.this.mTypeLabelButton.setEnabled(ComputeDlg.this.isTextPresentInTextComponent((JTextComponent)((Object)ComputeDlg.this.mTargetTextField)));
            }
            ComputeDlg.this.enableOkPaste(ComputeDlg.this.isTextPresentInTextComponent((JTextComponent)((Object)ComputeDlg.this.mNumericTextArea)) && ComputeDlg.this.isTextPresentInTextComponent((JTextComponent)((Object)ComputeDlg.this.mTargetTextField)));
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            if (documentEvent.getDocument() == ComputeDlg.this.mTargetTextField.getDocument()) {
                ComputeDlg.this.mTypeLabelButton.setEnabled(ComputeDlg.this.isTextPresentInTextComponent((JTextComponent)((Object)ComputeDlg.this.mTargetTextField)));
            }
            ComputeDlg.this.enableOkPaste(ComputeDlg.this.isTextPresentInTextComponent((JTextComponent)((Object)ComputeDlg.this.mNumericTextArea)) && ComputeDlg.this.isTextPresentInTextComponent((JTextComponent)((Object)ComputeDlg.this.mTargetTextField)));
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
        }
    }
}

