/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.transform.auto_recode;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.fopen.RefFileFilter;
import com.spss.java_client.core.comp_util.FileLocationsUtil;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.VarNameValidator;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.server.DataServerProxy;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.CustomVarListCellRenderer;
import com.spss.java_client.ui.controls.FileTextField;
import com.spss.java_client.ui.controls.IVarFilter;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.StringTextField;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.base.transform.auto_recode.AutoRecodeListModel;
import com.spss.java_client.ui.dialogs.base.transform.auto_recode.AutoRecodeSpssVarFormatter;
import com.spss.java_client.ui.dialogs.base.transform.res.TransformResBundle;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.ContentValidatorFileChooser;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.ControlAction;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.uitools.util.CharacterUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;

public class AutoRecodeDlg
extends BaseProcedureDialog
implements ListDataListener,
FocusListener,
DocumentListener,
ListSelectionListener,
ItemListener {
    private static final String RADIO_HIGHER_KEY = "IDS_HIGHEST_VALUE_RADIO";
    private static final String RADIO_LOWER_KEY = "IDS_LOWEST_VALUE_RADIO";
    private static final String NEW_NAME_BUTTON_KEY = "IDS_NEW_NAME_BUTTON";
    private static final String USE_CHECK_KEY = "IDS_USE_SAME_CHECK";
    private static final String TREAT_CHECK_KEY = "IDS_TREAT_BLANK_CHECK";
    private static final String APPLY_CHECK_KEY = "IDS_APPLY_TEMPLATE_CHECK";
    private static final String SAVE_CHECK_KEY = "IDS_SAVE_TEMPLATE_CHECK";
    private static final String FILE_BUTTON_KEY = "IDS_FILE";
    private static final String FILE_BUTTONT_KEY = "IDS_FILET";
    private SrcVariableList mSrcVarList;
    private TargetVariableList mTargetVarList;
    private JRadioButton mLowestRadioButton;
    private JRadioButton mHighestRadioButton;
    private JScrollPane mListScrollPane;
    private JScrollPane mTargetScrollPane;
    private JLabel mTargetListLabel;
    private ArrowButton mArrowButton;
    private JLabel mNewNameLabel;
    private StringTextField mNewTextField;
    private JButton mNewNameButton;
    private SpssButtonGroup mGroup;
    private JCheckBox mUseSameCheckBox;
    private JCheckBox mTreatBlankCheckBox;
    private JCheckBox mApplyCheckBox;
    private JCheckBox mSaveCheckBox;
    private JButton mFileChooserButton;
    private JButton mFileChooserButtonT;
    private FileTextField mFilePath;
    private FileTextField mSaveFilePath;
    private String mApplyFilePathString;
    private String mSaveFilePathString;
    private AutoRecodeSpssVarFormatter mFormatter;

    public AutoRecodeDlg(JFrame jFrame) {
        super(jFrame, false, TransformResBundle.getDefaultResourceBundleName(), TransformResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_AUTOMATIC_RECODE_TRANSFORM"));
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public String getDialogHelpID() {
        return "idh_aure";
    }

    @Override
    public String getIActionKey() {
        return "transform_automatic_recode";
    }

    @Override
    public String generateSyntax() {
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        stringBuffer.append(SyntaxUtil.getMainCommand("AUTORECODE"));
        stringBuffer.append(SyntaxUtil.getMainCommandParamters("VARIABLES="));
        stringBuffer.append(this.getTargetStringNames());
        stringBuffer.append("\n").append(SyntaxUtil.getSubCommand("/INTO"));
        stringBuffer.append(this.getTargetStringValues());
        if (this.mHighestRadioButton.isSelected()) {
            stringBuffer.append("\n").append(SyntaxUtil.getSubCommand("/DESCENDING"));
        }
        if (this.mUseSameCheckBox.isSelected()) {
            stringBuffer.append("\n").append(SyntaxUtil.getSubCommand("/GROUP"));
        }
        if (this.mTreatBlankCheckBox.isSelected()) {
            stringBuffer.append("\n").append(SyntaxUtil.getSubCommand("/BLANK=MISSING"));
        }
        if (this.mApplyCheckBox.isSelected()) {
            stringBuffer.append("\n").append(SyntaxUtil.getSubCommand("/APPLY TEMPLATE=")).append(CharacterUtil.smartQuote((String)this.mFilePath.getText()));
        }
        if (this.mSaveCheckBox.isSelected()) {
            stringBuffer.append("\n").append(SyntaxUtil.getSubCommand("/SAVE TEMPLATE=")).append(CharacterUtil.smartQuote((String)this.mSaveFilePath.getText()));
        }
        stringBuffer.append("\n").append(SyntaxUtil.getSubCommand("/PRINT"));
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        return stringBuffer.toString();
    }

    @Override
    public void reset() {
        super.reset();
        this.mFormatter.getVarMap().clear();
        this.mTargetVarList.getModel().removeAll();
        this.mApplyCheckBox.setSelected(false);
        this.mSaveCheckBox.setSelected(false);
        this.mUseSameCheckBox.setEnabled(true);
        this.mUseSameCheckBox.setSelected(false);
        this.mTreatBlankCheckBox.setSelected(false);
        this.setDefaults();
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.mNewTextField.setText("");
        if (this.mTargetVarList.getModel() == listDataEvent.getSource()) {
            this.mNewTextField.setEnabled(true);
            this.mNewNameLabel.setEnabled(true);
            this.enableOkPaste(false);
            this.useCheckBoxEnableCondition();
        }
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.mNewTextField.setText("");
        if (this.mTargetVarList.getModel() == listDataEvent.getSource()) {
            this.useCheckBoxEnableCondition();
            this.checkStateOfCheckBox();
        }
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.mApplyFilePathString != null && !this.mApplyFilePathString.equals("")) {
            this.mFilePath.setText(this.mApplyFilePathString);
        }
        if (this.mSaveFilePathString != null && !this.mSaveFilePathString.equals("")) {
            this.mSaveFilePath.setText(this.mSaveFilePathString);
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource() instanceof TargetVariableList) {
            VarListModel varListModel = this.mTargetVarList.getModel();
            if (varListModel.getSize() >= 1 && this.mTargetVarList.getSelectedValues().length == 1) {
                this.mNewTextField.setEnabled(true);
                this.mNewTextField.setOpaque(true);
                this.mNewNameLabel.setEnabled(true);
            }
        } else if (focusEvent.getSource() instanceof SrcVariableList) {
            this.mNewTextField.setEnabled(false);
            this.mNewTextField.setOpaque(false);
            this.mNewNameLabel.setEnabled(false);
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    public static boolean varNameExists(String string) {
        LocallyUniqueId locallyUniqueId = ProcedureDlgMgr.getMgr().getActiveDatasetId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        return iSpssDataSrc.findVarIndex(string) != -1;
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        if (this.mNewTextField.getDocument() == documentEvent.getDocument() && this.mNewTextField.getText().length() > 0) {
            this.mNewNameButton.setEnabled(true);
        }
        if (this.mFilePath.getDocument() == documentEvent.getDocument()) {
            this.checkStateOfCheckBox();
        }
        if (this.mSaveFilePath.getDocument() == documentEvent.getDocument()) {
            this.checkStateOfCheckBox();
        }
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        if (this.mNewTextField.getDocument() == documentEvent.getDocument() && this.mNewTextField.getText().length() < 1) {
            this.mNewNameButton.setEnabled(false);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.checkStateOfCheckBox();
        if (itemEvent.getSource() == this.mUseSameCheckBox) {
            if (this.mUseSameCheckBox.isSelected()) {
                ISpssVariable[] iSpssVariableArray = this.mSrcVarList.getSelectedValues();
                if (iSpssVariableArray.length > 0) {
                    short s = iSpssVariableArray[0].getType();
                    for (ISpssVariable iSpssVariable : iSpssVariableArray) {
                        if (s == iSpssVariable.getType() && this.mTargetVarList.canIncludeVariable(iSpssVariable)) continue;
                        this.mArrowButton.setEnabled(false);
                        break;
                    }
                }
            } else {
                this.mArrowButton.setEnabled(true);
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getSource() instanceof SrcVariableList) {
            int n;
            this.mNewTextField.setText("");
            this.mNewTextField.setEnabled(false);
            this.mNewNameLabel.setEnabled(false);
            ISpssVariable[] iSpssVariableArray = this.mSrcVarList.getSelectedValues();
            if (iSpssVariableArray.length > 1) {
                n = iSpssVariableArray[0].getType();
                for (ISpssVariable iSpssVariable : iSpssVariableArray) {
                    if (n == iSpssVariable.getType() || !this.mUseSameCheckBox.isSelected()) continue;
                    this.mArrowButton.setEnabled(false);
                }
            } else {
                n = this.mSrcVarList.getSelectedIndex();
                if (this.mUseSameCheckBox.isSelected() && this.mTargetVarList.getModel().getSize() > 0 && n >= 0) {
                    this.arrowButtonEnableCondition(n);
                }
            }
        }
        if (listSelectionEvent.getSource() instanceof TargetVariableList) {
            if (this.mTargetVarList.getSelectedValues().length == 1) {
                String string;
                this.mNewTextField.setText("");
                this.mNewTextField.setEnabled(true);
                this.mNewNameLabel.setEnabled(true);
                int n = this.mTargetVarList.getSelectedIndex();
                if (this.mTargetVarList.getModel().getSize() > 0 && n != -1 && !(string = this.mFormatter.getDisplayText((ISpssVariable)this.mTargetVarList.getSelectedValue())).equals("") && !string.endsWith("-->????????")) {
                    int n2 = string.indexOf("-->");
                    string = string.substring(n2 + 3);
                    this.mNewTextField.setText(string);
                    this.mNewNameButton.setEnabled(false);
                }
            } else {
                this.mNewTextField.setText("");
                this.mNewTextField.setEnabled(false);
                this.mNewNameLabel.setEnabled(false);
            }
        }
    }

    @Override
    protected void init() {
        super.init();
        JPanel jPanel = this.getViewPanel();
        this.initVars();
        this.setUI(jPanel);
        this.setDefaults();
        this.setFocusTraversalPolicy();
        this.pack();
    }

    @Override
    protected void loadDialogState() {
        super.loadDialogState();
        this.mFormatter.setVarMap(this.getDialogDataModel().getMap(this.mTargetVarList.getIdentifier()));
        this.removeItemsFromScrListContainedInTargetList();
        if (this.mSrcVarList.getModel().getSize() > 0) {
            this.mSrcVarList.requestFocus();
            this.mSrcVarList.setSelectedIndex(0);
        }
        if (this.checkTargetModelSize() && !this.checkList() && this.isApplyCheckBoxCondition() && this.isSaveCheckBoxCondition()) {
            this.enableOkPaste(true);
        }
    }

    private void removeItemsFromScrListContainedInTargetList() {
        int n = this.mTargetVarList.getModel().getSize();
        block0: for (int i = 0; i < n; ++i) {
            String string = this.mTargetVarList.getModel().getElementAt(i).getName();
            int n2 = this.mSrcVarList.getModel().getSize();
            for (int j = 0; j < n2; ++j) {
                String string2 = this.mSrcVarList.getModel().getElementAt(j).getName();
                if (!string2.equalsIgnoreCase(string)) continue;
                this.mSrcVarList.getModel().removeElementAt(j);
                continue block0;
            }
        }
    }

    @Override
    protected void saveDialogState() {
        super.saveDialogState();
        this.getDialogDataModel().putMap(this.mTargetVarList.getIdentifier(), this.mFormatter.getVarMapForSerialization());
    }

    private String getTargetStringNames() {
        String string = "";
        int n = this.mTargetVarList.getModel().getSize();
        for (int i = 0; i < n; ++i) {
            String string2 = this.mTargetVarList.getModel().getElementAt(i).getName();
            string = string + "" + string2 + " ";
        }
        return string;
    }

    private String getTargetStringValues() {
        String string = "";
        int n = this.mTargetVarList.getModel().getSize();
        for (int i = 0; i < n; ++i) {
            String string2 = this.mFormatter.getDisplayText(this.mTargetVarList.getModel().getElementAt(i));
            int n2 = string2.indexOf("-->");
            string2 = string2.substring(n2 + 3);
            string = string + " " + string2;
        }
        return string;
    }

    private void initVars() {
        this.mSrcVarList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        this.mListScrollPane = new JScrollPane(this.mSrcVarList);
        this.mListScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        this.mSrcVarList.setIdentifier("SourceList");
        this.mSrcVarList.addFocusListener(this);
        this.mSrcVarList.addListSelectionListener(this);
        this.mArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mTargetListLabel = DialogUtil.createLabel(this, "IDS_VARIABLES_NEW_NAME");
        this.mTargetVarList = new TargetVariableList();
        this.mTargetVarList.setSelectionMode(2);
        this.mTargetVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mTargetVarList.addVarFilter(new AutoRecodeFilter());
        this.mSrcVarList.setIdentifier("TargetList");
        this.mTargetVarList.addFocusListener(this);
        this.mTargetVarList.setLoadFromPersistent(false);
        this.mFormatter = new AutoRecodeSpssVarFormatter(this.mTargetVarList);
        this.mTargetVarList.setModel(new AutoRecodeListModel(this.mFormatter));
        this.mTargetVarList.setCellRenderer(new CustomVarListCellRenderer(this.mFormatter));
        this.mTargetVarList.getModel().addListDataListener(this);
        this.mTargetVarList.setShowIcon(false);
        this.mTargetVarList.addListSelectionListener(this);
        this.mTargetListLabel.setLabelFor(this.mTargetVarList);
        this.mTargetScrollPane = new JScrollPane(this.mTargetVarList);
        this.mTargetVarList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mTargetVarList.getFixedCellHeight() * 7 + 2));
        this.mTargetScrollPane.setPreferredSize(this.mTargetVarList.getMinimumSize());
        this.mNewNameLabel = DialogUtil.createLabel(this, "IDS_NEW_NAME_LABEL");
        this.mArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mArrowButton.registerVariableList(this.mTargetVarList, SpssArrowButton.ButtonOrientation.left);
        this.mNewTextField = new StringTextField();
        this.mNewTextField.getDocument().addDocumentListener(this);
        this.mNewNameLabel.setLabelFor((Component)((Object)this.mNewTextField));
        ControlAction controlAction = new ToggleButtonAction(this, NEW_NAME_BUTTON_KEY){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AutoRecodeDlg.this.checkTextValidation();
            }
        };
        this.mNewNameButton = new JButton(controlAction);
        this.mGroup = new SpssButtonGroup();
        controlAction = new ToggleButtonAction(this, RADIO_LOWER_KEY);
        this.mLowestRadioButton = new JRadioButton(controlAction);
        controlAction = new ToggleButtonAction(this, RADIO_HIGHER_KEY);
        this.mHighestRadioButton = new JRadioButton(controlAction);
        controlAction = new ToggleButtonAction(this, USE_CHECK_KEY);
        this.mUseSameCheckBox = new JCheckBox(controlAction);
        this.mUseSameCheckBox.addItemListener(this);
        controlAction = new ToggleButtonAction(this, TREAT_CHECK_KEY);
        this.mTreatBlankCheckBox = new JCheckBox(controlAction);
        controlAction = new ToggleButtonAction(this, APPLY_CHECK_KEY);
        this.mApplyCheckBox = new JCheckBox(controlAction);
        this.mApplyCheckBox.addItemListener(this);
        controlAction = new ToggleButtonAction(this, SAVE_CHECK_KEY);
        this.mSaveCheckBox = new JCheckBox(controlAction);
        this.mSaveCheckBox.addItemListener(this);
        this.mFileChooserButton = new JButton();
        this.mFileChooserButtonT = new JButton();
        this.mFilePath = new FileTextField();
        controlAction = new TextFieldAction(this, "FilePath");
        this.mFilePath.setAction(controlAction);
        this.mFilePath.setBorder(BorderFactory.createEmptyBorder());
        this.mFilePath.getDocument().addDocumentListener(this);
        this.mSaveFilePath = new FileTextField();
        controlAction = new TextFieldAction(this, "SaveFilePath");
        this.mSaveFilePath.setAction(controlAction);
        this.mSaveFilePath.setBorder(BorderFactory.createEmptyBorder());
        this.mSaveFilePath.getDocument().addDocumentListener(this);
        this.mFileChooserButton.setAction(new ToggleButtonAction(this, FILE_BUTTON_KEY){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ContentValidatorFileChooser contentValidatorFileChooser = new ContentValidatorFileChooser(RemoteFileChooser.ChooserType.OpenFile, RemoteFileChooser.ChooserOption.Syntax, FileLocationsUtil.getDataFilesDirectoryPath(), DataServerProxy.getDataProxy().isRemoteConnection());
                RefFileFilter refFileFilter = new RefFileFilter(AutoRecodeDlg.this.getResString("IDS_FILTER_DESCRIPTION"), AutoRecodeDlg.this.getResString("IDS_FILE_EXTENSION"));
                contentValidatorFileChooser.addChoosableFileFilter((FileFilter)refFileFilter);
                contentValidatorFileChooser.setAcceptAllFileFilterUsed(true);
                contentValidatorFileChooser.setFileFilter((FileFilter)refFileFilter);
                contentValidatorFileChooser.setDialogTitle(AutoRecodeDlg.this.getResString("IDS_FILE_DIALOG_TITLE"));
                int n = contentValidatorFileChooser.showOpenDialog((Component)((Object)AutoRecodeDlg.this));
                if (n == 0) {
                    String string = contentValidatorFileChooser.getSelectedFilePath();
                    if (string.endsWith(AutoRecodeDlg.this.getResString("IDS_FILE_EXTENSION")) || string.endsWith(AutoRecodeDlg.this.getResString("IDS_SAV_FILE_EXTENSION"))) {
                        AutoRecodeDlg.this.mFilePath.setText(string);
                        AutoRecodeDlg.this.mApplyFilePathString = string;
                        AutoRecodeDlg.this.mFilePath.setEnabled(true);
                    } else {
                        String string2 = String.format(ComponentState.getSPSSLocale(), AutoRecodeDlg.this.getResString("ERR_FILE_MESSAGE"), string);
                        SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)AutoRecodeDlg.this), string2, VersionInfo.getAppVersionString());
                    }
                    AutoRecodeDlg.this.checkStateOfCheckBox();
                }
            }
        });
        this.mFileChooserButtonT.setAction(new ToggleButtonAction(this, FILE_BUTTONT_KEY){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RemoteFileChooser remoteFileChooser = new RemoteFileChooser(RemoteFileChooser.ChooserType.SaveFile, RemoteFileChooser.ChooserOption.Generic, FileLocationsUtil.getDataFilesDirectoryPath(), DataServerProxy.getDataProxy().isRemoteConnection());
                RefFileFilter refFileFilter = new RefFileFilter(AutoRecodeDlg.this.getResString("IDS_FILTER_DESCRIPTION"), AutoRecodeDlg.this.getResString("IDS_FILE_EXTENSION"));
                remoteFileChooser.setFileFilter((FileFilter)refFileFilter);
                remoteFileChooser.setAcceptAllFileFilterUsed(false);
                remoteFileChooser.setDialogTitle(AutoRecodeDlg.this.getResString("IDS_FILE_DIALOG_SAVE_TITLE"));
                int n = remoteFileChooser.showSaveDialog((Component)((Object)AutoRecodeDlg.this));
                if (n == 0) {
                    FileLocationsUtil.setDataFilesDirectoryPath((String)remoteFileChooser.getCurrentDirectory().getAbsolutePath());
                    String string = remoteFileChooser.getSelectedFilePath();
                    if (!string.endsWith(AutoRecodeDlg.this.getResString("IDS_FILE_EXTENSION"))) {
                        AutoRecodeDlg.this.mSaveFilePath.setText(string + AutoRecodeDlg.this.getResString("IDS_FILE_EXTENSION"));
                    } else {
                        AutoRecodeDlg.this.mSaveFilePath.setText(string);
                    }
                }
                AutoRecodeDlg.this.checkStateOfCheckBox();
            }
        });
    }

    private void setDefaults() {
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcVarList.requestFocus();
        this.mSrcVarList.setSelectedIndex(0);
        this.mNewTextField.setEnabled(false);
        this.mNewTextField.setOpaque(false);
        this.mNewNameLabel.setEnabled(false);
        this.mNewNameButton.setEnabled(false);
        this.mFileChooserButton.setEnabled(false);
        this.mFileChooserButtonT.setEnabled(false);
        this.mFilePath.setOpaque(true);
        this.mFilePath.setEditable(false);
        this.mFilePath.setEnabled(false);
        this.mFilePath.setText("");
        this.mApplyFilePathString = "";
        this.mSaveFilePathString = "";
        this.mSaveFilePath.setText("");
        this.mSaveFilePath.setOpaque(false);
        this.mSaveFilePath.setEditable(false);
        this.mLowestRadioButton.setSelected(true);
        if (!RemoteFileChooser.enableSaveInModeler()) {
            this.mApplyCheckBox.setEnabled(false);
            this.mSaveCheckBox.setEnabled(false);
        }
    }

    private void arrowButtonEnableCondition(int n) {
        ISpssVariable iSpssVariable = this.mSrcVarList.getModel().getElementAt(n);
        ISpssVariable iSpssVariable2 = this.mTargetVarList.getModel().getElementAt(0);
        if (iSpssVariable.getType() == iSpssVariable2.getType()) {
            this.mArrowButton.setEnabled(true);
        } else if (iSpssVariable.getType() > 0 && iSpssVariable2.getType() > 0) {
            this.mArrowButton.setEnabled(true);
        } else {
            this.mArrowButton.setEnabled(false);
        }
    }

    private void useCheckBoxEnableCondition() {
        int n = 0;
        int n2 = 0;
        int n3 = this.mTargetVarList.getModel().getSize();
        for (int i = 0; i < n3; ++i) {
            ISpssVariable iSpssVariable = this.mTargetVarList.getModel().getElementAt(i);
            if (iSpssVariable.getType() != 0) {
                ++n;
            }
            if (iSpssVariable.getType() != 0) continue;
            ++n2;
        }
        if (n >= 2 && n2 >= 1) {
            this.mUseSameCheckBox.setEnabled(false);
            return;
        }
        if (n >= 2 && n2 == 0) {
            this.mUseSameCheckBox.setEnabled(true);
            return;
        }
        if (n == 1 && n2 >= 1) {
            this.mUseSameCheckBox.setEnabled(false);
            return;
        }
        if (n == 0 && n2 >= 1) {
            this.mUseSameCheckBox.setEnabled(true);
            return;
        }
        if (n == 1 && n2 == 0) {
            this.mUseSameCheckBox.setEnabled(true);
        }
    }

    private void checkTextValidation() {
        int n;
        String string = this.mNewTextField.getText();
        boolean bl = AutoRecodeDlg.varNameExists(string);
        if (bl) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_DUPLICATE_ERROR_MESSAGE"), VersionInfo.getAppVersionString());
            this.mNewTextField.setText(string);
            this.mNewTextField.requestFocus();
            this.mNewTextField.selectAll();
            return;
        }
        int n2 = this.mTargetVarList.getModel().getSize();
        for (n = n2 - 1; n >= 0; --n) {
            String string2 = this.mFormatter.getDisplayText(this.mTargetVarList.getModel().getElementAt(n));
            int n3 = string2.indexOf("-->");
            if (!(string2 = string2.substring(n3 + 3)).equalsIgnoreCase(string) || this.mTargetVarList.getSelectedIndex() == n) continue;
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_DUPLICATE_ERROR_MESSAGE"), VersionInfo.getAppVersionString());
            this.mNewTextField.setText(string);
            this.mNewTextField.requestFocus();
            this.mNewTextField.selectAll();
            return;
        }
        n = VarNameValidator.validateSPSSName((String)string, (boolean)true).asInt();
        boolean bl2 = DialogUtil.showBadSpssVarNameWarning(n, this);
        if (bl2) {
            this.mNewTextField.setText("");
            AutoRecodeListModel autoRecodeListModel = (AutoRecodeListModel)this.mTargetVarList.getModel();
            int n4 = this.mTargetVarList.getSelectedIndex();
            autoRecodeListModel.setElementPropertyAt(n4, string);
            this.checkStateOfCheckBox();
        }
        this.mNewTextField.setText(string);
        this.mNewTextField.requestFocus();
        this.mNewTextField.selectAll();
    }

    private void setUI(JPanel jPanel) {
        JPanel jPanel2 = this.setUpPanel();
        JPanel jPanel3 = this.setUpTemplateCheckPanel();
        JPanel jPanel4 = this.setUpCheckPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, jPanel4, gridBagConstraints, 0, 1, 1, 1, n, null);
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 2, 1, 1, n, null);
    }

    private JPanel setUpPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JPanel jPanel2 = this.setUpNewNamePanel();
        JPanel jPanel3 = this.setUpRadioPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_AUTOMATIC_RECODE_TRANSFORM_SOURCE_LABEL");
        jLabel.setLabelFor(this.mSrcVarList);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mListScrollPane, gridBagConstraints, 0, 1, 1, 6, n, null);
        n = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets = DialogUtil.getArrowButtonInsets();
        DialogUtil.addUsingGBL(jPanel, this.mArrowButton, gridBagConstraints, 1, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        n = 23;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mTargetListLabel, gridBagConstraints, 2, 0, 1, 1, n, null);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mTargetScrollPane, gridBagConstraints, 2, 1, 3, 3, n, null);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 2, 3, 2, 2, n, null);
        gridBagConstraints.weighty = 0.5;
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 2, 5, 2, 2, n, null);
        return jPanel;
    }

    private JPanel setUpNewNamePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = new Insets(5, 5, 5, 5);
        int n = 23;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mNewNameLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mNewTextField), gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets = new Insets(5, 10, 5, 5);
        DialogUtil.addUsingGBL(jPanel, this.mNewNameButton, gridBagConstraints, 1, 1, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setUpRadioPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        TitledBorder titledBorder = new TitledBorder(this.getResString("IDS_RADIO"));
        jPanel.setBorder(titledBorder);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mLowestRadioButton, gridBagConstraints, 0, 0, 1, 1, n, insets);
        this.mGroup.add(this.mLowestRadioButton);
        gridBagConstraints.weightx = 1.0;
        this.mGroup.add(this.mHighestRadioButton);
        DialogUtil.addUsingGBL(jPanel, this.mHighestRadioButton, gridBagConstraints, 1, 0, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setUpCheckPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mUseSameCheckBox, gridBagConstraints, 0, 0, 1, 1, n, null);
        DialogUtil.addUsingGBL(jPanel, this.mTreatBlankCheckBox, gridBagConstraints, 0, 1, 1, 1, n, null);
        DialogUtil.createButtonGroup(jPanel);
        return jPanel;
    }

    private JPanel setUpTemplateCheckPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        TitledBorder titledBorder = new TitledBorder(this.getResString("IDS_TEMPLATE"));
        jPanel.setBorder(titledBorder);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mApplyCheckBox, gridBagConstraints, 0, 0, 1, 1, n, null);
        DialogUtil.addUsingGBL(jPanel, this.mSaveCheckBox, gridBagConstraints, 0, 1, 1, 1, n, null);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets = new Insets(0, 3, 1, 3);
        DialogUtil.addUsingGBL(jPanel, this.mFileChooserButton, gridBagConstraints, 1, 0, 1, 1, n, insets);
        insets = new Insets(0, 3, 1, 3);
        DialogUtil.addUsingGBL(jPanel, this.mFileChooserButtonT, gridBagConstraints, 1, 1, 1, 1, n, insets);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        insets.set(3, 3, 1, 3);
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mFilePath), gridBagConstraints, 2, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mSaveFilePath), gridBagConstraints, 2, 1, 1, 1, n, insets);
        DialogUtil.createButtonGroup(jPanel);
        return jPanel;
    }

    private boolean checkList() {
        int n = this.mTargetVarList.getModel().getSize();
        for (int i = 0; i < n; ++i) {
            String string = this.mFormatter.getDisplayText(this.mTargetVarList.getModel().getElementAt(i));
            if (!string.endsWith("-->????????")) continue;
            return true;
        }
        return false;
    }

    private boolean checkTargetModelSize() {
        int n = this.mTargetVarList.getModel().getSize();
        return n > 0;
    }

    private boolean isFilePathEmpty(FileTextField fileTextField) {
        String string = fileTextField.getText();
        return string.equals("");
    }

    private void checkStateOfCheckBox() {
        if (this.checkTargetModelSize() & !this.checkList() & this.isApplyCheckBoxCondition() & this.isSaveCheckBoxCondition()) {
            this.enableOkPaste(true);
        } else {
            this.enableOkPaste(false);
        }
    }

    private boolean isApplyCheckBoxCondition() {
        if (this.mApplyCheckBox.isSelected()) {
            this.mFilePath.setEnabled(true);
            this.mFileChooserButton.setEnabled(true);
            return !this.isFilePathEmpty(this.mFilePath);
        }
        this.mFilePath.setEnabled(false);
        this.mFileChooserButton.setEnabled(false);
        return true;
    }

    private boolean isSaveCheckBoxCondition() {
        if (this.mSaveCheckBox.isSelected()) {
            this.mSaveFilePath.setEnabled(true);
            this.mFileChooserButtonT.setEnabled(true);
            return !this.isFilePathEmpty(this.mSaveFilePath);
        }
        this.mSaveFilePath.setEnabled(false);
        this.mFileChooserButtonT.setEnabled(false);
        return true;
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcVarList);
        vector.add(this.mArrowButton);
        vector.add(this.mTargetVarList);
        vector.add(this.mNewTextField);
        vector.add(this.mNewNameButton);
        vector.add(this.mGroup);
        vector.add(this.mUseSameCheckBox);
        vector.add(this.mTreatBlankCheckBox);
        vector.add(this.mApplyCheckBox);
        vector.add(this.mFileChooserButton);
        vector.add(this.mSaveCheckBox);
        vector.add(this.mFileChooserButtonT);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    class AutoRecodeFilter
    implements IVarFilter {
        AutoRecodeFilter() {
        }

        @Override
        public boolean canIncludeVariable(ISpssVariable iSpssVariable) {
            boolean bl;
            boolean bl2 = bl = iSpssVariable.getType() == 0;
            if (AutoRecodeDlg.this.mUseSameCheckBox.isSelected() && AutoRecodeDlg.this.mTargetVarList.getModel().getSize() > 0) {
                for (int i = 0; i < AutoRecodeDlg.this.mTargetVarList.getModel().getSize(); ++i) {
                    short s = AutoRecodeDlg.this.mTargetVarList.getModel().getElementAt(i).getType();
                    if ((!bl || s <= 0) && (bl || s != 0)) continue;
                    return false;
                }
            }
            return true;
        }
    }
}

