/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.transform;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.DocType;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.VarNameValidator;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.ITrendsInfo;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.controls.ComponentsArrowButton;
import com.spss.java_client.ui.controls.FixedLengthDocument;
import com.spss.java_client.ui.controls.FixedLengthNumericDocument;
import com.spss.java_client.ui.controls.PlainList;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.StringTextField;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.controls.drag_drop.PlainListDragAdapter;
import com.spss.java_client.ui.controls.drag_drop.PlainListDropListener;
import com.spss.java_client.ui.dialogs.base.transform.res.TransformResBundle;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.IPlainListVarMoveHandler;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.VarInfoBag;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.data.DataFrame;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.utils.SerializableObject;
import com.spss.uitools.controls.IntTextField;
import com.spss.uitools.controls.drag_drop.DragPane;
import com.spss.uitools.controls.drag_drop.IDropListener;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.Document;

public class TimeSeriesDlg
extends BaseProcedureDialog
implements ListDataListener,
ItemListener,
ListSelectionListener,
KeyListener,
ActionListener,
FocusListener,
IPlainListVarMoveHandler {
    private static final String DEFAULT_NAME_TEXT = "";
    private static final String DEFAULT_ORDER_TEXT = "1";
    private static final String DEFAULT_SPAN_TEXT = "1";
    private static final int MAX_VAR_LIMIT = 100;
    Map<String, Set<String>> mVariableMap;
    HashMap<String, SerializableObject> mPropertyMap;
    private SrcVariableList mSrcVarList;
    private PlainList mTargetVarList;
    private StringTextField mNameText;
    private JButton mChangeNameBtn;
    private JComboBox mFunctionCB;
    private JLabel mLblFunction;
    private IntTextField mOrderText;
    private IntTextField mSpanText;
    private JLabel mNameLabel;
    private JLabel mOrderLabel;
    private JLabel mSpanLabel;
    private ComponentsArrowButton mArrowButton;
    private Map<String, FunctionObject> mFunctionMap;
    private Vector<Object> mTabOrder;

    public TimeSeriesDlg(JFrame jFrame) {
        super(jFrame, false, TransformResBundle.getDefaultResourceBundleName(), TransformResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_CREATE_TIME_SERIES"));
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public String generateSyntax() {
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        stringBuffer.append(SyntaxUtil.getMainCommand("CREATE"));
        stringBuffer.append("\n  /");
        String string = this.getVariablesStringList();
        stringBuffer.append(string.replaceAll("\\) ", "\\)/"));
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        return stringBuffer.toString();
    }

    @Override
    public void reset() {
        super.reset();
        this.mVariableMap.clear();
        this.mPropertyMap.clear();
        ((DefaultListModel)this.mTargetVarList.getModel()).removeAllElements();
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcVarList.setSelectedIndex(0);
        this.mSrcVarList.requestFocus();
        this.mNameText.setText(DEFAULT_NAME_TEXT);
        this.mOrderText.setText("1");
        this.mSpanText.setText("1");
        this.mFunctionCB.setSelectedIndex(0);
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.enableOkPaste(true);
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.enableOkPaste(this.mTargetVarList.getModel().getSize() > 0);
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.enableOkPaste(this.mTargetVarList.getModel().getSize() > 0);
    }

    @Override
    public String getIActionKey() {
        return "transform_create_time_series";
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            this.checkCurrentFunction();
            this.enableChangeButton();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.mArrowButton) {
            if (SpssArrowButton.ButtonOrientation.right != ((ComponentsArrowButton)actionEvent.getSource()).getArrowOrientation()) {
                Object[] objectArray = this.mTargetVarList.getSelectedValues();
                int n = objectArray.length;
                int[] nArray = new int[n];
                int n2 = 0;
                for (int i = 0; i < n; ++i) {
                    TimeSeriesVariable timeSeriesVariable = (TimeSeriesVariable)objectArray[i];
                    for (int j = 0; j < this.mSrcVarList.getModel().getSize(); ++j) {
                        if (!timeSeriesVariable.getSpssVarName().equals(this.mSrcVarList.getModel().getElementAt(j).getName())) continue;
                        nArray[n2] = j;
                        ++n2;
                        break;
                    }
                    this.mVariableMap.get(timeSeriesVariable.getSpssVarName()).remove(timeSeriesVariable.getName());
                    this.mPropertyMap.remove(timeSeriesVariable.getName());
                    ((DefaultListModel)this.mTargetVarList.getModel()).removeElement(timeSeriesVariable);
                }
                this.mSrcVarList.setSelectedIndices(nArray);
                final SrcVariableList srcVariableList = this.mSrcVarList;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        srcVariableList.requestFocus();
                    }
                });
            } else if (this.mOrderText.isEnabled() && this.mOrderText.getText().length() == 0 || this.mSpanText.isEnabled() && this.mSpanText.getText().length() == 0 || this.mOrderText.getText().matches("0") || this.mSpanText.getText().matches("0")) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_EMPTY_ORDER_SPAN_MSG"), VersionInfo.getAppVersionString());
                if (this.mSpanText.isEnabled()) {
                    this.mSpanText.requestFocus();
                    this.mSpanText.selectAll();
                }
                if (this.mOrderText.isEnabled()) {
                    this.mOrderText.requestFocus();
                    this.mOrderText.selectAll();
                }
            } else {
                DefaultListModel defaultListModel = (DefaultListModel)this.mTargetVarList.getModel();
                int n = defaultListModel.getSize();
                ISpssVariable[] iSpssVariableArray = this.mSrcVarList.getSelectedValues();
                this.mSrcVarList.clearSelection();
                if (n + iSpssVariableArray.length <= 100) {
                    int n3 = this.mTargetVarList.getModel().getSize();
                    int n4 = n3 + iSpssVariableArray.length - 1;
                    this.mTargetVarList.clearSelection();
                    for (ISpssVariable iSpssVariable : iSpssVariableArray) {
                        TimeSeriesVariable timeSeriesVariable = new TimeSeriesVariable(iSpssVariable);
                        FunctionObject functionObject = this.mFunctionMap.get(this.getCurrentFunction());
                        timeSeriesVariable.setFunctionName(functionObject.getFunctionName());
                        timeSeriesVariable.setName(this.getNewVariableName(iSpssVariable));
                        if (functionObject.isOrder()) {
                            timeSeriesVariable.setOrderText(this.mOrderText.getText());
                        } else if (functionObject.isSpan()) {
                            timeSeriesVariable.setOrderText(this.mSpanText.getText());
                        }
                        timeSeriesVariable.setSpssVarName(iSpssVariable.getName());
                        this.mPropertyMap.put(timeSeriesVariable.getName(), timeSeriesVariable);
                        defaultListModel.addElement(timeSeriesVariable);
                    }
                    this.mTargetVarList.addSelectionInterval(n3, n4);
                    this.mTargetVarList.ensureIndexIsVisible(n4);
                    final PlainList plainList = this.mTargetVarList;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            plainList.requestFocus();
                        }
                    });
                } else {
                    String string = String.format(ComponentState.getSPSSLocale(), ResUtil.getCommonDlgString("ERR_LIST_MAX_LIMIT_EXCEEDED_WARNING"), 100);
                    SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this), string, VersionInfo.getAppVersionString());
                    this.mSrcVarList.setSelection(iSpssVariableArray);
                    this.mSrcVarList.requestFocus();
                }
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if ((listSelectionEvent.getSource().equals(this.mTargetVarList) || listSelectionEvent.getSource().equals(this.mSrcVarList)) && this.mTargetVarList.getSelectedIndex() == -1 && this.mSrcVarList.getSelectedIndex() == -1) {
            this.mNameText.setText(DEFAULT_NAME_TEXT);
            this.enableNameFuncPanel(false);
            this.mOrderText.setEnabled(false);
            this.mOrderText.setOpaque(false);
            this.mOrderLabel.setEnabled(false);
            this.mFunctionCB.setEnabled(false);
            this.mLblFunction.setEnabled(false);
            this.mChangeNameBtn.setEnabled(false);
        } else if (listSelectionEvent.getSource().equals(this.mTargetVarList) && this.mTargetVarList.getSelectedIndices().length == 1) {
            TimeSeriesVariable timeSeriesVariable = (TimeSeriesVariable)this.mTargetVarList.getSelectedValue();
            this.mNameText.setText(timeSeriesVariable.getName());
            FunctionObject functionObject = this.mFunctionMap.get(timeSeriesVariable.getFunctionName());
            this.mFunctionCB.setSelectedItem(functionObject);
            if (functionObject.isOrder()) {
                this.mOrderText.setText(timeSeriesVariable.getOrderText());
            } else {
                this.mSpanText.setText(timeSeriesVariable.getOrderText());
            }
            this.enableNameFuncPanel(true);
            this.mFunctionCB.setEnabled(true);
            this.mLblFunction.setEnabled(true);
            this.mChangeNameBtn.setEnabled(false);
        } else if (listSelectionEvent.getSource().equals(this.mTargetVarList) && this.mTargetVarList.getSelectedIndices().length > 1) {
            this.mNameText.setText(DEFAULT_NAME_TEXT);
            this.enableNameFuncPanel(false);
            this.mChangeNameBtn.setEnabled(false);
            if (this.mTargetVarList.getSelectedIndices().length > 1) {
                this.mFunctionCB.setEnabled(false);
                this.mLblFunction.setEnabled(false);
            }
        } else if (listSelectionEvent.getSource().equals(this.mSrcVarList) && this.mSrcVarList.getSelectedIndex() != -1) {
            this.mNameText.setText(DEFAULT_NAME_TEXT);
            this.mNameText.setEnabled(false);
            this.mNameText.setOpaque(false);
            this.mNameLabel.setEnabled(false);
            this.mChangeNameBtn.setEnabled(false);
            this.mOrderText.setEnabled(true);
            this.mOrderText.setOpaque(true);
            this.mOrderLabel.setEnabled(true);
            this.mFunctionCB.setEnabled(true);
            this.mLblFunction.setEnabled(true);
            this.mTargetVarList.clearSelection();
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        TimeSeriesVariable timeSeriesVariable = (TimeSeriesVariable)this.mTargetVarList.getSelectedValue();
        if (timeSeriesVariable != null) {
            this.enableChangeButton();
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource() instanceof SrcVariableList) {
            this.mArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
            if (this.mSrcVarList.getSelectedIndices().length != 1) {
                this.mNameText.setText(DEFAULT_NAME_TEXT);
                this.mNameText.setEnabled(false);
                this.mNameText.setOpaque(false);
                this.mNameLabel.setEnabled(false);
                this.mChangeNameBtn.setEnabled(false);
                this.mOrderText.setEnabled(true);
                this.mOrderText.setOpaque(true);
                this.mOrderLabel.setEnabled(true);
                this.mFunctionCB.setEnabled(true);
                this.mLblFunction.setEnabled(true);
                this.mTargetVarList.clearSelection();
            }
        } else {
            if (focusEvent.getSource() instanceof PlainList && this.mTargetVarList.getSelectedIndices().length == 1) {
                TimeSeriesVariable timeSeriesVariable = (TimeSeriesVariable)this.mTargetVarList.getSelectedValue();
                if (timeSeriesVariable != null) {
                    this.mNameText.setText(timeSeriesVariable.getName());
                    FunctionObject functionObject = this.mFunctionMap.get(timeSeriesVariable.getFunctionName());
                    this.mFunctionCB.setSelectedItem(functionObject);
                    if (functionObject.isOrder()) {
                        this.mOrderText.setText(timeSeriesVariable.getOrderText());
                    } else {
                        this.mSpanText.setText(timeSeriesVariable.getOrderText());
                    }
                    this.enableNameFuncPanel(true);
                }
                this.mSrcVarList.clearSelection();
            }
            this.mArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.left);
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public boolean okPastePressed() {
        boolean bl = true;
        if (this.mChangeNameBtn.isEnabled() && SpssAlertOptionPane.showConfirmDialog((Window)((Object)this), this.getResString("ERR_SAVE_CHANGES_WARNING"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION) != 0) {
            return false;
        }
        int n = this.getDataSource().getTrendsInfo().getPeriod();
        for (int i = this.mTargetVarList.getModel().getSize() - 1; i >= 0; --i) {
            TimeSeriesVariable timeSeriesVariable = (TimeSeriesVariable)this.mTargetVarList.getModel().getElementAt(i);
            if (!timeSeriesVariable.getFunctionName().equals("SDIFF") || n > 1) continue;
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_NO_PERIODICITY_WARNING_MSG"), VersionInfo.getAppVersionString());
            return false;
        }
        if (this.changeExistingVariables() && 0 != SpssAlertOptionPane.showConfirmDialog((Window)((Object)this), this.getResString("ERR_RMV_WARNING_CHANGE_EXISTING_VARIABLE"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eQuestion, SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION)) {
            bl = false;
        }
        return bl && super.okPastePressed();
    }

    @Override
    public String getDialogHelpID() {
        return "idh_crea";
    }

    @Override
    public void pack() {
        super.pack();
        if (this.getGlassPane() instanceof DragPane) {
            this.addDragAdapters();
        }
    }

    @Override
    public boolean isDragAllowed(JList jList, JList jList2, Object[] objectArray) {
        return true;
    }

    @Override
    public Object[] getModifiedData(Object[] objectArray, JList jList, PlainList plainList) {
        Object[] objectArray2 = new Object[objectArray.length];
        int n = 0;
        if (plainList.equals(this.mTargetVarList)) {
            for (Object object : objectArray) {
                if (!(object instanceof ISpssVariable)) continue;
                TimeSeriesVariable timeSeriesVariable = new TimeSeriesVariable((ISpssVariable)object);
                FunctionObject functionObject = this.mFunctionMap.get(this.getCurrentFunction());
                timeSeriesVariable.setFunctionName(functionObject.getFunctionName());
                timeSeriesVariable.setName(this.getNewVariableName((ISpssVariable)object));
                if (functionObject.isOrder()) {
                    timeSeriesVariable.setOrderText(this.mOrderText.getText());
                } else if (functionObject.isSpan()) {
                    timeSeriesVariable.setOrderText(this.mSpanText.getText());
                }
                timeSeriesVariable.setSpssVarName(((ISpssVariable)object).getName());
                this.mPropertyMap.put(timeSeriesVariable.getName(), timeSeriesVariable);
                objectArray2[n] = timeSeriesVariable;
                ++n;
            }
        }
        if (n == objectArray.length) {
            return objectArray2;
        }
        return objectArray;
    }

    @Override
    public boolean preMoveVariables(Object[] objectArray, PlainList plainList) {
        if (plainList.equals(this.mTargetVarList)) {
            if (this.mOrderText.isEnabled() && this.mOrderText.getText().length() == 0 || this.mSpanText.isEnabled() && this.mSpanText.getText().length() == 0 || this.mOrderText.getText().matches("0") || this.mSpanText.getText().matches("0")) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_EMPTY_ORDER_SPAN_MSG"), VersionInfo.getAppVersionString());
                if (this.mSpanText.isEnabled()) {
                    this.mSpanText.requestFocus();
                    this.mSpanText.selectAll();
                    return false;
                }
                if (this.mOrderText.isEnabled()) {
                    this.mOrderText.requestFocus();
                    this.mOrderText.selectAll();
                    return false;
                }
            }
            int n = 0;
            if (this.mTargetVarList.getMaxLimitOfList() < objectArray.length - n + this.mTargetVarList.getModel().getSize()) {
                String string = String.format(ComponentState.getSPSSLocale(), ResUtil.getCommonDlgString("ERR_LIST_MAX_LIMIT_EXCEEDED_WARNING"), this.mTargetVarList.getMaxLimitOfList());
                SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this), string, VersionInfo.getAppVersionString());
                return false;
            }
        }
        return true;
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        this.setupViewPanel(jPanel);
        this.enableNameFuncPanel(false);
        this.mSrcVarList.setSelectedIndex(0);
        this.setTabPolicy();
        this.pack();
    }

    @Override
    protected void loadDialogState() {
        HashMap<String, SerializableObject> hashMap;
        super.loadDialogState();
        this.validateSerializableLists();
        Map map = (Map)this.getDialogDataModel().getObject("TIME_SERIES_VAR_MAP");
        if (map != null) {
            this.mVariableMap = map;
        }
        if ((hashMap = this.getDialogDataModel().getSerializableMap("TIME_SERIES_PROPS_MAP")) != null) {
            this.mPropertyMap = hashMap;
        }
        this.mSrcVarList.setSelectedIndex(0);
    }

    @Override
    protected void validateSerializableLists() {
        this.mSrcVarList.loadFromActiveDataset();
        for (int i = this.mTargetVarList.getModel().getSize() - 1; i >= 0; --i) {
            TimeSeriesVariable timeSeriesVariable = (TimeSeriesVariable)this.mTargetVarList.getModel().getElementAt(i);
            LocallyUniqueId locallyUniqueId = ProcedureDlgMgr.getMgr().getActiveDatasetId();
            ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
            int n = iSpssDataSrc.findVarIndex(timeSeriesVariable.getSpssVarName());
            ISpssVariable iSpssVariable = timeSeriesVariable.getSpssVariable();
            if (iSpssVariable != null && n == -1) {
                boolean bl = iSpssDataSrc.isVariableInCurrentSet(timeSeriesVariable.getSpssVariable());
                if (!bl) {
                    ((DefaultListModel)this.mTargetVarList.getModel()).removeElementAt(i);
                    continue;
                }
                FunctionObject functionObject = this.mFunctionMap.get(this.getCurrentFunction());
                timeSeriesVariable.setFunctionName(functionObject.getFunctionName());
                timeSeriesVariable.setName(this.getNewVariableName(iSpssVariable));
                timeSeriesVariable.setSpssVarName(iSpssVariable.getName());
                continue;
            }
            if (this.mSrcVarList.canIncludeVariable(iSpssDataSrc.getVariable(n))) continue;
            ((DefaultListModel)this.mTargetVarList.getModel()).removeElementAt(i);
        }
        this.mTargetVarList.repaint();
        this.enableOkPaste(this.mTargetVarList.getModel().getSize() > 0);
    }

    @Override
    protected void saveDialogState() {
        this.getDialogDataModel().putObject("TIME_SERIES_VAR_MAP", this.mVariableMap);
        this.getDialogDataModel().putSerializableMap("TIME_SERIES_PROPS_MAP", this.mPropertyMap);
        super.saveDialogState();
    }

    private void addDragAdapters() {
        DragPane dragPane = (DragPane)this.getGlassPane();
        dragPane.addDropListener((IDropListener)new PlainListDropListener(this.mSrcVarList, this.mPlainListVarMoveHandler));
        PlainListDragAdapter plainListDragAdapter = new PlainListDragAdapter(this.mTargetVarList, dragPane, "PlainList");
        DialogUtil.modifyMouseInputListeners(this.mTargetVarList, plainListDragAdapter);
        dragPane.addDropListener((IDropListener)new PlainListDropListener(this.mTargetVarList, this.mPlainListVarMoveHandler));
    }

    private void initVars() {
        this.mSrcVarList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        this.mSrcVarList.addVarFilter(new SpssVarFilter(8, false));
        this.mTargetVarList = new PlainList("TIME_SERIES_TARGET_LIST");
        this.mTargetVarList.setDragType(PlainList.DragType.eAutoDragCopy);
        this.mTargetVarList.setMaxLimitOfList(100);
        this.mNameText = new StringTextField(16);
        this.mNameText.setDocument(new FixedLengthDocument(64));
        this.mChangeNameBtn = new JButton(new ChangeAction("IDS_COMMON_CHANGE_BUTTON"));
        this.mOrderText = new IntTextField(1, 999, true);
        this.mOrderText.setAllowMinMax(true, true);
        this.mSpanText = new IntTextField(1, 999, true);
        this.mSpanText.setAllowMinMax(true, true);
        this.mNameLabel = DialogUtil.createLabel(this, "IDS_NAME");
        this.mNameLabel.setLabelFor((Component)((Object)this.mNameText));
        this.mOrderLabel = DialogUtil.createLabel(this, "IDS_ORDER");
        this.mSpanLabel = DialogUtil.createLabel(this, "IDS_SPAN");
        this.mFunctionMap = new HashMap<String, FunctionObject>();
        FunctionObject[] functionObjectArray = this.createDefaultFunctions();
        this.mFunctionCB = new JComboBox<FunctionObject>(functionObjectArray);
        this.mTabOrder = new Vector();
        this.mVariableMap = new HashMap<String, Set<String>>();
        this.mPropertyMap = new HashMap();
        this.mOrderText.setDocument((Document)new FixedLengthNumericDocument(3, true, false));
        this.mSpanText.setDocument((Document)new FixedLengthNumericDocument(3, true, false));
        this.mChangeNameBtn.setEnabled(false);
        this.mSrcVarList.setSelectedIndex(0);
        this.mPlainListVarMoveHandler = this;
    }

    private void setupViewPanel(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_CREATE_TIME_SERIES_SOURCE_LIST_LABEL");
        jLabel.setLabelFor(this.mSrcVarList);
        Insets insets = DialogUtil.getStandardControlInsets();
        JScrollPane jScrollPane = new JScrollPane(this.mSrcVarList);
        this.mArrowButton = new ComponentsArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mArrowButton.registerComponents(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mArrowButton.registerComponents(this.mTargetVarList, SpssArrowButton.ButtonOrientation.left);
        ActionListener[] actionListenerArray = this.mArrowButton.getActionListeners();
        this.mTargetVarList.addFocusListener(this);
        this.mSrcVarList.addFocusListener(this);
        for (ActionListener object2 : actionListenerArray) {
            this.mArrowButton.removeActionListener(object2);
        }
        this.mArrowButton.addActionListener(this);
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_VARIABLES_COLON");
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        gridBagConstraints.fill = 0;
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, null);
        this.mSrcVarList.addListSelectionListener(this);
        this.mTabOrder.add(this.mSrcVarList);
        this.mSrcVarList.loadFromActiveDataset();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 1, 1, 6, n, insets);
        this.mTabOrder.add(this.mArrowButton);
        n = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets2 = DialogUtil.getArrowButtonInsets();
        DialogUtil.addUsingGBL(jPanel, this.mArrowButton, gridBagConstraints, 1, 1, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        n = 21;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 2, 0, 1, 1, n, insets);
        this.mTabOrder.add(this.mTargetVarList);
        this.mTargetVarList.addListSelectionListener(this);
        n = 23;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jScrollPane = new JScrollPane(this.mTargetVarList);
        jScrollPane.setPreferredSize(this.mTargetVarList.getMinimumSize());
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 2, 1, 1, 2, n, insets);
        this.mTargetVarList.getModel().addListDataListener(this);
        this.setupFunctionPanel(jPanel2);
        insets = new Insets(DialogUtil.getComponentGroupGap(), 0, 0, 0);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 2, 3, 1, 4, n, insets);
        jLabel2.setLabelFor(this.mTargetVarList);
    }

    private void setupFunctionPanel(JPanel jPanel) {
        this.mLblFunction = DialogUtil.createLabel(this, "IDS_FUNCTION");
        this.mLblFunction.setLabelFor(this.mFunctionCB);
        this.mOrderText.setText("1");
        this.mOrderText.addKeyListener((KeyListener)this);
        this.mSpanText.setText("1");
        this.mSpanText.addKeyListener((KeyListener)this);
        this.mNameText.addKeyListener(this);
        this.mOrderLabel.setLabelFor((Component)this.mOrderText);
        this.mSpanLabel.setLabelFor((Component)this.mSpanText);
        JLabel jLabel = new JLabel(this.getResString("IDS_NONE"));
        JLabel jLabel2 = new JLabel(this.getResString("IDS_PERIODICITY"));
        ITrendsInfo iTrendsInfo = this.getDataSource().getTrendsInfo();
        if (iTrendsInfo != null && iTrendsInfo.getNDateVars() > 1) {
            jLabel.setText(Integer.toString(iTrendsInfo.getPeriod()));
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = DialogUtil.getStandardControlInsets();
        insets.right = 4;
        insets.bottom = 4;
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_NAME_FUNCTION")));
        gridBagConstraints.anchor = 23;
        this.mTabOrder.add(this.mNameText);
        this.mTabOrder.add(this.mChangeNameBtn);
        this.mTabOrder.add(this.mFunctionCB);
        this.mTabOrder.add(this.mOrderText);
        this.mTabOrder.add(this.mSpanText);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mNameLabel, gridBagConstraints, 0, 0, 1, 1, 23, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mNameText), gridBagConstraints, 1, 0, 3, 1, gridBagConstraints.anchor, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mChangeNameBtn, gridBagConstraints, 4, 0, 2, 1, gridBagConstraints.anchor, insets);
        DialogUtil.addUsingGBL(jPanel, this.mLblFunction, gridBagConstraints, 0, 1, 2, 1, 23, insets);
        gridBagConstraints.weightx = 1.0;
        this.mFunctionCB.addItemListener(this);
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mFunctionCB, gridBagConstraints, 0, 2, 5, 1, 23, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mOrderLabel, gridBagConstraints, 0, 3, 1, 1, 23, insets);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mOrderText, gridBagConstraints, 1, 3, 1, 1, 23, insets);
        DialogUtil.addUsingGBL(jPanel, this.mSpanLabel, gridBagConstraints, 2, 3, 1, 1, 23, insets);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mSpanText, gridBagConstraints, 3, 3, 1, 1, 23, insets);
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 0, 4, 2, 1, 23, insets);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 2, 4, 1, 1, 23, insets);
        DialogUtil.normalizeButtonWidths((JPanel)jPanel);
    }

    private void checkCurrentFunction() {
        FunctionObject functionObject = (FunctionObject)this.mFunctionCB.getSelectedItem();
        boolean bl = this.mTargetVarList.getModel().getSize() == 0 || this.mTargetVarList.getSelectedIndices().length == 1 || this.mTargetVarList.getSelectedIndices().length == 0;
        boolean bl2 = functionObject.isOrder();
        boolean bl3 = functionObject.isSpan();
        this.mOrderText.setEnabled(bl && bl2);
        this.mOrderText.setOpaque(bl && bl2);
        this.mOrderLabel.setEnabled(bl && bl2);
        this.mSpanText.setEnabled(bl && bl3);
        this.mSpanText.setOpaque(bl && bl3);
        this.mSpanLabel.setEnabled(bl && bl3);
    }

    private void enableChangeButton() {
        FunctionObject functionObject = (FunctionObject)this.mFunctionCB.getSelectedItem();
        TimeSeriesVariable timeSeriesVariable = (TimeSeriesVariable)this.mTargetVarList.getSelectedValue();
        boolean bl = true;
        if (timeSeriesVariable != null) {
            String string = this.mNameText.getText();
            if (string.length() == 0) {
                bl = false;
            } else {
                if (string.equalsIgnoreCase(timeSeriesVariable.getName()) && timeSeriesVariable.getFunctionName().equalsIgnoreCase(functionObject.getFunctionName())) {
                    string = this.mOrderText.getText();
                    if (this.mOrderText.isEnabled() && (string.length() == 0 || string.equalsIgnoreCase(timeSeriesVariable.getOrderText()))) {
                        bl = false;
                    }
                    string = this.mSpanText.getText();
                    if (bl && this.mSpanText.isEnabled() && (string.length() == 0 || string.equalsIgnoreCase(timeSeriesVariable.getOrderText()))) {
                        bl = false;
                    }
                }
                if (bl && this.mOrderText.isEnabled() && this.mOrderText.getText().length() == 0) {
                    bl = false;
                }
                if (bl && this.mSpanText.isEnabled() && this.mSpanText.getText().length() == 0) {
                    bl = false;
                }
            }
        } else {
            bl = false;
        }
        this.mChangeNameBtn.setEnabled(bl);
    }

    private FunctionObject[] createDefaultFunctions() {
        FunctionObject[] functionObjectArray = new FunctionObject[]{new FunctionObject(this.getResString("IDS_FUNC_DIFF"), "DIFF", true, false), new FunctionObject(this.getResString("IDS_FUNC_SDIFF"), "SDIFF", true, false), new FunctionObject(this.getResString("IDS_FUNC_MA"), "MA", false, true), new FunctionObject(this.getResString("IDS_FUNC_PMA"), "PMA", false, true), new FunctionObject(this.getResString("IDS_FUNC_RMED"), "RMED", false, true), new FunctionObject(this.getResString("IDS_FUNC_CSUM"), "CSUM", false, false), new FunctionObject(this.getResString("IDS_FUNC_LAG"), "LAG", true, false), new FunctionObject(this.getResString("IDS_FUNC_LEAD"), "LEAD", true, false), new FunctionObject(this.getResString("IDS_FUNC_SMOOTH"), "T4253H", false, false)};
        for (FunctionObject functionObject : functionObjectArray) {
            this.mFunctionMap.put(functionObject.getFunctionName(), functionObject);
        }
        return functionObjectArray;
    }

    private void enableNameFuncPanel(boolean bl) {
        this.mNameText.setEnabled(bl);
        this.mNameText.setOpaque(bl);
        this.mNameLabel.setEnabled(bl);
        this.checkCurrentFunction();
    }

    private boolean checkVariableName(TimeSeriesVariable timeSeriesVariable) {
        Set<String> set = this.mVariableMap.get(timeSeriesVariable.getSpssVarName());
        String string = timeSeriesVariable.getName();
        if (!string.equals(this.mNameText.getText())) {
            if (this.mPropertyMap.containsKey(this.mNameText.getText())) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_DUPLICATE_VARIABLE_MSG"), VersionInfo.getAppVersionString());
                this.mNameText.requestFocus();
                this.mNameText.selectAll();
                return false;
            }
            set.remove(string);
        }
        set.add(this.mNameText.getText());
        return true;
    }

    private String getNewVariableName(ISpssVariable iSpssVariable) {
        Set<Object> set;
        int n = 1;
        String string = iSpssVariable.getName();
        if (!this.mVariableMap.containsKey(string)) {
            set = new HashSet();
            this.mVariableMap.put(string, set);
        } else {
            set = this.mVariableMap.get(string);
        }
        if (string.length() > 7) {
            string = string.substring(0, 6);
        }
        string = string + "_";
        while (set.contains(string + n)) {
            ++n;
        }
        string = string + n;
        set.add(string);
        return string;
    }

    private String getCurrentFunction() {
        return ((FunctionObject)this.mFunctionCB.getSelectedItem()).getFunctionName();
    }

    private void setTabPolicy() {
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            this.mTabOrder.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(this.mTabOrder, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private String getVariablesStringList() {
        DefaultListModel defaultListModel = (DefaultListModel)this.mTargetVarList.getModel();
        String string = DEFAULT_NAME_TEXT;
        int n = defaultListModel.getSize();
        for (int i = 0; i < n; ++i) {
            string = string + defaultListModel.getElementAt(i).toString();
            if (i >= n - 1) continue;
            string = string + " ";
        }
        return string;
    }

    private ISpssDataSrc getDataSource() {
        ISpssDataSrc iSpssDataSrc = null;
        SpssFrame spssFrame = SpssFrameMgr.getSpssFrameMgr().getDesignatedWindow(DocType.DE_DOC);
        if (spssFrame instanceof DataFrame) {
            LocallyUniqueId locallyUniqueId = ((DataFrame)spssFrame).getDatasetId();
            iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        }
        return iSpssDataSrc;
    }

    private boolean changeExistingVariables() {
        boolean bl = false;
        LocallyUniqueId locallyUniqueId = ProcedureDlgMgr.getMgr().getActiveDatasetId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        for (int i = 0; i < this.mTargetVarList.getModel().getSize(); ++i) {
            TimeSeriesVariable timeSeriesVariable = (TimeSeriesVariable)this.mTargetVarList.getModel().getElementAt(i);
            if (iSpssDataSrc.findVarIndex(timeSeriesVariable.getName()) == -1) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static class TimeSeriesVariable
    implements SerializableObject {
        private final String DISPLAY_TEXT_FORMAT1 = "{0}={1}({2} {3})";
        private final String DISPLAY_TEXT_FORMAT2 = "{0}={1}({2})";
        private ISpssVariable mVariable;
        private String mName;
        private String mFunctionName;
        private String mOrderText;
        private String mSpssVarName;

        public TimeSeriesVariable() {
            this.mVariable = null;
            this.mName = TimeSeriesDlg.DEFAULT_NAME_TEXT;
        }

        TimeSeriesVariable(ISpssVariable iSpssVariable) {
            this.mVariable = iSpssVariable;
            this.mName = iSpssVariable.getName();
        }

        public String getFunctionName() {
            return this.mFunctionName;
        }

        public void setFunctionName(String string) {
            this.mFunctionName = string;
        }

        public String getName() {
            return this.mName;
        }

        public void setName(String string) {
            this.mName = string;
        }

        public String getOrderText() {
            return this.mOrderText;
        }

        public void setOrderText(String string) {
            this.mOrderText = string;
        }

        public String getSpssVarName() {
            return this.mSpssVarName;
        }

        public void setSpssVarName(String string) {
            this.mSpssVarName = string;
        }

        public ISpssVariable getSpssVariable() {
            return this.mVariable;
        }

        public void setSpssVariable(ISpssVariable iSpssVariable) {
            this.mVariable = iSpssVariable;
        }

        public String toString() {
            if (this.getOrderText() != null) {
                return MessageFormat.format("{0}={1}({2} {3})", this.getName(), this.getFunctionName(), this.getSpssVarName(), this.getOrderText());
            }
            return MessageFormat.format("{0}={1}({2})", this.getName(), this.getFunctionName(), this.getSpssVarName());
        }

        public String getClassName() {
            return "com.spss.java_client.ui.dialogs.base.transform.TimeSeriesDlg$TimeSeriesVariable";
        }

        public boolean readVersionedObject(ObjectInputStream objectInputStream, int n) throws Exception {
            this.mName = objectInputStream.readUTF();
            this.mFunctionName = objectInputStream.readUTF();
            this.mOrderText = objectInputStream.readUTF();
            this.mSpssVarName = objectInputStream.readUTF();
            VarInfoBag varInfoBag = new VarInfoBag();
            boolean bl = varInfoBag.readVersionedObject(objectInputStream, n);
            if (bl) {
                this.mVariable = DialogDataModel.varBagToVariable(varInfoBag);
            }
            return bl;
        }

        public boolean writeVersionedObject(ObjectOutputStream objectOutputStream, int n) throws Exception {
            objectOutputStream.writeUTF(this.mName);
            objectOutputStream.writeUTF(this.mFunctionName);
            objectOutputStream.writeUTF(this.mOrderText);
            objectOutputStream.writeUTF(this.mSpssVarName);
            VarInfoBag varInfoBag = new VarInfoBag(this.mVariable);
            return varInfoBag.writeVersionedObject(objectOutputStream, n);
        }
    }

    private class ChangeAction
    extends ToggleButtonAction {
        public ChangeAction(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TimeSeriesVariable timeSeriesVariable = (TimeSeriesVariable)TimeSeriesDlg.this.mTargetVarList.getSelectedValue();
            boolean bl = true;
            String string = TimeSeriesDlg.this.mNameText.getText().trim();
            int n = VarNameValidator.validateSPSSName((String)string, (boolean)true).asInt();
            if (n > 0 && n != 100) {
                bl = DialogUtil.showBadSpssVarNameWarning(n, TimeSeriesDlg.this);
            }
            if (bl && TimeSeriesDlg.this.checkVariableName(timeSeriesVariable)) {
                TimeSeriesDlg.this.mPropertyMap.remove(timeSeriesVariable.getName());
                timeSeriesVariable.setFunctionName(TimeSeriesDlg.this.getCurrentFunction());
                timeSeriesVariable.setName(TimeSeriesDlg.this.mNameText.getText());
                if (TimeSeriesDlg.this.mOrderText.isEnabled() || TimeSeriesDlg.this.mSpanText.isEnabled()) {
                    if (TimeSeriesDlg.this.mOrderText.isEnabled()) {
                        timeSeriesVariable.setOrderText(TimeSeriesDlg.this.mOrderText.getText());
                    }
                    if (TimeSeriesDlg.this.mSpanText.isEnabled()) {
                        timeSeriesVariable.setOrderText(TimeSeriesDlg.this.mSpanText.getText());
                    }
                } else {
                    timeSeriesVariable.setOrderText(TimeSeriesDlg.DEFAULT_NAME_TEXT);
                }
                TimeSeriesDlg.this.mPropertyMap.put(timeSeriesVariable.getName(), timeSeriesVariable);
                int n2 = TimeSeriesDlg.this.mTargetVarList.getSelectedIndex();
                ((DefaultListModel)TimeSeriesDlg.this.mTargetVarList.getModel()).remove(n2);
                ((DefaultListModel)TimeSeriesDlg.this.mTargetVarList.getModel()).add(n2, timeSeriesVariable);
                TimeSeriesDlg.this.mTargetVarList.setSelectedIndex(n2);
                TimeSeriesDlg.this.checkCurrentFunction();
                TimeSeriesDlg.this.mChangeNameBtn.setEnabled(false);
            } else {
                TimeSeriesDlg.this.mNameText.requestFocus();
                TimeSeriesDlg.this.mNameText.selectAll();
            }
        }
    }

    private class FunctionObject {
        private String mFunctionLabel;
        private String mFunctionName;
        private boolean mIsOrder;
        private boolean mIsSpan;

        public FunctionObject(String string, String string2, boolean bl, boolean bl2) {
            this.mFunctionLabel = string;
            this.mFunctionName = string2;
            this.mIsOrder = bl;
            this.mIsSpan = bl2;
        }

        private String getFunctionName() {
            return this.mFunctionName;
        }

        private String getFunctionLabel() {
            return this.mFunctionLabel;
        }

        private boolean isOrder() {
            return this.mIsOrder;
        }

        private boolean isSpan() {
            return this.mIsSpan;
        }

        public String toString() {
            return this.getFunctionLabel();
        }

        public boolean equals(Object object) {
            return object instanceof FunctionObject && this.mFunctionName.equals(((FunctionObject)object).getFunctionName());
        }
    }
}

