/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.transform;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.VarNameValidator;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.ComponentsArrowButton;
import com.spss.java_client.ui.controls.FixedLengthDocument;
import com.spss.java_client.ui.controls.FixedLengthNumericDocument;
import com.spss.java_client.ui.controls.PlainList;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.StringTextField;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.controls.drag_drop.PlainListDragAdapter;
import com.spss.java_client.ui.controls.drag_drop.PlainListDropListener;
import com.spss.java_client.ui.dialogs.base.transform.res.TransformResBundle;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.IPlainListVarMoveHandler;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.VarInfoBag;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.utils.SerializableObject;
import com.spss.uitools.controls.IntTextField;
import com.spss.uitools.controls.drag_drop.DragPane;
import com.spss.uitools.controls.drag_drop.IDropListener;
import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.geom.Rectangle2D;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.Document;

public class ShiftValuesDlg
extends BaseProcedureDialog
implements ListDataListener,
ItemListener,
ListSelectionListener,
KeyListener,
ActionListener,
FocusListener,
IPlainListVarMoveHandler {
    private static final String CHANGE_BUTTON_KEY = "IDS_COMMON_CHANGE_BUTTON";
    private static final String LAG_RADIO_KEY = "IDS_METHOD_LAG_RADIO";
    private static final String LEAD_RADIO_KEY = "IDS_METHOD_LEAD_RADIO";
    private static final String DEFAULT_NAME_TEXT = "";
    private static final String DEFAULT_CASES_TO_SHIFT_TEXT = "1";
    private static final int MAX_VAR_LIMIT = 100;
    Map<String, Set<String>> mVariableMap;
    Map<String, ShiftSeriesVariable> mPropertyMap;
    private SrcVariableList mSrcVarList;
    private PlainList mTargetVarList;
    private StringTextField mNameText;
    private JButton mChangeNameBtn;
    private SpssButtonGroup mGroup;
    private JRadioButton mLagRadioButton;
    private JRadioButton mLeadRadioButton;
    private JLabel mLblMethod;
    private IntTextField mCasesToShift;
    private JLabel mNameLabel;
    private JLabel mCasesToShiftLabel;
    private ComponentsArrowButton mArrowButton;
    private Map<String, MethodObject> mMethodMap;
    private Vector<Object> mTabOrder;

    public ShiftValuesDlg(JFrame jFrame) {
        super(jFrame, false, TransformResBundle.getDefaultResourceBundleName(), TransformResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_SHIFT_VALUES"));
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public String generateSyntax() {
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        stringBuffer.append(SyntaxUtil.getMainCommand("SHIFT VALUES"));
        stringBuffer.append(this.getVariablesStringBuffer());
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        return stringBuffer.toString();
    }

    @Override
    public void reset() {
        super.reset();
        this.mVariableMap.clear();
        this.mPropertyMap.clear();
        ((DefaultListModel)this.mTargetVarList.getModel()).removeAllElements();
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcVarList.setSelectedIndex(0);
        this.mSrcVarList.requestFocus();
        this.mNameText.setText(DEFAULT_NAME_TEXT);
        this.mCasesToShift.setText(DEFAULT_CASES_TO_SHIFT_TEXT);
        this.mLagRadioButton.setSelected(true);
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.enableOkPaste(this.canEnableOkPaste());
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.enableOkPaste(this.canEnableOkPaste());
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.enableOkPaste(this.canEnableOkPaste());
    }

    @Override
    public String getIActionKey() {
        return "transform_shift_values";
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            this.checkCurrentMethod();
            this.enableChangeButton();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.mArrowButton) {
            if (SpssArrowButton.ButtonOrientation.right != ((ComponentsArrowButton)actionEvent.getSource()).getArrowOrientation()) {
                Object[] objectArray = this.mTargetVarList.getSelectedValues();
                int n = objectArray.length;
                int[] nArray = new int[n];
                int n2 = 0;
                for (int i = 0; i < n; ++i) {
                    ShiftSeriesVariable shiftSeriesVariable = (ShiftSeriesVariable)objectArray[i];
                    for (int j = 0; j < this.mSrcVarList.getModel().getSize(); ++j) {
                        if (!shiftSeriesVariable.getSpssVarName().equals(this.mSrcVarList.getModel().getElementAt(j).getName())) continue;
                        nArray[n2] = j;
                        ++n2;
                        break;
                    }
                    this.mVariableMap.get(shiftSeriesVariable.getSpssVarName()).remove(shiftSeriesVariable.getName());
                    this.mPropertyMap.remove(shiftSeriesVariable.getName());
                    ((DefaultListModel)this.mTargetVarList.getModel()).removeElement(shiftSeriesVariable);
                }
                this.mSrcVarList.setSelectedIndices(nArray);
                final SrcVariableList srcVariableList = this.mSrcVarList;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        srcVariableList.requestFocus();
                    }
                });
            } else if (this.mCasesToShift.isEnabled() && this.mCasesToShift.getText().length() == 0) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_EMPTY_CASES_TO_SHIFT_MSG"), VersionInfo.getAppVersionString());
                if (this.mCasesToShift.isEnabled()) {
                    this.mCasesToShift.requestFocus();
                    this.mCasesToShift.selectAll();
                }
            } else {
                DefaultListModel defaultListModel = (DefaultListModel)this.mTargetVarList.getModel();
                int n = defaultListModel.getSize();
                ISpssVariable[] iSpssVariableArray = this.mSrcVarList.getSelectedValues();
                this.mSrcVarList.clearSelection();
                if (n + iSpssVariableArray.length <= 100) {
                    int n3 = this.mTargetVarList.getModel().getSize();
                    int n4 = n3 + iSpssVariableArray.length - 1;
                    this.mTargetVarList.clearSelection();
                    for (ISpssVariable iSpssVariable : iSpssVariableArray) {
                        ShiftSeriesVariable shiftSeriesVariable = new ShiftSeriesVariable(iSpssVariable);
                        MethodObject methodObject = this.mMethodMap.get(this.getCurrentMethodName());
                        shiftSeriesVariable.setMethodName(methodObject.getMethodName());
                        shiftSeriesVariable.setName(iSpssVariable.getName());
                        this.putVarSet(iSpssVariable.getName());
                        if (methodObject.isCasesToShift()) {
                            shiftSeriesVariable.setCasesToShiftText(this.mCasesToShift.getText());
                        }
                        shiftSeriesVariable.setSpssVarName(iSpssVariable.getName());
                        this.mPropertyMap.put(shiftSeriesVariable.getName(), shiftSeriesVariable);
                        defaultListModel.addElement(shiftSeriesVariable);
                    }
                    this.mTargetVarList.addSelectionInterval(n3, n4);
                    this.mTargetVarList.ensureIndexIsVisible(n4);
                    final PlainList plainList = this.mTargetVarList;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            plainList.requestFocus();
                        }
                    });
                } else {
                    String string = String.format(ComponentState.getSPSSLocale(), ResUtil.getCommonDlgString("ERR_LIST_MAX_LIMIT_EXCEEDED_WARNING"), 100);
                    SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this), string, VersionInfo.getAppVersionString());
                    this.mSrcVarList.setSelection(iSpssVariableArray);
                    this.mSrcVarList.requestFocus();
                }
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if ((listSelectionEvent.getSource().equals(this.mTargetVarList) || listSelectionEvent.getSource().equals(this.mSrcVarList)) && this.mTargetVarList.getSelectedIndex() == -1 && this.mSrcVarList.getSelectedIndex() == -1) {
            this.mNameText.setText(DEFAULT_NAME_TEXT);
            this.enableNameFuncPanel(false);
            this.mChangeNameBtn.setEnabled(false);
            this.enableOkPaste(this.canEnableOkPaste());
        } else if (listSelectionEvent.getSource().equals(this.mTargetVarList) && this.mTargetVarList.getSelectedIndices().length == 1) {
            ShiftSeriesVariable shiftSeriesVariable = (ShiftSeriesVariable)this.mTargetVarList.getSelectedValue();
            String string = shiftSeriesVariable.getName();
            String string2 = shiftSeriesVariable.getSpssVarName();
            this.mNameText.setText(DEFAULT_NAME_TEXT);
            if (!string.equalsIgnoreCase(string2)) {
                this.mNameText.setText(string);
            }
            MethodObject methodObject = this.mMethodMap.get(shiftSeriesVariable.getMethodName());
            this.setSelectedLeadLagButtons();
            if (methodObject.isCasesToShift()) {
                this.mCasesToShift.setText(shiftSeriesVariable.getCasesToShiftText());
            }
            this.enableNameFuncPanel(true);
            this.mLblMethod.setEnabled(true);
            this.mLagRadioButton.setEnabled(true);
            this.mLeadRadioButton.setEnabled(true);
            this.mChangeNameBtn.setEnabled(false);
            this.enableOkPaste(this.canEnableOkPaste());
        } else if (listSelectionEvent.getSource().equals(this.mTargetVarList) && this.mTargetVarList.getSelectedIndices().length > 1) {
            this.mNameText.setText(DEFAULT_NAME_TEXT);
            this.enableNameFuncPanel(false);
            this.mChangeNameBtn.setEnabled(false);
            if (this.mTargetVarList.getSelectedIndices().length > 1) {
                this.mLblMethod.setEnabled(false);
                this.mLagRadioButton.setEnabled(false);
                this.mLeadRadioButton.setEnabled(false);
            }
            this.enableOkPaste(this.canEnableOkPaste());
        } else if (listSelectionEvent.getSource().equals(this.mSrcVarList) && this.mSrcVarList.getSelectedIndex() != -1) {
            this.mNameText.setText(DEFAULT_NAME_TEXT);
            this.mNameText.setEnabled(false);
            this.mNameText.setOpaque(false);
            this.mNameLabel.setEnabled(false);
            this.mChangeNameBtn.setEnabled(false);
            this.mCasesToShift.setEnabled(true);
            this.mCasesToShift.setOpaque(true);
            this.mCasesToShiftLabel.setEnabled(true);
            this.mLblMethod.setEnabled(true);
            this.mTargetVarList.clearSelection();
            this.mLagRadioButton.setEnabled(true);
            this.mLeadRadioButton.setEnabled(true);
            this.enableOkPaste(this.canEnableOkPaste());
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        ShiftSeriesVariable shiftSeriesVariable = (ShiftSeriesVariable)this.mTargetVarList.getSelectedValue();
        if (shiftSeriesVariable != null) {
            this.enableChangeButton();
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource() instanceof SrcVariableList) {
            this.mArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
            if (this.mSrcVarList.getSelectedIndices().length != 1) {
                this.mNameText.setText(DEFAULT_NAME_TEXT);
                this.mNameText.setEnabled(false);
                this.mNameText.setOpaque(false);
                this.mNameLabel.setEnabled(false);
                this.mChangeNameBtn.setEnabled(false);
                this.mCasesToShift.setEnabled(true);
                this.mCasesToShift.setOpaque(true);
                this.mCasesToShiftLabel.setEnabled(true);
                this.mLblMethod.setEnabled(true);
                this.mTargetVarList.clearSelection();
            }
        } else {
            if (focusEvent.getSource() instanceof PlainList && this.mTargetVarList.getSelectedIndices().length == 1) {
                ShiftSeriesVariable shiftSeriesVariable = (ShiftSeriesVariable)this.mTargetVarList.getSelectedValue();
                if (shiftSeriesVariable != null) {
                    String string = shiftSeriesVariable.getName();
                    String string2 = shiftSeriesVariable.getSpssVarName();
                    this.mNameText.setText(DEFAULT_NAME_TEXT);
                    if (!string.equalsIgnoreCase(string2)) {
                        this.mNameText.setText(string);
                    }
                    MethodObject methodObject = this.mMethodMap.get(shiftSeriesVariable.getMethodName());
                    this.setSelectedLeadLagButtons();
                    if (methodObject.isCasesToShift()) {
                        this.mCasesToShift.setText(shiftSeriesVariable.getCasesToShiftText());
                    }
                    this.enableNameFuncPanel(true);
                }
                this.mSrcVarList.clearSelection();
            }
            this.mArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.left);
        }
        this.enableOkPaste(this.canEnableOkPaste());
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public boolean okPastePressed() {
        if (this.mChangeNameBtn.isEnabled() && SpssAlertOptionPane.showConfirmDialog((Window)((Object)this), this.getResString("ERR_SAVE_CHANGES_WARNING"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION) != 0) {
            return false;
        }
        return super.okPastePressed();
    }

    @Override
    public String getDialogHelpID() {
        return "idh_shift_values";
    }

    @Override
    public void pack() {
        super.pack();
        if (this.getGlassPane() instanceof DragPane) {
            this.addDragAdapters();
        }
    }

    @Override
    public boolean isDragAllowed(JList jList, JList jList2, Object[] objectArray) {
        return true;
    }

    @Override
    public Object[] getModifiedData(Object[] objectArray, JList jList, PlainList plainList) {
        Object[] objectArray2 = new Object[objectArray.length];
        int n = 0;
        if (plainList.equals(this.mTargetVarList)) {
            for (Object object : objectArray) {
                if (!(object instanceof ISpssVariable)) continue;
                ShiftSeriesVariable shiftSeriesVariable = new ShiftSeriesVariable((ISpssVariable)object);
                MethodObject methodObject = this.mMethodMap.get(this.getCurrentMethodName());
                shiftSeriesVariable.setMethodName(methodObject.getMethodName());
                shiftSeriesVariable.setName(((ISpssVariable)object).getName());
                this.putVarSet(((ISpssVariable)object).getName());
                if (methodObject.isCasesToShift()) {
                    shiftSeriesVariable.setCasesToShiftText(this.mCasesToShift.getText());
                }
                shiftSeriesVariable.setSpssVarName(((ISpssVariable)object).getName());
                this.mPropertyMap.put(shiftSeriesVariable.getName(), shiftSeriesVariable);
                objectArray2[n] = shiftSeriesVariable;
                ++n;
            }
        }
        if (n == objectArray.length) {
            return objectArray2;
        }
        return objectArray;
    }

    @Override
    public boolean preMoveVariables(Object[] objectArray, PlainList plainList) {
        if (plainList.equals(this.mTargetVarList)) {
            if (this.mCasesToShift.isEnabled() && this.mCasesToShift.getText().length() == 0) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_EMPTY_CASES_TO_SHIFT_MSG"), VersionInfo.getAppVersionString());
                if (this.mCasesToShift.isEnabled()) {
                    this.mCasesToShift.requestFocus();
                    this.mCasesToShift.selectAll();
                    return false;
                }
            }
            if (this.mTargetVarList.getMaxLimitOfList() < objectArray.length + this.mTargetVarList.getModel().getSize()) {
                String string = String.format(ComponentState.getSPSSLocale(), ResUtil.getCommonDlgString("ERR_LIST_MAX_LIMIT_EXCEEDED_WARNING"), this.mTargetVarList.getMaxLimitOfList());
                SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this), string, VersionInfo.getAppVersionString());
                return false;
            }
        }
        return true;
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        this.setupViewPanel(jPanel);
        this.enableNameFuncPanel(false);
        this.mSrcVarList.setSelectedIndex(0);
        this.setTabPolicy();
        this.pack();
    }

    @Override
    protected void loadDialogState() {
        super.loadDialogState();
        this.validateSerializableLists();
        Object[] objectArray = this.getDialogDataModel().getArray("SHIFT_VALUES_MAP_STRING");
        if (objectArray != null) {
            this.mPropertyMap = (Map)objectArray[0];
            this.mVariableMap = (Map)objectArray[1];
        }
        this.mSrcVarList.setSelectedIndex(0);
    }

    @Override
    protected void validateSerializableLists() {
        this.mSrcVarList.loadFromActiveDataset();
        for (int i = this.mTargetVarList.getModel().getSize() - 1; i >= 0; --i) {
            ShiftSeriesVariable shiftSeriesVariable = (ShiftSeriesVariable)this.mTargetVarList.getModel().getElementAt(i);
            LocallyUniqueId locallyUniqueId = ProcedureDlgMgr.getMgr().getActiveDatasetId();
            ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
            int n = iSpssDataSrc.findVarIndex(shiftSeriesVariable.getSpssVarName());
            ISpssVariable iSpssVariable = shiftSeriesVariable.getSpssVariable();
            if (iSpssVariable != null && n == -1) {
                boolean bl = iSpssDataSrc.isVariableInCurrentSet(shiftSeriesVariable.getSpssVariable());
                if (!bl) {
                    ((DefaultListModel)this.mTargetVarList.getModel()).removeElementAt(i);
                    continue;
                }
                MethodObject methodObject = this.mMethodMap.get(this.getCurrentMethodName());
                shiftSeriesVariable.setMethodName(methodObject.getMethodName());
                shiftSeriesVariable.setName(this.getNewVariableName(iSpssVariable));
                shiftSeriesVariable.setSpssVarName(iSpssVariable.getName());
                continue;
            }
            if (this.mSrcVarList.canIncludeVariable(iSpssDataSrc.getVariable(n))) continue;
            ((DefaultListModel)this.mTargetVarList.getModel()).removeElementAt(i);
        }
        this.mTargetVarList.repaint();
        this.enableOkPaste(this.canEnableOkPaste());
    }

    @Override
    protected void saveDialogState() {
        Object[] objectArray = new Object[]{this.mPropertyMap, this.mVariableMap};
        this.getDialogDataModel().putArray("SHIFT_VALUES_MAP_STRING", objectArray);
        super.saveDialogState();
    }

    private void addDragAdapters() {
        DragPane dragPane = (DragPane)this.getGlassPane();
        dragPane.addDropListener((IDropListener)new PlainListDropListener(this.mSrcVarList, this.mPlainListVarMoveHandler));
        PlainListDragAdapter plainListDragAdapter = new PlainListDragAdapter(this.mTargetVarList, dragPane, "PlainList");
        DialogUtil.modifyMouseInputListeners(this.mTargetVarList, plainListDragAdapter);
        dragPane.addDropListener((IDropListener)new PlainListDropListener(this.mTargetVarList, this.mPlainListVarMoveHandler));
    }

    private void initVars() {
        this.mSrcVarList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        this.mTargetVarList = new PlainList("SHIFT_VALUES_TARGET_LIST");
        this.mTargetVarList.setDragType(PlainList.DragType.eAutoDragCopy);
        this.mTargetVarList.setMaxLimitOfList(100);
        this.mNameText = new StringTextField(16);
        this.mNameText.setDocument(new FixedLengthDocument(64));
        this.mChangeNameBtn = new JButton(new ChangeAction(CHANGE_BUTTON_KEY));
        this.mCasesToShift = new IntTextField(0, 999999999, true);
        this.mCasesToShift.setAllowMinMax(true, true);
        this.mNameLabel = DialogUtil.createLabel(this, "IDS_NAME");
        this.mNameLabel.setLabelFor((Component)((Object)this.mNameText));
        this.mCasesToShiftLabel = DialogUtil.createLabel(this, "IDS_NUM_CASES_SHIFT");
        this.mMethodMap = new HashMap<String, MethodObject>();
        this.createDefaultMethods();
        this.mGroup = new SpssButtonGroup();
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, LAG_RADIO_KEY);
        this.mLagRadioButton = new JRadioButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, LEAD_RADIO_KEY);
        this.mLeadRadioButton = new JRadioButton(toggleButtonAction);
        this.mTabOrder = new Vector();
        this.mVariableMap = new HashMap<String, Set<String>>();
        this.mPropertyMap = new HashMap<String, ShiftSeriesVariable>();
        this.mCasesToShift.setDocument((Document)new FixedLengthNumericDocument(9, true, false));
        this.mChangeNameBtn.setEnabled(false);
        this.mSrcVarList.setSelectedIndex(0);
        this.mPlainListVarMoveHandler = this;
    }

    private void setupViewPanel(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_SHIFT_VALUES_SOURCE_LIST_LABEL");
        jLabel.setLabelFor(this.mSrcVarList);
        Insets insets = DialogUtil.getStandardControlInsets();
        JScrollPane jScrollPane = new JScrollPane(this.mSrcVarList);
        this.mArrowButton = new ComponentsArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mArrowButton.registerComponents(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mArrowButton.registerComponents(this.mTargetVarList, SpssArrowButton.ButtonOrientation.left);
        ActionListener[] actionListenerArray = this.mArrowButton.getActionListeners();
        this.mTargetVarList.addFocusListener(this);
        this.mSrcVarList.addFocusListener(this);
        for (ActionListener object2 : actionListenerArray) {
            this.mArrowButton.removeActionListener(object2);
        }
        this.mArrowButton.addActionListener(this);
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_VARIABLES_COLON");
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        gridBagConstraints.fill = 0;
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, null);
        this.mSrcVarList.addListSelectionListener(this);
        this.mTabOrder.add(this.mSrcVarList);
        this.mSrcVarList.loadFromActiveDataset();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 1, 1, 6, n, insets);
        this.mTabOrder.add(this.mArrowButton);
        n = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets2 = DialogUtil.getArrowButtonInsets();
        DialogUtil.addUsingGBL(jPanel, this.mArrowButton, gridBagConstraints, 1, 1, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        n = 21;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 2, 0, 1, 1, n, insets);
        this.mTabOrder.add(this.mTargetVarList);
        this.mTargetVarList.addListSelectionListener(this);
        n = 23;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jScrollPane = new JScrollPane(this.mTargetVarList);
        jScrollPane.setPreferredSize(this.mTargetVarList.getMinimumSize());
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 2, 1, 1, 2, n, insets);
        this.mTargetVarList.getModel().addListDataListener(this);
        this.setupMethodPanel(jPanel2);
        insets = new Insets(DialogUtil.getComponentGroupGap(), 0, 0, 0);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 2, 3, 1, 4, n, insets);
        jLabel2.setLabelFor(this.mTargetVarList);
    }

    private void setupMethodPanel(JPanel jPanel) {
        this.mLblMethod = DialogUtil.createLabel(this, "IDS_METHOD");
        this.mLblMethod.setLabelFor(this.mLagRadioButton);
        this.mCasesToShift.setText(DEFAULT_CASES_TO_SHIFT_TEXT);
        this.mCasesToShift.addKeyListener((KeyListener)this);
        this.mNameText.addKeyListener(this);
        this.mCasesToShiftLabel.setLabelFor((Component)this.mCasesToShift);
        this.mLagRadioButton.addItemListener(this);
        this.mLeadRadioButton.addItemListener(this);
        this.mLagRadioButton.setSelected(true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = DialogUtil.getStandardControlInsets();
        insets.right = 4;
        insets.bottom = 4;
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_NAME_METHOD")));
        gridBagConstraints.anchor = 23;
        this.mTabOrder.add(this.mNameText);
        this.mTabOrder.add(this.mChangeNameBtn);
        this.mTabOrder.add(this.mGroup);
        this.mTabOrder.add(this.mCasesToShift);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        JPanel jPanel2 = new JPanel();
        double[] dArray = new double[]{-2.0, -2.0, -2.0};
        double[] dArray2 = new double[]{-2.0};
        TableLayout tableLayout = new TableLayout(dArray, dArray2);
        tableLayout.setHGap(7);
        tableLayout.setVGap(5);
        jPanel2.setLayout((LayoutManager)tableLayout);
        jPanel2.add((Component)this.mNameLabel, "0, 0");
        jPanel2.add((Component)((Object)this.mNameText), "1, 0, f, c");
        jPanel2.add((Component)this.mChangeNameBtn, "2, 0");
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, 23, insets);
        JPanel jPanel3 = new JPanel();
        Dimension dimension = this.mCasesToShift.getPreferredSize();
        int n = this.calcEditFieldWidthFromString("123456789");
        dimension.setSize((double)n, dimension.getHeight());
        this.mCasesToShift.setMinimumSize(dimension);
        this.mCasesToShift.setPreferredSize(dimension);
        dArray = new double[]{1.0, -3.0, -3.0};
        dArray2 = new double[]{-2.0, -2.0, -2.0, -2.0};
        tableLayout = new TableLayout(dArray, dArray2);
        tableLayout.setHGap(7);
        tableLayout.setVGap(5);
        jPanel3.setLayout((LayoutManager)tableLayout);
        jPanel3.add((Component)this.mLblMethod, "0, 0, 1, 0");
        jPanel3.add((Component)this.mLagRadioButton, "1, 1, 2, 1");
        this.mGroup.add(this.mLagRadioButton);
        jPanel3.add((Component)this.mLeadRadioButton, "1, 2, 2, 1");
        this.mGroup.add(this.mLeadRadioButton);
        jPanel3.add((Component)this.mCasesToShiftLabel, "1, 3");
        jPanel3.add((Component)this.mCasesToShift, "2, 3");
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 1, 1, 1, 23, insets);
        DialogUtil.normalizeButtonWidths((JPanel)jPanel);
    }

    private int calcEditFieldWidthFromString(String string) {
        FontMetrics fontMetrics = this.mCasesToShift.getFontMetrics(this.mCasesToShift.getFont());
        Rectangle2D rectangle2D = fontMetrics.getStringBounds(string, this.getGraphics());
        return (int)(rectangle2D.getWidth() + 0.5) + this.mCasesToShift.getMargin().left + this.mCasesToShift.getMargin().right + this.mCasesToShift.getInsets().left + this.mCasesToShift.getInsets().right;
    }

    private void setSelectedLeadLagButtons() {
        ShiftSeriesVariable shiftSeriesVariable = (ShiftSeriesVariable)this.mTargetVarList.getSelectedValue();
        MethodObject methodObject = this.mMethodMap.get(shiftSeriesVariable.getMethodName());
        if (methodObject.getMethodName().equalsIgnoreCase("LAG")) {
            this.mLagRadioButton.setSelected(true);
        } else {
            this.mLeadRadioButton.setSelected(true);
        }
    }

    private void checkCurrentMethod() {
        MethodObject methodObject = this.getCurrentMethod();
        boolean bl = this.mTargetVarList.getModel().getSize() == 0 || this.mTargetVarList.getSelectedIndices().length == 1 || this.mTargetVarList.getSelectedIndices().length == 0;
        boolean bl2 = methodObject.isCasesToShift();
        this.mCasesToShift.setEnabled(bl && bl2);
        this.mCasesToShift.setOpaque(bl && bl2);
        this.mCasesToShiftLabel.setEnabled(bl && bl2);
    }

    private void enableChangeButton() {
        MethodObject methodObject = this.getCurrentMethod();
        ShiftSeriesVariable shiftSeriesVariable = (ShiftSeriesVariable)this.mTargetVarList.getSelectedValue();
        boolean bl = true;
        if (shiftSeriesVariable != null) {
            String string = this.mNameText.getText();
            if (string.length() == 0) {
                bl = false;
            } else if (string.equalsIgnoreCase(shiftSeriesVariable.getSpssVarName())) {
                bl = false;
            } else if (shiftSeriesVariable.getName().equalsIgnoreCase(shiftSeriesVariable.getSpssVarName())) {
                if (string.equalsIgnoreCase(shiftSeriesVariable.getName())) {
                    bl = false;
                }
            } else if (string.equalsIgnoreCase(shiftSeriesVariable.getName()) && shiftSeriesVariable.getMethodName().equalsIgnoreCase(methodObject.getMethodName())) {
                string = this.mCasesToShift.getText();
                if (this.mCasesToShift.isEnabled() && (string.length() == 0 || string.equalsIgnoreCase(shiftSeriesVariable.getCasesToShiftText()))) {
                    bl = false;
                }
            }
            if (this.mCasesToShift.isEnabled() && this.mCasesToShift.getText().length() == 0) {
                bl = false;
            }
        } else {
            bl = false;
        }
        this.mChangeNameBtn.setEnabled(bl);
    }

    private MethodObject[] createDefaultMethods() {
        MethodObject[] methodObjectArray = new MethodObject[]{new MethodObject(this.getResString("IDS_METHOD_LAG"), "LAG", true), new MethodObject(this.getResString("IDS_METHOD_LEAD"), "LEAD", true)};
        for (MethodObject methodObject : methodObjectArray) {
            this.mMethodMap.put(methodObject.getMethodName(), methodObject);
        }
        return methodObjectArray;
    }

    private void enableNameFuncPanel(boolean bl) {
        this.mNameText.setEnabled(bl);
        this.mNameText.setOpaque(bl);
        this.mNameLabel.setEnabled(bl);
        this.checkCurrentMethod();
    }

    private boolean canEnableOkPaste() {
        boolean bl = true;
        DefaultListModel defaultListModel = (DefaultListModel)this.mTargetVarList.getModel();
        int n = defaultListModel.getSize();
        if (n == 0) {
            bl = false;
        } else {
            for (int i = 0; i < n; ++i) {
                ShiftSeriesVariable shiftSeriesVariable = (ShiftSeriesVariable)defaultListModel.getElementAt(i);
                if (shiftSeriesVariable.getName().equalsIgnoreCase(shiftSeriesVariable.getSpssVarName())) {
                    bl = false;
                    break;
                }
                if (!this.doesSrcListContainName(shiftSeriesVariable.getName())) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }

    private boolean checkVariableName(ShiftSeriesVariable shiftSeriesVariable) {
        String string;
        Set<String> set = this.mVariableMap.get(shiftSeriesVariable.getSpssVarName());
        String string2 = shiftSeriesVariable.getName();
        if (!string2.equals(string = this.mNameText.getText())) {
            if (this.doesSrcListContainName(string)) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_DUPLICATE_SRC_VARIABLE_MSG"), VersionInfo.getAppVersionString());
                this.mNameText.requestFocus();
                this.mNameText.selectAll();
                return false;
            }
            if (this.doesPropertyMapContainName(string)) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_DUPLICATE_VARIABLE_MSG"), VersionInfo.getAppVersionString());
                this.mNameText.requestFocus();
                this.mNameText.selectAll();
                return false;
            }
            set.remove(string2);
        }
        set.add(this.mNameText.getText());
        return true;
    }

    private boolean doesSrcListContainName(String string) {
        boolean bl = false;
        VarListModel varListModel = this.mSrcVarList.getModel();
        for (int i = 0; i < varListModel.getSize(); ++i) {
            if (!string.equalsIgnoreCase(varListModel.getElementAt(i).getName())) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private boolean doesPropertyMapContainName(String string) {
        boolean bl = false;
        Set<String> set = this.mPropertyMap.keySet();
        for (String string2 : set) {
            if (!string2.equalsIgnoreCase(string)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private void putVarSet(String string) {
        if (!this.mVariableMap.containsKey(string)) {
            this.mVariableMap.put(string, new HashSet());
        }
    }

    private String getNewVariableName(ISpssVariable iSpssVariable) {
        Set<Object> set;
        int n = 1;
        String string = iSpssVariable.getName();
        if (!this.mVariableMap.containsKey(string)) {
            set = new HashSet();
            this.mVariableMap.put(string, set);
        } else {
            set = this.mVariableMap.get(string);
        }
        if (set.contains(string)) {
            string = string + "_";
            while (set.contains(string + n)) {
                ++n;
            }
            string = string + n;
            set.add(string);
        } else {
            set.add(string);
        }
        return string;
    }

    private String getCurrentMethodName() {
        return this.getCurrentMethod().getMethodName();
    }

    private MethodObject getCurrentMethod() {
        MethodObject methodObject = this.mLeadRadioButton.isSelected() ? this.mMethodMap.get("LEAD") : this.mMethodMap.get("LAG");
        return methodObject;
    }

    private void setTabPolicy() {
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            this.mTabOrder.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(this.mTabOrder, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private StringBuffer getVariablesStringBuffer() {
        DefaultListModel defaultListModel = (DefaultListModel)this.mTargetVarList.getModel();
        int n = defaultListModel.getSize();
        StringBuffer stringBuffer = new StringBuffer(DEFAULT_NAME_TEXT);
        for (int i = 0; i < n; ++i) {
            ShiftSeriesVariable shiftSeriesVariable = (ShiftSeriesVariable)defaultListModel.getElementAt(i);
            if (i == 0) {
                stringBuffer.append(SyntaxUtil.getMainCommandParamters("VARIABLE=").append(shiftSeriesVariable.getSpssVarName()));
            } else {
                stringBuffer.append("VARIABLE=").append(shiftSeriesVariable.getSpssVarName());
            }
            stringBuffer.append(" RESULT=").append(shiftSeriesVariable.getName());
            stringBuffer.append(" ").append(shiftSeriesVariable.getMethodName()).append("=").append(shiftSeriesVariable.getCasesToShiftText());
            if (i >= n - 1) continue;
            stringBuffer.append("\n  /");
        }
        return stringBuffer;
    }

    public static class ShiftSeriesVariable
    implements SerializableObject {
        private final String DISPLAY_TEXT_FORMAT1 = "{0}-> {1}";
        private ISpssVariable mVariable;
        private String mName;
        private String mMethodName;
        private String mCasesToShiftText;
        private String mSpssVarName;

        public ShiftSeriesVariable(ISpssVariable iSpssVariable) {
            this.mVariable = iSpssVariable;
            this.mName = iSpssVariable.getName();
        }

        public String getMethodName() {
            return this.mMethodName;
        }

        public void setMethodName(String string) {
            this.mMethodName = string;
        }

        public String getName() {
            return this.mName;
        }

        public void setName(String string) {
            this.mName = string;
        }

        public String getCasesToShiftText() {
            return this.mCasesToShiftText;
        }

        public void setCasesToShiftText(String string) {
            this.mCasesToShiftText = string;
        }

        public String getSpssVarName() {
            return this.mSpssVarName;
        }

        public void setSpssVarName(String string) {
            this.mSpssVarName = string;
        }

        public ISpssVariable getSpssVariable() {
            return this.mVariable;
        }

        public void setSpssVariable(ISpssVariable iSpssVariable) {
            this.mVariable = iSpssVariable;
        }

        public String toString() {
            if (this.mName.equalsIgnoreCase(this.mSpssVarName)) {
                return MessageFormat.format("{0}-> {1}", this.getSpssVarName(), "?????");
            }
            return MessageFormat.format("{0}-> {1}", this.getSpssVarName(), this.getName());
        }

        public String getClassName() {
            return "com.spss.java_client.ui.dialogs.base.transform.ShiftValuesDlg$ShiftSeriesVariable";
        }

        public boolean readVersionedObject(ObjectInputStream objectInputStream, int n) throws Exception {
            this.mName = objectInputStream.readUTF();
            this.mMethodName = objectInputStream.readUTF();
            this.mCasesToShiftText = objectInputStream.readUTF();
            this.mSpssVarName = objectInputStream.readUTF();
            VarInfoBag varInfoBag = new VarInfoBag();
            boolean bl = varInfoBag.readVersionedObject(objectInputStream, n);
            if (bl) {
                this.mVariable = DialogDataModel.varBagToVariable(varInfoBag);
            }
            return bl;
        }

        public boolean writeVersionedObject(ObjectOutputStream objectOutputStream, int n) throws Exception {
            objectOutputStream.writeUTF(this.mName);
            objectOutputStream.writeUTF(this.mMethodName);
            objectOutputStream.writeUTF(this.mCasesToShiftText);
            objectOutputStream.writeUTF(this.mSpssVarName);
            VarInfoBag varInfoBag = new VarInfoBag(this.mVariable);
            return varInfoBag.writeVersionedObject(objectOutputStream, n);
        }
    }

    private class ChangeAction
    extends ToggleButtonAction {
        public ChangeAction(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ShiftSeriesVariable shiftSeriesVariable = (ShiftSeriesVariable)ShiftValuesDlg.this.mTargetVarList.getSelectedValue();
            boolean bl = true;
            String string = ShiftValuesDlg.this.mNameText.getText().trim();
            int n = VarNameValidator.validateSPSSName((String)string, (boolean)true).asInt();
            if (n > 0 && n != 100) {
                bl = DialogUtil.showBadSpssVarNameWarning(n, ShiftValuesDlg.this);
            }
            if (bl && ShiftValuesDlg.this.doesSrcListContainName(string)) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)ShiftValuesDlg.this), ShiftValuesDlg.this.getResString("ERR_DUPLICATE_SRC_VARIABLE_MSG"), VersionInfo.getAppVersionString());
                ShiftValuesDlg.this.mNameText.requestFocus();
                ShiftValuesDlg.this.mNameText.selectAll();
            } else if (bl && ShiftValuesDlg.this.checkVariableName(shiftSeriesVariable)) {
                ShiftValuesDlg.this.mPropertyMap.remove(shiftSeriesVariable.getName());
                shiftSeriesVariable.setMethodName(ShiftValuesDlg.this.getCurrentMethodName());
                shiftSeriesVariable.setName(ShiftValuesDlg.this.mNameText.getText());
                if (ShiftValuesDlg.this.mCasesToShift.isEnabled()) {
                    if (ShiftValuesDlg.this.mCasesToShift.isEnabled()) {
                        shiftSeriesVariable.setCasesToShiftText(ShiftValuesDlg.this.mCasesToShift.getText());
                    }
                } else {
                    shiftSeriesVariable.setCasesToShiftText(ShiftValuesDlg.DEFAULT_NAME_TEXT);
                }
                ShiftValuesDlg.this.mPropertyMap.put(shiftSeriesVariable.getName(), shiftSeriesVariable);
                int n2 = ShiftValuesDlg.this.mTargetVarList.getSelectedIndex();
                ((DefaultListModel)ShiftValuesDlg.this.mTargetVarList.getModel()).remove(n2);
                ((DefaultListModel)ShiftValuesDlg.this.mTargetVarList.getModel()).add(n2, shiftSeriesVariable);
                ShiftValuesDlg.this.mTargetVarList.setSelectedIndex(n2);
                ShiftValuesDlg.this.checkCurrentMethod();
                ShiftValuesDlg.this.mChangeNameBtn.setEnabled(false);
            } else {
                ShiftValuesDlg.this.mNameText.requestFocus();
                ShiftValuesDlg.this.mNameText.selectAll();
            }
        }
    }

    private class MethodObject {
        private String mMethodLabel;
        private String mMethodName;
        private boolean mIsCasesToShift;

        public MethodObject(String string, String string2, boolean bl) {
            this.mMethodLabel = string;
            this.mMethodName = string2;
            this.mIsCasesToShift = bl;
        }

        private String getMethodName() {
            return this.mMethodName;
        }

        private String getMethodLabel() {
            return this.mMethodLabel;
        }

        private boolean isCasesToShift() {
            return this.mIsCasesToShift;
        }

        public String toString() {
            return this.getMethodLabel();
        }

        public boolean equals(Object object) {
            boolean bl = false;
            if (object instanceof MethodObject) {
                bl = this.mMethodName.equals(((MethodObject)object).getMethodName());
            }
            return bl;
        }
    }
}

