/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.transform;

import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.ui.controls.FixedLengthNumericDocument;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.base.transform.res.TransformResBundle;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.common.res.CommonDlgResBundle;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.uitools.controls.IntTextField;
import com.spss.uitools.util.IOptionConstants;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class RandomNumberGeneratorDlg
extends BaseProcedureDialog
implements ItemListener,
DocumentListener,
FocusListener {
    private static final String VALUE_EDIT_KEY = "IDS_VALUE_EDIT";
    private static final String ACTIVE_GENERATOR_KEY = "IDS_RANNUMGENEATORS_ACTIVE_CHECK";
    private static final String SPSS_RADIO_KEY = "IDS_RANNUMGENEATORS_SPSS_RADIO";
    private static final String TWISTER_RADIO_KEY = "IDS_RANNUMGENEATORS_TWISTER_RADIO";
    private static final String INITIALIZATION_STARTING_KEY = "IDS_RANNUMGENEATORS_INITIALIZATION_CHECK";
    private static final String RANDOM_RADIO_KEY = "IDS_RANNUMGENEATORS_RANDOM_RADIO";
    private static final String FIXED_RADIO_KEY = "IDS_RANNUMGENEATORS_FIXED_RADIO";
    private JCheckBox mActiveGeneratorCheck;
    private JCheckBox mStartingPointCheck;
    private JRadioButton mSpssRadio;
    private JRadioButton mTwisterRadio;
    private JRadioButton mRandomRadio;
    private JRadioButton mFixedRadio;
    private JTextField mValueEdit;
    private JLabel mLabel;
    private SpssButtonGroup mActiveGeneratorGroup;
    private SpssButtonGroup mStartingPointGroup;
    private JLabel mCurrentLabel;

    public RandomNumberGeneratorDlg(JFrame jFrame) {
        super(jFrame, true, TransformResBundle.getDefaultResourceBundleName(), CommonDlgResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_RANNUMGENEATORS"));
    }

    @Override
    public String getDialogHelpID() {
        return "idh_seed";
    }

    @Override
    public String generateSyntax() {
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        stringBuffer.append(SyntaxUtil.getMainCommand("SET"));
        if (this.mActiveGeneratorCheck.isSelected()) {
            stringBuffer.append(SyntaxUtil.getMainCommandParamters("RNG="));
            if (this.mSpssRadio.isSelected()) {
                stringBuffer.append("MC");
            }
            if (this.mTwisterRadio.isSelected()) {
                stringBuffer.append("MT");
            }
        }
        if (this.mStartingPointCheck.isSelected()) {
            if (this.mActiveGeneratorCheck.isSelected()) {
                if (this.mTwisterRadio.isSelected()) {
                    stringBuffer.append(SyntaxUtil.getMainCommandParamters("MTINDEX="));
                } else {
                    stringBuffer.append(SyntaxUtil.getMainCommandParamters("SEED="));
                }
            } else {
                Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs();
                Preferences preferences2 = preferences.node("options");
                Preferences preferences3 = preferences2.node("data");
                String string = preferences3.get("random_number_gen", "MC");
                string = string.equalsIgnoreCase("MC") ? "SEED=" : "MTINDEX=";
                stringBuffer.append(SyntaxUtil.getMainCommandParamters(string));
            }
            if (this.mRandomRadio.isSelected()) {
                stringBuffer.append("RANDOM");
            }
            if (this.mFixedRadio.isSelected()) {
                stringBuffer.append(this.mValueEdit.getText());
            }
        }
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        return stringBuffer.toString();
    }

    @Override
    public String getIActionKey() {
        return "transform_random_number_generators";
    }

    @Override
    public void reset() {
        super.reset();
        this.setDefaults();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.mActiveGeneratorCheck) {
            if (this.mActiveGeneratorCheck.isSelected()) {
                this.mSpssRadio.setEnabled(true);
                this.mTwisterRadio.setEnabled(true);
            } else {
                this.mSpssRadio.setEnabled(false);
                this.mTwisterRadio.setEnabled(false);
            }
        }
        if (itemEvent.getSource() == this.mStartingPointCheck) {
            if (this.mStartingPointCheck.isSelected()) {
                this.mRandomRadio.setEnabled(true);
                this.mFixedRadio.setEnabled(true);
                if (this.mFixedRadio.isSelected()) {
                    this.mLabel.setEnabled(true);
                    this.mValueEdit.setEnabled(true);
                    this.mValueEdit.setEditable(true);
                }
            } else {
                this.mRandomRadio.setEnabled(false);
                this.mFixedRadio.setEnabled(false);
                this.mLabel.setEnabled(false);
                this.mValueEdit.setEnabled(false);
                this.mValueEdit.setEditable(false);
            }
        }
        if (itemEvent.getSource() == this.mFixedRadio) {
            if (this.mFixedRadio.isEnabled() && this.mFixedRadio.isSelected()) {
                this.mLabel.setEnabled(true);
                this.mValueEdit.setEnabled(true);
                this.mValueEdit.setEditable(true);
            } else {
                this.mLabel.setEnabled(false);
                this.mValueEdit.setEnabled(false);
                this.mValueEdit.setEditable(false);
            }
        }
        this.enableOkPaste(this.checkEnableOkPaste());
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.valueEditChanged();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.valueEditChanged();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.valueEditChanged();
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        JTextField jTextField = (JTextField)focusEvent.getSource();
        jTextField.selectAll();
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefaults();
        JPanel jPanel = this.getViewPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(0, 0, n2, 0);
        DialogUtil.addUsingGBL(jPanel, this.setupAcivePanel(), gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.setupInitializationPanel(), gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        this.setupLabelPanel(jPanel);
        this.setFocusTraversalPolicy();
        this.pack();
    }

    @Override
    protected void loadDialogState() {
        Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs().node("options").node("data");
        String string = preferences.get("random_number_gen", IOptionConstants.RANDOM_NUMBER_GENERATOR_VALUES[0]);
        if (string.equalsIgnoreCase("MC")) {
            this.mCurrentLabel.setText(this.getResString("IDS_RANNUMGENERATORS_CURRENT_COLON") + "      " + this.getResString(SPSS_RADIO_KEY));
        } else {
            this.mCurrentLabel.setText(this.getResString("IDS_RANNUMGENERATORS_CURRENT_COLON") + "      " + this.getResString(TWISTER_RADIO_KEY));
        }
        super.loadDialogState();
    }

    private void setupLabelPanel(JPanel jPanel) {
        Insets insets = DialogUtil.getStandardControlInsets();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.mCurrentLabel = new JLabel(this.getResString("IDS_RANNUMGENERATORS_CURRENT_COLON") + "      " + this.getResString(SPSS_RADIO_KEY));
        Insets insets2 = new Insets(insets.top, insets.left, insets.bottom, 0);
        DialogUtil.addUsingGBL(jPanel, this.mCurrentLabel, gridBagConstraints, 0, 2, 2, 1, n, insets);
        JPanel jPanel2 = PanelFactory.getEmptyPanel("");
        ResourceBundle resourceBundle = ResUtil.getBundle(CommonDlgResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
        URL uRL = ResUtil.getImageResourceFullPath(CommonDlgResBundle.getImageFolder() + ResUtil.getString(resourceBundle, "IDS_INFO_DOT_IMAGE"));
        JLabel jLabel = new JLabel();
        jLabel.setIcon(new ImageIcon(uRL));
        int n2 = DialogUtil.getComponentGroupGap();
        insets2.set(n2, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel2, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets2);
        JTextArea jTextArea = new JTextArea(this.getResString("IDS_RANNUMGENERATORS_LONGLABLE_COLON"));
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setBorder(null);
        jTextArea.setOpaque(false);
        jTextArea.setFocusable(false);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        insets2.set(n2, insets.left, n2 * 2, 0);
        DialogUtil.addUsingGBL(jPanel2, jTextArea, gridBagConstraints, 1, 0, 1, 1, n, insets2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 3, 2, 1, n, insets);
    }

    private void setDefaults() {
        this.mActiveGeneratorCheck.setSelected(false);
        this.mSpssRadio.setEnabled(false);
        this.mSpssRadio.setSelected(true);
        this.mTwisterRadio.setEnabled(false);
        this.mStartingPointCheck.setSelected(false);
        this.mRandomRadio.setEnabled(false);
        this.mRandomRadio.setSelected(true);
        this.mFixedRadio.setEnabled(false);
        this.mLabel.setEnabled(false);
        this.mValueEdit.setEnabled(false);
        this.mValueEdit.setEditable(false);
        this.mValueEdit.setText("2000000");
        this.enableOkPaste(false);
    }

    private JPanel setupInitializationPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        TitledBorder titledBorder = BorderFactory.createTitledBorder(this.getResString("IDS_RANNUMGENEATORS_INITIALIZATION"));
        jPanel.setBorder(titledBorder);
        Insets insets = DialogUtil.getStandardControlInsets();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        Insets insets2 = new Insets(insets.top, insets.left, insets.bottom, insets.right * 3);
        DialogUtil.addUsingGBL(jPanel, this.mStartingPointCheck, gridBagConstraints, 0, 0, 1, 1, n, insets2);
        insets2.set(insets.top, insets.left * 9, insets.bottom, insets.right * 3);
        DialogUtil.addUsingGBL(jPanel, this.mRandomRadio, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mFixedRadio, gridBagConstraints, 0, 2, 1, 1, n, insets2);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets2.set(insets.top, insets.left * 10, insets.bottom * 3, insets.right);
        DialogUtil.addUsingGBL(jPanel2, this.mLabel, gridBagConstraints, 0, 0, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.ipadx = 80;
        insets2.set(insets.top, insets.left, insets.bottom * 3, insets.right * 3);
        DialogUtil.addUsingGBL(jPanel2, this.mValueEdit, gridBagConstraints, 1, 0, 1, 1, n, insets2);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.ipadx = 0;
        insets2.set(insets.top, insets.left * 7, insets.bottom, insets.right * 6);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 3, 1, 1, n, insets2);
        this.mLabel.setLabelFor(this.mValueEdit);
        return jPanel;
    }

    private void initVars() {
        this.mLabel = DialogUtil.createLabel(this, "IDS_RANNUMGENERATORS_VAL_COLON");
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, ACTIVE_GENERATOR_KEY);
        this.mActiveGeneratorCheck = new JCheckBox(toggleButtonAction);
        this.mActiveGeneratorCheck.addItemListener(this);
        ToggleButtonAction toggleButtonAction2 = new ToggleButtonAction(this, SPSS_RADIO_KEY);
        this.mSpssRadio = new JRadioButton(toggleButtonAction2);
        this.mSpssRadio.setSelected(true);
        ToggleButtonAction toggleButtonAction3 = new ToggleButtonAction(this, TWISTER_RADIO_KEY);
        this.mTwisterRadio = new JRadioButton(toggleButtonAction3);
        ToggleButtonAction toggleButtonAction4 = new ToggleButtonAction(this, INITIALIZATION_STARTING_KEY);
        this.mStartingPointCheck = new JCheckBox(toggleButtonAction4);
        this.mStartingPointCheck.addItemListener(this);
        this.mValueEdit = new IntTextField(1, 2000000000, true);
        this.mValueEdit.setDocument(new FixedLengthNumericDocument(10, true, false));
        this.mValueEdit.getDocument().addDocumentListener(this);
        this.mValueEdit.setAction(new TextFieldAction(this, VALUE_EDIT_KEY));
        this.mValueEdit.addFocusListener(this);
        ToggleButtonAction toggleButtonAction5 = new ToggleButtonAction(this, RANDOM_RADIO_KEY);
        this.mRandomRadio = new JRadioButton(toggleButtonAction5);
        this.mRandomRadio.setSelected(true);
        this.mRandomRadio.addItemListener(this);
        ToggleButtonAction toggleButtonAction6 = new ToggleButtonAction(this, FIXED_RADIO_KEY);
        this.mFixedRadio = new JRadioButton(toggleButtonAction6);
        this.mFixedRadio.addItemListener(this);
        this.mActiveGeneratorGroup = new SpssButtonGroup();
        this.mActiveGeneratorGroup.add(this.mSpssRadio);
        this.mActiveGeneratorGroup.add(this.mTwisterRadio);
        this.mStartingPointGroup = new SpssButtonGroup();
        this.mStartingPointGroup.add(this.mRandomRadio);
        this.mStartingPointGroup.add(this.mFixedRadio);
    }

    private JPanel setupAcivePanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        TitledBorder titledBorder = BorderFactory.createTitledBorder(this.getResString("IDS_RANNUMGENEATORS_ACTIVE"));
        jPanel.setBorder(titledBorder);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(insets.top, insets.left, insets.bottom, insets.right * 12);
        DialogUtil.addUsingGBL(jPanel, this.mActiveGeneratorCheck, gridBagConstraints, 0, 0, 1, 1, n, insets2);
        insets2.set(insets.top, insets.left * 9, insets.bottom, insets.right * 12);
        DialogUtil.addUsingGBL(jPanel, this.mSpssRadio, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mTwisterRadio, gridBagConstraints, 0, 2, 1, 1, n, insets2);
        return jPanel;
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mActiveGeneratorCheck);
        vector.add(this.mActiveGeneratorGroup);
        vector.add(this.mStartingPointCheck);
        vector.add(this.mStartingPointGroup);
        vector.add(this.mValueEdit);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        this.setFocusTraversalPolicy(new DialogFocusTraversalPolicy(vector, false));
    }

    private boolean checkEnableOkPaste() {
        boolean bl = false;
        if (this.mActiveGeneratorCheck.isSelected()) {
            bl = true;
            if (this.mStartingPointCheck.isSelected() && this.mFixedRadio.isEnabled() && this.mFixedRadio.isSelected() && this.mValueEdit.getText().length() == 0) {
                bl = false;
            }
        }
        if (this.mStartingPointCheck.isSelected()) {
            if (this.mRandomRadio.isSelected()) {
                bl = true;
            } else if (this.mFixedRadio.isSelected() && this.mValueEdit.getText().length() > 0) {
                bl = true;
            }
        }
        return bl;
    }

    private void valueEditChanged() {
        if (this.mValueEdit.isEnabled()) {
            if (this.mValueEdit.getText().length() == 0) {
                this.enableOkPaste(false);
            } else {
                this.enableOkPaste(true);
            }
        }
    }
}

