/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.transform;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.fopen.RefFileFilter;
import com.spss.java_client.core.comp_util.FileLocationsUtil;
import com.spss.java_client.core.documents.data.VarNameValidator;
import com.spss.java_client.core.server.DataServerProxy;
import com.spss.java_client.ui.controls.FileTextField;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.StringTextField;
import com.spss.java_client.ui.dialogs.base.transform.res.TransformResBundle;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.common.res.CommonDlgResBundle;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.uitools.util.CharacterUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;

public class PrepareModelLoadModelDlg
extends BaseProcedureDialog
implements FocusListener,
DocumentListener {
    private StringTextField mNameTxt;
    private JLabel mNameLbl;
    private JRadioButton mSubstiute;
    private JRadioButton mSystemMissing;
    private SpssButtonGroup mMissingValuesGroup;
    private JButton mFileBtn;
    private RemoteFileChooser mFileChooser;
    private FileTextField mFileText;
    private JPanel mPanel;
    private JLabel mLblIcon;

    public PrepareModelLoadModelDlg(JFrame jFrame) {
        super(jFrame, true, TransformResBundle.getDefaultResourceBundleName(), CommonDlgResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_PREPAREMODEL_LOADMODEL"));
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public String generateSyntax() {
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        stringBuffer.append("* " + this.getResString("IDS_PREPAREMODEL_LOADMODEL_SYNTAX_TITLE") + ".");
        stringBuffer.append("\n" + SyntaxUtil.getMainCommand("MODEL HANDLE"));
        stringBuffer.append(SyntaxUtil.getMainCommandParamters("NAME="));
        stringBuffer.append(this.mNameTxt.getText().trim());
        stringBuffer.append(" FILE=");
        stringBuffer.append(CharacterUtil.smartQuote((String)this.mFileText.getText().trim()));
        stringBuffer.append("\n");
        stringBuffer.append(SyntaxUtil.getSubCommand("/OPTIONS MISSING="));
        if (this.mSubstiute.isSelected()) {
            stringBuffer.append("SUBSTITUTE");
        } else {
            stringBuffer.append("SYSMIS");
        }
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        return stringBuffer.toString();
    }

    @Override
    public String getDialogHelpID() {
        return "IDH_IDD_SCORING_LOAD_MODEL";
    }

    @Override
    public String getIActionKey() {
        return "transform_prepare_model_load";
    }

    @Override
    public void reset() {
        super.reset();
        this.setDefaults();
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (this.mFileText.getText() != null && this.mFileText.getText().length() > 0) {
            this.mFileText.setSelectionStart(0);
            this.mFileText.setSelectionEnd(this.mFileText.getText().length());
            this.mFileText.requestFocus();
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public boolean okPastePressed() {
        boolean bl;
        String string = "";
        int n = VarNameValidator.validateSPSSName((String)this.mNameTxt.getText(), (boolean)true).asInt();
        switch (n) {
            case 0: {
                bl = true;
                break;
            }
            case 1: {
                string = this.getResString("ERR_PREPAREMODEL_LOADMODEL_SCRATCH_VAR_NAME_MESSAGE");
                bl = false;
                break;
            }
            case 2: {
                string = this.getResString("ERR_PREPAREMODEL_LOADMODEL_SYSTEM_MESSAGE");
                bl = false;
                break;
            }
            case 3: {
                string = this.getResString("ERR_PREPAREMODEL_LOADMODEL_VAR_NAME_MESSAGE");
                bl = false;
                break;
            }
            case 4: {
                string = this.getResString("ERR_PREPAREMODEL_LOADMODEL_DATASET_NAME_NOT_VALID_MESSAGE");
                bl = false;
                break;
            }
            case 5: {
                string = this.getResString("ERR_PREPAREMODEL_LOADMODEL_RES_NAME_MESSAGE");
                bl = false;
                break;
            }
            case 6: {
                string = this.getResString("ERR_PREPAREMODEL_LOADMODEL_FIRST_BADCHAR_MESSAGE");
                bl = false;
                break;
            }
            case 7: {
                string = this.getResString("ERR_PREPAREMODEL_LOADMODEL_LAST_BADCHAR_MESSAGE");
                bl = false;
                break;
            }
            default: {
                bl = false;
            }
        }
        if (!bl) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), string, VersionInfo.getAppVersionString());
            this.mNameTxt.requestFocus();
            this.mNameTxt.selectAll();
        }
        return bl;
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.enableOkButton();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.enableOkButton();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.enableOkButton();
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefaults();
        JPanel jPanel = this.getViewPanel();
        this.addComponents(jPanel);
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(this.setTabTraversal(), false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
        this.pack();
    }

    private void initVars() {
        this.mNameLbl = DialogUtil.createLabel(this, "IDS_PREPAREMODEL_LOADMODEL_NAME");
        this.mNameTxt = new StringTextField(20);
        this.mNameLbl.setLabelFor((Component)((Object)this.mNameTxt));
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, "IDS_PREPAREMODEL_LOADMODEL_FILE"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PrepareModelLoadModelDlg.this.openFileDialog();
            }
        };
        this.mFileBtn = new JButton(toggleButtonAction);
        this.mFileText = new FileTextField();
        this.mFileText.setEditable(false);
        this.mSubstiute = new JRadioButton(new ToggleButtonAction(this, "IDS_PREPAREMODEL_LOADMODEL_SUBSTITUTE"));
        this.mSystemMissing = new JRadioButton(new ToggleButtonAction(this, "IDS_PREPAREMODEL_LOADMODEL_SYSMISSING"));
        JComponent[] jComponentArray = new JComponent[]{this.mSubstiute, this.mSystemMissing};
        this.mPanel = PanelFactory.getGridPanel(jComponentArray, this.getResString("IDS_PREPAREMODEL_LOADMODEL_MISSING"), 2);
        this.mMissingValuesGroup = DialogUtil.createButtonGroup(this.mPanel);
        ResourceBundle resourceBundle = ResUtil.getBundle(CommonDlgResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
        URL uRL = ResUtil.getImageResourceFullPath(CommonDlgResBundle.getImageFolder() + ResUtil.getString(resourceBundle, "IDS_INFO_DOT_IMAGE"));
        this.mLblIcon = new JLabel();
        this.mLblIcon.setIcon(new ImageIcon(uRL));
        this.mNameTxt.getDocument().addDocumentListener(this);
        this.mFileText.addFocusListener(this);
    }

    private void setDefaults() {
        this.mSubstiute.setSelected(true);
        this.mNameTxt.setText("");
        this.mFileText.setText("");
        this.mNameTxt.requestFocus();
    }

    private Vector<Object> setTabTraversal() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mNameTxt);
        vector.add(this.mFileBtn);
        vector.add(this.mFileText);
        vector.add(this.mMissingValuesGroup);
        for (int i = 0; i < this.mCmdButtonPanel.getComponentCount(); ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        return vector;
    }

    private void openFileDialog() {
        this.mFileChooser = new RemoteFileChooser(RemoteFileChooser.ChooserType.OpenFile, RemoteFileChooser.ChooserOption.Generic, FileLocationsUtil.getDataFilesDirectoryPath(), DataServerProxy.getDataProxy().isRemoteConnection());
        this.mFileChooser.setDialogTitle(this.getResString("IDS_PREPAREMODEL_LOADMODEL_OPEN_XML_FILE_DIALOG_TITLE"));
        RefFileFilter refFileFilter = new RefFileFilter(this.getResString("IDS_PREPAREMODEL_LOADMODEL_OPEN_MML_FILE_FILTER"), this.getResString("IDS_PREPAREMODEL_LOADMODEL_OPEN_MML_FILE_EXTENSION"));
        RefFileFilter refFileFilter2 = new RefFileFilter(this.getResString("IDS_PREPAREMODEL_LOADMODEL_OPEN_XML_FILE_FILTER"), this.getResString("IDS_PREPAREMODEL_LOADMODEL_OPEN_XML_FILE_EXTENSION"));
        this.mFileChooser.addChoosableFileFilter((FileFilter)refFileFilter2);
        this.mFileChooser.addChoosableFileFilter((FileFilter)refFileFilter);
        this.mFileChooser.setAcceptAllFileFilterUsed(true);
        this.mFileChooser.setFileFilter((FileFilter)refFileFilter2);
        int n = this.mFileChooser.showOpenDialog((Component)((Object)this));
        if (n == 0) {
            FileLocationsUtil.setDataFilesDirectoryPath((String)this.mFileChooser.getCurrentDirectory().getAbsolutePath());
            this.mFileText.setText(this.mFileChooser.getSelectedFilePath());
            this.enableOkButton();
            this.mFileChooser.requestFocus();
        }
    }

    private void enableOkButton() {
        if (this.mNameTxt.getText() != null && this.mNameTxt.getText().trim().length() > 0 && this.mFileText.getText() != null && this.mFileText.getText().trim().length() > 0) {
            this.enableOkPaste(true);
        } else {
            this.enableOkPaste(false);
        }
    }

    private void addComponents(JPanel jPanel) {
        JTextArea jTextArea = new JTextArea(this.getResString("IDS_PREPAREMODEL_LOADMODEL_LONGLABLE_COLON"));
        jTextArea.setOpaque(false);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setFocusable(false);
        jTextArea.setRows(3);
        jTextArea.setMinimumSize(new Dimension(160, 50));
        jTextArea.setPreferredSize(new Dimension(160, 50));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = 24;
        Insets insets = DialogUtil.getStandardButtonInsets();
        DialogUtil.addUsingGBL(jPanel, this.mNameLbl, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        n = 23;
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mNameTxt), gridBagConstraints, 1, 0, 2, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        n = 22;
        insets.set(DialogUtil.getGroupBoxInnerMargin(), insets.left, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mFileBtn, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mFileText), gridBagConstraints, 1, 1, 2, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        n = 23;
        insets = DialogUtil.getStandardButtonInsets();
        DialogUtil.addUsingGBL(jPanel, this.mPanel, gridBagConstraints, 1, 3, 1, 2, n, insets);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        n = 23;
        insets.set(insets.top, 0, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel2, this.mLblIcon, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        insets = DialogUtil.getStandardButtonInsets();
        n = 23;
        DialogUtil.addUsingGBL(jPanel2, jTextArea, gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 23;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 5, 2, 1, n, insets);
    }
}

