/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.transform;

import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.CalcWidget;
import com.spss.java_client.ui.controls.ExpressionAreaArrowButton;
import com.spss.java_client.ui.controls.ExpressionBuilderTextArea;
import com.spss.java_client.ui.controls.FunctionListControls;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TextAreaKeyListener;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.ExpressionBuilderUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.uitools.controls.drag_drop.DragPane;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ListSelectionModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class IfCases
extends BaseSubDialog
implements DocumentListener,
ItemListener,
ListSelectionListener,
KeyListener {
    private SrcVariableList mSrcVarList;
    private JScrollPane mSrcScrollPane;
    private ExpressionAreaArrowButton mLeftToRightArrowButton;
    private JRadioButton mIncludeAllCasesRadio;
    private JRadioButton mIncludeIfCaseRadio;
    private SpssButtonGroup mButtonGroup;
    private ExpressionBuilderTextArea mTextArea;
    private JScrollPane mScrollPane;
    private CalcWidget mCalcWidget;
    private JTextArea mDescriptionTextArea;
    private JScrollPane mDescriptionTextAreaScrollPane;
    private JLabel mFunctionGrpLabel;
    private JList mFunctionGrpList;
    private JScrollPane mFunctionGrpListScrollPane;
    private JLabel mFunctionSpecialVarsLabel;
    private JList mFunctionSpecialVarsList;
    private JScrollPane mFunctionSpecialVarsListScrollPane;
    private ArrowButton mFunctionListArrowButton;
    private FunctionListControls mFunctionListControls;
    private String helpId;

    public IfCases(BaseProcedureDialog baseProcedureDialog, String string, String string2) {
        super(baseProcedureDialog, baseProcedureDialog.getResString(string), true);
        this.helpId = string2;
    }

    @Override
    public String getDialogHelpID() {
        return this.helpId;
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.enableContinueButton();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.enableContinueButton();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        boolean bl;
        Object object = itemEvent.getItem();
        boolean bl2 = bl = itemEvent.getStateChange() == 1;
        if (object.equals(this.mIncludeIfCaseRadio)) {
            if (bl) {
                this.mSrcVarList.setEnabled(bl);
                if (this.mSrcVarList.getSelectedIndex() > -1) {
                    this.mLeftToRightArrowButton.setEnabled(bl);
                } else {
                    this.mSrcVarList.setSelectedIndex(0);
                }
                this.mTextArea.setEnabled(bl);
                this.mCalcWidget.setEnabled(bl);
                this.mFunctionListArrowButton.setEnabled(this.mFunctionListControls.getFunctionList().getSelectedIndex() > -1);
                this.mFunctionGrpLabel.setEnabled(bl);
                this.mFunctionGrpList.setEnabled(bl);
                this.mFunctionSpecialVarsLabel.setEnabled(bl);
                this.mFunctionSpecialVarsList.setEnabled(bl);
                this.mDescriptionTextArea.setEnabled(bl);
                this.enableContinueButton();
            }
            this.enableScrollBars(true);
        } else if (object.equals(this.mIncludeAllCasesRadio)) {
            if (bl) {
                this.mSrcVarList.setEnabled(!bl);
                if (this.mSrcVarList.getSelectedIndex() > -1) {
                    this.mLeftToRightArrowButton.setEnabled(!bl);
                }
                this.mTextArea.setEnabled(!bl);
                this.mScrollPane.setEnabled(!bl);
                this.mCalcWidget.setEnabled(!bl);
                this.mFunctionListArrowButton.setEnabled(!bl);
                this.mFunctionGrpLabel.setEnabled(!bl);
                this.mFunctionGrpList.setEnabled(!bl);
                this.mFunctionSpecialVarsLabel.setEnabled(!bl);
                this.mFunctionSpecialVarsList.setEnabled(!bl);
                this.mDescriptionTextArea.setEnabled(!bl);
                this.enableContinue(bl);
            }
            this.enableScrollBars(false);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getSource() == this.mSrcVarList && this.mSrcVarList.isEnabled()) {
            ListSelectionModel listSelectionModel = this.mSrcVarList.getSelectionModel();
            int n = listSelectionModel.getMinSelectionIndex();
            int n2 = listSelectionModel.getMaxSelectionIndex();
            boolean bl = n >= 0 && n2 >= 0;
            this.mLeftToRightArrowButton.setEnabled(bl);
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 9) {
            DialogFocusTraversalPolicy dialogFocusTraversalPolicy = (DialogFocusTraversalPolicy)this.getFocusTraversalPolicy();
            Component component = (Component)keyEvent.getSource();
            Component component2 = keyEvent.isShiftDown() ? dialogFocusTraversalPolicy.getComponentBefore((Container)((Object)this), component) : dialogFocusTraversalPolicy.getComponentAfter((Container)((Object)this), component);
            keyEvent.consume();
            if (component2 != null) {
                component2.requestFocus();
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public boolean continuePressed() {
        if (!(!this.mIncludeIfCaseRadio.isSelected() || this.mTextArea.validateContents() && DialogUtil.isValidIfExpression(this.mTextArea.getText(), this))) {
            this.mTextArea.requestFocus();
            this.mTextArea.selectAll();
            return false;
        }
        return super.continuePressed();
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefaults();
        JPanel jPanel = this.getViewPanel();
        this.addComponents(jPanel);
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(this.setTabTraversal(), false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
        this.mDescriptionTextArea.addKeyListener(new TextAreaKeyListener(this.mDescriptionTextArea, this, dialogFocusTraversalPolicy, false));
        if (this.getGlassPane() instanceof DragPane) {
            ExpressionBuilderUtil.addExpressionTextAreaDragAdapter((DragPane)this.getGlassPane(), this.mTextArea);
            ExpressionBuilderUtil.addDragAdapterToList((DragPane)this.getGlassPane(), this.mFunctionSpecialVarsList);
        }
        this.pack();
    }

    @Override
    protected boolean saveState(DialogDataModel dialogDataModel) {
        if (this.mTextArea.isEnabled()) {
            dialogDataModel.putString("IF_CONDITION_TEXT", this.mTextArea.getText());
        } else {
            dialogDataModel.putString("IF_CONDITION_TEXT", null);
        }
        dialogDataModel.putString("IF_CONDITION_TEXT_DISPLAY", this.mTextArea.getText());
        this.mFunctionListControls.saveFunctionState(dialogDataModel);
        return super.saveState(dialogDataModel);
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        super.loadState(dialogDataModel);
        String string = dialogDataModel.getString("IF_CONDITION_TEXT_DISPLAY");
        string = string != null ? string : "";
        this.mTextArea.setText(string);
        this.mFunctionListControls.loadFunctionState(dialogDataModel);
    }

    private void initVars() {
        this.mSrcVarList = new SrcVariableList();
        this.mSrcVarList.setIdentifier("SOURCE_VAR_LIST_IDENTIFIER");
        this.mSrcScrollPane = new JScrollPane(this.mSrcVarList);
        this.mSrcScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        this.mSrcVarList.setSelectionMode(0);
        this.mSrcVarList.addListSelectionListener(this);
        this.mLeftToRightArrowButton = new ExpressionAreaArrowButton(SpssArrowButton.ButtonOrientation.right);
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, "IDS_IF_CASES_INCLUDE_ALL_CASES_RADIO");
        this.mIncludeAllCasesRadio = new JRadioButton(toggleButtonAction);
        this.mIncludeAllCasesRadio.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_IF_CASES_INCLUDE_IF_CASE_SATISFIES_CONDITION");
        this.mIncludeIfCaseRadio = new JRadioButton(toggleButtonAction);
        this.mIncludeIfCaseRadio.addItemListener(this);
        this.mTextArea = new ExpressionBuilderTextArea();
        this.mTextArea.setMinimumSize(new Dimension(450, 80));
        this.mTextArea.setLineWrap(true);
        this.mTextArea.setWrapStyleWord(true);
        this.mTextArea.getDocument().addDocumentListener(this);
        this.mTextArea.addKeyListener(this);
        this.mScrollPane = new JScrollPane((Component)((Object)this.mTextArea));
        this.mScrollPane.setPreferredSize(this.mTextArea.getMinimumSize());
        this.mScrollPane.setVerticalScrollBarPolicy(20);
        this.mScrollPane.setHorizontalScrollBarPolicy(30);
        this.mCalcWidget = new CalcWidget((JTextArea)((Object)this.mTextArea));
        this.mFunctionListControls = new FunctionListControls(true, true);
        this.mFunctionListControls.setSrcList(this.mSrcVarList);
        this.mFunctionListControls.setExpressionArea((JTextArea)((Object)this.mTextArea));
        this.mFunctionListControls.setFunctionGroupIdentifier("Function Grp in If");
        this.mFunctionListArrowButton = this.mFunctionListControls.getFunctionArrow();
        this.mDescriptionTextArea = this.mFunctionListControls.getFunctionDescArea();
        this.mDescriptionTextArea.setMinimumSize(new Dimension(300, 150));
        this.mDescriptionTextArea.setLineWrap(true);
        this.mDescriptionTextArea.setWrapStyleWord(true);
        this.mDescriptionTextArea.setOpaque(false);
        this.mDescriptionTextAreaScrollPane = new JScrollPane(this.mDescriptionTextArea);
        this.mDescriptionTextAreaScrollPane.setPreferredSize(this.mDescriptionTextArea.getMinimumSize());
        this.mDescriptionTextAreaScrollPane.setVerticalScrollBarPolicy(20);
        this.mDescriptionTextAreaScrollPane.setHorizontalScrollBarPolicy(30);
        this.mFunctionGrpList = this.mFunctionListControls.getFunctionGroupList();
        this.mFunctionGrpList.setSelectionMode(0);
        this.mFunctionGrpListScrollPane = new JScrollPane(this.mFunctionGrpList);
        this.mFunctionGrpListScrollPane.setVerticalScrollBarPolicy(20);
        this.mFunctionGrpListScrollPane.setPreferredSize(new Dimension(DialogUtil.getFunctionGroupListWidth(), DialogUtil.getFunctionGroupListHeight()));
        this.mFunctionSpecialVarsList = this.mFunctionListControls.getFunctionList();
        this.mFunctionSpecialVarsList.setSelectionMode(0);
        this.mFunctionSpecialVarsListScrollPane = new JScrollPane(this.mFunctionSpecialVarsList);
        this.mFunctionSpecialVarsListScrollPane.setPreferredSize(new Dimension(DialogUtil.getFunctionGroupListWidth(), DialogUtil.getFunctionGroupListHeight() * 2));
        this.mFunctionSpecialVarsListScrollPane.setVerticalScrollBarPolicy(20);
        this.mFunctionListControls.setFunctionListIdentifier("Function list in If");
        this.mFunctionGrpLabel = DialogUtil.createLabel("IDS_FUNCTION_GROUP_LABEL");
        this.mFunctionGrpLabel.setLabelFor(this.mFunctionGrpList);
        this.mFunctionSpecialVarsLabel = DialogUtil.createLabel("IDS_FUNCTION_SPECIAL_VARIABLES_LABEL");
        this.mFunctionSpecialVarsLabel.setLabelFor(this.mFunctionSpecialVarsList);
        this.mLeftToRightArrowButton.registerComponents(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mLeftToRightArrowButton.registerComponents((JComponent)((Object)this.mTextArea), SpssArrowButton.ButtonOrientation.left);
    }

    private void setDefaults() {
        this.mIncludeAllCasesRadio.setSelected(true);
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcVarList.setEnabled(false);
        this.mLeftToRightArrowButton.setEnabled(false);
        this.mTextArea.setLineWrap(true);
        this.mTextArea.setEnabled(false);
        this.mScrollPane.setEnabled(false);
        this.mCalcWidget.setEnabled(false);
        this.mFunctionListArrowButton.setEnabled(false);
        this.mDescriptionTextArea.setEnabled(false);
        this.mFunctionGrpLabel.setEnabled(false);
        this.mFunctionSpecialVarsLabel.setEnabled(false);
        this.mFunctionGrpList.setEnabled(false);
        this.mFunctionSpecialVarsList.setEnabled(false);
        this.mDescriptionTextAreaScrollPane.setEnabled(false);
        this.mFunctionGrpListScrollPane.setEnabled(false);
        this.mFunctionSpecialVarsListScrollPane.setEnabled(false);
        this.mFunctionListArrowButton.setEnabled(false);
    }

    private void enableContinueButton() {
        String string = this.mTextArea.getText();
        if (string.contains("?") || string.equals("")) {
            this.enableContinue(false);
        } else {
            this.enableContinue(true);
        }
    }

    private void enableScrollBars(boolean bl) {
        this.mSrcVarList.setOpaque(bl);
        this.mSrcScrollPane.getVerticalScrollBar().setEnabled(bl);
        this.mSrcScrollPane.getHorizontalScrollBar().setEnabled(bl);
        this.mSrcScrollPane.setWheelScrollingEnabled(bl);
        this.mSrcScrollPane.setOpaque(bl);
        this.mTextArea.setOpaque(bl);
        this.mScrollPane.getVerticalScrollBar().setEnabled(bl);
        this.mScrollPane.getHorizontalScrollBar().setEnabled(bl);
        this.mScrollPane.setWheelScrollingEnabled(bl);
        this.mScrollPane.setOpaque(bl);
        this.mDescriptionTextAreaScrollPane.getVerticalScrollBar().setEnabled(bl);
        this.mDescriptionTextAreaScrollPane.getHorizontalScrollBar().setEnabled(bl);
        this.mDescriptionTextAreaScrollPane.setWheelScrollingEnabled(bl);
        this.mDescriptionTextAreaScrollPane.setOpaque(bl);
    }

    private void addComponents(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mSrcScrollPane, gridBagConstraints, 0, 0, 1, 8, n, null);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel, this.mIncludeAllCasesRadio, gridBagConstraints, 2, 0, 2, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mIncludeIfCaseRadio, gridBagConstraints, 2, 1, 2, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mScrollPane, gridBagConstraints, 2, 2, 3, 1, n, null);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        n = 10;
        Insets insets2 = DialogUtil.getArrowButtonInsets();
        DialogUtil.addUsingGBL(jPanel, this.mLeftToRightArrowButton, gridBagConstraints, 1, 2, 1, 1, n, insets2);
        Insets insets3 = DialogUtil.getArrowButtonInsets();
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets4 = new Insets(n2 * 2, insets3.left, 0, n2 * 3);
        n = 23;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mDescriptionTextAreaScrollPane, gridBagConstraints, 1, 7, 3, 1, n, insets4);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mCalcWidget, gridBagConstraints, 2, 4, 1, 3, n, DialogUtil.getStandardControlInsets());
        insets4.set(n2 * 2, insets3.left, 0, n2 * 3);
        gridBagConstraints.fill = 0;
        n = 21;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mFunctionListArrowButton, gridBagConstraints, 3, 5, 1, 2, n, insets4);
        n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mFunctionGrpLabel, gridBagConstraints, 4, 3, 1, 1, n, null);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mFunctionGrpListScrollPane, gridBagConstraints, 4, 4, 1, 1, n, null);
        insets4.set(n2, 0, 0, 0);
        n = 21;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mFunctionSpecialVarsLabel, gridBagConstraints, 4, 5, 1, 1, n, insets4);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mFunctionSpecialVarsListScrollPane, gridBagConstraints, 4, 6, 1, 2, n, null);
        this.mButtonGroup = DialogUtil.createButtonGroup(jPanel);
    }

    private Vector<Object> setTabTraversal() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mButtonGroup);
        vector.add(this.mSrcVarList);
        vector.add(this.mLeftToRightArrowButton);
        vector.add((Object)this.mTextArea);
        vector.add(this.mCalcWidget.getDefaultFocusButton());
        vector.add(this.mFunctionGrpList);
        vector.add(this.mFunctionSpecialVarsList);
        vector.add(this.mFunctionListArrowButton);
        vector.add(this.mDescriptionTextArea);
        for (int i = 0; i < this.mCmdButtonPanel.getComponentCount(); ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        return vector;
    }
}

