/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.help;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.dialogs.base.help.res.HelpResBundle;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAboutSplashPanel;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.dialogs.BaseDialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class AboutDlg
extends BaseDialog {
    private static final String OK_BUTTON = "IDS_OK";
    private JButton mOkButton;

    public AboutDlg(SpssFrame spssFrame) throws HeadlessException {
        super((JFrame)spssFrame, true, ResUtil.getBundle(HelpResBundle.getDefaultResourceBundleName(), ResUtil.getLocale()), HelpResBundle.getImageFolder());
        this.setTitle(VersionInfo.getAppVersionString());
        this.setLocationRelativeTo(spssFrame);
    }

    public void doHelp() {
    }

    protected void init() {
        super.init();
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setBorder(new EmptyBorder(new Insets(0, 0, 5, 0)));
        JPanel jPanel2 = this.getViewPanel();
        this.setupPanel(jPanel2);
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(this.setTabTraversal(), false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
        jPanel.setPreferredSize(new Dimension(650, 555));
        this.pack();
        Dimension dimension = this.mOkButton.getSize();
        dimension.width *= 2;
        this.mOkButton.setMinimumSize(dimension);
        this.mOkButton.setPreferredSize(dimension);
        this.mOkButton.setSize(dimension);
        this.setResizable(false);
    }

    protected JPanel setupCmdButtonPanel() {
        JPanel jPanel = new JPanel(true);
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(OK_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AboutDlg.this.dispose();
            }
        };
        this.mOkButton = new JButton(toggleButtonAction);
        jPanel.setBorder(new EmptyBorder(DialogUtil.getMainButtonGap(), DialogUtil.getStandardButtonInsets().left, DialogUtil.getStandardButtonInsets().bottom, DialogUtil.getStandardButtonInsets().right));
        jPanel.setLayout(new FlowLayout());
        jPanel.add(this.mOkButton);
        this.getRootPane().setDefaultButton(this.mOkButton);
        return jPanel;
    }

    protected void setupPanel(JPanel jPanel) {
        String string;
        if (VersionInfo.isStudentVersion()) {
            ComponentState.trace1((String)"* * About box detected Student version.", (int)32);
            string = ResUtil.getCommonDlgString("IDS_SPLASH_FILENAME_STUDENT");
        } else if (VersionInfo.isStatsLiteVersion()) {
            ComponentState.trace1((String)"* * About box detected Developer version.", (int)32);
            string = ResUtil.getCommonDlgString("IDS_SPLASH_FILENAME_DEVELOPR");
        } else if (VersionInfo.IsApplicationOnCloud()) {
            ComponentState.trace1((String)"* * About box detected Statistics Subscription version.", (int)32);
            string = ResUtil.getCommonDlgString("IDS_SPLASH_FILENAME_CLOUD");
        } else {
            ComponentState.trace1((String)"* * About box detected Statistics version.", (int)32);
            string = ResUtil.getCommonDlgString("IDS_SPLASH_FILENAME");
        }
        String string2 = OSInfo.is64Bit() ? ResUtil.getCommonDlgString("IDS_HELP_CLIENT_INFO_64BIT") : ResUtil.getCommonDlgString("IDS_HELP_CLIENT_INFO_32BIT");
        String string3 = "";
        string3 = VersionInfo.IsApplicationOnCloud() ? String.format(ComponentState.getSPSSLocale(), ResUtil.getCommonDlgString("IDS_HELP_BUILD_INFO"), VersionInfo.getBuildNumberString()) : String.format(ComponentState.getSPSSLocale(), ResUtil.getCommonDlgString("IDS_HELP_RELEASE_INFO"), VersionInfo.getVersionString());
        this.add(new SpssAboutSplashPanel(ResUtil.getCommonDlgString("IDS_HELP_STATS_COPYRIGHT_STMT"), ResUtil.getCommonDlgString("IDS_HELP_STATS_VERSION_NUM"), true, string3, string2, ResUtil.getCommonDlgImageResource(string)));
    }

    private Vector<Object> setTabTraversal() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mOkButton);
        return vector;
    }
}

