/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.graphs.legacy_dialogs.three_d_bar;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.controls.FixedLengthNumericDocument;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.uitools.controls.ContextEnabledTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.text.DecimalFormat;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class ThreeDBar2Param
extends BaseSubDialog
implements DocumentListener {
    static final String MIN_KEY = "MIN_KEY";
    static final String MAX_KEY = "MAX_KEY";
    private ContextEnabledTextField mMinText;
    private ContextEnabledTextField mMaxText;
    private String mLabelStr;

    public ThreeDBar2Param(BaseProcedureDialog baseProcedureDialog, String string) {
        super(baseProcedureDialog, baseProcedureDialog.getResString("IDS_3D_BAR_PARAMETER_TITLE"), true);
        this.mLabelStr = string;
        this.init();
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idd_2param_dlg";
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.enableContinue(this.mMaxText.getText().length() > 0 && this.mMinText.getText().length() > 0);
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.enableContinue(this.mMaxText.getText().length() > 0 && this.mMinText.getText().length() > 0);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.enableContinue(this.mMaxText.getText().length() > 0 && this.mMinText.getText().length() > 0);
    }

    @Override
    public boolean continuePressed() {
        double d;
        String string = this.mMinText.getText();
        String string2 = this.mMaxText.getText();
        if (string.length() == 0 && string2.length() == 0) {
            return false;
        }
        double d2 = 0.0;
        double d3 = 0.0;
        d2 = string.equals("-") || string.equals(".") ? 0.0 : Double.parseDouble(string);
        d3 = string2.equals("-") || string2.equals(".") ? 0.0 : Double.parseDouble(string2);
        if (this.mLabelStr.contains(this.getResString("IDS_3D_BAR_REPRESENTS_PERCENTILE"))) {
            if (!string.equals("-")) {
                d = Double.parseDouble(string);
                if (d <= 0.0 || d >= 100.0) {
                    SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_3D_BAR_REPRESENTS_PERCENTILE"), VersionInfo.getAppVersionString());
                    this.mMinText.requestFocus();
                    return false;
                }
            } else {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_3D_BAR_REPRESENTS_PERCENTILE"), VersionInfo.getAppVersionString());
                return false;
            }
        }
        if (this.mLabelStr.contains(this.getResString("IDS_3D_BAR_REPRESENTS_PERCENTILE"))) {
            if (!string2.equals("-")) {
                d = Double.parseDouble(string2);
                if (d <= 0.0 || d >= 100.0) {
                    SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_3D_BAR_REPRESENTS_PERCENTILE"), VersionInfo.getAppVersionString());
                    this.mMaxText.requestFocus();
                    return false;
                }
            } else {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_3D_BAR_REPRESENTS_PERCENTILE"), VersionInfo.getAppVersionString());
                return false;
            }
        }
        if (d2 > d3) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_3D_BAR_2_PARAMETER_RANGE"), VersionInfo.getAppVersionString());
            this.mMaxText.requestFocus();
            this.mMaxText.selectAll();
            return false;
        }
        return true;
    }

    @Override
    protected boolean saveState(DialogDataModel dialogDataModel) {
        boolean bl = super.saveState(dialogDataModel);
        if (this.continuePressed()) {
            DecimalFormat decimalFormat;
            String string = this.mMinText.getText();
            String string2 = this.mMaxText.getText();
            if (string.equals("-") || string.equals(".")) {
                dialogDataModel.putString(MIN_KEY, "0");
            } else {
                if (string.contains(".") && string.length() - string.indexOf(".") > 1) {
                    decimalFormat = new DecimalFormat("###########.###########");
                    string = decimalFormat.format(string);
                } else if (string.contains(".")) {
                    string = string.substring(0, string.indexOf("."));
                }
                dialogDataModel.putString(MIN_KEY, string);
            }
            if (string2.equals("-") || string2.equals(".")) {
                dialogDataModel.putString(MAX_KEY, "0");
            } else {
                if (string2.contains(".") && string2.length() - string2.indexOf(".") > 1) {
                    decimalFormat = new DecimalFormat("###########.###########");
                    string2 = decimalFormat.format(string2);
                } else if (string2.contains(".")) {
                    string2 = string2.substring(0, string2.indexOf("."));
                }
                dialogDataModel.putString(MAX_KEY, string2);
            }
        } else {
            dialogDataModel.putString(MIN_KEY, null);
            dialogDataModel.putString(MAX_KEY, null);
        }
        return bl;
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        super.loadState(dialogDataModel);
        if (dialogDataModel.getString(MIN_KEY) != null) {
            this.mMinText.setText(dialogDataModel.getString(MIN_KEY));
            this.mMinText.requestFocus();
            this.mMinText.selectAll();
        }
        if (dialogDataModel.getString(MAX_KEY) != null) {
            this.mMaxText.setText(dialogDataModel.getString(MAX_KEY));
        }
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        TitledBorder titledBorder = BorderFactory.createTitledBorder(this.mLabelStr);
        jPanel.setBorder(titledBorder);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(insets.top, insets.left, insets.right, insets.bottom);
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_3D_BAR_2_PARAMETER_MIN_LABEL");
        jLabel.setLabelFor((Component)this.mMinText);
        insets2.left = n2;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        insets2.left = 2 * n2;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mMinText, gridBagConstraints, 1, 1, 1, 1, n, insets2);
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_3D_BAR_2_PARAMETER_MAX_LABEL");
        jLabel2.setLabelFor((Component)this.mMaxText);
        insets2.top = n2;
        insets2.left = n2;
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 0, 2, 1, 1, n, insets2);
        insets2.left = 2 * n2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mMaxText, gridBagConstraints, 1, 2, 1, 1, n, insets2);
        this.setTabTraversalOrder();
        this.pack();
    }

    private void initVars() {
        this.mMinText = new ContextEnabledTextField(12);
        this.mMinText.setColumns(8);
        FixedLengthNumericDocument fixedLengthNumericDocument = new FixedLengthNumericDocument(12, false, true);
        this.mMinText.setDocument((Document)fixedLengthNumericDocument);
        this.mMinText.getDocument().addDocumentListener(this);
        this.mMaxText = new ContextEnabledTextField(12);
        this.mMaxText.setColumns(8);
        fixedLengthNumericDocument = new FixedLengthNumericDocument(12, false, true);
        this.mMaxText.setDocument((Document)fixedLengthNumericDocument);
        this.mMaxText.getDocument().addDocumentListener(this);
        this.enableContinue(false);
    }

    private void setTabTraversalOrder() {
        Component[] componentArray;
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mMinText);
        vector.add(this.mMaxText);
        for (Component component : componentArray = this.mCmdButtonPanel.getComponents()) {
            vector.add(component);
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }
}

