/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.graphs.legacy_dialogs.three_d_bar;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.controls.FixedLengthNumericDocument;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.uitools.controls.ContextEnabledTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.text.DecimalFormat;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class ThreeDBar1Param
extends BaseSubDialog
implements DocumentListener {
    static final String VAL_KEY = "VAL_KEY";
    private ContextEnabledTextField mValText;
    private String mLabelStr;

    public ThreeDBar1Param(BaseProcedureDialog baseProcedureDialog, String string) {
        super(baseProcedureDialog, baseProcedureDialog.getResString("IDS_3D_BAR_PARAMETER_TITLE"), true);
        this.mLabelStr = string;
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idd_1param_dlg";
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.enableContinue(this.mValText.getText().length() > 0);
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.enableContinue(this.mValText.getText().length() > 0);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.enableContinue(this.mValText.getText().length() > 0);
    }

    @Override
    public boolean continuePressed() {
        String string = this.mValText.getText();
        if (string.length() == 0) {
            this.mValText.requestFocus();
            this.mValText.selectAll();
            return false;
        }
        if (this.mLabelStr.contains(this.getResString("IDS_3D_BAR_REPRESENTS_PERCENTILE"))) {
            try {
                double d = Double.parseDouble(string);
                if (d <= 0.0 || d >= 100.0) {
                    SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_3D_BAR_REPRESENTS_PERCENTILE"), VersionInfo.getAppVersionString());
                    this.mValText.requestFocus();
                    this.mValText.selectAll();
                    return false;
                }
            }
            catch (NumberFormatException numberFormatException) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_3D_BAR_REPRESENTS_PERCENTILE"), VersionInfo.getAppVersionString());
                this.mValText.requestFocus();
                this.mValText.selectAll();
                return false;
            }
        }
        return true;
    }

    @Override
    protected boolean saveState(DialogDataModel dialogDataModel) {
        boolean bl;
        block8: {
            bl = super.saveState(dialogDataModel);
            if (this.continuePressed()) {
                String string = this.mValText.getText();
                try {
                    double d = Double.parseDouble(string);
                    if (string.equals("-") || string.equals(".") || d == 0.0) {
                        dialogDataModel.putString(VAL_KEY, "0");
                        break block8;
                    }
                    DecimalFormat decimalFormat = new DecimalFormat("###########.###########");
                    if (string.contains(".") && string.length() - string.indexOf(".") > 1) {
                        double d2 = Double.parseDouble(string);
                        string = "" + d2;
                        string = decimalFormat.format(d2);
                    } else {
                        if (string.contains(".")) {
                            string = string.substring(0, string.indexOf("."));
                        }
                        double d3 = Double.parseDouble(string);
                        string = "" + decimalFormat.format(d3);
                    }
                    dialogDataModel.putString(VAL_KEY, string);
                }
                catch (NumberFormatException numberFormatException) {
                    dialogDataModel.putString(VAL_KEY, "0");
                }
            } else {
                dialogDataModel.putString(VAL_KEY, null);
            }
        }
        return bl;
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        super.loadState(dialogDataModel);
        if (dialogDataModel.getString(VAL_KEY) != null) {
            String string = dialogDataModel.getString(VAL_KEY);
            this.mValText.setText(string);
            this.mValText.requestFocus();
            this.mValText.selectAll();
        }
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(insets.top, insets.left, insets.right, insets.bottom);
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_3D_BAR_BARS_REPRESENTS_LABEL");
        jLabel.setText(this.mLabelStr);
        jLabel.setLabelFor((Component)this.mValText);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets2);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        insets2.top = DialogUtil.getComponentGroupGap() + 3;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mValText, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        this.pack();
    }

    private void initVars() {
        this.mValText = new ContextEnabledTextField(12);
        this.mValText.setColumns(10);
        FixedLengthNumericDocument fixedLengthNumericDocument = new FixedLengthNumericDocument(12, false, true);
        this.mValText.setDocument((Document)fixedLengthNumericDocument);
        this.mValText.getDocument().addDocumentListener(this);
        this.enableContinue(false);
    }
}

