/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.graphs.legacy_dialogs.scatterdot;

import com.spss.java_client.ui.dialogs.base.graphs.GraphsUtil;
import com.spss.java_client.ui.dialogs.base.graphs.OptionsSubDialog;
import com.spss.java_client.ui.dialogs.base.graphs.TitlesSubDialog;
import com.spss.java_client.ui.dialogs.base.graphs.legacy_dialogs.scatterdot.ScatterPlotCommonPanel;
import com.spss.java_client.ui.dialogs.base.graphs.legacy_dialogs.scatterdot.ScatterPlotUtils;
import com.spss.java_client.ui.dialogs.base.graphs.res.GraphsResBundle;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class ScatterPlotThreeDimensionalDlg
extends BaseProcedureDialog {
    static final String TITLES_BUTTON = "IDS_REPORT_COMMON_TITLES_3DOT";
    static final String OPTIONS_BUTTON = "IDS_COMMON_OPTIONS_3DOT";
    private ScatterPlotCommonPanel mCommonPanel;

    public ScatterPlotThreeDimensionalDlg(JFrame jFrame) {
        super(jFrame, false, GraphsResBundle.getDefaultResourceBundleName(), GraphsResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_SD_SCATTERPLOT_3D_TITLE"));
        this.setLocationRelativeTo(this.getParent());
    }

    public void enableOkPasteButtons(boolean bl) {
        this.enableOkPaste(bl);
    }

    @Override
    public void reset() {
        super.reset();
        this.mCommonPanel.setDefaults();
    }

    @Override
    public String generateSyntax() {
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        stringBuffer.append(SyntaxUtil.getCommand("GRAPH"));
        stringBuffer.append(SyntaxUtil.getSubCommand("/SCATTERPLOT(XYZ)="));
        stringBuffer.append(this.mCommonPanel.getXAxisTargetList().getVariablesStringList() + " WITH ");
        stringBuffer.append(this.mCommonPanel.getYAxisTargetList().getVariablesStringList() + " WITH ");
        stringBuffer.append(this.mCommonPanel.getZAxisTargetList().getVariablesStringList());
        stringBuffer.append(ScatterPlotUtils.generateMarkersLabelCasesSyntax(dialogDataModel, this.mCommonPanel.getSetMarkersByTargetList(), this.mCommonPanel.getLabelCaseByTargetList()));
        stringBuffer.append(ScatterPlotUtils.generatePanelSyntax(this.mCommonPanel.getRowsTargetList(), this.mCommonPanel.isNestVarCheckSelectedForRows(), this.mCommonPanel.getColumnsTargetList(), this.mCommonPanel.isNestVarCheckSelectedForColumns()));
        stringBuffer.append(ScatterPlotUtils.generateOptionsSyntax(dialogDataModel));
        stringBuffer.append(ScatterPlotUtils.generateTemplateSyntax(this.mCommonPanel.isUseChartCheckSelected(), this.mCommonPanel.getTemplateFileText()));
        stringBuffer.append(GraphsUtil.generateTitlesSubDialogSyntax(dialogDataModel));
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        return stringBuffer.toString();
    }

    @Override
    public String getDialogHelpID() {
        return "idh_gs3d";
    }

    @Override
    public String getIActionKey() {
        return "graphs_legacy_dialogs_3_d_scatter";
    }

    @Override
    public boolean okPastePressed() {
        return true;
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        this.addComponents(jPanel);
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(this.setTabTraversal(), false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
        this.pack();
    }

    @Override
    protected void loadDialogState() {
        super.loadDialogState();
        this.mCommonPanel.mSrcVarList.setSelectedIndex(0);
        this.mCommonPanel.mSrcVarList.requestFocus();
    }

    @Override
    protected JPanel setupOptionsButtonPanel() {
        JPanel jPanel = super.setupOptionsButtonPanel();
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(TITLES_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScatterPlotThreeDimensionalDlg.this.runTitlesSubDlg();
            }
        };
        JButton jButton = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, jButton);
        toggleButtonAction = new ToggleButtonAction(OPTIONS_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScatterPlotThreeDimensionalDlg.this.runOptionsSubDlg();
            }
        };
        JButton jButton2 = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, jButton2);
        return jPanel;
    }

    private void initVars() {
        this.mCommonPanel = new ScatterPlotCommonPanel(this, true, this.getResString("IDS_SD_SCATTERPLOT_3D_SOURCE_LABEL"));
    }

    private void addComponents(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        int n = 23;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mCommonPanel, gridBagConstraints, 0, 0, 1, 1, n, null);
    }

    private Vector<Object> setTabTraversal() {
        int n;
        Vector<Object> vector = new Vector<Object>();
        Vector<Object> vector2 = this.mCommonPanel.setTabTraversal();
        for (n = 0; n < vector2.size(); ++n) {
            vector.add(vector2.elementAt(n));
        }
        for (n = 0; n < this.mOptionButtonPanel.getComponentCount(); ++n) {
            Component component = this.mOptionButtonPanel.getComponent(n);
            if (!(component instanceof JButton)) continue;
            vector.add(this.mOptionButtonPanel.getComponent(n));
        }
        for (n = 0; n < this.mCmdButtonPanel.getComponentCount(); ++n) {
            vector.add(this.mCmdButtonPanel.getComponent(n));
        }
        return vector;
    }

    private void runTitlesSubDlg() {
        this.runSubDialog(new TitlesSubDialog(this));
    }

    private void runOptionsSubDlg() {
        if (this.mCommonPanel.getLabelCaseByTargetList().getModel().getSize() > 0) {
            this.runSubDialog(new OptionsSubDialog(this, 7));
        } else {
            this.runSubDialog(new OptionsSubDialog(this, 3));
        }
    }
}

