/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.graphs.legacy_dialogs.scatterdot;

import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.dialogs.base.graphs.ImageLabelKeyListener;
import com.spss.java_client.ui.dialogs.base.graphs.MatrixImage;
import com.spss.java_client.ui.dialogs.base.graphs.MatrixImagesGroup;
import com.spss.java_client.ui.dialogs.base.graphs.legacy_dialogs.scatterdot.ScatterPlotSimpleDotDlg;
import com.spss.java_client.ui.dialogs.base.graphs.res.GraphsResBundle;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.border.Border;

public class ScatterPlotSimpleDotOptions
extends BaseSubDialog {
    public static final String EXCLUDE_CASES_LISTWISE_RADIO = "IDS_OPT_SUBDLG_EX_CASES_LISTWISE_RADIO";
    public static final String EXCLUDE_CASES_VAR_BY_VAR_RADIO = "IDS_OPT_SUBDLG_EX_CASES_VAR_BY_VAR_RADIO";
    public static final String DISPLAY_GROUPS_SIMPLE_OPTIONS_CHECK = "IDS_OPT_SUBDLG_FOR_SIMPLE_DOT_DISPLAY_GROUPS_CHECK";
    private JRadioButton mExCasesListwiseRadio;
    private JRadioButton mExCasesVarByVarRadio;
    private JCheckBox mDisplayGroupsCheck;
    private JLabel mAsymmetricLabel;
    private JLabel mSymmetricLabel;
    private JLabel mFlatLabel;
    private MatrixImagesGroup mOptionsImageLabelGroup;
    private MatrixImage mAsymmetricImage;
    private MatrixImage mSymmetricImage;
    private MatrixImage mFlatImage;
    private Vector<Object> jComponentsVector;

    public ScatterPlotSimpleDotOptions(BaseProcedureDialog baseProcedureDialog, String string, boolean bl) {
        super(baseProcedureDialog, string, bl, GraphsResBundle.getDefaultResourceBundleName(), GraphsResBundle.getImageFolder());
        this.setTitle(string);
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idd_scatter_dot_shape";
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefaults();
        JPanel jPanel = this.getViewPanel();
        this.setUpUI(jPanel);
        this.setTabTraversalOrder();
        this.pack();
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        Integer n = dialogDataModel.getInteger("IDS_SCATTER_PLOT_SIMPLE_DOT_OPTIONS_SELECTED_IMAGE");
        if (n != null) {
            this.setImageSelected(n);
        }
        super.loadState(dialogDataModel);
    }

    @Override
    protected boolean saveState(DialogDataModel dialogDataModel) {
        super.saveState(dialogDataModel);
        dialogDataModel.putInteger("IDS_SCATTER_PLOT_SIMPLE_DOT_OPTIONS_SELECTED_IMAGE", new Integer(this.getSelectedImageIndex()));
        return true;
    }

    private void initVars() {
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, EXCLUDE_CASES_LISTWISE_RADIO);
        this.mExCasesListwiseRadio = new JRadioButton(toggleButtonAction);
        this.mExCasesVarByVarRadio = DialogUtil.createRadioButton(this, EXCLUDE_CASES_VAR_BY_VAR_RADIO, null);
        this.mDisplayGroupsCheck = DialogUtil.createCheckBox(this, DISPLAY_GROUPS_SIMPLE_OPTIONS_CHECK, null);
        this.mAsymmetricLabel = DialogUtil.createLabel(this, "IDS_SD_ASYMMETRIC_LABEL");
        this.mSymmetricLabel = DialogUtil.createLabel(this, "IDS_SD_SYMMETRIC_LABEL");
        this.mFlatLabel = DialogUtil.createLabel(this, "IDS_SD_FLAT_LABEL");
        this.mOptionsImageLabelGroup = new MatrixImagesGroup();
        this.mAsymmetricImage = new MatrixImage(this.getResImageURL("IDS_SD_ASYMMETRIC_IMAGE"));
        this.mAsymmetricImage.setImageLabelGroup(this.mOptionsImageLabelGroup);
        this.mAsymmetricImage.addMouseListener(new imageMouseSelectionListener());
        this.mSymmetricImage = new MatrixImage(this.getResImageURL("IDS_SD_SYMMETRIC_IMAGE"));
        this.mSymmetricImage.setImageLabelGroup(this.mOptionsImageLabelGroup);
        this.mSymmetricImage.addMouseListener(new imageMouseSelectionListener());
        this.mFlatImage = new MatrixImage(this.getResImageURL("IDS_SD_FLAT_IMAGE"));
        this.mFlatImage.setImageLabelGroup(this.mOptionsImageLabelGroup);
        this.mFlatImage.addMouseListener(new imageMouseSelectionListener());
        this.mAsymmetricLabel.setLabelFor(this.mAsymmetricImage);
        this.mSymmetricLabel.setLabelFor(this.mSymmetricImage);
        this.mFlatLabel.setLabelFor(this.mFlatImage);
        Vector<MatrixImage> vector = new Vector<MatrixImage>();
        vector.add(this.mAsymmetricImage);
        vector.add(this.mSymmetricImage);
        vector.add(this.mFlatImage);
        this.mAsymmetricImage.addKeyListener(new optionsDlgImageLabelKeyListener(vector, this.mOptionsImageLabelGroup));
        this.mSymmetricImage.addKeyListener(new optionsDlgImageLabelKeyListener(vector, this.mOptionsImageLabelGroup));
        this.mFlatImage.addKeyListener(new optionsDlgImageLabelKeyListener(vector, this.mOptionsImageLabelGroup));
        this.mAsymmetricImage.addFocusListener(new imageFocusListener());
        this.mSymmetricImage.addFocusListener(new imageFocusListener());
        this.mFlatImage.addFocusListener(new imageFocusListener());
    }

    private void setDefaults() {
        this.mExCasesListwiseRadio.setEnabled(false);
        this.mExCasesVarByVarRadio.setEnabled(false);
        this.mExCasesVarByVarRadio.setSelected(true);
        this.mAsymmetricImage.setSelected(true);
        if (((ScatterPlotSimpleDotDlg)((Object)this.getParent())).getTypeOfElementInXAxisList() == 3) {
            this.mDisplayGroupsCheck.setEnabled(false);
        }
    }

    private JPanel setupMissingValuesPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_OPT_SUBDLG_MISSING_VALUES_CAPTION")));
        JSeparator jSeparator = new JSeparator(0);
        jSeparator.setEnabled(true);
        jSeparator.setSize(1, 1);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        int n = DialogUtil.getGroupBoxInnerMargin();
        gridBagConstraints.fill = 2;
        Insets insets = new Insets(n, n, 0, n);
        DialogUtil.addUsingGBL(jPanel, this.mExCasesListwiseRadio, gridBagConstraints, 0, 0, 1, 1, 23, insets);
        Insets insets2 = DialogUtil.getStandardControlInsets();
        insets.set(insets2.top, n, n, n);
        DialogUtil.addUsingGBL(jPanel, this.mExCasesVarByVarRadio, gridBagConstraints, 0, 1, 1, 1, 23, insets);
        DialogUtil.addUsingGBL(jPanel, jSeparator, gridBagConstraints, 0, 2, 1, 1, 23, null);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mDisplayGroupsCheck, gridBagConstraints, 0, 3, 1, 1, 23, insets);
        return jPanel;
    }

    private JPanel createPlotShapePanel() {
        JComponent[] jComponentArray = new JComponent[]{this.mAsymmetricImage, this.mSymmetricImage, this.mFlatImage, this.mAsymmetricLabel, this.mSymmetricLabel, this.mFlatLabel};
        JPanel jPanel = PanelFactory.getPanelForImageLabels(jComponentArray, this.getResString("IDS_SD_PLOT_SHAPE_LABEL"), 3);
        return jPanel;
    }

    private void setUpUI(JPanel jPanel) {
        JPanel jPanel2 = this.setupMissingValuesPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n = DialogUtil.getComponentGroupGap();
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, 23, null);
        JPanel jPanel3 = this.createPlotShapePanel();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        Insets insets = new Insets(n, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 1, 1, 1, 23, insets);
    }

    private void setTabTraversalOrder() {
        Component[] componentArray;
        this.jComponentsVector = new Vector();
        this.jComponentsVector.add(this.mDisplayGroupsCheck);
        this.jComponentsVector.add(this.mAsymmetricImage);
        for (Component component : componentArray = this.mCmdButtonPanel.getComponents()) {
            this.jComponentsVector.add(component);
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(this.jComponentsVector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private int getSelectedImageIndex() {
        int n = -1;
        if (this.mOptionsImageLabelGroup.isSelected(this.mAsymmetricImage)) {
            n = 0;
        } else if (this.mOptionsImageLabelGroup.isSelected(this.mSymmetricImage)) {
            n = 1;
        } else if (this.mOptionsImageLabelGroup.isSelected(this.mFlatImage)) {
            n = 2;
        }
        return n;
    }

    private void setImageSelected(int n) {
        switch (n) {
            case 0: {
                this.mAsymmetricImage.setSelected(true);
                break;
            }
            case 1: {
                this.mSymmetricImage.setSelected(true);
                break;
            }
            case 2: {
                this.mFlatImage.setSelected(true);
            }
        }
    }

    private class optionsDlgImageLabelKeyListener
    extends ImageLabelKeyListener {
        optionsDlgImageLabelKeyListener(Vector vector, MatrixImagesGroup matrixImagesGroup) {
            super(vector, matrixImagesGroup);
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 40 || keyEvent.getKeyCode() == 39) {
                super.keyPressed(keyEvent);
                MatrixImage matrixImage = ScatterPlotSimpleDotOptions.this.mOptionsImageLabelGroup.getSelectedMatrixImage();
                matrixImage.setSelected(true);
                ScatterPlotSimpleDotOptions.this.jComponentsVector.insertElementAt(matrixImage, 1);
                ScatterPlotSimpleDotOptions.this.jComponentsVector.remove(2);
                DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(ScatterPlotSimpleDotOptions.this.jComponentsVector, false);
                ScatterPlotSimpleDotOptions.this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
            } else if (keyEvent.getKeyCode() == 38 || keyEvent.getKeyCode() == 37) {
                super.keyPressed(keyEvent);
                MatrixImage matrixImage = ScatterPlotSimpleDotOptions.this.mOptionsImageLabelGroup.getSelectedMatrixImage();
                matrixImage.setSelected(true);
                ScatterPlotSimpleDotOptions.this.jComponentsVector.insertElementAt(matrixImage, 1);
                ScatterPlotSimpleDotOptions.this.jComponentsVector.remove(2);
                DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(ScatterPlotSimpleDotOptions.this.jComponentsVector, false);
                ScatterPlotSimpleDotOptions.this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
            }
        }
    }

    private class imageFocusListener
    extends FocusAdapter {
        private imageFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            MatrixImage matrixImage = (MatrixImage)focusEvent.getSource();
            matrixImage.setSelected(true);
            ScatterPlotSimpleDotOptions.this.jComponentsVector.remove(1);
            ScatterPlotSimpleDotOptions.this.jComponentsVector.insertElementAt(matrixImage, 1);
            DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(ScatterPlotSimpleDotOptions.this.jComponentsVector, false);
            ScatterPlotSimpleDotOptions.this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
        }
    }

    private class imageMouseSelectionListener
    extends MouseAdapter {
        private imageMouseSelectionListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            MatrixImage matrixImage = (MatrixImage)mouseEvent.getSource();
            Border border = BorderFactory.createLineBorder(Color.BLACK, 2);
            matrixImage.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(1), border));
            matrixImage.setSelected(true);
            ScatterPlotSimpleDotOptions.this.jComponentsVector.remove(1);
            ScatterPlotSimpleDotOptions.this.jComponentsVector.insertElementAt(matrixImage, 1);
            DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(ScatterPlotSimpleDotOptions.this.jComponentsVector, false);
            ScatterPlotSimpleDotOptions.this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
        }
    }
}

