/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.graphs.legacy_dialogs.scatterdot;

import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.FileTextField;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.base.graphs.TitlesSubDialog;
import com.spss.java_client.ui.dialogs.base.graphs.legacy_dialogs.scatterdot.ScatterPlotSimpleDotOptions;
import com.spss.java_client.ui.dialogs.base.graphs.legacy_dialogs.scatterdot.ScatterPlotUtils;
import com.spss.java_client.ui.dialogs.base.graphs.res.GraphsResBundle;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.uitools.util.CharacterUtil;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class ScatterPlotSimpleDotDlg
extends BaseProcedureDialog
implements ListDataListener,
ItemListener,
ActionListener {
    static final String X_AXIS_VAR_LIST = "IDS_X_AXIS_VAR_LIST";
    static final String TITLES_BUTTON = "IDS_REPORT_COMMON_TITLES_3DOT";
    static final String OPTIONS_BUTTON = "IDS_COMMON_OPTIONS_3DOT";
    static final String CHART_SPEC_CHECK = "IDS_SD_CHART_SPEC_CHECK";
    static final String FILE_BUTTON = "IDS_SD_FILE_3DOT";
    static final String ROWS_LIST_IDENTIFIER = "ROWS_TARGET_LIST";
    static final String COLUMNS_LIST_IDENTIFIER = "COLUMNS_TARGET_LIST";
    private ArrowButton mXAxisListArrow;
    private ArrowButton mRowsArrowButton;
    private ArrowButton mColumnsArrowButton;
    private SrcVariableList mSrcVarList;
    private TargetVariableList mXAxisVarList;
    private TargetVariableList mRowsTargetList;
    private TargetVariableList mColumnTargetList;
    private JScrollPane mSrcScrollPane;
    private JScrollPane mXAxisListScrollPane;
    private JCheckBox mChartSpecCheckBox;
    private JButton mFileButton;
    private JCheckBox mNestVariableColumnsCheckBox;
    private JCheckBox mNestVariableRowsCheckBox;
    private FileTextField mFilePath;
    private JButton mOptionsButton;

    public ScatterPlotSimpleDotDlg(JFrame jFrame) {
        super(jFrame, false, GraphsResBundle.getDefaultResourceBundleName(), GraphsResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_SD_SCATTERPLOT_SIMPLE_DOT_TITLE"));
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public String generateSyntax() {
        String string;
        boolean bl;
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        stringBuffer.append(SyntaxUtil.getMainCommand("XGRAPH"));
        stringBuffer.append(SyntaxUtil.getMainCommandParamters("CHART=[POINT] BY "));
        stringBuffer.append(this.mXAxisVarList.getVariablesStringList()).append("[");
        if (this.mXAxisVarList.getModel().getElementAt(0).getDisplayMeasurementLevel().value() < 3) {
            stringBuffer.append("c");
        } else {
            stringBuffer.append("s");
        }
        stringBuffer.append("]");
        stringBuffer.append(this.getOptionsSyntax());
        stringBuffer.append(ScatterPlotUtils.generatePanelSyntax(this.mRowsTargetList, this.mNestVariableRowsCheckBox.isSelected(), this.mColumnTargetList, this.mNestVariableColumnsCheckBox.isSelected()));
        stringBuffer.append(ScatterPlotUtils.generateTemplateSyntax(this.mChartSpecCheckBox.isSelected(), this.mFilePath.getText().trim(), true));
        String string2 = dialogDataModel.getString("IDS_TITLE_LINE1_EDIT");
        String string3 = dialogDataModel.getString("IDS_TITLE_LINE2_EDIT");
        boolean bl2 = string2 != null && string2.length() > 0;
        boolean bl3 = string3 != null && string3.length() > 0;
        String string4 = dialogDataModel.getString("IDS_FOOTNOTE_LINE1_EDIT");
        String string5 = dialogDataModel.getString("IDS_FOOTNOTE_LINE2_EDIT");
        boolean bl4 = string4 != null && string4.length() > 0;
        boolean bl5 = bl = string5 != null && string5.length() > 0;
        if (bl2 || bl3 || bl4 || bl) {
            stringBuffer.append("\n  /TITLES");
        }
        if (bl2 || bl3) {
            stringBuffer.append(" TITLE=");
            if (bl2) {
                stringBuffer.append(CharacterUtil.smartQuote((String)string2));
            }
            if (bl3) {
                if (!bl2) {
                    stringBuffer.append("' '");
                }
                stringBuffer.append(" ").append(CharacterUtil.smartQuote((String)string3));
            }
        }
        if ((string = dialogDataModel.getString("IDS_SUBTITLE_EDIT")) != null && string.length() > 0) {
            stringBuffer.append(" SUBTITLE=").append(CharacterUtil.smartQuote((String)string));
        }
        if (bl4 || bl) {
            stringBuffer.append(" FOOTNOTE=");
            if (bl4) {
                stringBuffer.append(CharacterUtil.smartQuote((String)string4));
            }
            if (bl) {
                if (!bl4) {
                    stringBuffer.append("' '");
                }
                stringBuffer.append(" ").append(CharacterUtil.smartQuote((String)string5));
            }
        }
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        return stringBuffer.toString();
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idd_scatter_dot";
    }

    @Override
    public String getIActionKey() {
        return "graphs_legacy_dialogs_simple_dot_scatter";
    }

    @Override
    public boolean okPastePressed() {
        return true;
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.enableOkPasteOnControls();
        this.mOptionsButton.setEnabled(this.mXAxisVarList.getModel().getSize() > 0);
        this.mNestVariableRowsCheckBox.setEnabled(this.mRowsTargetList.getModel().getSize() > 1);
        this.mNestVariableColumnsCheckBox.setEnabled(this.mColumnTargetList.getModel().getSize() > 1);
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.enableOkPasteOnControls();
        this.mOptionsButton.setEnabled(this.mXAxisVarList.getModel().getSize() > 0);
        this.mNestVariableRowsCheckBox.setEnabled(this.mRowsTargetList.getModel().getSize() > 1);
        this.mNestVariableColumnsCheckBox.setEnabled(this.mColumnTargetList.getModel().getSize() > 1);
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.enableOkPasteOnControls();
        this.mOptionsButton.setEnabled(this.mXAxisVarList.getModel().getSize() > 0);
        this.mNestVariableRowsCheckBox.setEnabled(this.mRowsTargetList.getModel().getSize() > 1);
        this.mNestVariableColumnsCheckBox.setEnabled(this.mColumnTargetList.getModel().getSize() > 1);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource().equals(this.mChartSpecCheckBox)) {
            this.mFileButton.setEnabled(this.mChartSpecCheckBox.isSelected());
            this.mFilePath.setEnabled(this.mChartSpecCheckBox.isSelected());
            this.enableOkPasteOnControls();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        ScatterPlotUtils.openTemplateFilesDialog(this, (JTextField)((Object)this.mFilePath));
        this.enableOkPasteOnControls();
    }

    @Override
    public void reset() {
        super.reset();
        this.setDefaults();
    }

    public int getTypeOfElementInXAxisList() {
        return this.mXAxisVarList.getModel().getElementAt(0).getMeasurementLevel().value();
    }

    public void paint(Graphics graphics) {
        if (this.mFilePath.getText() != null) {
            this.mFilePath.setText(this.mFilePath.getText());
        }
        super.paint(graphics);
        super.validate();
    }

    @Override
    protected JPanel setupOptionsButtonPanel() {
        JPanel jPanel = super.setupOptionsButtonPanel();
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(TITLES_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScatterPlotSimpleDotDlg.this.runTitlesSubDlg();
            }
        };
        JButton jButton = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, jButton);
        toggleButtonAction = new ToggleButtonAction(OPTIONS_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScatterPlotSimpleDotDlg.this.runOptionsSubDlg();
            }
        };
        this.mOptionsButton = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, this.mOptionsButton);
        return jPanel;
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefaults();
        JPanel jPanel = this.getViewPanel();
        this.addComponentsToPanel(jPanel);
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(this.setTabTraversal(), false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
        this.pack();
    }

    @Override
    protected void loadDialogState() {
        super.loadDialogState();
        this.mSrcVarList.setSelectedIndex(0);
        this.mSrcVarList.requestFocus();
    }

    private void initVars() {
        this.mSrcVarList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcVarList.setLoadFromPersistent(true);
        this.mSrcScrollPane = new JScrollPane(this.mSrcVarList);
        this.mSrcScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        this.mXAxisVarList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mXAxisVarList.addVarFilter(new SpssVarFilter(8, false));
        this.mXAxisVarList.getModel().addListDataListener(this);
        this.mXAxisVarList.setIdentifier(X_AXIS_VAR_LIST);
        this.mXAxisListScrollPane = new JScrollPane(this.mXAxisVarList);
        this.mXAxisListScrollPane.setHorizontalScrollBarPolicy(31);
        this.mXAxisListScrollPane.setVerticalScrollBarPolicy(21);
        this.mXAxisListScrollPane.setPreferredSize(this.mXAxisVarList.getMinimumSize());
        this.mXAxisListArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mXAxisListArrow.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mXAxisListArrow.registerVariableList(this.mXAxisVarList, SpssArrowButton.ButtonOrientation.left);
        this.mRowsTargetList = new TargetVariableList(TargetVariableList.TargetListType.normal);
        this.mRowsTargetList.getModel().addListDataListener(this);
        this.mRowsTargetList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mRowsTargetList.setIdentifier(ROWS_LIST_IDENTIFIER);
        this.mColumnTargetList = new TargetVariableList(TargetVariableList.TargetListType.normal);
        this.mColumnTargetList.getModel().addListDataListener(this);
        this.mColumnTargetList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mColumnTargetList.setIdentifier(COLUMNS_LIST_IDENTIFIER);
        this.mRowsArrowButton = new ArrowButton();
        this.mRowsArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mRowsArrowButton.registerVariableList(this.mRowsTargetList, SpssArrowButton.ButtonOrientation.left);
        this.mColumnsArrowButton = new ArrowButton();
        this.mColumnsArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mColumnsArrowButton.registerVariableList(this.mColumnTargetList, SpssArrowButton.ButtonOrientation.left);
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, "IDS_SD_NEST_VARS_ROWS");
        this.mNestVariableRowsCheckBox = new JCheckBox();
        this.mNestVariableRowsCheckBox.setAction(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_SD_NEST_VARS_COLUMNS");
        this.mNestVariableColumnsCheckBox = new JCheckBox();
        this.mNestVariableColumnsCheckBox.setAction(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, CHART_SPEC_CHECK);
        this.mChartSpecCheckBox = new JCheckBox(toggleButtonAction);
        this.mChartSpecCheckBox.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this, FILE_BUTTON);
        this.mFileButton = new JButton(toggleButtonAction);
        this.mFileButton.addActionListener(this);
        this.mFilePath = new FileTextField();
        this.mFilePath.setAction(new TextFieldAction(this, "IDS_SD_SIMPLE_DOT_TEMPLATE_FILE_TEXT"));
        this.mFilePath.getDocument().addDocumentListener(new fileTextListener());
        this.mFilePath.setEditable(false);
        this.mFilePath.setOpaque(false);
        this.mFilePath.setBorder(BorderFactory.createEmptyBorder());
    }

    private void setDefaults() {
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcVarList.requestFocus();
        this.mXAxisVarList.removeAll();
        this.mRowsTargetList.removeAll();
        this.mColumnTargetList.removeAll();
        this.mFileButton.setEnabled(false);
        this.mFilePath.setEnabled(false);
        this.mFilePath.setText("");
        this.mChartSpecCheckBox.setSelected(false);
        this.mNestVariableRowsCheckBox.setSelected(false);
        this.mNestVariableColumnsCheckBox.setSelected(false);
        this.mNestVariableRowsCheckBox.setEnabled(false);
        this.mNestVariableColumnsCheckBox.setEnabled(false);
        this.enableOkPaste(false);
        this.mOptionsButton.setEnabled(false);
        this.mSrcVarList.setSelectedIndex(0);
    }

    private void addComponentsToPanel(JPanel jPanel) {
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_SD_X_AXIS_VAR_COLON");
        jLabel.setLabelFor(this.mXAxisVarList);
        JComponent[] jComponentArray = new JComponent[]{this.mChartSpecCheckBox, this.mFileButton, this.mFilePath};
        JPanel jPanel2 = PanelFactory.getGraphsChartTemplatePanel(jComponentArray, this.getResString("IDS_SD_TEMPLATE"));
        JPanel jPanel3 = this.setupPanelBy();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        int n = 23;
        gridBagConstraints.fill = 2;
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_SD_SCATTERPLOT_SIMPLE_DOT_SOURCE_LABEL");
        jLabel2.setLabelFor(this.mSrcVarList);
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        Insets insets = DialogUtil.getArrowButtonInsets();
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets2 = new Insets(0, insets.left + n2 + 3, 0, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mSrcScrollPane, gridBagConstraints, 0, 1, 1, 2, n, null);
        n = 20;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mXAxisListArrow, gridBagConstraints, 1, 0, 1, 2, n, insets2);
        Insets insets3 = new Insets(0, 3, 0, 0);
        Insets insets4 = new Insets(0, 3, 0, n2 + 4);
        gridBagConstraints.weightx = 1.0;
        n = 23;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 2, 0, 1, 1, n, insets3);
        DialogUtil.addUsingGBL(jPanel, this.mXAxisListScrollPane, gridBagConstraints, 2, 1, 1, 1, n, insets4);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        n = 23;
        gridBagConstraints.fill = 1;
        insets2.set(DialogUtil.getComponentGroupGap(), DialogUtil.getComponentGroupGap(), 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 1, 2, 2, 1, n, insets2);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        insets2.set(DialogUtil.getComponentGroupGap(), 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 3, 3, 1, n, insets2);
    }

    private JPanel setupPanelBy() {
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_SD_ROWS_COLON");
        jLabel.setLabelFor(this.mRowsTargetList);
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_SD_COLUMNS_COLON");
        jLabel2.setLabelFor(this.mColumnTargetList);
        JComponent[] jComponentArray = new JComponent[]{jLabel, this.mRowsArrowButton, this.mRowsTargetList, this.mNestVariableRowsCheckBox, jLabel2, this.mColumnsArrowButton, this.mColumnTargetList, this.mNestVariableColumnsCheckBox};
        return PanelFactory.getGraphsPanelByPanel(jComponentArray, this.getResString("IDS_SD_PANEL_BY_TITLE"));
    }

    private Vector<Object> setTabTraversal() {
        int n;
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcVarList);
        vector.add(this.mXAxisListArrow);
        vector.add(this.mRowsArrowButton);
        vector.add(this.mColumnsArrowButton);
        vector.add(this.mXAxisVarList);
        vector.add(this.mRowsTargetList);
        vector.add(this.mNestVariableRowsCheckBox);
        vector.add(this.mColumnTargetList);
        vector.add(this.mNestVariableColumnsCheckBox);
        vector.add(this.mChartSpecCheckBox);
        vector.add(this.mFileButton);
        int n2 = this.mOptionButtonPanel.getComponentCount();
        for (n = 0; n < n2; ++n) {
            Component component = this.mOptionButtonPanel.getComponent(n);
            if (!(component instanceof JButton)) continue;
            vector.add(this.mOptionButtonPanel.getComponent(n));
        }
        n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        return vector;
    }

    private void runTitlesSubDlg() {
        this.runSubDialog(new TitlesSubDialog(this));
    }

    private void runOptionsSubDlg() {
        this.runSubDialog(new ScatterPlotSimpleDotOptions(this, this.getResString("IDS_SD_SCATTERPLOT_SIMPLE_DOT_OPTIONS_TITLE"), true));
    }

    private void enableOkPasteOnControls() {
        if (this.mXAxisVarList.getModel().getSize() > 0) {
            if (!this.mChartSpecCheckBox.isSelected()) {
                this.enableOkPaste(true);
            } else if (this.mChartSpecCheckBox.isSelected() && this.mFilePath.getText().trim().length() > 0) {
                this.enableOkPaste(true);
            } else {
                this.enableOkPaste(false);
            }
        } else {
            this.enableOkPaste(false);
        }
    }

    private String getOptionsSyntax() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n").append(SyntaxUtil.getSubCommand("/DISPLAY DOT="));
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        Integer n = dialogDataModel.getInteger("IDS_SCATTER_PLOT_SIMPLE_DOT_OPTIONS_SELECTED_IMAGE");
        if (n == null || n == 0) {
            stringBuffer.append("ASYMMETRIC");
        } else if (n == 1) {
            stringBuffer.append("SYMMETRIC");
        } else if (n == 2) {
            stringBuffer.append("FLAT");
        }
        if (this.mXAxisVarList.getModel().getElementAt(0).getMeasurementLevel().value() < 3) {
            stringBuffer.append("\n").append(SyntaxUtil.getSubCommand("/MISSING REPORT="));
            Boolean bl = dialogDataModel.getBoolean("IDS_OPT_SUBDLG_FOR_SIMPLE_DOT_DISPLAY_GROUPS_CHECK");
            if (bl == null || !bl.booleanValue()) {
                stringBuffer.append("NO");
            } else {
                stringBuffer.append("YES");
            }
        }
        return stringBuffer.toString();
    }

    class fileTextListener
    implements DocumentListener {
        fileTextListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            ScatterPlotSimpleDotDlg.this.enableOkPasteOnControls();
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            ScatterPlotSimpleDotDlg.this.enableOkPasteOnControls();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            ScatterPlotSimpleDotDlg.this.enableOkPasteOnControls();
        }
    }
}

