/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.graphs.legacy_dialogs.scatterdot;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.ComponentsArrowButton;
import com.spss.java_client.ui.controls.FileTextField;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.PlainTable;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.controls.drag_drop.PairedVariablesDragAdapter;
import com.spss.java_client.ui.controls.drag_drop.PairedVariablesDropListener;
import com.spss.java_client.ui.dialogs.adv_stats.rep_measures.ListTraversalArrowButton;
import com.spss.java_client.ui.dialogs.base.graphs.GraphsUtil;
import com.spss.java_client.ui.dialogs.base.graphs.OptionsSubDialog;
import com.spss.java_client.ui.dialogs.base.graphs.TitlesSubDialog;
import com.spss.java_client.ui.dialogs.base.graphs.legacy_dialogs.scatterdot.ScatterPlotUtils;
import com.spss.java_client.ui.dialogs.base.graphs.res.GraphsResBundle;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.IVarMoveHandler;
import com.spss.java_client.ui.dialogs.common.PairedVariableUtility;
import com.spss.java_client.ui.dialogs.common.PairedVariablesTable;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SwapTableContentListener;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.uitools.controls.drag_drop.DragPane;
import com.spss.uitools.controls.drag_drop.IDropListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class ScatterPlotOverlayDlg
extends BaseProcedureDialog
implements ListDataListener,
ActionListener,
FocusListener,
IVarMoveHandler {
    static final String MATRIX_VAR_LIST = "IDS_MATRIX_VAR_LIST";
    static final String LABEL_CASES_VAR_LIST = "IDS_LABEL_CASES_VAR_LIST";
    static final String SWAP_PAIR_BUTTON = "IDS_SD_SWAP_PAIR";
    static final String VARIABLE1_LABEL = "IDS_SD_VARIABLE_1";
    static final String VARIABLE2_LABEL = "IDS_SD_VARIABLE_2";
    static final String TITLES_BUTTON = "IDS_REPORT_COMMON_TITLES_3DOT";
    static final String OPTIONS_BUTTON = "IDS_COMMON_OPTIONS_3DOT";
    static final String CHART_SPEC_CHECK = "IDS_SD_CHART_SPEC_CHECK";
    static final String FILE_BUTTON = "IDS_SD_FILE";
    static final String ROWS_LIST_IDENTIFIER = "ROWS_TARGET_LIST";
    static final String COLUMNS_LIST_IDENTIFIER = "COLUMNS_TARGET_LIST";
    public static final String FILE_PATH = "IDS_FILE_PATH";
    private ComponentsArrowButton mYXPairsListArrow;
    private ArrowButton mLabelCasesListArrow;
    private ArrowButton mRowsArrowButton;
    private ArrowButton mColumnsArrowButton;
    private SrcVariableList mSrcVarList;
    private TargetVariableList mLabelCasesVarList;
    private TargetVariableList mRowsTargetList;
    private TargetVariableList mColumnTargetList;
    private JLabel mLabelCasesVarListLabel;
    private JScrollPane mSrcScrollPane;
    private JScrollPane mYXPairsListScrollPane;
    private JScrollPane mLabelCasesListScrollPane;
    private JCheckBox mNestVariableColumnsCheckBox;
    private JCheckBox mNestVariableRowsCheckBox;
    private PairedVariablesTable mPairedTable;
    private JButton mSwapButton;
    private ListTraversalArrowButton mUpDownButtons;
    private JPanel mPanel;
    private JCheckBox mUseChartSpecCheckBox;
    private JButton mFileButton;
    private FileTextField mFilePath;
    private Border mBlueBorder = BorderFactory.createLineBorder(Color.BLUE);
    private Border mDefaultScrollPaneBorder;

    public ScatterPlotOverlayDlg(JFrame jFrame) {
        super(jFrame, false, GraphsResBundle.getDefaultResourceBundleName(), GraphsResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_SD_SCATTERPLOT_OVERLAY_TITLE"));
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.enableOkPasteButtons();
        this.mNestVariableRowsCheckBox.setEnabled(this.mRowsTargetList.getModel().getSize() > 0);
        this.mNestVariableColumnsCheckBox.setEnabled(this.mColumnTargetList.getModel().getSize() > 0);
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.enableOkPasteButtons();
        this.mNestVariableRowsCheckBox.setEnabled(this.mRowsTargetList.getModel().getSize() > 0);
        this.mNestVariableColumnsCheckBox.setEnabled(this.mColumnTargetList.getModel().getSize() > 0);
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.enableOkPasteButtons();
        this.mNestVariableRowsCheckBox.setEnabled(this.mRowsTargetList.getModel().getSize() > 0);
        this.mNestVariableColumnsCheckBox.setEnabled(this.mColumnTargetList.getModel().getSize() > 0);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.mYXPairsListArrow)) {
            if (SpssArrowButton.ButtonOrientation.right != ((ComponentsArrowButton)actionEvent.getSource()).getArrowOrientation()) {
                PairedVariableUtility.removeElementFromTable(this.mPairedTable, this.mSrcVarList);
                this.mUpDownButtons.resetArrowButtons();
                this.mSwapButton.setEnabled(false);
            } else {
                PairedVariableUtility.addElementToTable(this.mPairedTable, this.mSrcVarList);
            }
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource().equals(this.mSrcVarList)) {
            this.mYXPairsListArrow.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
            this.mPairedTable.setSelectionBackground(Color.lightGray);
            this.mYXPairsListArrow.setEnabled(true);
            this.enableOkPasteButtons();
        } else if (focusEvent.getSource() instanceof PlainTable) {
            this.mYXPairsListScrollPane.setBorder(this.mBlueBorder);
            this.enableOkPasteButtons();
            this.enableSwapButton();
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        Object object = focusEvent.getSource();
        if (object instanceof PlainTable) {
            this.mYXPairsListScrollPane.setBorder(this.mDefaultScrollPaneBorder);
        }
    }

    @Override
    public void reset() {
        super.reset();
        PairedVariableUtility.resetTable(this.mPairedTable);
        this.getDialogDataModel().putSerializableArray("PAIRED_TTEST_TARGET_LIST", null);
        this.setDefaults();
        this.mSwapButton.setEnabled(false);
        this.mUpDownButtons.resetArrowButtons();
    }

    @Override
    public String generateSyntax() {
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        stringBuffer.append(SyntaxUtil.getCommand("GRAPH"));
        stringBuffer.append(SyntaxUtil.getSubCommand("/SCATTERPLOT(OVERLAY)="));
        stringBuffer.append(PairedVariableUtility.getSyntaxString(this.mPairedTable, false));
        stringBuffer.append(ScatterPlotUtils.generateMarkersLabelCasesSyntax(dialogDataModel, null, this.mLabelCasesVarList));
        stringBuffer.append(ScatterPlotUtils.generatePanelSyntax(this.mRowsTargetList, this.mNestVariableRowsCheckBox.isSelected(), this.mColumnTargetList, this.mNestVariableColumnsCheckBox.isSelected()));
        stringBuffer.append(ScatterPlotUtils.generateOptionsSyntax(dialogDataModel));
        stringBuffer.append(GraphsUtil.generateTitlesSubDialogSyntax(dialogDataModel));
        String string = this.getFilePath();
        if (this.mUseChartSpecCheckBox.isSelected() && string != null) {
            stringBuffer.append(ScatterPlotUtils.generateTemplateSyntax(true, string));
        }
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        return stringBuffer.toString();
    }

    private String getFilePath() {
        return this.mFilePath.getText() != null && this.mFilePath.getText().length() > 0 ? this.mFilePath.getText() : null;
    }

    @Override
    public String getDialogHelpID() {
        return "idh_gsov";
    }

    @Override
    public String getIActionKey() {
        return "graphs_legacy_dialogs_overlay_scatter";
    }

    @Override
    public boolean okPastePressed() {
        if (PairedVariableUtility.isDuplicatePairAvailable(this.mPairedTable)) {
            return false;
        }
        return super.okPastePressed();
    }

    @Override
    public boolean preMoveVariables(ISpssVariable[] iSpssVariableArray, VariableList variableList) {
        if (!(variableList instanceof SrcVariableList) && iSpssVariableArray.length > 0) {
            for (ISpssVariable iSpssVariable : iSpssVariableArray) {
                if (this.mLabelCasesVarList.getModel().getSize() <= 0 || !this.mLabelCasesVarList.getModel().getElementAt(0).getName().equals(iSpssVariable.getName())) continue;
                SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this), ResUtil.getCommonDlgString("ERR_CANNOT_ACCEPT_VARS_PRESENT_IN_OTHER_TARGET_LIST"), VersionInfo.getAppVersionString());
                return false;
            }
        }
        return true;
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        super.validate();
    }

    @Override
    public void pack() {
        super.pack();
        if (this.getGlassPane() instanceof DragPane) {
            this.addDragAdapters((DragPane)this.getGlassPane(), (Component)((Object)this), this.mVarMoveHandler);
        }
    }

    @Override
    protected void saveDialogState() {
        super.saveDialogState();
        PairedVariableUtility.saveTableData(this.getDialogDataModel(), this.mPairedTable);
    }

    @Override
    protected void validateSerializableLists() {
        this.enableOkPasteButtons();
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefaults();
        JPanel jPanel = this.getViewPanel();
        this.setupViewPanel(jPanel);
        this.setFocusTraversalPolicy();
        this.pack();
    }

    @Override
    protected void loadDialogState() {
        super.loadDialogState();
        PairedVariableUtility.loadTableData(this.getDialogDataModel(), this.mPairedTable);
        this.validateSerializableLists();
        this.mSrcVarList.setSelectedIndex(0);
        this.mSrcVarList.requestFocus();
        this.enableTemplateControls(this.mUseChartSpecCheckBox.isSelected());
    }

    protected void initVars() {
        ActionListener[] actionListenerArray;
        this.mSrcVarList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcVarList.addFocusListener(this);
        this.mSrcScrollPane = new JScrollPane(this.mSrcVarList);
        this.mSrcScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.getResString("IDS_SD_Y_X_TABLE_COL1"));
        arrayList.add(this.getResString("IDS_SD_Y_X_TABLE_COL2"));
        arrayList.add(this.getResString("IDS_SD_Y_X_TABLE_COL3"));
        this.mPairedTable = new PairedVariablesTable(this.mSrcVarList, arrayList);
        this.mPairedTable.addFocusListener(this);
        this.mYXPairsListScrollPane = new JScrollPane(this.mPairedTable);
        this.mDefaultScrollPaneBorder = this.mYXPairsListScrollPane.getBorder();
        Dimension dimension = this.mPairedTable.getPreferredSize();
        this.mYXPairsListScrollPane.setPreferredSize(new Dimension(dimension.width, 103));
        this.mLabelCasesVarListLabel = DialogUtil.createLabel(this, "IDS_SD_LABEL_CASES_BY");
        this.mLabelCasesVarList = new TargetVariableList(TargetVariableList.TargetListType.single_item, VariableList.VarMoveType.eKeepOriginal);
        this.mLabelCasesVarList.setIdentifier(LABEL_CASES_VAR_LIST);
        this.mLabelCasesVarListLabel.setLabelFor(this.mLabelCasesVarList);
        this.mLabelCasesListScrollPane = new JScrollPane(this.mLabelCasesVarList);
        this.mLabelCasesListScrollPane.setHorizontalScrollBarPolicy(31);
        this.mLabelCasesListScrollPane.setVerticalScrollBarPolicy(21);
        this.mLabelCasesListScrollPane.setPreferredSize(this.mLabelCasesVarList.getMinimumSize());
        this.mYXPairsListArrow = new ComponentsArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mYXPairsListArrow.registerComponents(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mYXPairsListArrow.registerComponents(this.mPairedTable, SpssArrowButton.ButtonOrientation.left);
        for (ActionListener actionListener : actionListenerArray = this.mYXPairsListArrow.getActionListeners()) {
            this.mYXPairsListArrow.removeActionListener(actionListener);
        }
        this.mYXPairsListArrow.addActionListener(this);
        this.mLabelCasesListArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mLabelCasesListArrow.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mLabelCasesListArrow.registerVariableList(this.mLabelCasesVarList, SpssArrowButton.ButtonOrientation.left);
        this.mRowsTargetList = new TargetVariableList(TargetVariableList.TargetListType.normal);
        this.mRowsTargetList.getModel().addListDataListener(this);
        this.mRowsTargetList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mRowsTargetList.getModel().addListDataListener(this);
        this.mRowsTargetList.setIdentifier(ROWS_LIST_IDENTIFIER);
        this.mColumnTargetList = new TargetVariableList(TargetVariableList.TargetListType.normal);
        this.mColumnTargetList.getModel().addListDataListener(this);
        this.mColumnTargetList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mColumnTargetList.getModel().addListDataListener(this);
        this.mColumnTargetList.setIdentifier(COLUMNS_LIST_IDENTIFIER);
        this.mRowsArrowButton = new ArrowButton();
        this.mRowsArrowButton.setVarMoveHandler(this);
        this.mRowsArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mRowsArrowButton.registerVariableList(this.mRowsTargetList, SpssArrowButton.ButtonOrientation.left);
        this.mColumnsArrowButton = new ArrowButton();
        this.mColumnsArrowButton.setVarMoveHandler(this);
        this.mColumnsArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mColumnsArrowButton.registerVariableList(this.mColumnTargetList, SpssArrowButton.ButtonOrientation.left);
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, "IDS_SD_NEST_VARS_ROWS");
        this.mNestVariableRowsCheckBox = new JCheckBox();
        this.mNestVariableRowsCheckBox.setAction(toggleButtonAction);
        ToggleButtonAction toggleButtonAction2 = new ToggleButtonAction(this, "IDS_SD_NEST_VARS_COLUMNS");
        this.mNestVariableColumnsCheckBox = new JCheckBox();
        this.mNestVariableColumnsCheckBox.setAction(toggleButtonAction2);
        this.mSwapButton = new JButton();
        String string = ResUtil.getCommonDlgString("IDS_PAIR_VARIABLE_SWAP_BUTTON_IMAGE");
        URL uRL = ResUtil.getCommonDlgImageResource(string);
        this.mSwapButton.setIcon(new ImageIcon(uRL));
        this.mSwapButton.addActionListener(new SwapTableContentListener(this.mPairedTable, this.mSwapButton));
        this.mUpDownButtons = new ListTraversalArrowButton(this.mPairedTable, false, this.mSrcVarList.getSelectionBackground());
        this.mSwapButton.setEnabled(false);
        this.mPanel = this.mUpDownButtons.setupArrowButtonPanel();
        this.createTemplateGroupControls();
    }

    @Override
    protected JPanel setupOptionsButtonPanel() {
        JPanel jPanel = super.setupOptionsButtonPanel();
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(TITLES_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScatterPlotOverlayDlg.this.runTitlesSubDlg();
            }
        };
        JButton jButton = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, jButton);
        toggleButtonAction = new ToggleButtonAction(OPTIONS_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScatterPlotOverlayDlg.this.runOptionsSubDlg();
            }
        };
        JButton jButton2 = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, jButton2);
        return jPanel;
    }

    protected void setDefaults() {
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcVarList.setSelectedIndex(0);
        this.mSrcVarList.requestFocus();
        this.mLabelCasesVarList.removeAll();
        this.mRowsTargetList.removeAll();
        this.mColumnTargetList.removeAll();
        this.mNestVariableRowsCheckBox.setSelected(false);
        this.mNestVariableColumnsCheckBox.setSelected(false);
        this.mNestVariableRowsCheckBox.setEnabled(false);
        this.mNestVariableColumnsCheckBox.setEnabled(false);
        this.mFileButton.setEnabled(false);
        this.mFilePath.setEnabled(false);
        this.mFilePath.setText("");
        this.mUseChartSpecCheckBox.setSelected(false);
        this.enableOkPaste(false);
    }

    private void addDragAdapters(DragPane dragPane, Component component, IVarMoveHandler iVarMoveHandler) {
        if (component instanceof PlainTable) {
            PairedVariablesDragAdapter pairedVariablesDragAdapter = new PairedVariablesDragAdapter(this.mPairedTable, dragPane, "PlainTable");
            DialogUtil.modifyMouseInputListeners(this.mPairedTable, pairedVariablesDragAdapter);
            dragPane.addDropListener((IDropListener)new PairedVariablesDropListener(this.mPairedTable, iVarMoveHandler, this.mSrcVarList));
        } else if (component instanceof Container) {
            Container container = (Container)component;
            for (Component component2 : container.getComponents()) {
                this.addDragAdapters(dragPane, component2, iVarMoveHandler);
            }
        }
    }

    private void setFocusTraversalPolicy() {
        int n;
        int n2;
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcVarList);
        vector.add(this.mYXPairsListArrow);
        vector.add(this.mPairedTable);
        for (n2 = 0; n2 < this.mPanel.getComponentCount(); ++n2) {
            vector.add(this.mPanel.getComponent(n2));
        }
        vector.add(this.mSwapButton);
        vector.add(this.mLabelCasesListArrow);
        vector.add(this.mLabelCasesVarList);
        vector.add(this.mRowsArrowButton);
        vector.add(this.mRowsTargetList);
        vector.add(this.mNestVariableRowsCheckBox);
        vector.add(this.mColumnsArrowButton);
        vector.add(this.mColumnTargetList);
        vector.add(this.mNestVariableColumnsCheckBox);
        vector.add(this.mUseChartSpecCheckBox);
        vector.add(this.mFileButton);
        n2 = this.mOptionButtonPanel.getComponentCount();
        for (n = 0; n < n2; ++n) {
            Component component = this.mOptionButtonPanel.getComponent(n);
            if (!(component instanceof JButton)) continue;
            vector.add(this.mOptionButtonPanel.getComponent(n));
        }
        n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private void setupViewPanel(JPanel jPanel) {
        JPanel jPanel2 = this.setupSourcePanel();
        JPanel jPanel3 = this.setupLabelCasesByPanel();
        JPanel jPanel4 = this.setupPanelBy();
        JPanel jPanel5 = this.setupTableArrowButtonPanel();
        JPanel jPanel6 = this.setupTemplatePanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        int n3 = DialogUtil.getComponentGroupGap();
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        Insets insets = new Insets(n2, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 3, n, insets);
        DialogUtil.addUsingGBL(jPanel, jPanel5, gridBagConstraints, 1, 0, 1, 1, n, null);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        insets.set(n3, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 1, 1, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        insets.set(n3, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel4, gridBagConstraints, 1, 2, 1, 1, n, insets);
        insets.set(n3, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel6, gridBagConstraints, 0, 3, 2, 1, n, insets);
    }

    private void enableOkPasteButtons() {
        boolean bl;
        String string = this.getFilePath();
        boolean bl2 = bl = this.mPairedTable.getRowCount() != 1 && (!this.mUseChartSpecCheckBox.isSelected() || string != null);
        if (bl) {
            bl = PairedVariableUtility.isBlankCellAvailable(this.mPairedTable);
        }
        this.enableOkPaste(bl);
    }

    private void enableSwapButton() {
        boolean bl = true;
        int[] nArray = this.mPairedTable.getSelectedRows();
        if (nArray != null && nArray.length > 0) {
            for (int i = nArray.length - 1; i >= 0; --i) {
                if (!this.mPairedTable.getValueAt(nArray[i], 1).equals("") || !this.mPairedTable.getValueAt(nArray[i], 2).equals("")) continue;
                bl = false;
                break;
            }
        } else {
            bl = false;
        }
        this.mSwapButton.setEnabled(bl);
    }

    private JPanel setupSourcePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        int n = 23;
        gridBagConstraints.fill = 2;
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_SD_SCATTERPLOT_OVERLAY_SOURCE_LABEL");
        jLabel.setLabelFor(this.mSrcVarList);
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(n2, n2, 0, n2);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        insets.set(0, n2, n2, n2);
        DialogUtil.addUsingGBL(jPanel, this.mSrcScrollPane, gridBagConstraints, 0, 1, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setupLabelCasesByPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = DialogUtil.getArrowButtonInsets();
        Insets insets2 = new Insets(0, n2 + n2, 0, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mLabelCasesListArrow, gridBagConstraints, 0, 0, 1, 2, 10, insets2);
        insets2.set(0, 3, 0, n2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mLabelCasesVarListLabel, gridBagConstraints, 1, 0, 1, 1, n, insets2);
        insets2.set(0, 3, n2, n2 + 4);
        DialogUtil.addUsingGBL(jPanel, this.mLabelCasesListScrollPane, gridBagConstraints, 1, 1, 1, 1, n, insets2);
        return jPanel;
    }

    private JPanel setupTemplatePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_SD_TEMPLATE")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 18;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(0, n2, 0, n2);
        DialogUtil.addUsingGBL(jPanel, this.mUseChartSpecCheckBox, gridBagConstraints, 0, 0, 2, 1, n, insets);
        insets = new Insets(0, n2 + 20, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mFileButton, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        insets = new Insets(0, DialogUtil.getComponentGroupGap(), n2, n2);
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mFilePath), gridBagConstraints, 1, 1, 1, 1, n, insets);
        return jPanel;
    }

    private void createTemplateGroupControls() {
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, "IDS_SD_USE_SPEC_FROM");
        this.mUseChartSpecCheckBox = new JCheckBox();
        this.mUseChartSpecCheckBox.setAction(toggleButtonAction);
        this.mUseChartSpecCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScatterPlotOverlayDlg.this.enableTemplateControls(ScatterPlotOverlayDlg.this.mUseChartSpecCheckBox.isSelected());
                ScatterPlotOverlayDlg.this.enableOkPasteButtons();
            }
        });
        toggleButtonAction = new ToggleButtonAction(this, FILE_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                this.showGraphsTemplateFileChooser();
                ScatterPlotOverlayDlg.this.enableOkPasteButtons();
            }

            private void showGraphsTemplateFileChooser() {
                ScatterPlotUtils.openTemplateFilesDialog(ScatterPlotOverlayDlg.this, (JTextField)((Object)ScatterPlotOverlayDlg.this.mFilePath));
            }
        };
        this.mFileButton = new JButton(toggleButtonAction);
        this.mFileButton.setEnabled(false);
        this.mFilePath = new FileTextField();
        this.mFilePath.setAction(new TextFieldAction(this, FILE_PATH));
        this.mFilePath.setOpaque(false);
        this.mFilePath.setEditable(false);
        this.mFilePath.setColumns(20);
        this.mFilePath.setEnabled(false);
        this.mFilePath.setFocusTraversalKeysEnabled(false);
        this.mFilePath.setBorder(BorderFactory.createEmptyBorder());
        this.mFilePath.setText("");
    }

    private void enableTemplateControls(boolean bl) {
        this.mFileButton.setEnabled(bl);
        this.mFilePath.setEnabled(bl);
    }

    private JPanel setupTableArrowButtonPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_SD_Y_X_PAIRS_PANEL")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = DialogUtil.getArrowButtonInsets();
        Insets insets2 = new Insets(0, n2, 0, n2);
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_SD_Y_X_PAIRS");
        jLabel.setLabelFor(this.mPairedTable);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 1, 0, 1, 1, n, insets2);
        insets2.set(0, n2, 0, insets.right);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        n = 10;
        DialogUtil.addUsingGBL(jPanel, this.mYXPairsListArrow, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        insets2.set(0, 3, n2, n2);
        DialogUtil.addUsingGBL(jPanel, this.mYXPairsListScrollPane, gridBagConstraints, 1, 1, 2, 1, n, insets2);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        insets2.set(0, n2, 0, n2);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel2, this.mPanel, gridBagConstraints, 0, 0, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel2, this.mSwapButton, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        insets2.set(0, 0, n2, n2);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 3, 1, 1, 1, n, insets2);
        return jPanel;
    }

    private JPanel setupPanelBy() {
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_SD_ROWS_COLON");
        jLabel.setLabelFor(this.mRowsTargetList);
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_SD_COLUMNS_COLON");
        jLabel2.setLabelFor(this.mColumnTargetList);
        JComponent[] jComponentArray = new JComponent[]{jLabel, this.mRowsArrowButton, this.mRowsTargetList, this.mNestVariableRowsCheckBox, jLabel2, this.mColumnsArrowButton, this.mColumnTargetList, this.mNestVariableColumnsCheckBox};
        return PanelFactory.getGraphsPanelByPanel(jComponentArray, this.getResString("IDS_SD_PANEL_BY_TITLE"));
    }

    private void runTitlesSubDlg() {
        this.runSubDialog(new TitlesSubDialog(this));
    }

    private void runOptionsSubDlg() {
        if (this.mLabelCasesVarList.getModel().getSize() > 0) {
            this.runSubDialog(new OptionsSubDialog(this, 3077));
        } else {
            this.runSubDialog(new OptionsSubDialog(this, 3073));
        }
    }
}

