/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.graphs.legacy_dialogs.scatterdot;

import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.FileTextField;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.base.graphs.GraphsUtil;
import com.spss.java_client.ui.dialogs.base.graphs.OptionsSubDialog;
import com.spss.java_client.ui.dialogs.base.graphs.TitlesSubDialog;
import com.spss.java_client.ui.dialogs.base.graphs.legacy_dialogs.scatterdot.ScatterPlotUtils;
import com.spss.java_client.ui.dialogs.base.graphs.res.GraphsResBundle;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class ScatterPlotMatrixDlg
extends BaseProcedureDialog
implements ListDataListener,
ItemListener,
ActionListener {
    static final String MATRIX_VAR_LIST = "IDS_MATRIX_VAR_LIST";
    static final String SET_MARKERS_VAR_LIST = "IDS_SET_MARKERS_VAR_LIST";
    static final String MARKERS_VAR_LIST = "IDS_MARKERS_VAR_LIST";
    static final String LABEL_CASES_VAR_LIST = "IDS_LABEL_CASES_VAR_LIST";
    static final String TITLES_BUTTON = "IDS_REPORT_COMMON_TITLES_3DOT";
    static final String OPTIONS_BUTTON = "IDS_COMMON_OPTIONS_3DOT";
    static final String CHART_SPEC_CHECK = "IDS_SD_CHART_SPEC_CHECK";
    static final String FILE_BUTTON = "IDS_SD_FILE_3DOT";
    static final String ROWS_LIST_IDENTIFIER = "ROWS_TARGET_LIST";
    static final String COLUMNS_LIST_IDENTIFIER = "COLUMNS_TARGET_LIST";
    private ArrowButton mMatrixListArrow;
    private ArrowButton mSetMarkersListArrow;
    private ArrowButton mLabelCasesListArrow;
    private ArrowButton mRowsArrowButton;
    private ArrowButton mColumnsArrowButton;
    private SrcVariableList mSrcVarList;
    private TargetVariableList mMatrixVarList;
    private TargetVariableList mSetMarkersVarList;
    private TargetVariableList mLabelCasesVarList;
    private TargetVariableList mRowsTargetList;
    private TargetVariableList mColumnTargetList;
    private JLabel mSetMarkersVarListLabel;
    private JLabel mLabelCasesVarListLabel;
    private JScrollPane mSrcScrollPane;
    private JScrollPane mMatrixListScrollPane;
    private JScrollPane mSetMarkersListScrollPane;
    private JScrollPane mLabelCasesListScrollPane;
    private JCheckBox mChartSpecCheckBox;
    private JCheckBox mNestVariableColumnsCheckBox;
    private JCheckBox mNestVariableRowsCheckBox;
    private JButton mFileButton;
    private FileTextField mFilePath;

    public ScatterPlotMatrixDlg(JFrame jFrame) {
        super(jFrame, false, GraphsResBundle.getDefaultResourceBundleName(), GraphsResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_SD_SCATTERPLOT_MATRIX_TITLE"));
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.enableOkPasteOnControls();
        this.mNestVariableRowsCheckBox.setEnabled(this.mRowsTargetList.getModel().getSize() > 0);
        this.mNestVariableColumnsCheckBox.setEnabled(this.mColumnTargetList.getModel().getSize() > 0);
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.enableOkPasteOnControls();
        this.mNestVariableRowsCheckBox.setEnabled(this.mRowsTargetList.getModel().getSize() > 0);
        this.mNestVariableColumnsCheckBox.setEnabled(this.mColumnTargetList.getModel().getSize() > 0);
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.enableOkPasteOnControls();
        this.mNestVariableRowsCheckBox.setEnabled(this.mRowsTargetList.getModel().getSize() > 0);
        this.mNestVariableColumnsCheckBox.setEnabled(this.mColumnTargetList.getModel().getSize() > 0);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource().equals(this.mChartSpecCheckBox)) {
            this.mFileButton.setEnabled(this.mChartSpecCheckBox.isSelected());
            this.mFilePath.setEnabled(this.mChartSpecCheckBox.isSelected());
            this.enableOkPasteOnControls();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        ScatterPlotUtils.openTemplateFilesDialog(this, (JTextField)((Object)this.mFilePath));
        this.enableOkPasteOnControls();
    }

    @Override
    public void reset() {
        super.reset();
        this.setDefaults();
    }

    @Override
    public String generateSyntax() {
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        stringBuffer.append(SyntaxUtil.getCommand("GRAPH"));
        stringBuffer.append(SyntaxUtil.getSubCommand("/SCATTERPLOT(MATRIX)=") + this.mMatrixVarList.getVariablesStringList());
        stringBuffer.append(ScatterPlotUtils.generateMarkersLabelCasesSyntax(dialogDataModel, this.mSetMarkersVarList, this.mLabelCasesVarList));
        stringBuffer.append(ScatterPlotUtils.generatePanelSyntax(this.mRowsTargetList, this.mNestVariableRowsCheckBox.isSelected(), this.mColumnTargetList, this.mNestVariableColumnsCheckBox.isSelected()));
        stringBuffer.append(ScatterPlotUtils.generateOptionsSyntax(dialogDataModel));
        stringBuffer.append(ScatterPlotUtils.generateTemplateSyntax(this.mChartSpecCheckBox.isSelected(), this.mFilePath.getText()));
        stringBuffer.append(GraphsUtil.generateTitlesSubDialogSyntax(dialogDataModel));
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        return stringBuffer.toString();
    }

    @Override
    public String getDialogHelpID() {
        return "idh_gsma";
    }

    @Override
    public String getIActionKey() {
        return "graphs_legacy_dialogs_matrix_scatter";
    }

    @Override
    public boolean okPastePressed() {
        return true;
    }

    public void paint(Graphics graphics) {
        if (this.mFilePath.getText() != null) {
            this.mFilePath.setText(this.mFilePath.getText());
        }
        super.paint(graphics);
        super.validate();
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefaults();
        JPanel jPanel = this.getViewPanel();
        this.setupViewPanel(jPanel);
        this.setFocusTraversalPolicy();
        this.pack();
    }

    @Override
    protected void loadDialogState() {
        super.loadDialogState();
        this.mSrcVarList.setSelectedIndex(0);
        this.mSrcVarList.requestFocus();
    }

    protected void initVars() {
        this.mSrcVarList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcScrollPane = new JScrollPane(this.mSrcVarList);
        this.mSrcScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        this.mMatrixVarList = new TargetVariableList();
        this.mMatrixVarList.addVarFilter(new SpssVarFilter(8, false));
        this.mMatrixVarList.addVarFilter(new SpssVarFilter(32, false));
        this.mMatrixVarList.getModel().addListDataListener(this);
        this.mMatrixVarList.setIdentifier(MATRIX_VAR_LIST);
        this.mMatrixListScrollPane = new JScrollPane(this.mMatrixVarList);
        this.mMatrixVarList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mMatrixVarList.getFixedCellHeight() * 4 + 2));
        this.mMatrixListScrollPane.setPreferredSize(this.mMatrixVarList.getMinimumSize());
        this.mSetMarkersVarListLabel = DialogUtil.createLabel(this, "IDS_SD_SET_MARKERS_BY");
        this.mSetMarkersVarList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mSetMarkersVarList.setIdentifier(MARKERS_VAR_LIST);
        this.mSetMarkersVarListLabel.setLabelFor(this.mSetMarkersVarList);
        this.mSetMarkersListScrollPane = new JScrollPane(this.mSetMarkersVarList);
        this.mSetMarkersListScrollPane.setHorizontalScrollBarPolicy(31);
        this.mSetMarkersListScrollPane.setVerticalScrollBarPolicy(21);
        this.mSetMarkersListScrollPane.setPreferredSize(this.mSetMarkersVarList.getMinimumSize());
        this.mLabelCasesVarListLabel = DialogUtil.createLabel(this, "IDS_SD_LABEL_CASES_BY");
        this.mLabelCasesVarList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mLabelCasesVarList.setIdentifier(LABEL_CASES_VAR_LIST);
        this.mLabelCasesVarListLabel.setLabelFor(this.mLabelCasesVarList);
        this.mLabelCasesListScrollPane = new JScrollPane(this.mLabelCasesVarList);
        this.mLabelCasesListScrollPane.setHorizontalScrollBarPolicy(31);
        this.mLabelCasesListScrollPane.setVerticalScrollBarPolicy(21);
        this.mLabelCasesListScrollPane.setPreferredSize(this.mLabelCasesVarList.getMinimumSize());
        this.mMatrixListArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mMatrixListArrow.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mMatrixListArrow.registerVariableList(this.mMatrixVarList, SpssArrowButton.ButtonOrientation.left);
        this.mLabelCasesListArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mLabelCasesListArrow.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mLabelCasesListArrow.registerVariableList(this.mLabelCasesVarList, SpssArrowButton.ButtonOrientation.left);
        this.mSetMarkersListArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mSetMarkersListArrow.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mSetMarkersListArrow.registerVariableList(this.mSetMarkersVarList, SpssArrowButton.ButtonOrientation.left);
        this.mRowsTargetList = new TargetVariableList(TargetVariableList.TargetListType.normal);
        this.mRowsTargetList.getModel().addListDataListener(this);
        this.mRowsTargetList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mRowsTargetList.setIdentifier(ROWS_LIST_IDENTIFIER);
        this.mColumnTargetList = new TargetVariableList(TargetVariableList.TargetListType.normal);
        this.mColumnTargetList.getModel().addListDataListener(this);
        this.mColumnTargetList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mColumnTargetList.setIdentifier(COLUMNS_LIST_IDENTIFIER);
        this.mRowsArrowButton = new ArrowButton();
        this.mRowsArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mRowsArrowButton.registerVariableList(this.mRowsTargetList, SpssArrowButton.ButtonOrientation.left);
        this.mColumnsArrowButton = new ArrowButton();
        this.mColumnsArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mColumnsArrowButton.registerVariableList(this.mColumnTargetList, SpssArrowButton.ButtonOrientation.left);
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, "IDS_SD_NEST_VARS_ROWS");
        this.mNestVariableRowsCheckBox = new JCheckBox();
        this.mNestVariableRowsCheckBox.setAction(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_SD_NEST_VARS_COLUMNS");
        this.mNestVariableColumnsCheckBox = new JCheckBox();
        this.mNestVariableColumnsCheckBox.setAction(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, CHART_SPEC_CHECK);
        this.mChartSpecCheckBox = new JCheckBox(toggleButtonAction);
        this.mChartSpecCheckBox.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this, FILE_BUTTON);
        this.mFileButton = new JButton(toggleButtonAction);
        this.mFileButton.addActionListener(this);
        this.mFilePath = new FileTextField();
        this.mFilePath.setAction(new TextFieldAction(this, "IDS_SD_MATRIX_TEMPLATE_FILE_TEXT"));
        this.mFilePath.getDocument().addDocumentListener(new fileTextListener());
        this.mFilePath.setEditable(false);
        this.mFilePath.setOpaque(false);
        this.mFilePath.setBorder(BorderFactory.createEmptyBorder());
    }

    @Override
    protected JPanel setupOptionsButtonPanel() {
        JPanel jPanel = super.setupOptionsButtonPanel();
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(TITLES_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScatterPlotMatrixDlg.this.runTitlesSubDlg();
            }
        };
        JButton jButton = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, jButton);
        toggleButtonAction = new ToggleButtonAction(OPTIONS_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScatterPlotMatrixDlg.this.runOptionsSubDlg();
            }
        };
        JButton jButton2 = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, jButton2);
        return jPanel;
    }

    protected void setDefaults() {
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcVarList.requestFocus();
        this.mMatrixVarList.removeAll();
        this.mSetMarkersVarList.removeAll();
        this.mLabelCasesVarList.removeAll();
        this.mRowsTargetList.removeAll();
        this.mColumnTargetList.removeAll();
        this.mFileButton.setEnabled(false);
        this.mFilePath.setEnabled(false);
        this.mFilePath.setText("");
        this.mChartSpecCheckBox.setSelected(false);
        this.mNestVariableRowsCheckBox.setSelected(false);
        this.mNestVariableColumnsCheckBox.setSelected(false);
        this.mNestVariableRowsCheckBox.setEnabled(false);
        this.mNestVariableColumnsCheckBox.setEnabled(false);
        this.mSrcVarList.setSelectedIndex(0);
        this.enableOkPaste(false);
    }

    private void setFocusTraversalPolicy() {
        int n;
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcVarList);
        vector.add(this.mMatrixListArrow);
        vector.add(this.mSetMarkersListArrow);
        vector.add(this.mLabelCasesListArrow);
        vector.add(this.mRowsArrowButton);
        vector.add(this.mColumnsArrowButton);
        vector.add(this.mMatrixVarList);
        vector.add(this.mSetMarkersVarList);
        vector.add(this.mLabelCasesVarList);
        vector.add(this.mRowsTargetList);
        vector.add(this.mNestVariableRowsCheckBox);
        vector.add(this.mColumnTargetList);
        vector.add(this.mNestVariableColumnsCheckBox);
        vector.add(this.mChartSpecCheckBox);
        vector.add(this.mFileButton);
        int n2 = this.mOptionButtonPanel.getComponentCount();
        for (n = 0; n < n2; ++n) {
            Component component = this.mOptionButtonPanel.getComponent(n);
            if (!(component instanceof JButton)) continue;
            vector.add(this.mOptionButtonPanel.getComponent(n));
        }
        n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private void setupViewPanel(JPanel jPanel) {
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_SD_MATRIX_VARIABLES");
        jLabel.setLabelFor(this.mMatrixVarList);
        JComponent[] jComponentArray = new JComponent[]{this.mChartSpecCheckBox, this.mFileButton, this.mFilePath};
        JPanel jPanel2 = PanelFactory.getGraphsChartTemplatePanel(jComponentArray, this.getResString("IDS_SD_TEMPLATE"));
        JPanel jPanel3 = this.setupPanelBy();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        int n = 23;
        gridBagConstraints.fill = 2;
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_SD_SCATTERPLOT_MATRIX_SOURCE_LABEL");
        jLabel2.setLabelFor(this.mSrcVarList);
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        Insets insets = DialogUtil.getArrowButtonInsets();
        int n2 = DialogUtil.getComponentGroupGap();
        int n3 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets2 = new Insets(0, insets.left + n3 + 3, 0, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mSrcScrollPane, gridBagConstraints, 0, 1, 1, 7, n, null);
        n = 20;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mMatrixListArrow, gridBagConstraints, 1, 1, 1, 1, n, insets2);
        Insets insets3 = new Insets(0, 3, 0, 0);
        gridBagConstraints.weightx = 1.0;
        n = 23;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 2, 0, 1, 1, n, insets3);
        Insets insets4 = new Insets(0, 3, 0, n3 + 4);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mMatrixListScrollPane, gridBagConstraints, 2, 1, 1, 2, n, insets4);
        n = 20;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mSetMarkersListArrow, gridBagConstraints, 1, 3, 1, 2, n, insets2);
        insets3.set(n2, 3, 0, 0);
        gridBagConstraints.weightx = 1.0;
        n = 23;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mSetMarkersVarListLabel, gridBagConstraints, 2, 3, 1, 1, n, insets3);
        DialogUtil.addUsingGBL(jPanel, this.mSetMarkersListScrollPane, gridBagConstraints, 2, 4, 1, 1, n, insets4);
        n = 20;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mLabelCasesListArrow, gridBagConstraints, 1, 5, 1, 2, n, insets2);
        gridBagConstraints.weightx = 1.0;
        n = 23;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mLabelCasesVarListLabel, gridBagConstraints, 2, 5, 1, 1, n, insets3);
        DialogUtil.addUsingGBL(jPanel, this.mLabelCasesListScrollPane, gridBagConstraints, 2, 6, 1, 1, n, insets4);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        insets2.set(DialogUtil.getComponentGroupGap(), DialogUtil.getComponentGroupGap(), 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 1, 7, 2, 1, n, insets2);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        insets2.set(DialogUtil.getComponentGroupGap(), 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 8, 3, 1, n, insets2);
    }

    private JPanel setupPanelBy() {
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_SD_ROWS_COLON");
        jLabel.setLabelFor(this.mRowsTargetList);
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_SD_COLUMNS_COLON");
        jLabel2.setLabelFor(this.mColumnTargetList);
        JComponent[] jComponentArray = new JComponent[]{jLabel, this.mRowsArrowButton, this.mRowsTargetList, this.mNestVariableRowsCheckBox, jLabel2, this.mColumnsArrowButton, this.mColumnTargetList, this.mNestVariableColumnsCheckBox};
        return PanelFactory.getGraphsPanelByPanel(jComponentArray, this.getResString("IDS_SD_PANEL_BY_TITLE"));
    }

    private void runTitlesSubDlg() {
        this.runSubDialog(new TitlesSubDialog(this));
    }

    private void runOptionsSubDlg() {
        if (this.mLabelCasesVarList.getModel().getSize() > 0) {
            this.runSubDialog(new OptionsSubDialog(this, 3079));
        } else {
            this.runSubDialog(new OptionsSubDialog(this, 3075));
        }
    }

    private void enableOkPasteOnControls() {
        if (this.mMatrixVarList.getModel().getSize() > 1) {
            if (!this.mChartSpecCheckBox.isSelected()) {
                this.enableOkPaste(true);
            } else if (this.mChartSpecCheckBox.isSelected() && this.mFilePath.getText().trim().length() > 0) {
                this.enableOkPaste(true);
            } else {
                this.enableOkPaste(false);
            }
        } else {
            this.enableOkPaste(false);
        }
    }

    class fileTextListener
    implements DocumentListener {
        fileTextListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            ScatterPlotMatrixDlg.this.enableOkPasteOnControls();
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            ScatterPlotMatrixDlg.this.enableOkPasteOnControls();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            ScatterPlotMatrixDlg.this.enableOkPasteOnControls();
        }
    }
}

