/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.graphs.legacy_dialogs.scatterdot;

import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.FileTextField;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.base.graphs.legacy_dialogs.scatterdot.ScatterPlotSimpleDlg;
import com.spss.java_client.ui.dialogs.base.graphs.legacy_dialogs.scatterdot.ScatterPlotThreeDimensionalDlg;
import com.spss.java_client.ui.dialogs.base.graphs.legacy_dialogs.scatterdot.ScatterPlotUtils;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class ScatterPlotCommonPanel
extends JPanel
implements ListDataListener,
ItemListener,
ActionListener {
    public SrcVariableList mSrcVarList;
    static final String Y_AXIS_VAR_LIST = "IDS_Y_AXIS_VAR_LIST";
    static final String X_AXIS_VAR_LIST = "IDS_X_AXIS_VAR_LIST";
    static final String Z_AXIS_VAR_LIST = "IDS_Z_AXIS_VAR_LIST";
    static final String SET_MARKERS_VAR_LIST = "IDS_SET_MARKERS_VAR_LIST";
    static final String LABEL_CASES_VAR_LIST = "IDS_LABEL_CASES_VAR_LIST";
    static final String TITLES_BUTTON = "IDS_REPORT_COMMON_TITLES_3DOT";
    static final String OPTIONS_BUTTON = "IDS_COMMON_OPTIONS_3DOT";
    static final String CHART_SPEC_CHECK = "IDS_SD_CHART_SPEC_CHECK";
    static final String FILE_BUTTON = "IDS_SD_FILE_3DOT";
    static final String ROWS_LIST_IDENTIFIER = "ROWS_TARGET_LIST";
    static final String COLUMNS_LIST_IDENTIFIER = "COLUMNS_TARGET_LIST";
    private BaseProcedureDialog mBaseDialog;
    private boolean mAllVisible = false;
    private ArrowButton mXAxisListArrow;
    private ArrowButton mYAxisListArrow;
    private ArrowButton mZAxisListArrow;
    private ArrowButton mSetMarkersListArrow;
    private ArrowButton mLabelCasesListArrow;
    private ArrowButton mRowsArrowButton;
    private ArrowButton mColumnsArrowButton;
    private TargetVariableList mXAxisVarList;
    private TargetVariableList mYAxisVarList;
    private TargetVariableList mZAxisVarList;
    private TargetVariableList mSetMarkersVarList;
    private TargetVariableList mLabelCasesVarList;
    private TargetVariableList mRowsTargetList;
    private TargetVariableList mColumnTargetList;
    private JLabel mSetMarkersVarListLabel;
    private JLabel mLabelCasesVarListLabel;
    private JScrollPane mSrcScrollPane;
    private JScrollPane mYAxisListScrollPane;
    private JScrollPane mXAxisListScrollPane;
    private JScrollPane mZAxisListScrollPane;
    private JScrollPane mSetMarkersListScrollPane;
    private JScrollPane mLabelCasesListScrollPane;
    private JCheckBox mChartSpecCheckBox;
    private JButton mFileButton;
    private JCheckBox mNestVariableColumnsCheckBox;
    private JCheckBox mNestVariableRowsCheckBox;
    private FileTextField mFilePath;
    private String mSourceLabelString;

    public ScatterPlotCommonPanel(BaseProcedureDialog baseProcedureDialog, boolean bl, String string) {
        this.mBaseDialog = baseProcedureDialog;
        this.mAllVisible = bl;
        this.setLayout(new GridBagLayout());
        this.initVars();
        this.setDefaults();
        this.addComponentsToPanel(this);
        this.enableOkPasteOnControls();
        this.mSourceLabelString = string;
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.enableOkPasteOnControls();
        this.mNestVariableRowsCheckBox.setEnabled(this.mRowsTargetList.getModel().getSize() > 0);
        this.mNestVariableColumnsCheckBox.setEnabled(this.mColumnTargetList.getModel().getSize() > 0);
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.enableOkPasteOnControls();
        this.mNestVariableRowsCheckBox.setEnabled(this.mRowsTargetList.getModel().getSize() > 0);
        this.mNestVariableColumnsCheckBox.setEnabled(this.mColumnTargetList.getModel().getSize() > 0);
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.enableOkPasteOnControls();
        this.mNestVariableRowsCheckBox.setEnabled(this.mRowsTargetList.getModel().getSize() > 0);
        this.mNestVariableColumnsCheckBox.setEnabled(this.mColumnTargetList.getModel().getSize() > 0);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource().equals(this.mChartSpecCheckBox)) {
            this.mFileButton.setEnabled(this.mChartSpecCheckBox.isSelected());
            this.mFilePath.setEnabled(this.mChartSpecCheckBox.isSelected());
            this.enableOkPasteOnControls();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        ScatterPlotUtils.openTemplateFilesDialog(this.mBaseDialog, (JTextField)((Object)this.mFilePath));
        this.enableOkPasteOnControls();
    }

    public TargetVariableList getLabelCaseByTargetList() {
        return this.mLabelCasesVarList;
    }

    public TargetVariableList getSetMarkersByTargetList() {
        return this.mSetMarkersVarList;
    }

    public TargetVariableList getRowsTargetList() {
        return this.mRowsTargetList;
    }

    public TargetVariableList getColumnsTargetList() {
        return this.mColumnTargetList;
    }

    public TargetVariableList getXAxisTargetList() {
        return this.mXAxisVarList;
    }

    public TargetVariableList getYAxisTargetList() {
        return this.mYAxisVarList;
    }

    public TargetVariableList getZAxisTargetList() {
        return this.mZAxisVarList;
    }

    public String getTemplateFileText() {
        return this.mFilePath.getText();
    }

    public boolean isUseChartCheckSelected() {
        return this.mChartSpecCheckBox.isSelected();
    }

    public boolean isNestVarCheckSelectedForRows() {
        return this.mNestVariableRowsCheckBox.isSelected();
    }

    public boolean isNestVarCheckSelectedForColumns() {
        return this.mNestVariableColumnsCheckBox.isSelected();
    }

    public Vector<Object> setTabTraversal() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcVarList);
        vector.add(this.mYAxisListArrow);
        vector.add(this.mXAxisListArrow);
        if (this.mAllVisible) {
            vector.add(this.mZAxisListArrow);
        }
        vector.add(this.mSetMarkersListArrow);
        vector.add(this.mLabelCasesListArrow);
        vector.add(this.mRowsArrowButton);
        vector.add(this.mColumnsArrowButton);
        vector.add(this.mYAxisVarList);
        vector.add(this.mXAxisVarList);
        if (this.mAllVisible) {
            vector.add(this.mZAxisVarList);
        }
        vector.add(this.mSetMarkersVarList);
        vector.add(this.mLabelCasesVarList);
        vector.add(this.mRowsTargetList);
        vector.add(this.mNestVariableRowsCheckBox);
        vector.add(this.mColumnTargetList);
        vector.add(this.mNestVariableColumnsCheckBox);
        vector.add(this.mChartSpecCheckBox);
        vector.add(this.mFileButton);
        return vector;
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.mFilePath.getText() != null) {
            this.mFilePath.setText(this.mFilePath.getText());
        }
        super.paint(graphics);
        super.validate();
    }

    protected void setDefaults() {
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcVarList.requestFocus();
        this.mXAxisVarList.removeAll();
        this.mYAxisVarList.removeAll();
        this.mSetMarkersVarList.removeAll();
        this.mLabelCasesVarList.removeAll();
        this.mRowsTargetList.removeAll();
        this.mColumnTargetList.removeAll();
        this.mFileButton.setEnabled(false);
        this.mFilePath.setEnabled(false);
        this.mFilePath.setText("");
        this.mChartSpecCheckBox.setSelected(false);
        this.mNestVariableRowsCheckBox.setSelected(false);
        this.mNestVariableColumnsCheckBox.setSelected(false);
        this.mNestVariableRowsCheckBox.setEnabled(false);
        this.mNestVariableColumnsCheckBox.setEnabled(false);
        if (this.mAllVisible) {
            this.mZAxisVarList.removeAll();
            ((ScatterPlotThreeDimensionalDlg)this.mBaseDialog).enableOkPasteButtons(false);
        } else {
            ((ScatterPlotSimpleDlg)this.mBaseDialog).enableOkPasteButtons(false);
        }
        this.mSrcVarList.setSelectedIndex(0);
    }

    private void initVars() {
        this.mSrcVarList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcScrollPane = new JScrollPane(this.mSrcVarList);
        this.mSrcScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        this.mYAxisVarList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mYAxisVarList.addVarFilter(new SpssVarFilter(8, false));
        this.mYAxisVarList.getModel().addListDataListener(this);
        this.mYAxisVarList.setIdentifier(Y_AXIS_VAR_LIST);
        this.mYAxisListScrollPane = new JScrollPane(this.mYAxisVarList);
        this.mYAxisListScrollPane.setHorizontalScrollBarPolicy(31);
        this.mYAxisListScrollPane.setVerticalScrollBarPolicy(21);
        this.mYAxisListScrollPane.setPreferredSize(this.mYAxisVarList.getMinimumSize());
        this.mXAxisVarList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mXAxisVarList.addVarFilter(new SpssVarFilter(8, false));
        this.mXAxisVarList.getModel().addListDataListener(this);
        this.mXAxisVarList.setIdentifier(X_AXIS_VAR_LIST);
        this.mXAxisListScrollPane = new JScrollPane(this.mXAxisVarList);
        this.mXAxisListScrollPane.setHorizontalScrollBarPolicy(31);
        this.mXAxisListScrollPane.setVerticalScrollBarPolicy(21);
        this.mXAxisListScrollPane.setPreferredSize(this.mXAxisVarList.getMinimumSize());
        if (this.mAllVisible) {
            this.mZAxisVarList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
            this.mZAxisVarList.addVarFilter(new SpssVarFilter(8, false));
            this.mZAxisVarList.getModel().addListDataListener(this);
            this.mZAxisVarList.setIdentifier(Z_AXIS_VAR_LIST);
            this.mZAxisListScrollPane = new JScrollPane(this.mZAxisVarList);
            this.mZAxisListScrollPane.setHorizontalScrollBarPolicy(31);
            this.mZAxisListScrollPane.setVerticalScrollBarPolicy(21);
            this.mZAxisListScrollPane.setPreferredSize(this.mYAxisVarList.getMinimumSize());
        }
        this.mSetMarkersVarListLabel = DialogUtil.createLabel(this.mBaseDialog, "IDS_SD_SET_MARKERS_BY");
        this.mSetMarkersVarList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mSetMarkersVarList.setIdentifier(SET_MARKERS_VAR_LIST);
        this.mSetMarkersVarListLabel.setLabelFor(this.mSetMarkersVarList);
        this.mSetMarkersListScrollPane = new JScrollPane(this.mSetMarkersVarList);
        this.mSetMarkersListScrollPane.setHorizontalScrollBarPolicy(31);
        this.mSetMarkersListScrollPane.setVerticalScrollBarPolicy(21);
        this.mSetMarkersListScrollPane.setPreferredSize(this.mSetMarkersVarList.getMinimumSize());
        this.mLabelCasesVarListLabel = DialogUtil.createLabel(this.mBaseDialog, "IDS_SD_LABEL_CASES_BY");
        this.mLabelCasesVarList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mLabelCasesVarList.setIdentifier(LABEL_CASES_VAR_LIST);
        this.mLabelCasesVarListLabel.setLabelFor(this.mLabelCasesVarList);
        this.mLabelCasesListScrollPane = new JScrollPane(this.mLabelCasesVarList);
        this.mLabelCasesListScrollPane.setHorizontalScrollBarPolicy(31);
        this.mLabelCasesListScrollPane.setVerticalScrollBarPolicy(21);
        this.mLabelCasesListScrollPane.setPreferredSize(this.mLabelCasesVarList.getMinimumSize());
        this.mYAxisListArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mYAxisListArrow.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mYAxisListArrow.registerVariableList(this.mYAxisVarList, SpssArrowButton.ButtonOrientation.left);
        if (this.mAllVisible) {
            this.mZAxisListArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
            this.mZAxisListArrow.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
            this.mZAxisListArrow.registerVariableList(this.mZAxisVarList, SpssArrowButton.ButtonOrientation.left);
        }
        this.mXAxisListArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mXAxisListArrow.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mXAxisListArrow.registerVariableList(this.mXAxisVarList, SpssArrowButton.ButtonOrientation.left);
        this.mLabelCasesListArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mLabelCasesListArrow.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mLabelCasesListArrow.registerVariableList(this.mLabelCasesVarList, SpssArrowButton.ButtonOrientation.left);
        this.mSetMarkersListArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mSetMarkersListArrow.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mSetMarkersListArrow.registerVariableList(this.mSetMarkersVarList, SpssArrowButton.ButtonOrientation.left);
        this.mRowsTargetList = new TargetVariableList(TargetVariableList.TargetListType.normal);
        this.mRowsTargetList.getModel().addListDataListener(this);
        this.mRowsTargetList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mRowsTargetList.setIdentifier(ROWS_LIST_IDENTIFIER);
        this.mColumnTargetList = new TargetVariableList(TargetVariableList.TargetListType.normal);
        this.mColumnTargetList.getModel().addListDataListener(this);
        this.mColumnTargetList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mColumnTargetList.setIdentifier(COLUMNS_LIST_IDENTIFIER);
        this.mRowsArrowButton = new ArrowButton();
        this.mRowsArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mRowsArrowButton.registerVariableList(this.mRowsTargetList, SpssArrowButton.ButtonOrientation.left);
        this.mColumnsArrowButton = new ArrowButton();
        this.mColumnsArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mColumnsArrowButton.registerVariableList(this.mColumnTargetList, SpssArrowButton.ButtonOrientation.left);
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mBaseDialog, "IDS_SD_NEST_VARS_ROWS");
        this.mNestVariableRowsCheckBox = new JCheckBox();
        this.mNestVariableRowsCheckBox.setAction(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mBaseDialog, "IDS_SD_NEST_VARS_COLUMNS");
        this.mNestVariableColumnsCheckBox = new JCheckBox();
        this.mNestVariableColumnsCheckBox.setAction(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mBaseDialog, FILE_BUTTON);
        this.mFileButton = new JButton(toggleButtonAction);
        this.mFileButton.addActionListener(this);
        this.mFilePath = new FileTextField();
        this.mFilePath.setAction(new TextFieldAction(this.mBaseDialog, "IDS_SD_COMMON_TEMPLATE_FILE_TEXT"));
        this.mFilePath.getDocument().addDocumentListener(new fileTextListener());
        this.mFilePath.setEditable(false);
        this.mFilePath.setOpaque(false);
        this.mFilePath.setBorder(BorderFactory.createEmptyBorder());
        toggleButtonAction = new ToggleButtonAction(this.mBaseDialog, CHART_SPEC_CHECK);
        this.mChartSpecCheckBox = new JCheckBox(toggleButtonAction);
        this.mChartSpecCheckBox.addItemListener(this);
    }

    private void addComponentsToPanel(JPanel jPanel) {
        JLabel jLabel = DialogUtil.createLabel(this.mBaseDialog, "IDS_SD_Y_AXIS_COLON");
        jLabel.setLabelFor(this.mYAxisVarList);
        JLabel jLabel2 = DialogUtil.createLabel(this.mBaseDialog, "IDS_SD_X_AXIS_COLON");
        jLabel2.setLabelFor(this.mXAxisVarList);
        JComponent[] jComponentArray = new JComponent[]{this.mChartSpecCheckBox, this.mFileButton, this.mFilePath};
        JPanel jPanel2 = PanelFactory.getGraphsChartTemplatePanel(jComponentArray, this.mBaseDialog.getResString("IDS_SD_TEMPLATE"));
        JPanel jPanel3 = this.setupPanelBy();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        int n = 23;
        gridBagConstraints.fill = 2;
        JLabel jLabel3 = DialogUtil.createLabel(this.mBaseDialog, this.mSourceLabelString);
        jLabel3.setLabelFor(this.mSrcVarList);
        DialogUtil.addUsingGBL(jPanel, jLabel3, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        Insets insets = DialogUtil.getArrowButtonInsets();
        int n2 = DialogUtil.getComponentGroupGap();
        int n3 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets2 = new Insets(0, insets.left + n3 + 3, 0, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mSrcScrollPane, gridBagConstraints, 0, 1, 1, 10, n, null);
        n = 20;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mYAxisListArrow, gridBagConstraints, 1, 0, 1, 2, n, insets2);
        Insets insets3 = new Insets(0, 3, 0, 0);
        gridBagConstraints.weightx = 1.0;
        n = 23;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 2, 0, 1, 1, n, insets3);
        Insets insets4 = new Insets(0, 3, 0, n3 + 4);
        DialogUtil.addUsingGBL(jPanel, this.mYAxisListScrollPane, gridBagConstraints, 2, 1, 1, 1, n, insets4);
        n = 20;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mXAxisListArrow, gridBagConstraints, 1, 2, 1, 2, n, insets2);
        insets3.set(n2, 3, 0, 0);
        gridBagConstraints.weightx = 1.0;
        n = 23;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 2, 2, 1, 1, n, insets3);
        DialogUtil.addUsingGBL(jPanel, this.mXAxisListScrollPane, gridBagConstraints, 2, 3, 1, 1, n, insets4);
        if (this.mAllVisible) {
            JLabel jLabel4 = DialogUtil.createLabel(this.mBaseDialog, "IDS_SD_Z_AXIS_COLON");
            jLabel4.setLabelFor(this.mZAxisVarList);
            n = 20;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 0;
            DialogUtil.addUsingGBL(jPanel, this.mZAxisListArrow, gridBagConstraints, 1, 4, 1, 2, n, insets2);
            gridBagConstraints.weightx = 1.0;
            n = 23;
            gridBagConstraints.fill = 2;
            DialogUtil.addUsingGBL(jPanel, jLabel4, gridBagConstraints, 2, 4, 1, 1, n, insets3);
            DialogUtil.addUsingGBL(jPanel, this.mZAxisListScrollPane, gridBagConstraints, 2, 5, 1, 1, n, insets4);
        }
        n = 20;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mSetMarkersListArrow, gridBagConstraints, 1, 6, 1, 2, n, insets2);
        gridBagConstraints.weightx = 1.0;
        n = 23;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mSetMarkersVarListLabel, gridBagConstraints, 2, 6, 1, 1, n, insets3);
        DialogUtil.addUsingGBL(jPanel, this.mSetMarkersListScrollPane, gridBagConstraints, 2, 7, 1, 1, n, insets4);
        n = 20;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mLabelCasesListArrow, gridBagConstraints, 1, 8, 1, 2, n, insets2);
        gridBagConstraints.weightx = 1.0;
        n = 23;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mLabelCasesVarListLabel, gridBagConstraints, 2, 8, 1, 1, n, insets3);
        DialogUtil.addUsingGBL(jPanel, this.mLabelCasesListScrollPane, gridBagConstraints, 2, 9, 1, 1, n, insets4);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        insets2.set(DialogUtil.getComponentGroupGap(), DialogUtil.getComponentGroupGap(), 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 1, 10, 2, 1, n, insets2);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        insets2.set(DialogUtil.getComponentGroupGap(), 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 11, 3, 1, n, insets2);
    }

    private JPanel setupPanelBy() {
        JLabel jLabel = DialogUtil.createLabel(this.mBaseDialog, "IDS_SD_ROWS_COLON");
        jLabel.setLabelFor(this.mRowsTargetList);
        JLabel jLabel2 = DialogUtil.createLabel(this.mBaseDialog, "IDS_SD_COLUMNS_COLON");
        jLabel2.setLabelFor(this.mColumnTargetList);
        JComponent[] jComponentArray = new JComponent[]{jLabel, this.mRowsArrowButton, this.mRowsTargetList, this.mNestVariableRowsCheckBox, jLabel2, this.mColumnsArrowButton, this.mColumnTargetList, this.mNestVariableColumnsCheckBox};
        return PanelFactory.getGraphsPanelByPanel(jComponentArray, this.mBaseDialog.getResString("IDS_SD_PANEL_BY_TITLE"));
    }

    private void enableOkPasteOnControls() {
        if (this.mAllVisible) {
            if (this.mXAxisVarList.getModel().getSize() > 0 && this.mYAxisVarList.getModel().getSize() > 0 && this.mZAxisVarList.getModel().getSize() > 0) {
                if (!this.mChartSpecCheckBox.isSelected()) {
                    ((ScatterPlotThreeDimensionalDlg)this.mBaseDialog).enableOkPasteButtons(true);
                } else if (this.mChartSpecCheckBox.isSelected() && this.mFilePath.getText().trim().length() > 0) {
                    ((ScatterPlotThreeDimensionalDlg)this.mBaseDialog).enableOkPasteButtons(true);
                } else {
                    ((ScatterPlotThreeDimensionalDlg)this.mBaseDialog).enableOkPasteButtons(false);
                }
            } else {
                ((ScatterPlotThreeDimensionalDlg)this.mBaseDialog).enableOkPasteButtons(false);
            }
        } else if (this.mXAxisVarList.getModel().getSize() > 0 && this.mYAxisVarList.getModel().getSize() > 0) {
            if (!this.mChartSpecCheckBox.isSelected()) {
                ((ScatterPlotSimpleDlg)this.mBaseDialog).enableOkPasteButtons(true);
            } else if (this.mChartSpecCheckBox.isSelected() && this.mFilePath.getText().trim().length() > 0) {
                ((ScatterPlotSimpleDlg)this.mBaseDialog).enableOkPasteButtons(true);
            } else {
                ((ScatterPlotSimpleDlg)this.mBaseDialog).enableOkPasteButtons(false);
            }
        } else {
            ((ScatterPlotSimpleDlg)this.mBaseDialog).enableOkPasteButtons(false);
        }
    }

    class fileTextListener
    implements DocumentListener {
        fileTextListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            ScatterPlotCommonPanel.this.enableOkPasteOnControls();
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            ScatterPlotCommonPanel.this.enableOkPasteOnControls();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            ScatterPlotCommonPanel.this.enableOkPasteOnControls();
        }
    }
}

