/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.graphs.legacy_dialogs.scatterdot;

import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.dialogs.base.graphs.ImageLabelKeyListener;
import com.spss.java_client.ui.dialogs.base.graphs.MatrixImage;
import com.spss.java_client.ui.dialogs.base.graphs.MatrixImagesGroup;
import com.spss.java_client.ui.dialogs.base.graphs.res.GraphsResBundle;
import com.spss.java_client.ui.dialogs.common.BaseGatingDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.shared.core_tools.system.OSInfo;
import java.awt.GridBagConstraints;
import java.awt.HeadlessException;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ScatterDotDlg
extends BaseGatingDialog {
    private JLabel mSimpleScatterLabel;
    private JLabel mMatrixScatterLabel;
    private JLabel mSimpleDotLabel;
    private JLabel mOverlayScatterLabel;
    private JLabel m3DScatterLabel;
    private MatrixImagesGroup mScatterDotImageLabelGroup;
    private MatrixImage mSimpleScatterImage;
    private MatrixImage mMatrixScatterImage;
    private MatrixImage mSimpleDotImage;
    private MatrixImage mOverlayScatterImage;
    private MatrixImage m3DScatterImage;

    public ScatterDotDlg(JFrame jFrame) throws HeadlessException {
        super(jFrame, GraphsResBundle.getDefaultResourceBundleName(), GraphsResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_SCATTER_DOT_DIALOG_TITLE"));
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public String getDialogHelpID() {
        return "idh_gsca";
    }

    @Override
    public String getIActionKey() {
        return "graphs_legacy_dialogs_scatter";
    }

    @Override
    public boolean continuePressed() {
        return true;
    }

    @Override
    public String getNextProcDlgActionKey() {
        if (this.mSimpleScatterImage.isSelected()) {
            return "graphs_legacy_dialogs_simple_scatter";
        }
        if (this.mMatrixScatterImage.isSelected()) {
            return "graphs_legacy_dialogs_matrix_scatter";
        }
        if (this.mSimpleDotImage.isSelected()) {
            return "graphs_legacy_dialogs_simple_dot_scatter";
        }
        if (this.mOverlayScatterImage.isSelected()) {
            return "graphs_legacy_dialogs_overlay_scatter";
        }
        if (this.m3DScatterImage.isSelected()) {
            return "graphs_legacy_dialogs_3_d_scatter";
        }
        return null;
    }

    @Override
    public void loadDialogState() {
        Integer n = this.mDialogDataModel.getInteger("IDS_SCATTER_DOT_SELECTED_IMAGE");
        if (n != null) {
            this.setImageSelected(n);
        }
        super.loadDialogState();
    }

    @Override
    public void saveDialogState() {
        super.saveDialogState();
        this.mDialogDataModel.putInteger("IDS_SCATTER_DOT_SELECTED_IMAGE", this.getSelectedImageIndex());
    }

    @Override
    protected void init() {
        super.init();
        this.renameContinueAction("IDS_DEFINE");
        this.initVars();
        this.setDefaults();
        JPanel jPanel = this.getViewPanel();
        JPanel jPanel2 = this.createPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, null);
        this.pack();
    }

    private void initVars() {
        this.mSimpleScatterLabel = DialogUtil.createMultiLineLabel(this, "IDS_SD_SIMPLE_SCATTER", 60);
        this.mMatrixScatterLabel = DialogUtil.createMultiLineLabel(this, "IDS_SD_MATRIX_SCATTER", 60);
        this.mSimpleDotLabel = DialogUtil.createMultiLineLabel(this, "IDS_SD_SIMPLE_DOT", 45);
        this.mOverlayScatterLabel = DialogUtil.createMultiLineLabel(this, "IDS_SD_OVERLAY_SCATTER", 60);
        this.m3DScatterLabel = DialogUtil.createMultiLineLabel(this, "IDS_SD_3D_SCATTER", 50);
        this.mScatterDotImageLabelGroup = new MatrixImagesGroup();
        this.mSimpleScatterImage = new MatrixImage(this.getResImageURL("IDS_SD_SIMPLE_SCATTER_IMAGE"));
        this.mSimpleScatterImage.setImageLabelGroup(this.mScatterDotImageLabelGroup);
        this.mMatrixScatterImage = new MatrixImage(this.getResImageURL("IDS_SD_MATRIX_SCATTER_IMAGE"));
        this.mMatrixScatterImage.setImageLabelGroup(this.mScatterDotImageLabelGroup);
        this.mSimpleDotImage = new MatrixImage(this.getResImageURL("IDS_SD_SIMPLE_DOT_IMAGE"));
        this.mSimpleDotImage.setImageLabelGroup(this.mScatterDotImageLabelGroup);
        this.mOverlayScatterImage = new MatrixImage(this.getResImageURL("IDS_SD_OVERLAY_SCATTER_IMAGE"));
        this.mOverlayScatterImage.setImageLabelGroup(this.mScatterDotImageLabelGroup);
        this.m3DScatterImage = new MatrixImage(this.getResImageURL("IDS_SD_3D_SCATTER_IMAGE"));
        this.m3DScatterImage.setImageLabelGroup(this.mScatterDotImageLabelGroup);
        Vector<MatrixImage> vector = new Vector<MatrixImage>();
        vector.add(this.mSimpleScatterImage);
        vector.add(this.mOverlayScatterImage);
        vector.add(this.mMatrixScatterImage);
        vector.add(this.m3DScatterImage);
        vector.add(this.mSimpleDotImage);
        this.mSimpleScatterImage.addKeyListener(new ImageLabelKeyListener(vector, this.mScatterDotImageLabelGroup));
        this.mOverlayScatterImage.addKeyListener(new ImageLabelKeyListener(vector, this.mScatterDotImageLabelGroup));
        this.mMatrixScatterImage.addKeyListener(new ImageLabelKeyListener(vector, this.mScatterDotImageLabelGroup));
        this.m3DScatterImage.addKeyListener(new ImageLabelKeyListener(vector, this.mScatterDotImageLabelGroup));
        this.mSimpleDotImage.addKeyListener(new ImageLabelKeyListener(vector, this.mScatterDotImageLabelGroup));
        Vector<Object> vector2 = new Vector<Object>();
        if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
            vector2.add(this.mDefineButton);
            vector2.add(this.mSimpleScatterImage);
            vector2.add(this.mHelpButton);
            vector2.add(this.mCancelButton);
        } else {
            vector2.add(this.mDefineButton);
            vector2.add(this.mCancelButton);
            vector2.add(this.mHelpButton);
            vector2.add(this.mSimpleScatterImage);
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector2, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private void setDefaults() {
        this.mSimpleScatterImage.setDefaultSelectedImage(true);
        this.mOverlayScatterImage.setDefaultSelectedImage(false);
        this.mMatrixScatterImage.setDefaultSelectedImage(false);
        this.m3DScatterImage.setDefaultSelectedImage(false);
        this.mSimpleDotImage.setDefaultSelectedImage(false);
    }

    private JPanel createPanel() {
        JComponent[] jComponentArray = new JComponent[]{this.mSimpleScatterImage, this.mOverlayScatterImage, this.mSimpleScatterLabel, this.mOverlayScatterLabel, this.mMatrixScatterImage, this.m3DScatterImage, this.mMatrixScatterLabel, this.m3DScatterLabel, this.mSimpleDotImage, new JLabel(), this.mSimpleDotLabel};
        return PanelFactory.getPanelForImageLabels(jComponentArray, "", 2);
    }

    private int getSelectedImageIndex() {
        int n = -1;
        if (this.mScatterDotImageLabelGroup.isSelected(this.mSimpleScatterImage)) {
            n = 0;
        } else if (this.mScatterDotImageLabelGroup.isSelected(this.mOverlayScatterImage)) {
            n = 1;
        } else if (this.mScatterDotImageLabelGroup.isSelected(this.mMatrixScatterImage)) {
            n = 2;
        } else if (this.mScatterDotImageLabelGroup.isSelected(this.m3DScatterImage)) {
            n = 3;
        } else if (this.mScatterDotImageLabelGroup.isSelected(this.mSimpleDotImage)) {
            n = 4;
        }
        return n;
    }

    private void setImageSelected(int n) {
        switch (n) {
            case 0: {
                this.mSimpleScatterImage.setDefaultSelectedImage(true);
                break;
            }
            case 1: {
                this.mOverlayScatterImage.setDefaultSelectedImage(true);
                break;
            }
            case 2: {
                this.mMatrixScatterImage.setDefaultSelectedImage(true);
                break;
            }
            case 3: {
                this.m3DScatterImage.setDefaultSelectedImage(true);
                break;
            }
            case 4: {
                this.mSimpleDotImage.setDefaultSelectedImage(true);
            }
        }
    }
}

