/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.graphs.legacy_dialogs.population_pyramid;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.dictionary.OBS;
import com.spss.java_client.core.documents.data.dictionary.SPSS_Format;
import com.spss.java_client.ui.controls.FixedLengthNumericDocument;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.shared.core_tools.format.CellValueFormatter;
import com.spss.shared.core_tools.utils.SerializableObject;
import com.spss.uitools.controls.ContextEnabledTextField;
import com.spss.uitools.dialogs.BaseDialog;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class PopulationPyramidScaleOptions
extends BaseSubDialog
implements ItemListener {
    static final String CUSTOM_VAL = "CUSTOM_VAL";
    static final String CUSTOM_VAL_RADIO = "IDS_POPU_PYRAMID_SCALE_ANCH_CUSTOM";
    static final String NUMBER_INTERVAL = "NUMBER_INTERVAL";
    static final String INTERVAL_WIDTH = "INTERVAL_WIDTH";
    static final String NORMAL_CURVE = "IDS_POPU_PYRAMID_SCALE_DISP_CURVE";
    static final String ANCHOR_AUTO = "IDS_POPU_PYRAMID_SCALE_ANCH_AUTO";
    static final String BIN_AUTO = "IDS_POPU_PYRAMID_SCALE_BIN_AUTO";
    static final String BIN_CUSTOM = "IDS_POPU_PYRAMID_SCALE_BIN_CUSTOM";
    static final String INTERVAL_NUM_RADIO = "IDS_POPU_PYRAMID_SCALE_BIN_NUM_INTERVALS";
    static final String INTERVAL_WIDTH_RADIO = "IDS_POPU_PYRAMID_SCALE_BIN_INTERVALS_WIDTH";
    private JCheckBox mDisplayCurveCheck;
    private JRadioButton mAutomaticAnchorRadio;
    private JRadioButton mCustomValRadio;
    private ContextEnabledTextField mCustomValText;
    private JRadioButton mAutomaticBinRadio;
    private JRadioButton mCustomBinRadio;
    private JRadioButton mNumberIntervalsRadio;
    private ContextEnabledTextField mNumberIntervalsText;
    private JRadioButton mIntervalWidthRadio;
    private ContextEnabledTextField mIntervalWidthText;
    private SpssButtonGroup mBinGroup;
    private SpssButtonGroup mFirstBinGroup;
    private SpssButtonGroup mIntervalButtonGroup;
    private BaseDialog mParent;
    private SPSS_Format mLastFormat;

    public PopulationPyramidScaleOptions(BaseProcedureDialog baseProcedureDialog) {
        super(baseProcedureDialog, baseProcedureDialog.getResString("IDS_POPU_PYRAMID_SCALE_TITLE_SUB"), true);
        this.mParent = baseProcedureDialog;
    }

    @Override
    public String getDialogHelpID() {
        return "IDH_IDD_POPU_OPTION_SCALE";
    }

    @Override
    public boolean continuePressed() {
        return this.verifyTextField(this.mCustomValText) && this.verifyTextField(this.mNumberIntervalsText) && this.verifyTextField(this.mIntervalWidthText);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.mCustomValText.setEnabled(!this.mAutomaticAnchorRadio.isSelected());
        this.mCustomValText.setOpaque(!this.mAutomaticAnchorRadio.isSelected());
        if (this.mAutomaticBinRadio.isSelected()) {
            this.mNumberIntervalsRadio.setEnabled(false);
            this.mNumberIntervalsText.setEnabled(false);
            this.mNumberIntervalsText.setOpaque(false);
            this.mIntervalWidthRadio.setEnabled(false);
            this.mIntervalWidthText.setEnabled(false);
            this.mIntervalWidthText.setOpaque(false);
        } else {
            this.mNumberIntervalsRadio.setEnabled(true);
            this.mIntervalWidthRadio.setEnabled(true);
            this.mIntervalWidthText.setEnabled(!this.mNumberIntervalsRadio.isSelected());
            this.mIntervalWidthText.setOpaque(!this.mNumberIntervalsRadio.isSelected());
            this.mNumberIntervalsText.setEnabled(!this.mIntervalWidthRadio.isSelected());
            this.mNumberIntervalsText.setOpaque(!this.mIntervalWidthRadio.isSelected());
        }
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        super.loadState(dialogDataModel);
        SPSS_Format sPSS_Format = (SPSS_Format)dialogDataModel.getSerializableObject("DISTRI_VAR_FORMAT");
        if (this.mLastFormat == null) {
            this.mLastFormat = sPSS_Format;
        }
        if (dialogDataModel.getString(CUSTOM_VAL) != null) {
            this.mCustomValText.setText(dialogDataModel.getString(CUSTOM_VAL));
        }
        if (dialogDataModel.getString(NUMBER_INTERVAL) != null) {
            this.mNumberIntervalsText.setText(dialogDataModel.getString(NUMBER_INTERVAL));
        }
        if (dialogDataModel.getString(INTERVAL_WIDTH) != null) {
            this.mIntervalWidthText.setText(dialogDataModel.getString(INTERVAL_WIDTH));
        }
    }

    @Override
    protected boolean saveState(DialogDataModel dialogDataModel) {
        dialogDataModel.putString(CUSTOM_VAL, this.mCustomValText.getText());
        dialogDataModel.putString(NUMBER_INTERVAL, this.mNumberIntervalsText.getText());
        dialogDataModel.putString(INTERVAL_WIDTH, this.mIntervalWidthText.getText());
        dialogDataModel.putSerializableObject("VARIABLE_FORMAT", (SerializableObject)this.mLastFormat);
        return super.saveState(dialogDataModel);
    }

    @Override
    protected void init() {
        super.init();
        JPanel jPanel = this.getViewPanel();
        this.initVars();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mDisplayCurveCheck, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weighty = 1.0;
        JPanel jPanel2 = this.setupAnchorFirstBinPanel();
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 1, 1, 1, n, null);
        jPanel2 = this.setupBinSizesPanel();
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 2, 1, 1, n, null);
        this.setupFocusTraversalPolicy();
        this.pack();
    }

    private void setupFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mDisplayCurveCheck);
        vector.add(this.mFirstBinGroup);
        vector.add(this.mCustomValText);
        vector.add(this.mBinGroup);
        vector.add(this.mIntervalButtonGroup);
        vector.add(this.mNumberIntervalsText);
        vector.add(this.mIntervalWidthText);
        Component component = this.mCmdButtonPanel.getComponent(0);
        Component component2 = this.mCmdButtonPanel.getComponent(1);
        Component component3 = this.mCmdButtonPanel.getComponent(2);
        vector.add(component);
        vector.add(component2);
        vector.add(component3);
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private JPanel setupAnchorFirstBinPanel() {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        int n = DialogUtil.getGroupBoxInnerMargin();
        int n2 = DialogUtil.getComponentGroupGap();
        TitledBorder titledBorder = new TitledBorder(this.getResString("IDS_POPU_PYRAMID_SCALE_ANCHOR_TITLE"));
        jPanel.setBorder(titledBorder);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n3 = 23;
        DialogUtil.addUsingGBL(jPanel, this.mAutomaticAnchorRadio, gridBagConstraints, 0, 0, 1, 1, n3, null);
        DialogUtil.addUsingGBL(jPanel, this.mCustomValRadio, gridBagConstraints, 0, 1, 1, 1, n3, null);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.mCustomValText.setColumns(12);
        Insets insets = new Insets(3, n2 + n - 1, n, n);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mCustomValText, gridBagConstraints, 1, 1, 1, 1, n3, insets);
        return jPanel;
    }

    private JPanel setupBinSizesPanel() {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        TitledBorder titledBorder = new TitledBorder(this.getResString("IDS_POPU_PYRAMID_SCALE_BIN_TITLE"));
        jPanel.setBorder(titledBorder);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(insets.top, insets.left, insets.bottom, insets.right);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mAutomaticBinRadio, gridBagConstraints, 0, 0, 1, 1, n, null);
        DialogUtil.addUsingGBL(jPanel, this.mCustomBinRadio, gridBagConstraints, 0, 1, 1, 1, n, null);
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        int n3 = DialogUtil.getComponentGroupGap();
        insets2.set(0, n3 * 2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mNumberIntervalsRadio, gridBagConstraints, 0, 2, 1, 1, n, insets2);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.mNumberIntervalsText.setColumns(5);
        insets2.set(3, n3 * 2 + n2, 0, n2 * 8);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mNumberIntervalsText, gridBagConstraints, 1, 2, 1, 1, n, insets2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        insets2.set(0, n3 * 2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mIntervalWidthRadio, gridBagConstraints, 0, 3, 1, 1, n, insets2);
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        this.mIntervalWidthText.setColumns(12);
        insets2.set(3, n3 * 2 + n2, n2, n2);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mIntervalWidthText, gridBagConstraints, 1, 3, 1, 1, n, insets2);
        return jPanel;
    }

    private void initVars() {
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, NORMAL_CURVE);
        this.mDisplayCurveCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, ANCHOR_AUTO);
        this.mAutomaticAnchorRadio = new JRadioButton(toggleButtonAction);
        this.mAutomaticAnchorRadio.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this, CUSTOM_VAL_RADIO);
        this.mCustomValRadio = new JRadioButton(toggleButtonAction);
        this.mCustomValRadio.addItemListener(this);
        this.mFirstBinGroup = new SpssButtonGroup();
        this.mFirstBinGroup.add(this.mAutomaticAnchorRadio);
        this.mFirstBinGroup.add(this.mCustomValRadio);
        this.mCustomValText = new ContextEnabledTextField(2);
        this.mCustomValText.setDocument((Document)new CustomDocument());
        this.mCustomValText.setName(CUSTOM_VAL);
        toggleButtonAction = new ToggleButtonAction(this, BIN_AUTO);
        this.mAutomaticBinRadio = new JRadioButton(toggleButtonAction);
        this.mAutomaticBinRadio.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this, BIN_CUSTOM);
        this.mCustomBinRadio = new JRadioButton(toggleButtonAction);
        this.mCustomBinRadio.addItemListener(this);
        this.mBinGroup = new SpssButtonGroup();
        this.mBinGroup.add(this.mAutomaticBinRadio);
        this.mBinGroup.add(this.mCustomBinRadio);
        toggleButtonAction = new ToggleButtonAction(this, INTERVAL_NUM_RADIO);
        this.mNumberIntervalsRadio = new JRadioButton(toggleButtonAction);
        this.mNumberIntervalsRadio.addItemListener(this);
        this.mNumberIntervalsText = new ContextEnabledTextField(2);
        FixedLengthNumericDocument fixedLengthNumericDocument = new FixedLengthNumericDocument(Integer.MAX_VALUE, true, false);
        this.mNumberIntervalsText.setDocument((Document)fixedLengthNumericDocument);
        this.mNumberIntervalsText.setName(NUMBER_INTERVAL);
        toggleButtonAction = new ToggleButtonAction(this, INTERVAL_WIDTH_RADIO);
        this.mIntervalWidthRadio = new JRadioButton(toggleButtonAction);
        this.mIntervalWidthRadio.addItemListener(this);
        this.mIntervalButtonGroup = new SpssButtonGroup();
        this.mIntervalButtonGroup.add(this.mNumberIntervalsRadio);
        this.mIntervalButtonGroup.add(this.mIntervalWidthRadio);
        this.mIntervalWidthText = new ContextEnabledTextField(2);
        fixedLengthNumericDocument = new FixedLengthNumericDocument(Integer.MAX_VALUE, false, true);
        this.mIntervalWidthText.setDocument((Document)fixedLengthNumericDocument);
        this.mIntervalWidthText.setName(INTERVAL_WIDTH);
        this.setDefaults();
    }

    private void setDefaults() {
        this.mAutomaticAnchorRadio.setSelected(true);
        this.mAutomaticBinRadio.setSelected(true);
        this.mNumberIntervalsRadio.setSelected(true);
    }

    private boolean verifyTextField(ContextEnabledTextField contextEnabledTextField) {
        if (contextEnabledTextField.isEnabled() && contextEnabledTextField.getText().length() == 0) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_POPU_PYRAMID_SCALE_EMPTY_INPUT"), VersionInfo.getAppVersionString());
            contextEnabledTextField.requestFocus();
            return false;
        }
        if (contextEnabledTextField.getName().equals(CUSTOM_VAL) && contextEnabledTextField.isEnabled()) {
            OBS oBS = new OBS();
            boolean bl = this.stringToObs(contextEnabledTextField.getText(), oBS, this.mLastFormat);
            if (!this.mLastFormat.getFormatType().isStringFormat() && (!bl || oBS.isString() || oBS.isEmpty())) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_POPU_PYRAMID_INVALID_INPUT"), VersionInfo.getAppVersionString());
                contextEnabledTextField.requestFocus();
                contextEnabledTextField.selectAll();
                return false;
            }
        }
        return true;
    }

    private boolean stringToObs(String string, OBS oBS, SPSS_Format sPSS_Format) {
        if (!CellValueFormatter.stringToObs((String)string, (SPSS_Format)sPSS_Format, (OBS)oBS)) {
            return false;
        }
        try {
            if (sPSS_Format.getFormatType().isDateOrTimeFormat() && string.trim().getBytes(ComponentState.getCurrentCharsetName()).length > sPSS_Format.getWidth()) {
                return false;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return true;
    }

    class CustomDocument
    extends PlainDocument {
        CustomDocument() {
        }

        @Override
        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            DialogDataModel dialogDataModel = ((BaseProcedureDialog)PopulationPyramidScaleOptions.this.mParent).getDialogDataModel();
            if (dialogDataModel != null) {
                SPSS_Format sPSS_Format = (SPSS_Format)dialogDataModel.getSerializableObject("DISTRI_VAR_FORMAT");
                boolean bl = true;
                if (sPSS_Format.getFormatType().isCurrencyFormat()) {
                    bl = string.matches(PopulationPyramidScaleOptions.this.mParent.getResString("IDS_POPU_PYRAMID_CURRENCY_CHARACTERS"));
                } else if (sPSS_Format.getFormatType().isNumericFormat()) {
                    bl = string.matches("[[0-9]Ee.+-]*");
                }
                if (bl) {
                    super.insertString(n, string, attributeSet);
                }
            }
        }
    }
}

