/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.graphs.legacy_dialogs.population_pyramid;

import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.MeasurementLevel;
import com.spss.java_client.core.documents.data.dictionary.SPSS_Format;
import com.spss.java_client.core.documents.data.dictionary.SpssVariable;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.FileTextField;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.dialogs.base.graphs.GraphsRemoteFileChooser;
import com.spss.java_client.ui.dialogs.base.graphs.TitlesSubDialog;
import com.spss.java_client.ui.dialogs.base.graphs.legacy_dialogs.population_pyramid.PopulationPyramidCatOptions;
import com.spss.java_client.ui.dialogs.base.graphs.legacy_dialogs.population_pyramid.PopulationPyramidScaleOptions;
import com.spss.java_client.ui.dialogs.base.graphs.res.GraphsResBundle;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.shared.core_tools.utils.SerializableObject;
import com.spss.uitools.util.CharacterUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.net.URL;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class PopulationPyramidDlg
extends BaseProcedureDialog
implements ItemListener,
ListDataListener {
    static final String COMPUTE_RADIO_KEY = "IDS_POPU_PYRAMID_COMPUTE_COUNT_RADIO";
    static final String GET_COUNT_RADIO_KEY = "IDS_POPU_PYRAMID_GET_COUNT_RADIO";
    static final String USE_CHART_CHECK = "IDS_POPU_PYRAMID_USE_CHART_CHECK";
    static final String FILE_BUTTON_KEY = "IDS_POPU_PYRAMID_FILE_BUTTON";
    static final String ENABLE_DISPLAY_ERROR_BAR = "ENABLE_DISPLAY_ERROR_BAR";
    static final String CUSTOM_VAL = "CUSTOM_VAL";
    static final String NUMBER_INTERVAL = "NUMBER_INTERVAL";
    static final String INTERVAL_WIDTH = "INTERVAL_WIDTH";
    static final String ANCHOR_AUTO = "IDS_POPU_PYRAMID_SCALE_ANCH_AUTO";
    static final String BIN_AUTO = "IDS_POPU_PYRAMID_SCALE_BIN_AUTO";
    static final String CUSTOM_VAL_RADIO = "IDS_POPU_PYRAMID_SCALE_ANCH_CUSTOM";
    static final String BIN_CUSTOM = "IDS_POPU_PYRAMID_SCALE_BIN_CUSTOM";
    private SrcVariableList mSrcVarList;
    private TargetVariableList mTargetVarCountList;
    private ArrowButton mArrowButtonForVarCountList;
    private TargetVariableList mTargetDistributionList;
    private ArrowButton mArrowButtonForDistributionList;
    private TargetVariableList mTargetSplitList;
    private ArrowButton mArrowButtonForSplitList;
    private TargetVariableList mTargetRowsList;
    private ArrowButton mArrowButtonForRowsList;
    private JRadioButton mComputeCountRadio;
    private JRadioButton mGetCountRadio;
    private JCheckBox mUseChartCheck;
    private JButton mFileButton;
    private FileTextField mFileNameLabel;
    private JButton mCatOptionsButton;
    private JButton mTitleButton;
    private JCheckBox mNestRowCheck;
    private int mGap;
    private SpssButtonGroup mButtonGroup;

    public PopulationPyramidDlg(JFrame jFrame) {
        super(jFrame, false, GraphsResBundle.getDefaultResourceBundleName(), GraphsResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_POPU_PYRAMID_TITLE"));
        this.setLocationRelativeTo(this.getParent());
    }

    public void paint(Graphics graphics) {
        this.mFileNameLabel.setText(this.mFileNameLabel.getText());
        super.paint(graphics);
        super.validate();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        ISpssVariable[] iSpssVariableArray = this.mSrcVarList.getSelectedValues();
        this.mArrowButtonForVarCountList.setEnabled(this.mGetCountRadio.isSelected() && iSpssVariableArray.length == 1);
        this.mTargetVarCountList.setEnabled(this.mGetCountRadio.isSelected());
        this.mTargetVarCountList.setOpaque(this.mGetCountRadio.isSelected());
        if (this.mUseChartCheck.isSelected()) {
            this.mFileButton.setEnabled(true);
            this.mFileNameLabel.setEnabled(true);
        } else {
            this.mFileButton.setEnabled(false);
            this.mFileNameLabel.setEnabled(false);
        }
        this.okPasteValue();
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        if (this.mTargetDistributionList.getModel().getSize() > 0) {
            DialogUtil.enableHTMLComponent(this.mCatOptionsButton, true);
            if (this.mTargetDistributionList.getModel().getElementAt(0).getDisplayMeasurementLevel().equals((Object)MeasurementLevel.scale)) {
                if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
                    this.mCatOptionsButton.setText(this.getResString("IDS_POPU_PYRAMID_SCALE_OPTION_BUTTON_MAC"));
                } else {
                    this.mCatOptionsButton.setText(this.getResString("IDS_POPU_PYRAMID_SCALE_OPTION_BUTTON"));
                }
            } else if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
                this.mCatOptionsButton.setText(this.getResString("IDS_POPU_PYRAMID_OPTION_BUTTON_MAC"));
            } else {
                this.mCatOptionsButton.setText(this.getResString("IDS_POPU_PYRAMID_OPTION_BUTTON"));
            }
            SpssVariable spssVariable = (SpssVariable)this.mTargetDistributionList.getModel().getElementAt(0);
            DialogDataModel dialogDataModel = this.getDialogDataModel();
            if (dialogDataModel != null) {
                dialogDataModel.putSerializableObject("DISTRI_VAR_FORMAT", (SerializableObject)spssVariable.getFormat());
            }
        } else {
            DialogUtil.enableHTMLComponent(this.mCatOptionsButton, false);
        }
        this.onRowListDataEvent();
        this.okPasteValue();
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        if (this.mTargetDistributionList.getModel().getSize() > 0) {
            DialogUtil.enableHTMLComponent(this.mCatOptionsButton, true);
        } else {
            DialogUtil.enableHTMLComponent(this.mCatOptionsButton, false);
            if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
                this.mCatOptionsButton.setText(this.getResString("IDS_POPU_PYRAMID_SCALE_OPTION_BUTTON_MAC"));
            } else {
                this.mCatOptionsButton.setText(this.getResString("IDS_POPU_PYRAMID_SCALE_OPTION_BUTTON"));
            }
        }
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        dialogDataModel.putString(CUSTOM_VAL, "");
        dialogDataModel.putString(NUMBER_INTERVAL, "");
        dialogDataModel.putString(INTERVAL_WIDTH, "");
        dialogDataModel.putBoolean(ANCHOR_AUTO, true);
        dialogDataModel.putBoolean(BIN_AUTO, true);
        dialogDataModel.putBoolean(CUSTOM_VAL_RADIO, false);
        dialogDataModel.putBoolean(BIN_CUSTOM, false);
        this.onRowListDataEvent();
        this.okPasteValue();
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
    }

    @Override
    public String getIActionKey() {
        return "graphs_legacy_dialogs_popu_pyramid";
    }

    @Override
    public String getDialogHelpID() {
        return "IDH_IDD_POPULATION_PYRAMID";
    }

    @Override
    public void reset() {
        super.reset();
        this.mSrcVarList.removeAll();
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcVarList.requestFocus();
        this.mTargetDistributionList.removeAll();
        this.mTargetRowsList.removeAll();
        this.mArrowButtonForRowsList.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
        this.mTargetSplitList.removeAll();
        this.mTargetVarCountList.removeAll();
        this.mFileNameLabel.setText("");
        if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
            this.mCatOptionsButton.setText(this.getResString("IDS_POPU_PYRAMID_SCALE_OPTION_BUTTON_MAC"));
        } else {
            this.mCatOptionsButton.setText(this.getResString("IDS_POPU_PYRAMID_SCALE_OPTION_BUTTON"));
        }
        this.setDefaults();
    }

    @Override
    public String generateSyntax() {
        String string;
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        stringBuffer.append(SyntaxUtil.getMainCommand("XGRAPH"));
        stringBuffer.append(SyntaxUtil.getMainCommandParamters("CHART="));
        String string2 = "";
        if (this.mComputeCountRadio.isSelected() && !this.mTargetDistributionList.getModel().getElementAt(0).getDisplayMeasurementLevel().equals((Object)MeasurementLevel.scale)) {
            string2 = string2 + "([COUNT][BAR])";
        }
        if (this.mComputeCountRadio.isSelected() && this.mTargetDistributionList.getModel().getElementAt(0).getDisplayMeasurementLevel().equals((Object)MeasurementLevel.scale)) {
            string2 = string2 + "[HISTOBAR]";
        }
        if (this.mGetCountRadio.isSelected()) {
            string2 = string2 + "(" + this.mTargetVarCountList.getModel().getElementAt(0).getName() + " [SUM] [BAR])";
        }
        string2 = string2 + " BY ";
        string2 = string2 + this.mTargetDistributionList.getModel().getElementAt(0).getName() + this.getVarType(this.mTargetDistributionList.getModel().getElementAt(0)) + " BY " + this.mTargetSplitList.getModel().getElementAt(0).getName() + "[c]";
        stringBuffer.append(string2);
        stringBuffer.append("\n" + SyntaxUtil.getSingleValueSubCommand("COORDINATE SPLIT", "YES", false));
        String string3 = "";
        boolean bl = false;
        for (int i = 0; i < this.mTargetRowsList.getModel().getSize(); ++i) {
            string3 = string3 + this.mTargetRowsList.getModel().getElementAt(i).getName() + " ";
            bl = true;
        }
        if (bl) {
            stringBuffer.append("\n");
        }
        stringBuffer.append(SyntaxUtil.getSingleValueSubCommand("PANEL ROWVAR", string3, false));
        if (this.mTargetRowsList.getModel().getSize() > 0) {
            if (this.mNestRowCheck.isSelected() && this.mNestRowCheck.isEnabled() && this.mTargetRowsList.getModel().getSize() > 1) {
                stringBuffer.append("ROWOP=NEST");
            } else {
                stringBuffer.append("ROWOP=CROSS");
            }
        }
        if (!this.mTargetDistributionList.getModel().getElementAt(0).getDisplayMeasurementLevel().equals((Object)MeasurementLevel.scale)) {
            Boolean bl2 = dialogDataModel.getBoolean("IDS_POPU_PYRAMID_DISPLAY_GROUPS_DEFINED_BY_MISSING_VALUES");
            if (bl2 != null && bl2.booleanValue()) {
                stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/MISSING") + " USE=LISTWISE REPORT=YES");
            }
            if (this.mComputeCountRadio.isSelected() && (bl2 = dialogDataModel.getBoolean("IDS_POPU_PYRAMID_CONFIDENCE_INTERVALS")) != null && bl2.booleanValue() && (string = dialogDataModel.getString("IDS_LEVEL")) != null && string.length() > 0) {
                stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/ERRORBAR CI(") + string + ")");
            }
        } else {
            Boolean bl3 = dialogDataModel.getBoolean(CUSTOM_VAL_RADIO);
            if (bl3 != null && bl3.booleanValue()) {
                string = dialogDataModel.getString(CUSTOM_VAL);
                SPSS_Format sPSS_Format = (SPSS_Format)dialogDataModel.getSerializableObject("DISTRI_VAR_FORMAT");
                if (string != null) {
                    if (sPSS_Format.getFormatType().isDateOrTimeFormat()) {
                        string = "'" + string + "'";
                    }
                    stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/BIN START=") + string);
                }
            } else {
                stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/BIN START=AUTO"));
            }
            bl3 = dialogDataModel.getBoolean(BIN_CUSTOM);
            if (bl3 != null && bl3.booleanValue()) {
                bl3 = dialogDataModel.getBoolean("IDS_POPU_PYRAMID_SCALE_BIN_NUM_INTERVALS");
                string = "";
                if (bl3 != null && bl3.booleanValue() && (string = dialogDataModel.getString(NUMBER_INTERVAL)) != null) {
                    stringBuffer.append(" SIZE=COUNT(" + string + ")");
                }
                if ((bl3 = dialogDataModel.getBoolean("IDS_POPU_PYRAMID_SCALE_BIN_INTERVALS_WIDTH")) != null && bl3.booleanValue() && (string = dialogDataModel.getString(INTERVAL_WIDTH)) != null) {
                    stringBuffer.append(" SIZE=WIDTH(" + string + ")");
                }
            } else {
                stringBuffer.append(" SIZE=AUTO");
            }
            bl3 = dialogDataModel.getBoolean("IDS_POPU_PYRAMID_SCALE_DISP_CURVE");
            if (bl3 != null && bl3.booleanValue()) {
                stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/DISTRIBUTION TYPE=NORMAL"));
            }
        }
        if (this.mUseChartCheck.isSelected() && this.mFileNameLabel.getText().length() > 0) {
            stringBuffer.append("\n" + SyntaxUtil.getSingleValueSubCommand("TEMPLATE FILE", CharacterUtil.smartQuote((String)this.mFileNameLabel.getText()), false));
        }
        if ((string = this.generateSyntaxForTitle()).length() > 0) {
            stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/TITLES"));
            stringBuffer.append(string);
        }
        stringBuffer.append(SyntaxUtil.terminateSyntax().toString());
        return stringBuffer.toString();
    }

    @Override
    protected void saveDialogState() {
        super.saveDialogState();
        this.getDialogDataModel().putString("FILE_TEXT", this.mFileNameLabel.getText());
    }

    @Override
    protected void loadDialogState() {
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        if (dialogDataModel.getString("FILE_TEXT") != null) {
            this.mFileNameLabel.setText(dialogDataModel.getString("FILE_TEXT"));
        }
        this.okPasteValue();
        super.loadDialogState();
        this.mSrcVarList.setSelectedIndex(0);
    }

    @Override
    protected void init() {
        super.init();
        this.normalizeButtonWidths(this.mOptionButtonPanel);
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBorder(BorderFactory.createEmptyBorder());
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_POPU_PYRAMID_SOURCE_LIST_LABEL");
        jLabel.setLabelFor(this.mSrcVarList);
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel2, jLabel, gridBagConstraints, 0, 0, 1, 1, n, null);
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(0, n2, 0, 0);
        JScrollPane jScrollPane = new JScrollPane(this.mSrcVarList);
        jScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel2, jScrollPane, gridBagConstraints, 0, 1, 1, 1, n, null);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 5, n, null);
        gridBagConstraints.fill = 2;
        JPanel jPanel3 = this.setupCountsPanel();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 1, 0, 1, 1, n, insets);
        jPanel3 = this.setupDistributionOverPanel();
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 1, 2, 1, 1, n, new Insets(n2, n2, 0, 0));
        jPanel3 = this.setupSplitByPanel();
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 1, 3, 1, 1, n, new Insets(n2, n2, 0, 0));
        gridBagConstraints.fill = 1;
        jPanel3 = this.setupRowsPanel();
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 1, 4, 1, 1, n, new Insets(n2, n2, 0, 0));
        jPanel3 = this.setupTemplatePanel();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.0;
        n = 23;
        insets.set(n2, 0, n2, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 5, 2, 1, n, insets);
        this.setTabTraversalPolicy();
        this.pack();
    }

    @Override
    protected JPanel setupOptionsButtonPanel() {
        JPanel jPanel = super.setupOptionsButtonPanel();
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction("IDS_REPORT_COMMON_TITLES_3DOT"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PopulationPyramidDlg.this.runTitleSubDialog();
            }
        };
        this.mTitleButton = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, this.mTitleButton);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_POPU_PYRAMID_SCALE_OPTION_BUTTON"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PopulationPyramidDlg.this.runOptionSubDialog();
            }
        };
        toggleButtonAction.putValue("Name", this.getResString("IDS_POPU_PYRAMID_SCALE_OPTION_BUTTON"));
        this.mCatOptionsButton = new JButton(toggleButtonAction);
        if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
            this.mCatOptionsButton.setText(this.getResString("IDS_POPU_PYRAMID_SCALE_OPTION_BUTTON_MAC"));
        }
        this.addOptionsPanelButton(jPanel, this.mCatOptionsButton);
        return jPanel;
    }

    private String getVarType(ISpssVariable iSpssVariable) {
        if (iSpssVariable.getDisplayMeasurementLevel().equals((Object)MeasurementLevel.scale)) {
            return "[s]";
        }
        return "[c]";
    }

    private void normalizeButtonWidths(JPanel jPanel) {
        Serializable serializable;
        JButton jButton;
        int n = 40;
        for (Component component : jPanel.getComponents()) {
            int n2;
            if (!(component instanceof JButton)) continue;
            jButton = (JButton)component;
            serializable = jButton.getFontMetrics(jButton.getFont());
            String string = jButton.getText();
            if (string.contains("<br>")) {
                string = string.replaceAll("<html>", "");
                string = string.replaceAll("</html>", "");
                String[] stringArray = string.split("<br>");
                String string2 = stringArray[0];
                for (String string3 : stringArray) {
                    if (string3.length() <= string2.length()) continue;
                    string2 = string3;
                }
                string = string2;
            }
            n = n > (n2 = serializable.stringWidth(string)) ? n : n2;
        }
        for (Component component : jPanel.getComponents()) {
            if (!(component instanceof JButton)) continue;
            jButton = (JButton)component;
            serializable = jButton.getPreferredSize();
            ((Dimension)serializable).width = n + jButton.getInsets().left + jButton.getInsets().right;
            jButton.setPreferredSize((Dimension)serializable);
            jButton.setMaximumSize((Dimension)serializable);
            jButton.setMinimumSize((Dimension)serializable);
        }
    }

    private void okPasteValue() {
        if (this.mUseChartCheck.isSelected() && this.mFileNameLabel.getText().length() == 0 || this.mGetCountRadio.isSelected() && this.mTargetVarCountList.getModel().getSize() == 0 || this.mTargetDistributionList.getModel().getSize() == 0 || this.mTargetSplitList.getModel().getSize() == 0) {
            this.enableOkPaste(false);
        } else {
            this.enableOkPaste(true);
        }
    }

    private void runTitleSubDialog() {
        this.runSubDialog(new TitlesSubDialog(this));
    }

    private void runOptionSubDialog() {
        if (this.mTargetDistributionList.getModel().getElementAt(0).getDisplayMeasurementLevel().equals((Object)MeasurementLevel.scale)) {
            this.runSubDialog(new PopulationPyramidScaleOptions(this));
        } else {
            this.getDialogDataModel().putBoolean(ENABLE_DISPLAY_ERROR_BAR, this.mComputeCountRadio.isSelected());
            this.runSubDialog(new PopulationPyramidCatOptions(this));
        }
    }

    private JPanel setupCountsPanel() {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        TitledBorder titledBorder = new TitledBorder(this.getResString("IDS_POPU_PYRAMID_COUNT_PANEL_TITLE"));
        jPanel.setBorder(titledBorder);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getGroupBoxInnerMargin();
        int n2 = 23;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel, this.mComputeCountRadio, gridBagConstraints, 0, 0, 2, 1, n2, insets);
        DialogUtil.addUsingGBL(jPanel, this.mGetCountRadio, gridBagConstraints, 0, 1, 2, 1, n2, insets);
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_VARIABLE");
        jLabel.setLabelFor(this.mTargetVarCountList);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 1, 2, 1, 1, n2, new Insets(0, n, 0, 0));
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        n2 = 20;
        DialogUtil.addUsingGBL(jPanel, this.mArrowButtonForVarCountList, gridBagConstraints, 0, 2, 1, 2, n2, new Insets(0, this.mGap * 2, n, 0));
        JScrollPane jScrollPane = new JScrollPane(this.mTargetVarCountList);
        jScrollPane.setPreferredSize(this.mTargetVarCountList.getMinimumSize());
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setVerticalScrollBarPolicy(21);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        n2 = 23;
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 1, 3, 1, 1, n2, new Insets(0, n, n, n));
        return jPanel;
    }

    private JPanel setupDistributionOverPanel() {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_POPU_PYRAMID_DISTRIBUTION_LIST_LABEL");
        jLabel.setLabelFor(this.mTargetDistributionList);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 1, 0, 1, 1, n, new Insets(0, n2, 0, 0));
        n = 20;
        DialogUtil.addUsingGBL(jPanel, this.mArrowButtonForDistributionList, gridBagConstraints, 0, 0, 1, 2, n, new Insets(0, this.mGap * 2 + 5, 0, 0));
        JScrollPane jScrollPane = new JScrollPane(this.mTargetDistributionList);
        jScrollPane.setPreferredSize(this.mTargetDistributionList.getMinimumSize());
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setVerticalScrollBarPolicy(21);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        n = 23;
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 1, 1, 1, 1, n, new Insets(0, n2, 0, 0));
        gridBagConstraints.fill = 0;
        URL uRL = null;
        uRL = this.getResImageURL("IDS_DIST_IMAGE");
        JLabel jLabel2 = new JLabel();
        jLabel2.setIcon(new ImageIcon(uRL));
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 2, 0, 1, 2, n, null);
        return jPanel;
    }

    private JPanel setupSplitByPanel() {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_POPU_PYRAMID_SPLIT_LIST_LABEL");
        jLabel.setLabelFor(this.mTargetSplitList);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 1, 0, 1, 1, n, new Insets(0, n2, 0, 0));
        n = 20;
        DialogUtil.addUsingGBL(jPanel, this.mArrowButtonForSplitList, gridBagConstraints, 0, 0, 1, 2, n, new Insets(0, this.mGap * 2 + 5, 0, 0));
        JScrollPane jScrollPane = new JScrollPane(this.mTargetSplitList);
        jScrollPane.setPreferredSize(this.mTargetSplitList.getMinimumSize());
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setVerticalScrollBarPolicy(21);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        n = 23;
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 1, 1, 1, 1, n, new Insets(0, n2, 0, 0));
        gridBagConstraints.fill = 0;
        URL uRL = null;
        uRL = this.getResImageURL("IDS_SPLIT_IMAGE");
        JLabel jLabel2 = new JLabel();
        jLabel2.setIcon(new ImageIcon(uRL));
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 2, 0, 1, 2, n, null);
        return jPanel;
    }

    private JPanel setupRowsPanel() {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        TitledBorder titledBorder = new TitledBorder(this.getResString("IDS_POPU_PYRAMID_PANELBY_TITLE"));
        jPanel.setBorder(titledBorder);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_POPU_PYRAMID_ROW_LIST_LABEL");
        jLabel.setLabelFor(this.mTargetRowsList);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 1, 0, 1, 1, n, new Insets(0, n2, 0, 0));
        DialogUtil.addUsingGBL(jPanel, this.mArrowButtonForRowsList, gridBagConstraints, 0, 1, 1, 1, 10, new Insets(0, this.mGap * 2, 0, 0));
        JScrollPane jScrollPane = new JScrollPane(this.mTargetRowsList);
        int n3 = DialogUtil.getComponentGroupGap();
        this.mTargetRowsList.setMinimumSize(new Dimension(n3 * 13 + 7, n3 * 5 + 5));
        jScrollPane.setPreferredSize(this.mTargetRowsList.getMinimumSize());
        n = 23;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 1, 1, 1, 1, n, new Insets(0, n2, 0, n2));
        gridBagConstraints.fill = 0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mNestRowCheck, gridBagConstraints, 1, 2, 1, 1, n, new Insets(0, n2, n2, n2));
        return jPanel;
    }

    private JPanel setupTemplatePanel() {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        TitledBorder titledBorder = new TitledBorder(this.getResString("IDS_POPU_PYRAMID_TEMPLATE_PANEL_TITLE"));
        jPanel.setBorder(titledBorder);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        int n3 = DialogUtil.getGroupBoxInnerMargin();
        gridBagConstraints.fill = 0;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel, this.mUseChartCheck, gridBagConstraints, 0, 0, 2, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mFileButton, gridBagConstraints, 0, 1, 1, 1, n, new Insets(n3, n3, n3, 0));
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mFileNameLabel), gridBagConstraints, 1, 1, 1, 1, n, new Insets(n2 + insets.bottom, n2, n3, n3));
        return jPanel;
    }

    private void initVars() {
        this.mSrcVarList = new SrcVariableList();
        this.mSrcVarList.setContextMenuFlags(this.mSrcVarList.getContextMenuFlags() | 8);
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcVarList.setLoadFromPersistent(true);
        this.mTargetVarCountList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mTargetVarCountList.setIdentifier("TARGET_VAR_COUNT_LIST");
        this.mTargetVarCountList.addVarFilter(new SpssVarFilter(8, false));
        this.mTargetVarCountList.getModel().addListDataListener(this);
        this.mArrowButtonForVarCountList = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mArrowButtonForVarCountList.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mArrowButtonForVarCountList.registerVariableList(this.mTargetVarCountList, SpssArrowButton.ButtonOrientation.left);
        this.mTargetDistributionList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mTargetDistributionList.setIdentifier("TARGET_DITRIBUTION_LIST");
        this.mTargetDistributionList.getModel().addListDataListener(this);
        this.mArrowButtonForDistributionList = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mArrowButtonForDistributionList.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mArrowButtonForDistributionList.registerVariableList(this.mTargetDistributionList, SpssArrowButton.ButtonOrientation.left);
        this.mTargetSplitList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mTargetSplitList.setIdentifier("TARGET_SPLIT_LIST");
        this.mTargetSplitList.getModel().addListDataListener(this);
        this.mArrowButtonForSplitList = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mArrowButtonForSplitList.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mArrowButtonForSplitList.registerVariableList(this.mTargetSplitList, SpssArrowButton.ButtonOrientation.left);
        this.mTargetRowsList = new TargetVariableList(TargetVariableList.TargetListType.normal);
        this.mTargetRowsList.setIdentifier("TARGET_ROW_LIST");
        this.mTargetRowsList.getModel().addListDataListener(this);
        this.mArrowButtonForRowsList = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mArrowButtonForRowsList.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mArrowButtonForRowsList.registerVariableList(this.mTargetRowsList, SpssArrowButton.ButtonOrientation.left);
        this.mFileNameLabel = new FileTextField();
        this.mFileNameLabel.setBorder(BorderFactory.createEmptyBorder());
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, COMPUTE_RADIO_KEY);
        this.mComputeCountRadio = new JRadioButton(toggleButtonAction);
        this.mComputeCountRadio.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this, GET_COUNT_RADIO_KEY);
        this.mGetCountRadio = new JRadioButton(toggleButtonAction);
        this.mGetCountRadio.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this, USE_CHART_CHECK);
        this.mButtonGroup = new SpssButtonGroup();
        this.mButtonGroup.add(this.mComputeCountRadio);
        this.mButtonGroup.add(this.mGetCountRadio);
        this.mUseChartCheck = new JCheckBox(toggleButtonAction);
        this.mUseChartCheck.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this, FILE_BUTTON_KEY){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PopulationPyramidDlg.this.openTemplateFile();
            }
        };
        this.mFileButton = new JButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_POPU_PYRAMID_NEST_VAR_CHECK");
        this.mNestRowCheck = new JCheckBox(toggleButtonAction);
        this.mGap = DialogUtil.getComponentGroupGap();
        this.setDefaults();
    }

    private void setDefaults() {
        DialogUtil.enableHTMLComponent(this.mCatOptionsButton, false);
        this.mSrcVarList.setSelectedIndex(0);
        this.mNestRowCheck.setEnabled(false);
        this.mNestRowCheck.setSelected(false);
        this.mComputeCountRadio.setSelected(true);
        this.mGetCountRadio.setSelected(false);
        this.mArrowButtonForVarCountList.setEnabled(false);
        this.mTargetVarCountList.setEnabled(false);
        this.mTargetVarCountList.setOpaque(false);
        this.mUseChartCheck.setSelected(false);
        this.mFileButton.setEnabled(false);
        this.mFileNameLabel.setOpaque(false);
        this.mFileNameLabel.setText("");
        this.mFileNameLabel.setEditable(false);
        this.mFileNameLabel.setCaretPosition(0);
    }

    private void openTemplateFile() {
        GraphsRemoteFileChooser graphsRemoteFileChooser = new GraphsRemoteFileChooser(this);
        int n = graphsRemoteFileChooser.showOpenDialog((Component)((Object)this));
        if (n == 0) {
            this.mFileNameLabel.setText(graphsRemoteFileChooser.getSelectedFilePath());
            this.okPasteValue();
        }
    }

    private String generateSyntaxForTitle() {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        String string2 = "";
        String string3 = dialogDataModel.getString("IDS_TITLE_LINE1_EDIT");
        String string4 = dialogDataModel.getString("IDS_TITLE_LINE2_EDIT");
        if (string3 != null && string3.length() > 0) {
            string2 = string2 + CharacterUtil.smartQuote((String)string3) + " ";
        }
        if (string4 != null && string4.length() > 0) {
            string2 = string2 + CharacterUtil.smartQuote((String)string4);
        }
        if (string2.length() != 0) {
            stringBuffer.append("\n   TITLE=" + string2);
        }
        if ((string = dialogDataModel.getString("IDS_SUBTITLE_EDIT")) != null && string.length() > 0) {
            string = CharacterUtil.smartQuote((String)string);
            stringBuffer.append("\n   SUBTITLE=" + string);
        }
        String string5 = "";
        String string6 = dialogDataModel.getString("IDS_FOOTNOTE_LINE1_EDIT");
        String string7 = dialogDataModel.getString("IDS_FOOTNOTE_LINE2_EDIT");
        if (string6 != null && string6.length() > 0) {
            string5 = string5 + CharacterUtil.smartQuote((String)string6) + " ";
        }
        if (string7 != null && string7.length() > 0) {
            string5 = string5 + CharacterUtil.smartQuote((String)string7);
        }
        if (string5.length() != 0) {
            stringBuffer.append("\n   FOOTNOTE=" + string5);
        }
        return stringBuffer.toString();
    }

    private void setTabTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcVarList);
        vector.add(this.mButtonGroup);
        vector.add(this.mArrowButtonForVarCountList);
        vector.add(this.mArrowButtonForDistributionList);
        vector.add(this.mArrowButtonForSplitList);
        vector.add(this.mArrowButtonForRowsList);
        vector.add(this.mTargetVarCountList);
        vector.add(this.mTargetDistributionList);
        vector.add(this.mTargetSplitList);
        vector.add(this.mTargetRowsList);
        vector.add(this.mNestRowCheck);
        vector.add(this.mUseChartCheck);
        vector.add(this.mFileButton);
        vector.add(this.mTitleButton);
        vector.add(this.mCatOptionsButton);
        for (Component component : this.mCmdButtonPanel.getComponents()) {
            vector.add(component);
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private void onRowListDataEvent() {
        this.mNestRowCheck.setEnabled(this.mTargetRowsList.getModel().getSize() >= 2);
    }
}

