/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.graphs.legacy_dialogs.population_pyramid;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.controls.FixedLengthNumericDocument;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.uitools.controls.ContextEnabledTextField;
import com.spss.uitools.controls.IntTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class PopulationPyramidCatOptions
extends BaseSubDialog
implements DocumentListener,
ItemListener {
    static final String MISSING_VALUE_CHECK = "IDS_POPU_PYRAMID_DISPLAY_GROUPS_DEFINED_BY_MISSING_VALUES";
    static final String DISPLAY_ERROR_BAR_CHECK = "IDS_POPU_PYRAMID_DISPLAY_ERROR_BARS";
    static final String CONFIDENCE_INTERVAL_RADIO = "IDS_POPU_PYRAMID_CONFIDENCE_INTERVALS";
    static final String CONFIDENCE_INTERVAL_TEXT = "IDS_LEVEL";
    private JRadioButton mConfidenceRadioButton;
    private JRadioButton mStdErrorRadioButton;
    private JRadioButton mStdDeviationRadioButton;
    private ContextEnabledTextField mConfidenceText;
    private IntTextField mStdErrorText;
    private IntTextField mStdDeviationText;
    private JCheckBox mMissingValuesCheckBox;
    private JCheckBox mErrorBarsCheckBox;
    private GridBagConstraints mConstraints;
    private Insets mInsets;
    private TitledBorder mTitleBorder;
    private JLabel mLevelLabel;
    private JLabel mMultiplierLabel1;
    private JLabel mMultiplierLabel2;
    private final String STD_DEVIATION_DEFAULT_VALUE = "2";
    private final String STD_ERROR_DEFAULT_VALUE = "2";
    private final String CONFIDENCE_DEFAULT_VALUE = "95";
    private boolean isDispErrorBarEnable;

    public PopulationPyramidCatOptions(BaseProcedureDialog baseProcedureDialog) {
        super(baseProcedureDialog, baseProcedureDialog.getResString("IDS_POPU_PYRAMID_CAT_TITLE_SUB"), true);
    }

    @Override
    public String getDialogHelpID() {
        return "IDH_GROP";
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.mConfidenceRadioButton.isSelected()) {
            this.mLevelLabel.setEnabled(true);
            this.mConfidenceText.setEnabled(true);
            this.mConfidenceText.setOpaque(true);
            this.checkContinueButtonState((JTextField)this.mConfidenceText);
        } else {
            this.mLevelLabel.setEnabled(false);
            this.mConfidenceText.setEnabled(false);
            this.mConfidenceText.setOpaque(false);
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.checkContinueButtonState((JTextField)this.mConfidenceText);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.checkContinueButtonState((JTextField)this.mConfidenceText);
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public boolean continuePressed() {
        Double d;
        String string = this.mConfidenceText.getText();
        if (!string.equals(".") && (d = Double.valueOf(Double.parseDouble(string))) >= 50.0 && d <= 99.9) {
            return true;
        }
        SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_POPU_PYRAMID_CONF_INTERVAL_RANGE"), VersionInfo.getAppVersionString());
        return false;
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        super.loadState(dialogDataModel);
        if (dialogDataModel.getBoolean("ENABLE_DISPLAY_ERROR_BAR") != null) {
            this.isDispErrorBarEnable = dialogDataModel.getBoolean("ENABLE_DISPLAY_ERROR_BAR");
        }
        this.mErrorBarsCheckBox.setEnabled(this.isDispErrorBarEnable);
        this.mConfidenceRadioButton.setEnabled(this.mErrorBarsCheckBox.isSelected());
        this.mConfidenceText.setEnabled(this.mErrorBarsCheckBox.isSelected());
        this.mConfidenceText.setOpaque(this.mErrorBarsCheckBox.isSelected());
        this.mLevelLabel.setEnabled(this.mErrorBarsCheckBox.isSelected());
    }

    @Override
    protected boolean saveState(DialogDataModel dialogDataModel) {
        return super.saveState(dialogDataModel);
    }

    @Override
    protected void init() {
        super.init();
        JPanel jPanel = this.getViewPanel();
        this.initVars();
        JPanel jPanel2 = this.setupMissingValuesPanel();
        this.mConstraints.weightx = 1.0;
        this.mConstraints.weighty = 1.0;
        this.mConstraints.fill = 1;
        int n = DialogUtil.getComponentGroupGap();
        int n2 = 23;
        DialogUtil.addUsingGBL(jPanel, jPanel2, this.mConstraints, 0, 0, 1, 1, n2, null);
        this.mConstraints.fill = 0;
        JPanel jPanel3 = this.setupCheckBoxPanel();
        this.mConstraints.weighty = 0.0;
        this.mInsets.set(n, DialogUtil.getStandardControlInsets().left, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel3, this.mConstraints, 0, 1, 1, 1, n2, this.mInsets);
        JPanel jPanel4 = this.setupErrorsRepresentPanel();
        this.mConstraints.weighty = 1.0;
        this.mConstraints.fill = 1;
        this.mInsets.set(n, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel4, this.mConstraints, 0, 3, 1, 1, n2, this.mInsets);
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        spssButtonGroup.add(this.mConfidenceRadioButton);
        spssButtonGroup.add(this.mStdErrorRadioButton);
        spssButtonGroup.add(this.mStdDeviationRadioButton);
        this.setupFocusTraversalPolicy();
        this.pack();
    }

    private void setupFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mMissingValuesCheckBox);
        vector.add(this.mErrorBarsCheckBox);
        vector.add(this.mConfidenceRadioButton);
        vector.add(this.mConfidenceText);
        Component component = this.mCmdButtonPanel.getComponent(0);
        Component component2 = this.mCmdButtonPanel.getComponent(1);
        Component component3 = this.mCmdButtonPanel.getComponent(2);
        vector.add(component);
        vector.add(component2);
        vector.add(component3);
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private JPanel setupErrorsRepresentPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.mTitleBorder = new TitledBorder(this.getResString("IDS_POPU_PYRAMID_ERROR_BARS_REPRESENT"));
        jPanel.setBorder(this.mTitleBorder);
        this.mConstraints.weightx = 1.0;
        this.mConstraints.weighty = 0.0;
        int n = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = DialogUtil.getStandardControlInsets();
        int n2 = 23;
        this.mInsets.set(n, n, 0, n);
        DialogUtil.addUsingGBL(jPanel, this.mConfidenceRadioButton, this.mConstraints, 0, 0, 2, 1, n2, this.mInsets);
        this.mConstraints.weightx = 0.0;
        int n3 = DialogUtil.getComponentGroupGap();
        Insets insets2 = new Insets(0, n3 * 2 + 3, 5, 3);
        DialogUtil.addUsingGBL(jPanel, this.mLevelLabel, this.mConstraints, 0, 1, 1, 1, n2, insets2);
        this.mConstraints.fill = 0;
        this.mInsets.set(insets.top, insets.left, 0, n);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mConfidenceText, this.mConstraints, 1, 1, 1, 1, n2, this.mInsets);
        this.mConstraints.weightx = 1.0;
        this.mInsets.set(n, n, 0, n);
        DialogUtil.addUsingGBL(jPanel, this.mStdErrorRadioButton, this.mConstraints, 0, 2, 2, 1, n2, this.mInsets);
        this.mConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mMultiplierLabel1, this.mConstraints, 0, 3, 1, 1, n2, insets2);
        this.mConstraints.fill = 0;
        this.mInsets.set(insets.top, insets.left, 0, n);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mStdErrorText, this.mConstraints, 1, 3, 1, 1, n2, this.mInsets);
        this.mConstraints.weightx = 1.0;
        this.mInsets.set(n, n, 0, n);
        DialogUtil.addUsingGBL(jPanel, this.mStdDeviationRadioButton, this.mConstraints, 0, 4, 2, 1, n2, this.mInsets);
        this.mConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mMultiplierLabel2, this.mConstraints, 0, 5, 1, 1, n2, insets2);
        this.mConstraints.weighty = 1.0;
        this.mConstraints.fill = 0;
        this.mInsets.set(DialogUtil.getStandardControlInsets().top, DialogUtil.getStandardControlInsets().left, DialogUtil.getGroupBoxInnerMargin(), DialogUtil.getGroupBoxInnerMargin());
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mStdDeviationText, this.mConstraints, 1, 5, 1, 1, n2, this.mInsets);
        return jPanel;
    }

    private JPanel setupCheckBoxPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.mConstraints.weightx = 1.0;
        this.mConstraints.weighty = 0.0;
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = DialogUtil.getGroupBoxInnerMargin();
        int n2 = DialogUtil.getComponentGroupGap();
        int n3 = 23;
        this.mInsets.set(0, n, 0, n);
        JCheckBox jCheckBox = new JCheckBox(new ToggleButtonAction(this.mParentDlg, "IDS_POPU_PYRAMID_DISPLAY_CHART_WITH_CASE_LABELS"));
        jCheckBox.setEnabled(false);
        DialogUtil.addUsingGBL(jPanel, jCheckBox, this.mConstraints, 0, 0, 1, 1, n3, this.mInsets);
        JSeparator jSeparator = new JSeparator(0);
        this.mConstraints.fill = 2;
        jSeparator.setBounds(0, 0, 100, 100);
        jSeparator.setEnabled(true);
        jSeparator.setSize(50, 1);
        DialogUtil.addUsingGBL(jPanel, jSeparator, this.mConstraints, 0, 1, 1, 1, n3, new Insets(n2, n2, n2, n2));
        this.mInsets.set(insets.top, n, 0, n);
        this.mConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mErrorBarsCheckBox, this.mConstraints, 0, 2, 1, 1, n3, this.mInsets);
        return jPanel;
    }

    private JPanel setupMissingValuesPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.mTitleBorder = new TitledBorder(this.getResString("IDS_POPU_PYRAMID_MISSING_VALUES"));
        jPanel.setBorder(this.mTitleBorder);
        this.mConstraints.weightx = 0.0;
        this.mConstraints.weighty = 0.0;
        this.mConstraints.fill = 2;
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        JRadioButton jRadioButton = new JRadioButton(new ToggleButtonAction(this.mParentDlg, "IDS_POPU_PYRAMID_EXCLUDE_CASES_LISTWISE"));
        jRadioButton.setSelected(true);
        jRadioButton.setEnabled(false);
        JRadioButton jRadioButton2 = new JRadioButton(new ToggleButtonAction(this.mParentDlg, "IDS_POPU_PYRAMID_EXCLUDE_CASES_VARIABLE_BY_VARIABLE"));
        jRadioButton2.setEnabled(false);
        spssButtonGroup.add(jRadioButton);
        spssButtonGroup.add(jRadioButton2);
        this.mConstraints.weightx = 1.0;
        int n = DialogUtil.getGroupBoxInnerMargin();
        int n2 = 23;
        this.mInsets.set(n, n, 0, n);
        DialogUtil.addUsingGBL(jPanel, jRadioButton, this.mConstraints, 0, 0, 1, 1, n2, this.mInsets);
        this.mConstraints.weighty = 1.0;
        Insets insets = DialogUtil.getStandardControlInsets();
        this.mInsets.set(insets.top, n, n, n);
        DialogUtil.addUsingGBL(jPanel, jRadioButton2, this.mConstraints, 0, 1, 1, 1, n2, this.mInsets);
        JSeparator jSeparator = new JSeparator(0);
        jSeparator.setBounds(0, 0, 99, 99);
        jSeparator.setSize(100, 1);
        this.mConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jSeparator, this.mConstraints, 0, 2, 1, 1, n2, this.mInsets);
        this.mConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mMissingValuesCheckBox, this.mConstraints, 0, 3, 1, 1, n2, this.mInsets);
        return jPanel;
    }

    private void initVars() {
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, CONFIDENCE_INTERVAL_RADIO);
        this.mConfidenceRadioButton = new JRadioButton(toggleButtonAction);
        this.mConfidenceRadioButton.addItemListener(this);
        this.mLevelLabel = DialogUtil.createLabel(this, "IDS_POPU_PYRAMID_LEVEL");
        this.mConfidenceText = new ContextEnabledTextField(5);
        FixedLengthNumericDocument fixedLengthNumericDocument = new FixedLengthNumericDocument(5, true, true);
        this.mConfidenceText.setDocument((Document)fixedLengthNumericDocument);
        this.mConfidenceText.setColumns(5);
        this.mConfidenceText.setAction((Action)new TextFieldAction(this, CONFIDENCE_INTERVAL_TEXT));
        this.mConfidenceText.getDocument().addDocumentListener(this);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_POPU_PYRAMID_STANDARD_ERROR");
        this.mStdErrorRadioButton = new JRadioButton(toggleButtonAction);
        this.mStdErrorRadioButton.addItemListener(this);
        this.mMultiplierLabel1 = DialogUtil.createLabel(this, "IDS_POPU_PYRAMID_MULTIPLIER1");
        this.mStdErrorText = new IntTextField(1, 99999, true);
        this.mStdErrorText.setColumns(5);
        this.mStdErrorText.setDocument((Document)new FixedLengthNumericDocument(5, true, false));
        this.mStdErrorText.setAction((Action)new TextFieldAction(this, "IDS_POPU_PYRAMID_MULTIPLIER1"));
        this.mStdErrorText.getDocument().addDocumentListener(this);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_POPU_PYRAMID_STANDARD_DEVIATION");
        this.mStdDeviationRadioButton = new JRadioButton(toggleButtonAction);
        this.mStdDeviationRadioButton.addItemListener(this);
        this.mMultiplierLabel2 = DialogUtil.createLabel(this, "IDS_POPU_PYRAMID_MULTIPLIER2");
        this.mStdDeviationText = new IntTextField(1, 99999, true);
        this.mStdDeviationText.setColumns(5);
        this.mStdDeviationText.setDocument((Document)new FixedLengthNumericDocument(5, true, false));
        this.mStdDeviationText.setAction((Action)new TextFieldAction(this, "IDS_POPU_PYRAMID_MULTIPLIER2"));
        this.mStdDeviationText.getDocument().addDocumentListener(this);
        this.mMissingValuesCheckBox = new JCheckBox(new ToggleButtonAction(this, MISSING_VALUE_CHECK));
        this.mErrorBarsCheckBox = new JCheckBox();
        this.mErrorBarsCheckBox.setAction(new ToggleButtonAction(this, DISPLAY_ERROR_BAR_CHECK){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
                if (jCheckBox.isSelected()) {
                    PopulationPyramidCatOptions.this.mConfidenceRadioButton.setEnabled(true);
                    PopulationPyramidCatOptions.this.mConfidenceText.setEnabled(true);
                    PopulationPyramidCatOptions.this.mConfidenceText.setOpaque(true);
                    PopulationPyramidCatOptions.this.mLevelLabel.setEnabled(true);
                } else {
                    PopulationPyramidCatOptions.this.mConfidenceRadioButton.setEnabled(false);
                    PopulationPyramidCatOptions.this.mConfidenceText.setEnabled(false);
                    PopulationPyramidCatOptions.this.mConfidenceText.setOpaque(false);
                    PopulationPyramidCatOptions.this.mLevelLabel.setEnabled(false);
                    PopulationPyramidCatOptions.this.enableContinue(true);
                }
            }
        });
        this.mConstraints = new GridBagConstraints();
        this.mInsets = new Insets(0, 0, 0, 0);
        this.setDefaults();
    }

    private void setDefaults() {
        this.mMissingValuesCheckBox.setEnabled(true);
        this.mConfidenceRadioButton.setSelected(true);
        this.mConfidenceRadioButton.setEnabled(false);
        this.mLevelLabel.setEnabled(false);
        this.mConfidenceText.setText("95");
        this.mConfidenceText.setEnabled(false);
        this.mConfidenceText.setOpaque(false);
        this.mStdErrorRadioButton.setEnabled(false);
        this.mMultiplierLabel1.setEnabled(false);
        this.mStdErrorText.setText("2");
        this.mStdErrorText.setEnabled(false);
        this.mStdErrorText.setOpaque(false);
        this.mStdDeviationRadioButton.setEnabled(false);
        this.mMultiplierLabel2.setEnabled(false);
        this.mStdDeviationText.setText("2");
        this.mStdDeviationText.setEnabled(false);
        this.mStdDeviationText.setOpaque(false);
    }

    private void checkContinueButtonState(JTextField jTextField) {
        if (jTextField.isEnabled()) {
            this.enableContinue(jTextField.getText().length() > 0);
        }
    }
}

