/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.graphs.legacy_dialogs.pie;

import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.CustomVarListCellRenderer;
import com.spss.java_client.ui.controls.FileTextField;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.base.graphs.GraphsRemoteFileChooser;
import com.spss.java_client.ui.dialogs.base.graphs.GraphsTargetListMoveHandler;
import com.spss.java_client.ui.dialogs.base.graphs.GraphsUtil;
import com.spss.java_client.ui.dialogs.base.graphs.OptionsSubDialog;
import com.spss.java_client.ui.dialogs.base.graphs.TitlesSubDialog;
import com.spss.java_client.ui.dialogs.base.graphs.legacy_dialogs.pie.PieSumSPSSVarFormatter;
import com.spss.java_client.ui.dialogs.base.graphs.res.GraphsResBundle;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.uitools.util.CharacterUtil;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class PieSeparateVariablesDlg
extends BaseProcedureDialog
implements ListDataListener,
ActionListener,
ItemListener,
DocumentListener {
    private static final String FILEPATH_EDIT = "IDS_FILEPATH_EDIT";
    private static final String SOURCE_VARIABLE_LIST = "SOURCE_VARIABLE_LIST";
    private static final String SLICES_TARGET_VARIABLE_LIST = "SLICES_TARGET_VARIABLE_LIST";
    static final String COLUMNS_TARGET_VARIABLE_LIST_IDENTIFIER = "COLUMNS_TARGET_VARIABLE_LIST";
    static final String ROWS_TARGET_VARIABLE_LIST_IDENTIFIER = "ROWS_TARGET_VARIABLE_LIST";
    private SrcVariableList mSrcVariableList;
    private TargetVariableList mSlicesTargetVariableList;
    private ArrowButton mSlicesArrowButton;
    private TargetVariableList mRowsTargetList;
    private ArrowButton mRowsArrowButton;
    private JCheckBox mNestVariableRowsCheck;
    private TargetVariableList mColumnsTargetList;
    private ArrowButton mColumnsArrowButton;
    private JCheckBox mNestVariableColumnsCheck;
    private JCheckBox mUseChartSpecCheck;
    private JButton mFileButton;
    private FileTextField mFilePathEdit;
    private RemoteFileChooser mFileChooser;

    public PieSeparateVariablesDlg(JFrame jFrame) throws HeadlessException {
        super(jFrame, false, GraphsResBundle.getDefaultResourceBundleName(), GraphsResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_PIE_SV_SUMMARIES_SEPARATE_VAR_CAPTION"));
    }

    @Override
    public String getIActionKey() {
        return "graphs_legacy_dialogs_pie_summary_sep_vars";
    }

    @Override
    public String getDialogHelpID() {
        return "idh_gppv";
    }

    public void paint(Graphics graphics) {
        this.mFilePathEdit.setText(this.mFilePathEdit.getText());
        super.paint(graphics);
        super.validate();
    }

    @Override
    public String generateSyntax() {
        String string;
        DialogDataModel dialogDataModel;
        Boolean bl;
        boolean bl2;
        int n;
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        stringBuffer.append(SyntaxUtil.getMainCommand("GRAPH"));
        stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/PIE="));
        VarListModel varListModel = this.mSlicesTargetVariableList.getModel();
        int n2 = varListModel.getSize();
        for (n = 0; n < n2; ++n) {
            ISpssVariable iSpssVariable;
            if (n > 0) {
                stringBuffer.append(" ");
            }
            if ((iSpssVariable = varListModel.getElementAt(n)) == null) continue;
            stringBuffer.append("SUM(" + iSpssVariable.getName() + ")");
        }
        n = this.mColumnsTargetList.getModel().getSize() > 0 ? 1 : 0;
        boolean bl3 = bl2 = this.mRowsTargetList.getModel().getSize() > 0;
        if (n != 0 || bl2) {
            stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/PANEL"));
            if (n != 0) {
                stringBuffer.append(" COLVAR=" + this.mColumnsTargetList.getVariablesStringList());
                stringBuffer.append(" COLOP=");
                if (this.mNestVariableColumnsCheck.isSelected()) {
                    stringBuffer.append("NEST");
                } else {
                    stringBuffer.append("CROSS");
                }
            }
            if (bl2) {
                stringBuffer.append(" ROWVAR=" + this.mRowsTargetList.getVariablesStringList());
                stringBuffer.append(" ROWOP=");
                if (this.mNestVariableRowsCheck.isSelected()) {
                    stringBuffer.append("NEST");
                } else {
                    stringBuffer.append("CROSS");
                }
            }
        }
        if ((bl = (dialogDataModel = this.getDialogDataModel()).getBoolean("IDS_OPT_SUBDLG_EX_CASES_VAR_BY_VAR_RADIO")) != null && bl.booleanValue()) {
            stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/MISSING=VARIABLEWISE"));
        } else {
            stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/MISSING=LISTWISE"));
        }
        if (this.mUseChartSpecCheck.isSelected() && (string = this.mFilePathEdit.getText()) != null && string.length() > 0) {
            stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/TEMPLATE=" + CharacterUtil.smartQuote((String)string)));
        }
        if ((string = GraphsUtil.generateTitlesSubDialogSyntax(this.getDialogDataModel())).length() != 0) {
            stringBuffer.append(string);
        }
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        return stringBuffer.toString();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.mUseChartSpecCheck) {
            boolean bl = this.mUseChartSpecCheck.isSelected();
            this.mFileButton.setEnabled(bl);
            this.mFilePathEdit.setEnabled(bl);
            this.checkEnableOkPaste();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        int n;
        if (actionEvent.getSource() == this.mFileButton && (n = this.mFileChooser.showOpenDialog((Component)((Object)this))) == 0) {
            this.mFilePathEdit.setText(this.mFileChooser.getSelectedFilePath());
        }
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.doListDataChange(listDataEvent);
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.doListDataChange(listDataEvent);
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.doListDataChange(listDataEvent);
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.checkEnableOkPaste();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.checkEnableOkPaste();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.checkEnableOkPaste();
    }

    @Override
    public void reset() {
        super.reset();
        this.mSrcVariableList.removeAll();
        this.mSlicesTargetVariableList.removeAll();
        this.mRowsTargetList.removeAll();
        this.mColumnsTargetList.removeAll();
        this.mFilePathEdit.setText("");
        this.mNestVariableRowsCheck.setSelected(false);
        this.mNestVariableColumnsCheck.setSelected(false);
        this.mUseChartSpecCheck.setSelected(false);
        this.mSlicesArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
        this.mRowsArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
        this.mColumnsArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
        this.mSrcVariableList.requestFocus();
        this.setDefaults();
    }

    @Override
    public void loadDialogState() {
        super.loadDialogState();
        this.mSrcVariableList.setSelectedIndex(0);
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.mFileChooser != null) {
            this.mFileChooser.onDispose();
        }
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        this.setupUI(jPanel);
        this.setTabTraversalOrder();
        this.pack();
    }

    @Override
    protected JPanel setupOptionsButtonPanel() {
        JPanel jPanel = super.setupOptionsButtonPanel();
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction("IDS_REPORT_COMMON_TITLES_3DOT"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PieSeparateVariablesDlg.this.runTitlesSubDialog();
            }
        };
        JButton jButton = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, jButton);
        toggleButtonAction = new ToggleButtonAction("IDS_COMMON_OPTIONS_3DOT"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PieSeparateVariablesDlg.this.runOptionsSubDialog();
            }
        };
        JButton jButton2 = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, jButton2);
        return jPanel;
    }

    protected void runOptionsSubDialog() {
        this.runSubDialog(new OptionsSubDialog(this, 1041));
    }

    protected void runTitlesSubDialog() {
        this.runSubDialog(new TitlesSubDialog(this));
    }

    private void initVars() {
        this.mSrcVariableList = new SrcVariableList();
        this.mSrcVariableList.setIdentifier(SOURCE_VARIABLE_LIST);
        this.mSlicesTargetVariableList = new TargetVariableList();
        this.mSlicesTargetVariableList.setIdentifier(SLICES_TARGET_VARIABLE_LIST);
        this.mSlicesTargetVariableList.setDragType(VariableList.VarMoveType.eKeepOriginal);
        this.mSlicesTargetVariableList.setAllowDuplicates(true);
        this.mSlicesArrowButton = new ArrowButton();
        SpssVarFilter spssVarFilter = new SpssVarFilter(8, true, false);
        this.mSlicesTargetVariableList.addVarFilter(spssVarFilter);
        PieSumSPSSVarFormatter pieSumSPSSVarFormatter = new PieSumSPSSVarFormatter(this.mSlicesTargetVariableList);
        this.mSlicesTargetVariableList.setCellRenderer(new CustomVarListCellRenderer(pieSumSPSSVarFormatter));
        this.mRowsTargetList = new TargetVariableList();
        this.mRowsTargetList.setIdentifier(ROWS_TARGET_VARIABLE_LIST_IDENTIFIER);
        this.mRowsArrowButton = new ArrowButton();
        this.mColumnsTargetList = new TargetVariableList();
        this.mColumnsTargetList.setIdentifier(COLUMNS_TARGET_VARIABLE_LIST_IDENTIFIER);
        this.mColumnsArrowButton = new ArrowButton();
        this.mNestVariableRowsCheck = DialogUtil.createCheckBox(this, "IDS_PIE_SV_NEST_VAR_NO_EMPTY_ROW_CHECK", null);
        this.mNestVariableColumnsCheck = DialogUtil.createCheckBox(this, "IDS_PIE_SV_NEST_VAR_NO_EMPTY_COLS_CHECK", null);
        this.mUseChartSpecCheck = DialogUtil.createCheckBox(this, "IDS_PIE_SV_USE_CHART_CHECK", null);
        this.mFileButton = DialogUtil.createButton(this, "IDS_PIE_SV_FILE_BUTTON", this);
        this.mFilePathEdit = new FileTextField();
        this.mFilePathEdit.setAction(new TextFieldAction(this, FILEPATH_EDIT));
        this.mFilePathEdit.setBorder(BorderFactory.createEmptyBorder());
        this.mFileChooser = new GraphsRemoteFileChooser(this);
        this.setDefaults();
        this.mRowsTargetList.getModel().addListDataListener(this);
        this.mColumnsTargetList.getModel().addListDataListener(this);
        this.mSlicesTargetVariableList.getModel().addListDataListener(this);
        this.mFilePathEdit.getDocument().addDocumentListener(this);
        this.mUseChartSpecCheck.addItemListener(this);
        this.mSlicesArrowButton.registerVariableList(this.mSrcVariableList, SpssArrowButton.ButtonOrientation.right);
        this.mSlicesArrowButton.registerVariableList(this.mSlicesTargetVariableList, SpssArrowButton.ButtonOrientation.left);
        this.mRowsArrowButton.registerVariableList(this.mSrcVariableList, SpssArrowButton.ButtonOrientation.right);
        this.mRowsArrowButton.registerVariableList(this.mRowsTargetList, SpssArrowButton.ButtonOrientation.left);
        this.mColumnsArrowButton.registerVariableList(this.mSrcVariableList, SpssArrowButton.ButtonOrientation.right);
        this.mColumnsArrowButton.registerVariableList(this.mColumnsTargetList, SpssArrowButton.ButtonOrientation.left);
        this.setupMoveHandler();
    }

    private void setTabTraversalOrder() {
        Component[] componentArray;
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcVariableList);
        vector.add(this.mSlicesArrowButton);
        vector.add(this.mRowsArrowButton);
        vector.add(this.mColumnsArrowButton);
        vector.add(this.mSlicesTargetVariableList);
        vector.add(this.mRowsTargetList);
        vector.add(this.mNestVariableRowsCheck);
        vector.add(this.mColumnsTargetList);
        vector.add(this.mNestVariableColumnsCheck);
        vector.add(this.mUseChartSpecCheck);
        vector.add(this.mFileButton);
        for (Component component : componentArray = this.mOptionButtonPanel.getComponents()) {
            if (!(component instanceof JButton)) continue;
            vector.add(component);
        }
        for (Component component : componentArray = this.mCmdButtonPanel.getComponents()) {
            vector.add(component);
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private void doListDataChange(ListDataEvent listDataEvent) {
        if (listDataEvent.getSource() == this.mRowsTargetList.getModel()) {
            this.mNestVariableRowsCheck.setEnabled(this.mRowsTargetList.getModel().getSize() > 0);
        } else if (listDataEvent.getSource() == this.mColumnsTargetList.getModel()) {
            this.mNestVariableColumnsCheck.setEnabled(this.mColumnsTargetList.getModel().getSize() > 0);
        } else if (listDataEvent.getSource() == this.mSlicesTargetVariableList.getModel()) {
            this.checkEnableOkPaste();
        }
    }

    private void checkEnableOkPaste() {
        boolean bl;
        boolean bl2 = bl = this.mSlicesTargetVariableList.getModel().getSize() >= 2;
        if (bl && this.mUseChartSpecCheck.isSelected()) {
            String string = this.mFilePathEdit.getText();
            bl = string != null && string.length() > 0;
        }
        this.enableOkPaste(bl);
    }

    private void setupMoveHandler() {
        GraphsTargetListMoveHandler graphsTargetListMoveHandler = new GraphsTargetListMoveHandler(this, this.mSrcVariableList, this.mSlicesTargetVariableList.getModel());
        this.mRowsArrowButton.setVarMoveHandler(graphsTargetListMoveHandler);
        this.mColumnsArrowButton.setVarMoveHandler(graphsTargetListMoveHandler);
        this.mVarMoveHandler = graphsTargetListMoveHandler;
    }

    private void setDefaults() {
        this.mFilePathEdit.setOpaque(false);
        this.mFilePathEdit.setEditable(false);
        this.mSrcVariableList.loadFromActiveDataset();
        this.mSrcVariableList.setSelectedIndex(0);
        this.mNestVariableRowsCheck.setEnabled(false);
        this.mNestVariableColumnsCheck.setEnabled(false);
        this.mFileButton.setEnabled(false);
        this.mFilePathEdit.setText("");
        this.mFilePathEdit.setEnabled(false);
    }

    private void setupUI(JPanel jPanel) {
        JPanel jPanel2 = this.setupSeparateVariablesPanel();
        JPanel jPanel3 = this.setupTemplatePanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(n, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, 23, insets);
        gridBagConstraints.weighty = 0.0;
        insets.set(0, 0, 0, n);
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 1, 1, 1, 23, insets);
    }

    private JPanel setupSeparateVariablesPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_SOURCE_LIST_LABEL");
        jLabel.setLabelFor(this.mSrcVariableList);
        JPanel jPanel2 = this.setupPanelByPanel();
        JScrollPane jScrollPane = new JScrollPane(this.mSrcVariableList);
        jScrollPane.setPreferredSize(this.mSrcVariableList.getMinimumSize());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, 23, null);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n = DialogUtil.getComponentGroupGap();
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 1, 1, 3, 23, null);
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_PIE_SV_SLICE_REPRESENT_LABEL");
        jLabel2.setLabelFor(this.mSlicesTargetVariableList);
        JScrollPane jScrollPane2 = new JScrollPane(this.mSlicesTargetVariableList);
        jScrollPane2.setMinimumSize(this.mSlicesTargetVariableList.getMinimumSize());
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        Insets insets = DialogUtil.getArrowButtonInsets();
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets2 = new Insets(0, 3, 0, n2);
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 2, 0, 1, 1, 23, insets2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        insets2.set(0, insets.left + n2 + 3, 0, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mSlicesArrowButton, gridBagConstraints, 1, 1, 1, 1, 10, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        insets2.set(0, 3, 0, n2 + 4);
        DialogUtil.addUsingGBL(jPanel, jScrollPane2, gridBagConstraints, 2, 1, 1, 1, 23, insets2);
        insets2.set(0, n, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 1, 2, 2, 1, 23, insets2);
        return jPanel;
    }

    private JPanel setupPanelByPanel() {
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_PIE_SV_ROWS_LABEL");
        jLabel.setLabelFor(this.mRowsTargetList);
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_PIE_SV_COLUMNS_LABEL");
        jLabel2.setLabelFor(this.mColumnsTargetList);
        JComponent[] jComponentArray = new JComponent[]{jLabel, this.mRowsArrowButton, this.mRowsTargetList, this.mNestVariableRowsCheck, jLabel2, this.mColumnsArrowButton, this.mColumnsTargetList, this.mNestVariableColumnsCheck};
        return PanelFactory.getGraphsPanelByPanel(jComponentArray, this.getResString("IDS_PIE_SV_PANEL_BY_CAPTION"));
    }

    private JPanel setupTemplatePanel() {
        JComponent[] jComponentArray = new JComponent[8];
        jComponentArray[0] = this.mUseChartSpecCheck;
        jComponentArray[1] = this.mFileButton;
        jComponentArray[2] = this.mFilePathEdit;
        return PanelFactory.getGraphsChartTemplatePanel(jComponentArray, this.getResString("IDS_PIE_SV_TEMPLATE_CAPTION"));
    }
}

