/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.graphs.legacy_dialogs.pie;

import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.CustomVarListCellRenderer;
import com.spss.java_client.ui.controls.FileTextField;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.dialogs.base.graphs.GraphsRemoteFileChooser;
import com.spss.java_client.ui.dialogs.base.graphs.GraphsUtil;
import com.spss.java_client.ui.dialogs.base.graphs.OptionsSubDialog;
import com.spss.java_client.ui.dialogs.base.graphs.TitlesSubDialog;
import com.spss.java_client.ui.dialogs.base.graphs.legacy_dialogs.pie.PieSumSPSSVarFormatter;
import com.spss.java_client.ui.dialogs.base.graphs.res.GraphsResBundle;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.uitools.util.CharacterUtil;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class PieGroupsCasesDlg
extends BaseProcedureDialog
implements ItemListener,
ListDataListener,
ActionListener,
DocumentListener {
    private static final String FILEPATH_EDIT = "IDS_FILEPATH_EDIT";
    private static final String COLUMNS_TARGET_VARIABLE_LIST = "COLUMNS_TARGET_VARIABLE_LIST";
    private static final String ROWS_TARGET_VARIABLE_LIST = "ROWS_TARGET_VARIABLE_LIST";
    private static final String DEFINE_SLICES_TARGET_VARIABLE_LIST = "DEFINE_SLICES_TARGET_VARIABLE_LIST";
    private static final String VARIABLE_TARGET_VARIABLE_LIST = "VARIABLE_TARGET_VARIABLE_LIST";
    private static final String SOURCE_VARIABLE_LIST = "SOURCE_VARIABLE_LIST";
    private JRadioButton mNCasesRadio;
    private JRadioButton mPctCasesRadio;
    private JRadioButton mSumVarRadio;
    private JCheckBox mNestVariableColumnsCheck;
    private JCheckBox mNestVariableRowsCheck;
    private JCheckBox mUseChartSpecCheck;
    private JButton mFileButton;
    private JLabel mVariableLabel;
    private SrcVariableList mSrcVariableList;
    private ArrowButton mVariablesArrowButton;
    private ArrowButton mDefineSlicesArrowButton;
    private ArrowButton mRowsArrowButton;
    private ArrowButton mColumnsArrowButton;
    private TargetVariableList mVariablesTargetList;
    private TargetVariableList mDefineSlicesTargetList;
    private TargetVariableList mRowsTargetList;
    private TargetVariableList mColumnsTargetList;
    private FileTextField mFilePathEdit;
    private RemoteFileChooser mFileChooser;
    private SpssButtonGroup mSlicesRadioButtonGroup;

    public PieGroupsCasesDlg(JFrame jFrame) throws HeadlessException {
        super(jFrame, false, GraphsResBundle.getDefaultResourceBundleName(), GraphsResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_PIE_GC_SUMMARIES_GROUPS_CASES_CAPTION"));
    }

    @Override
    public String getIActionKey() {
        return "graphs_legacy_dialogs_pie_summary_groups_cases";
    }

    public void paint(Graphics graphics) {
        this.mFilePathEdit.setText(this.mFilePathEdit.getText());
        super.paint(graphics);
        super.validate();
    }

    @Override
    public String generateSyntax() {
        String string;
        DialogDataModel dialogDataModel;
        Boolean bl;
        boolean bl2;
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        stringBuffer.append(SyntaxUtil.getMainCommand("GRAPH"));
        String string2 = this.mDefineSlicesTargetList.getVariablesStringList();
        if (this.mNCasesRadio.isSelected()) {
            stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/PIE=COUNT"));
        } else if (this.mPctCasesRadio.isSelected()) {
            stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/PIE=PCT"));
        } else if (this.mSumVarRadio.isSelected()) {
            String string3 = this.mVariablesTargetList.getVariablesStringList();
            stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/PIE=SUM(") + string3 + ")");
        }
        stringBuffer.append(" BY " + string2);
        boolean bl3 = this.mColumnsTargetList.getModel().getSize() > 0;
        boolean bl4 = bl2 = this.mRowsTargetList.getModel().getSize() > 0;
        if (bl3 || bl2) {
            stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/PANEL"));
            if (bl3) {
                stringBuffer.append(" COLVAR=" + this.mColumnsTargetList.getVariablesStringList());
                stringBuffer.append(" COLOP=");
                if (this.mNestVariableColumnsCheck.isSelected()) {
                    stringBuffer.append("NEST");
                } else {
                    stringBuffer.append("CROSS");
                }
            }
            if (bl2) {
                stringBuffer.append(" ROWVAR=" + this.mRowsTargetList.getVariablesStringList());
                stringBuffer.append(" ROWOP=");
                if (this.mNestVariableRowsCheck.isSelected()) {
                    stringBuffer.append("NEST");
                } else {
                    stringBuffer.append("CROSS");
                }
            }
        }
        if ((bl = (dialogDataModel = this.getDialogDataModel()).getBoolean("IDS_OPT_SUBDLG_DISPLAY_GROUPS_CHECK")) != null && bl.booleanValue()) {
            stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/MISSING=REPORT"));
        }
        if (this.mUseChartSpecCheck.isSelected() && (string = this.mFilePathEdit.getText()) != null && string.length() > 0) {
            stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/TEMPLATE=") + CharacterUtil.smartQuote((String)string));
        }
        if ((string = GraphsUtil.generateTitlesSubDialogSyntax(this.getDialogDataModel())).length() != 0) {
            stringBuffer.append(string);
        }
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        return stringBuffer.toString();
    }

    @Override
    public void reset() {
        super.reset();
        this.mVariablesTargetList.removeAll();
        this.mDefineSlicesTargetList.removeAll();
        this.mRowsTargetList.removeAll();
        this.mColumnsTargetList.removeAll();
        this.mFilePathEdit.setText("");
        this.mUseChartSpecCheck.setSelected(false);
        this.mVariablesArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
        this.mDefineSlicesArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
        this.mRowsArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
        this.mColumnsArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
        this.mSrcVariableList.requestFocus();
        this.setDefaults();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.mSumVarRadio && this.mSumVarRadio.isSelected()) {
            this.mVariablesTargetList.setEnabled(true);
            this.mVariablesTargetList.setOpaque(true);
            if (this.mVariablesTargetList.getModel().getSize() > 0 && SpssArrowButton.ButtonOrientation.right != this.mVariablesArrowButton.getArrowOrientation()) {
                this.mVariablesArrowButton.setEnabled(true);
                this.mVariablesTargetList.setSelectedIndex(0);
            } else if (this.mVariablesTargetList.getModel().getSize() > 0 && SpssArrowButton.ButtonOrientation.right == this.mVariablesArrowButton.getArrowOrientation()) {
                this.mVariablesArrowButton.setEnabled(false);
            } else if (this.mSrcVariableList.getSelectedValue() != null && this.mSrcVariableList.getSelectedIndices().length == 1) {
                this.mVariablesArrowButton.setEnabled(true);
            } else {
                this.mVariablesArrowButton.setEnabled(false);
            }
        } else if (object.equals(this.mNCasesRadio) && this.mNCasesRadio.isSelected() || object.equals(this.mPctCasesRadio) && this.mPctCasesRadio.isSelected()) {
            this.mVariablesArrowButton.setEnabled(false);
            this.mVariablesTargetList.setEnabled(false);
            this.mVariablesTargetList.setOpaque(false);
        } else if (object == this.mUseChartSpecCheck) {
            boolean bl = this.mUseChartSpecCheck.isSelected();
            this.mFileButton.setEnabled(bl);
            this.mFilePathEdit.setEnabled(bl);
        }
        this.checkEnableOkPaste();
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.doListDataChange(listDataEvent);
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.doListDataChange(listDataEvent);
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.doListDataChange(listDataEvent);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        int n;
        Object object = actionEvent.getSource();
        if (object == this.mFileButton && (n = this.mFileChooser.showOpenDialog((Component)((Object)this))) == 0) {
            this.mFilePathEdit.setText(this.mFileChooser.getSelectedFilePath());
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.checkEnableOkPaste();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.checkEnableOkPaste();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.checkEnableOkPaste();
    }

    @Override
    public String getDialogHelpID() {
        return "idh_gppg";
    }

    @Override
    public void loadDialogState() {
        super.loadDialogState();
        this.mSrcVariableList.setSelectedIndex(0);
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.mFileChooser != null) {
            this.mFileChooser.onDispose();
        }
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        this.setupUI(jPanel);
        this.setTabTraversalOrder();
        this.pack();
    }

    @Override
    protected JPanel setupOptionsButtonPanel() {
        JPanel jPanel = super.setupOptionsButtonPanel();
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction("IDS_REPORT_COMMON_TITLES_3DOT"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PieGroupsCasesDlg.this.runTitlesSubDialog();
            }
        };
        JButton jButton = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, jButton);
        toggleButtonAction = new ToggleButtonAction("IDS_COMMON_OPTIONS_3DOT"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PieGroupsCasesDlg.this.runOptionsSubDialog();
            }
        };
        JButton jButton2 = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, jButton2);
        return jPanel;
    }

    protected void runOptionsSubDialog() {
        this.runSubDialog(new OptionsSubDialog(this, 1042));
    }

    protected void runTitlesSubDialog() {
        this.runSubDialog(new TitlesSubDialog(this));
    }

    private void initVars() {
        this.mSrcVariableList = new SrcVariableList();
        this.mSrcVariableList.setIdentifier(SOURCE_VARIABLE_LIST);
        this.mVariablesTargetList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mVariablesTargetList.setIdentifier(VARIABLE_TARGET_VARIABLE_LIST);
        this.mVariablesArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        PieSumSPSSVarFormatter pieSumSPSSVarFormatter = new PieSumSPSSVarFormatter(this.mVariablesTargetList);
        this.mVariablesTargetList.setCellRenderer(new CustomVarListCellRenderer(pieSumSPSSVarFormatter));
        SpssVarFilter spssVarFilter = new SpssVarFilter(8, true, false);
        this.mVariablesTargetList.addVarFilter(spssVarFilter);
        this.mDefineSlicesTargetList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mDefineSlicesTargetList.setIdentifier(DEFINE_SLICES_TARGET_VARIABLE_LIST);
        this.mDefineSlicesArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mRowsTargetList = new TargetVariableList();
        this.mRowsTargetList.setIdentifier(ROWS_TARGET_VARIABLE_LIST);
        this.mRowsArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mColumnsTargetList = new TargetVariableList();
        this.mColumnsTargetList.setIdentifier(COLUMNS_TARGET_VARIABLE_LIST);
        this.mColumnsArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mNCasesRadio = DialogUtil.createRadioButton(this, "IDS_PIE_GC_N_CASES_RADIO", null);
        this.mSumVarRadio = DialogUtil.createRadioButton(this, "IDS_PIE_GC_SUM_VAR_RADIO", null);
        this.mPctCasesRadio = DialogUtil.createRadioButton(this, "IDS_PIE_GC_PCT_CASES_RADIO", null);
        this.mSlicesRadioButtonGroup = new SpssButtonGroup();
        this.mSlicesRadioButtonGroup.add(this.mNCasesRadio);
        this.mSlicesRadioButtonGroup.add(this.mSumVarRadio);
        this.mSlicesRadioButtonGroup.add(this.mPctCasesRadio);
        this.mNestVariableRowsCheck = DialogUtil.createCheckBox(this, "IDS_PIE_GC_NEST_VAR_NO_EMPTY_ROW_CHECK", null);
        this.mNestVariableColumnsCheck = DialogUtil.createCheckBox(this, "IDS_PIE_GC_NEST_VAR_NO_EMPTY_COL_CHECK", null);
        this.mUseChartSpecCheck = DialogUtil.createCheckBox(this, "IDS_PIE_GC_USE_CHART_CHECK", null);
        this.mFileButton = DialogUtil.createButton(this, "IDS_PIE_GC_FILE_BUTTON", null);
        this.mVariableLabel = DialogUtil.createLabel(this, "IDS_VARIABLE");
        this.mVariableLabel.setLabelFor(this.mVariablesTargetList);
        this.mFilePathEdit = new FileTextField();
        this.mFilePathEdit.setAction(new TextFieldAction(this, FILEPATH_EDIT));
        this.mFilePathEdit.setBorder(BorderFactory.createEmptyBorder());
        this.mFileChooser = new GraphsRemoteFileChooser(this);
        this.mVariablesTargetList.getModel().addListDataListener(this);
        this.mDefineSlicesTargetList.getModel().addListDataListener(this);
        this.mRowsTargetList.getModel().addListDataListener(this);
        this.mColumnsTargetList.getModel().addListDataListener(this);
        this.mSumVarRadio.addItemListener(this);
        this.mUseChartSpecCheck.addItemListener(this);
        this.mNCasesRadio.addItemListener(this);
        this.mPctCasesRadio.addItemListener(this);
        this.mFileButton.addActionListener(this);
        this.mFilePathEdit.getDocument().addDocumentListener(this);
        this.mVariablesArrowButton.registerVariableList(this.mSrcVariableList, SpssArrowButton.ButtonOrientation.right);
        this.mVariablesArrowButton.registerVariableList(this.mVariablesTargetList, SpssArrowButton.ButtonOrientation.left);
        this.mRowsArrowButton.registerVariableList(this.mSrcVariableList, SpssArrowButton.ButtonOrientation.right);
        this.mRowsArrowButton.registerVariableList(this.mRowsTargetList, SpssArrowButton.ButtonOrientation.left);
        this.mColumnsArrowButton.registerVariableList(this.mSrcVariableList, SpssArrowButton.ButtonOrientation.right);
        this.mColumnsArrowButton.registerVariableList(this.mColumnsTargetList, SpssArrowButton.ButtonOrientation.left);
        this.setDefaults();
    }

    private void setTabTraversalOrder() {
        Component[] componentArray;
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcVariableList);
        vector.add(this.mSlicesRadioButtonGroup);
        vector.add(this.mVariablesArrowButton);
        vector.add(this.mVariablesTargetList);
        vector.add(this.mDefineSlicesArrowButton);
        vector.add(this.mRowsArrowButton);
        vector.add(this.mColumnsArrowButton);
        vector.add(this.mDefineSlicesTargetList);
        vector.add(this.mRowsTargetList);
        vector.add(this.mNestVariableRowsCheck);
        vector.add(this.mColumnsTargetList);
        vector.add(this.mNestVariableColumnsCheck);
        vector.add(this.mUseChartSpecCheck);
        vector.add(this.mFileButton);
        for (Component component : componentArray = this.mOptionButtonPanel.getComponents()) {
            if (!(component instanceof JButton)) continue;
            vector.add(component);
        }
        for (Component component : componentArray = this.mCmdButtonPanel.getComponents()) {
            vector.add(component);
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private void doListDataChange(ListDataEvent listDataEvent) {
        Object object = listDataEvent.getSource();
        if (object == this.mRowsTargetList.getModel()) {
            this.mNestVariableRowsCheck.setEnabled(this.mRowsTargetList.getModel().getSize() > 0);
        } else if (object == this.mColumnsTargetList.getModel()) {
            this.mNestVariableColumnsCheck.setEnabled(this.mColumnsTargetList.getModel().getSize() > 0);
        } else if (object == this.mDefineSlicesTargetList.getModel() || object == this.mVariablesTargetList.getModel()) {
            this.checkEnableOkPaste();
        }
    }

    private void checkEnableOkPaste() {
        boolean bl;
        boolean bl2 = bl = this.mDefineSlicesTargetList.getModel().getSize() > 0;
        if (bl && this.mSumVarRadio.isSelected()) {
            boolean bl3 = bl = this.mVariablesTargetList.getModel().getSize() > 0;
        }
        if (bl && this.mUseChartSpecCheck.isSelected()) {
            String string = this.mFilePathEdit.getText();
            bl = string != null && string.length() > 0;
        }
        this.enableOkPaste(bl);
    }

    private void setDefaults() {
        this.mFilePathEdit.setOpaque(false);
        this.mFilePathEdit.setEditable(false);
        this.mSrcVariableList.loadFromActiveDataset();
        this.mSrcVariableList.setSelectedIndex(0);
        this.mNCasesRadio.setSelected(true);
        this.setVariableEnable(false);
        this.mNestVariableRowsCheck.setEnabled(false);
        this.mNestVariableColumnsCheck.setEnabled(false);
        this.mFileButton.setEnabled(false);
    }

    private void setVariableEnable(boolean bl) {
        this.mVariableLabel.setEnabled(bl);
        if (this.mSrcVariableList.getModel().getSize() > 0 && this.mSrcVariableList.getSelectedIndices().length == 1) {
            this.mVariablesArrowButton.setEnabled(bl);
        }
        this.mVariablesTargetList.setEnabled(bl);
        this.mVariablesTargetList.setOpaque(bl);
    }

    private void setupUI(JPanel jPanel) {
        JPanel jPanel2 = this.setupSummariesGroupCasesPanel();
        JPanel jPanel3 = this.setupTemplatePanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(n, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, 23, insets);
        insets.set(n, 0, n, n);
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 1, 1, 1, 23, insets);
    }

    private JPanel setupSummariesGroupCasesPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_SOURCE_LIST_LABEL");
        jLabel.setLabelFor(this.mSrcVariableList);
        JScrollPane jScrollPane = new JScrollPane(this.mSrcVariableList);
        jScrollPane.setPreferredSize(this.mSrcVariableList.getMinimumSize());
        JPanel jPanel2 = this.setupSliceRepresentPanel();
        JPanel jPanel3 = this.setupDefineSlicesPanel();
        JPanel jPanel4 = this.setupPanelByPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        JPanel jPanel5 = new JPanel(new GridBagLayout());
        jPanel5.setBorder(BorderFactory.createEmptyBorder());
        DialogUtil.addUsingGBL(jPanel5, jLabel, gridBagConstraints, 0, 0, 1, 1, 23, null);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n = DialogUtil.getGroupBoxInnerMargin();
        int n2 = DialogUtil.getComponentGroupGap();
        DialogUtil.addUsingGBL(jPanel5, jScrollPane, gridBagConstraints, 0, 1, 1, 1, 23, null);
        DialogUtil.addUsingGBL(jPanel, jPanel5, gridBagConstraints, 0, 0, 1, 3, 23, null);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        Insets insets = new Insets(0, n2, 0, n);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 1, 0, 1, 1, 23, insets);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        insets.set(0, 0, n, n);
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 1, 1, 1, 1, 23, insets);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        insets.set(0, n2, 0, n);
        DialogUtil.addUsingGBL(jPanel, jPanel4, gridBagConstraints, 1, 2, 1, 1, 23, insets);
        return jPanel;
    }

    private JPanel setupSliceRepresentPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JPanel jPanel2 = this.setupVariablePanel();
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_PIE_GC_SLICE_REPRESENT_CAPTION")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel, this.mNCasesRadio, gridBagConstraints, 0, 0, 1, 1, 23, insets);
        DialogUtil.addUsingGBL(jPanel, this.mSumVarRadio, gridBagConstraints, 0, 1, 1, 1, 23, insets);
        DialogUtil.addUsingGBL(jPanel, this.mPctCasesRadio, gridBagConstraints, 1, 0, 1, 1, 23, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 2, 2, 1, 23, null);
        return jPanel;
    }

    private JPanel setupVariablePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JScrollPane jScrollPane = new JScrollPane(this.mVariablesTargetList);
        jScrollPane.setPreferredSize(this.mVariablesTargetList.getMinimumSize());
        jScrollPane.setVerticalScrollBarPolicy(21);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(n, n, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mVariableLabel, gridBagConstraints, 1, 0, 1, 1, 23, insets);
        Insets insets2 = DialogUtil.getArrowButtonInsets();
        insets = new Insets(0, n, n * 2, insets2.right);
        DialogUtil.addUsingGBL(jPanel, this.mVariablesArrowButton, gridBagConstraints, 0, 0, 1, 2, 20, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        insets = new Insets(0, n - 2, n * 2, n);
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 1, 1, 1, 1, 20, insets);
        return jPanel;
    }

    private JPanel setupDefineSlicesPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.mDefineSlicesArrowButton.registerVariableList(this.mSrcVariableList, SpssArrowButton.ButtonOrientation.right);
        this.mDefineSlicesArrowButton.registerVariableList(this.mDefineSlicesTargetList, SpssArrowButton.ButtonOrientation.left);
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_PIE_GC_DEFINE_SLICES_COLON_LABEL");
        jLabel.setLabelFor(this.mDefineSlicesTargetList);
        JScrollPane jScrollPane = new JScrollPane(this.mDefineSlicesTargetList);
        jScrollPane.setPreferredSize(this.mDefineSlicesTargetList.getMinimumSize());
        jScrollPane.setVerticalScrollBarPolicy(21);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        Insets insets = DialogUtil.getArrowButtonInsets();
        int n = DialogUtil.getComponentGroupGap();
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        Insets insets2 = new Insets(n, 3, 0, n2);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 1, 0, 1, 1, 23, insets2);
        gridBagConstraints.weightx = 0.0;
        insets2.set(0, insets.left + n2 + 3, 0, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mDefineSlicesArrowButton, gridBagConstraints, 0, 0, 1, 2, 20, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        insets2.set(0, 3, 0, n2 + 4);
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 1, 1, 1, 1, 20, insets2);
        return jPanel;
    }

    private JPanel setupPanelByPanel() {
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_PIE_GC_ROWS_COLON_LABEL");
        jLabel.setLabelFor(this.mRowsTargetList);
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_PIE_GC_COLUMNS_COLON_LABEL");
        jLabel2.setLabelFor(this.mColumnsTargetList);
        JComponent[] jComponentArray = new JComponent[]{jLabel, this.mRowsArrowButton, this.mRowsTargetList, this.mNestVariableRowsCheck, jLabel2, this.mColumnsArrowButton, this.mColumnsTargetList, this.mNestVariableColumnsCheck};
        return PanelFactory.getGraphsPanelByPanel(jComponentArray, this.getResString("IDS_PIE_GC_PANEL_BY_CAPTION"));
    }

    private JPanel setupTemplatePanel() {
        JComponent[] jComponentArray = new JComponent[8];
        jComponentArray[0] = this.mUseChartSpecCheck;
        jComponentArray[1] = this.mFileButton;
        jComponentArray[2] = this.mFilePathEdit;
        return PanelFactory.getGraphsChartTemplatePanel(jComponentArray, this.getResString("IDS_PIE_GC_TEMPLATE_CAPTION"));
    }
}

