/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.graphs.legacy_dialogs.pie;

import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.base.graphs.res.GraphsResBundle;
import com.spss.java_client.ui.dialogs.common.BaseGatingDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.shared.core_tools.system.OSInfo;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;

public class PieDlg
extends BaseGatingDialog {
    private JRadioButton mGroupsRadio;
    private JRadioButton mSeparateVariablesRadio;
    private JRadioButton mIndividualCasesRadio;

    public PieDlg(JFrame jFrame) throws HeadlessException {
        super(jFrame, GraphsResBundle.getDefaultResourceBundleName(), GraphsResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_PIE_CAPTION"));
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public String getIActionKey() {
        return "graphs_legacy_dialogs_pie";
    }

    @Override
    public String getDialogHelpID() {
        return "idh_gpie";
    }

    @Override
    public String getNextProcDlgActionKey() {
        String string = this.mGroupsRadio.isSelected() ? "graphs_legacy_dialogs_pie_summary_groups_cases" : (this.mSeparateVariablesRadio.isSelected() ? "graphs_legacy_dialogs_pie_summary_sep_vars" : "graphs_legacy_dialogs_pie_value_individual_cases");
        return string;
    }

    @Override
    public boolean continuePressed() {
        return true;
    }

    @Override
    protected void init() {
        super.init();
        this.renameContinueAction("IDS_DEFINE");
        JPanel jPanel = this.getViewPanel();
        this.initVars();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel, this.setupChartPanel(), gridBagConstraints, 0, 0, 1, 1, n, insets);
        this.pack();
    }

    private JPanel setupChartPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(this.getResString("IDS_PIE_DATA_CHART_CAPTION")));
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel, this.mGroupsRadio, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mSeparateVariablesRadio, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mIndividualCasesRadio, gridBagConstraints, 0, 2, 1, 1, n, insets);
        return jPanel;
    }

    private void initVars() {
        this.mGroupsRadio = DialogUtil.createRadioButton(this, "IDS_PIE_GROUPS_RADIO", null);
        this.mSeparateVariablesRadio = DialogUtil.createRadioButton(this, "IDS_PIE_SEPARATE_VARS_RADIO", null);
        this.mIndividualCasesRadio = DialogUtil.createRadioButton(this, "IDS_PIE_INDIVIDUAL_CASES_RADIO", null);
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        spssButtonGroup.add(this.mGroupsRadio);
        spssButtonGroup.add(this.mSeparateVariablesRadio);
        spssButtonGroup.add(this.mIndividualCasesRadio);
        spssButtonGroup.setSelected(this.mGroupsRadio.getModel(), true);
        Vector<Object> vector = new Vector<Object>();
        vector.add(spssButtonGroup);
        if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
            vector.add(this.mHelpButton);
            vector.add(this.mCancelButton);
            vector.add(this.mDefineButton);
        } else {
            vector.add(this.mDefineButton);
            vector.add(this.mCancelButton);
            vector.add(this.mHelpButton);
        }
        this.setFocusTraversalPolicy(new DialogFocusTraversalPolicy(vector, false));
    }
}

