/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.graphs.legacy_dialogs.line;

import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.base.graphs.ImageLabelKeyListener;
import com.spss.java_client.ui.dialogs.base.graphs.MatrixImage;
import com.spss.java_client.ui.dialogs.base.graphs.MatrixImagesGroup;
import com.spss.java_client.ui.dialogs.base.graphs.res.GraphsResBundle;
import com.spss.java_client.ui.dialogs.common.BaseGatingDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.shared.core_tools.system.OSInfo;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;

public class LineDlg
extends BaseGatingDialog {
    private JRadioButton mSummariesForGroupsOfCasesRadio;
    private JRadioButton mSummariesOfSeparateVarsRadio;
    private JRadioButton mValuesOfIndividualCasesRadio;
    private SpssButtonGroup mRadioButtonGroup;
    private MatrixImage mSimpleLineImageLabel;
    private MatrixImage mMultipleImageLabel;
    private MatrixImage mDropLineImageLabel;
    private JLabel mSimpleLineLabel;
    private JLabel mMultipleLabel;
    private JLabel mDropLineLabel;
    private MatrixImagesGroup mGraphsLineImageLabelGroup;

    public LineDlg(JFrame jFrame) throws HeadlessException {
        super(jFrame, GraphsResBundle.getDefaultResourceBundleName(), GraphsResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_LINE_CHARTS_TITLE"));
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public String getDialogHelpID() {
        return "idh_glin";
    }

    @Override
    public String getIActionKey() {
        return "graphs_legacy_dialogs_line";
    }

    @Override
    public String getNextProcDlgActionKey() {
        String string = null;
        if (this.mSummariesForGroupsOfCasesRadio.isSelected()) {
            if (this.mGraphsLineImageLabelGroup.isSelected(this.mSimpleLineImageLabel)) {
                string = "graphs_legacy_dialogs_line_simple_group_of_cases";
            } else if (this.mGraphsLineImageLabelGroup.isSelected(this.mMultipleImageLabel)) {
                string = "graphs_legacy_dialogs_line_multi_group_of_cases";
            } else if (this.mGraphsLineImageLabelGroup.isSelected(this.mDropLineImageLabel)) {
                string = "graphs_legacy_dialogs_line_dropline_group_of_cases";
            }
        } else if (this.mSummariesOfSeparateVarsRadio.isSelected()) {
            if (this.mGraphsLineImageLabelGroup.isSelected(this.mSimpleLineImageLabel)) {
                string = "graphs_legacy_dialogs_line_simple_separate_variable";
            } else if (this.mGraphsLineImageLabelGroup.isSelected(this.mMultipleImageLabel)) {
                string = "graphs_legacy_dialogs_line_multi_separate_variable";
            } else if (this.mGraphsLineImageLabelGroup.isSelected(this.mDropLineImageLabel)) {
                string = "graphs_legacy_dialogs_line_dropline_separate_variable";
            }
        } else if (this.mGraphsLineImageLabelGroup.isSelected(this.mSimpleLineImageLabel)) {
            string = "graphs_legacy_dialogs_line_simple_individual_cases";
        } else if (this.mGraphsLineImageLabelGroup.isSelected(this.mMultipleImageLabel)) {
            string = "graphs_legacy_dialogs_line_multi_individual_cases";
        } else if (this.mGraphsLineImageLabelGroup.isSelected(this.mDropLineImageLabel)) {
            string = "graphs_legacy_dialogs_line_dropline_individual_cases";
        }
        return string;
    }

    @Override
    public boolean continuePressed() {
        return true;
    }

    @Override
    public void loadDialogState() {
        Integer n = this.mDialogDataModel.getInteger("IDS_GRAPHS_LINE_SELECTED_IMAGE");
        if (n != null) {
            this.setImageSelected(n);
        }
        super.loadDialogState();
    }

    @Override
    public void saveDialogState() {
        super.saveDialogState();
        this.mDialogDataModel.putInteger("IDS_GRAPHS_LINE_SELECTED_IMAGE", this.getSelectedImageIndex());
    }

    @Override
    protected void init() {
        super.init();
        this.renameContinueAction("IDS_DEFINE");
        this.initVars();
        this.setDefaults();
        this.addComponentsToMainPanel(this.getViewPanel());
        this.setTabPolicy();
        this.pack();
    }

    private void initVars() {
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, "IDS_LINE_SUMMARIES_FOR_GROUPS_OF_CASES_RADIO");
        this.mSummariesForGroupsOfCasesRadio = new JRadioButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_LINE_SUMMARIES_OF_SEPARATE_VARIABLES_RADIO");
        this.mSummariesOfSeparateVarsRadio = new JRadioButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_LINE_VALUES_OF_INDIVIDUAL_CASES_RADIO");
        this.mValuesOfIndividualCasesRadio = new JRadioButton(toggleButtonAction);
        this.mGraphsLineImageLabelGroup = new MatrixImagesGroup();
        this.mSimpleLineLabel = new JLabel(this.getResString("IDS_LINE_SIMPLE"));
        this.mSimpleLineImageLabel = new MatrixImage(this.getResImageURL("IDS_LINE_SIMPLE_LINE_IMAGE"));
        this.mSimpleLineImageLabel.setImageLabelGroup(this.mGraphsLineImageLabelGroup);
        this.mMultipleLabel = new JLabel(this.getResString("IDS_LINE_MULTIPLE"));
        this.mMultipleImageLabel = new MatrixImage(this.getResImageURL("IDS_LINE_MULTI_LINE_IMAGE"));
        this.mMultipleImageLabel.setImageLabelGroup(this.mGraphsLineImageLabelGroup);
        this.mDropLineLabel = new JLabel(this.getResString("IDS_LINE_DROPLINE"));
        this.mDropLineImageLabel = new MatrixImage(this.getResImageURL("IDS_LINE_DROP_LINE_IMAGE"));
        this.mDropLineImageLabel.setImageLabelGroup(this.mGraphsLineImageLabelGroup);
        Vector<MatrixImage> vector = new Vector<MatrixImage>();
        vector.add(this.mSimpleLineImageLabel);
        vector.add(this.mMultipleImageLabel);
        vector.add(this.mDropLineImageLabel);
        this.mSimpleLineImageLabel.addKeyListener(new ImageLabelKeyListener(vector, this.mGraphsLineImageLabelGroup));
        this.mMultipleImageLabel.addKeyListener(new ImageLabelKeyListener(vector, this.mGraphsLineImageLabelGroup));
        this.mDropLineImageLabel.addKeyListener(new ImageLabelKeyListener(vector, this.mGraphsLineImageLabelGroup));
    }

    private void setDefaults() {
        this.mSimpleLineImageLabel.setDefaultSelectedImage(true);
        this.mMultipleImageLabel.setDefaultSelectedImage(false);
        this.mDropLineImageLabel.setDefaultSelectedImage(false);
        this.mSummariesForGroupsOfCasesRadio.setSelected(true);
    }

    private void addComponentsToMainPanel(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        int n = 23;
        JPanel jPanel2 = this.setupImageLabelPanel();
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weighty = 1.0;
        JPanel jPanel3 = this.setupDataInChartArePanel();
        Insets insets = new Insets(DialogUtil.getComponentGroupGap(), 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 1, 1, 1, n, insets);
        this.mRadioButtonGroup = DialogUtil.createButtonGroup(jPanel3);
    }

    private JPanel setupImageLabelPanel() {
        JComponent[] jComponentArray = new JComponent[]{this.mSimpleLineImageLabel, this.mMultipleImageLabel, this.mDropLineImageLabel, this.mSimpleLineLabel, this.mMultipleLabel, this.mDropLineLabel, new JLabel()};
        return PanelFactory.getPanelForImageLabels(jComponentArray, "", 3);
    }

    private JPanel setupDataInChartArePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(this.getResString("IDS_LINE_DATA_CHART_BORDER_TITLE")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        Insets insets = new Insets(DialogUtil.getGroupBoxInnerMargin(), 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mSummariesForGroupsOfCasesRadio, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mSummariesOfSeparateVarsRadio, gridBagConstraints, 0, 1, 1, 1, n, null);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        insets.set(0, 0, DialogUtil.getGroupBoxInnerMargin(), 0);
        DialogUtil.addUsingGBL(jPanel, this.mValuesOfIndividualCasesRadio, gridBagConstraints, 0, 2, 1, 1, n, insets);
        return jPanel;
    }

    private void setTabPolicy() {
        Vector<Object> vector = new Vector<Object>();
        if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
            vector.add(this.mDefineButton);
            vector.add(this.mSimpleLineImageLabel);
            vector.add(this.mRadioButtonGroup);
            vector.add(this.mHelpButton);
            vector.add(this.mCancelButton);
        } else {
            vector.add(this.mDefineButton);
            vector.add(this.mCancelButton);
            vector.add(this.mHelpButton);
            vector.add(this.mSimpleLineImageLabel);
            vector.add(this.mRadioButtonGroup);
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private int getSelectedImageIndex() {
        int n = -1;
        if (this.mGraphsLineImageLabelGroup.isSelected(this.mSimpleLineImageLabel)) {
            n = 0;
        } else if (this.mGraphsLineImageLabelGroup.isSelected(this.mMultipleImageLabel)) {
            n = 1;
        } else if (this.mGraphsLineImageLabelGroup.isSelected(this.mDropLineImageLabel)) {
            n = 2;
        }
        return n;
    }

    private void setImageSelected(int n) {
        switch (n) {
            case 0: {
                this.mSimpleLineImageLabel.setDefaultSelectedImage(true);
                break;
            }
            case 1: {
                this.mMultipleImageLabel.setDefaultSelectedImage(true);
                break;
            }
            case 2: {
                this.mDropLineImageLabel.setDefaultSelectedImage(true);
            }
        }
    }
}

