/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.graphs.legacy_dialogs.high_low;

import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.base.graphs.ImageLabelKeyListener;
import com.spss.java_client.ui.dialogs.base.graphs.MatrixImage;
import com.spss.java_client.ui.dialogs.base.graphs.MatrixImagesGroup;
import com.spss.java_client.ui.dialogs.base.graphs.res.GraphsResBundle;
import com.spss.java_client.ui.dialogs.common.BaseGatingDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.shared.core_tools.system.OSInfo;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;

public class HighLowDlg
extends BaseGatingDialog {
    private JRadioButton mSummariesForGroupsOfCasesRadio;
    private JRadioButton mSummariesOfSeparateVarsRadio;
    private JRadioButton mValuesOfIndividualCasesRadio;
    private SpssButtonGroup mRadioButtonGroup;
    private MatrixImage mSimpleHighLowCloseImageLabel;
    private MatrixImage mSimpleRangeBarImageLabel;
    private MatrixImage mClusteredHighLowCloseImageLabel;
    private MatrixImage mClusteredRangeBarImageLabel;
    private MatrixImage mDifferenceAreaImageLabel;
    private JLabel mSimpleHighLowCloseLabel;
    private JLabel mSimpleRangeBarLabel;
    private JLabel mClusteredHighLowCloseLabel;
    private JLabel mClusteredRangeBarLabel;
    private JLabel mDifferenceAreaLabel;
    private MatrixImagesGroup mHighLowImageLabelGroup;

    public HighLowDlg(JFrame jFrame) throws HeadlessException {
        super(jFrame, GraphsResBundle.getDefaultResourceBundleName(), GraphsResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_HILO_HIGH_LOW_CHARTS_TITLE"));
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public String getDialogHelpID() {
        return "idh_ghil";
    }

    @Override
    public String getIActionKey() {
        return "graphs_legacy_dialogs_high_low";
    }

    @Override
    public String getNextProcDlgActionKey() {
        String string = null;
        if (this.mSummariesForGroupsOfCasesRadio.isSelected()) {
            if (this.mHighLowImageLabelGroup.isSelected(this.mSimpleHighLowCloseImageLabel)) {
                string = "graphs_legacy_dialogs_high_low_simple_groups_of_cases";
            } else if (this.mHighLowImageLabelGroup.isSelected(this.mSimpleRangeBarImageLabel)) {
                string = "graphs_legacy_dialogs_high_low_simple_range_bar_groups_of_cases";
            } else if (this.mHighLowImageLabelGroup.isSelected(this.mClusteredHighLowCloseImageLabel)) {
                string = "graphs_legacy_dialogs_high_low_clustered_groups_of_cases";
            } else if (this.mHighLowImageLabelGroup.isSelected(this.mClusteredRangeBarImageLabel)) {
                string = "graphs_legacy_dialogs_high_low_clustered_range_bar_groups_of_cases";
            } else if (this.mHighLowImageLabelGroup.isSelected(this.mDifferenceAreaImageLabel)) {
                string = "graphs_legacy_dialogs_high_low_difference_area_groups_of_cases";
            }
        } else if (this.mSummariesOfSeparateVarsRadio.isSelected()) {
            if (this.mHighLowImageLabelGroup.isSelected(this.mSimpleHighLowCloseImageLabel)) {
                string = "graphs_legacy_dialogs_high_low_simple_seperate_variables";
            } else if (this.mHighLowImageLabelGroup.isSelected(this.mSimpleRangeBarImageLabel)) {
                string = "graphs_legacy_dialogs_high_low_simple_range_bar_seperate_variables";
            } else if (this.mHighLowImageLabelGroup.isSelected(this.mClusteredHighLowCloseImageLabel)) {
                string = "graphs_legacy_dialogs_high_low_clustered_seperate_variables";
            } else if (this.mHighLowImageLabelGroup.isSelected(this.mClusteredRangeBarImageLabel)) {
                string = "graphs_legacy_dialogs_high_low_clustered_range_bar_seperate_variables";
            } else if (this.mHighLowImageLabelGroup.isSelected(this.mDifferenceAreaImageLabel)) {
                string = "graphs_legacy_dialogs_high_low_difference_area_seperate_variables";
            }
        } else if (this.mHighLowImageLabelGroup.isSelected(this.mSimpleHighLowCloseImageLabel)) {
            string = "graphs_legacy_dialogs_high_low_simple_values_of_individual_cases";
        } else if (this.mHighLowImageLabelGroup.isSelected(this.mSimpleRangeBarImageLabel)) {
            string = "graphs_legacy_dialogs_high_low_simple_range_bar_values_of_individual_cases";
        } else if (this.mHighLowImageLabelGroup.isSelected(this.mClusteredHighLowCloseImageLabel)) {
            string = "graphs_legacy_dialogs_high_low_clustered_values_of_individual_cases";
        } else if (this.mHighLowImageLabelGroup.isSelected(this.mClusteredRangeBarImageLabel)) {
            string = "graphs_legacy_dialogs_high_low_clustered_range_bar_values_of_individual_cases";
        } else if (this.mHighLowImageLabelGroup.isSelected(this.mDifferenceAreaImageLabel)) {
            string = "graphs_legacy_dialogs_high_low_difference_area_values_of_individual_cases";
        }
        return string;
    }

    @Override
    public boolean continuePressed() {
        return true;
    }

    @Override
    public void loadDialogState() {
        Integer n = this.mDialogDataModel.getInteger("IDS_HILO_SELECTED_IMAGE");
        if (n != null) {
            this.setImageSelected(n);
        }
        super.loadDialogState();
    }

    @Override
    public void saveDialogState() {
        super.saveDialogState();
        this.mDialogDataModel.putInteger("IDS_HILO_SELECTED_IMAGE", this.getSelectedImageIndex());
    }

    @Override
    protected void init() {
        super.init();
        this.renameContinueAction("IDS_DEFINE");
        this.initVars();
        this.setDefaults();
        this.addComponentsToMainPanel(this.getViewPanel());
        this.setTabPolicy();
        this.pack();
    }

    private void initVars() {
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, "IDS_HILO_SUMMARIES_FOR_GROUPS_OF_CASES");
        this.mSummariesForGroupsOfCasesRadio = new JRadioButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_HILO_SUMMARIES_OF_SEPERATE_VARS");
        this.mSummariesOfSeparateVarsRadio = new JRadioButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_HILO_VALUES_OF_INDIVIDUAL_CASES");
        this.mValuesOfIndividualCasesRadio = new JRadioButton(toggleButtonAction);
        this.mHighLowImageLabelGroup = new MatrixImagesGroup();
        this.mSimpleHighLowCloseLabel = DialogUtil.createMultiLineLabel(this, "IDS_HILO_SIMPLE_HILO_CLOSE", 100);
        this.mSimpleHighLowCloseImageLabel = new MatrixImage(this.getResImageURL("IDS_HILO_SIMPLE_HILO_CLOSE_IMAGE"));
        this.mSimpleHighLowCloseImageLabel.setImageLabelGroup(this.mHighLowImageLabelGroup);
        this.mSimpleRangeBarLabel = DialogUtil.createMultiLineLabel(this, "IDS_HILO_SIMPLE_RANGE_BAR", 80);
        this.mSimpleRangeBarImageLabel = new MatrixImage(this.getResImageURL("IDS_HILO_SIMPLE_RANGE_BAR_IMAGE"));
        this.mSimpleRangeBarImageLabel.setImageLabelGroup(this.mHighLowImageLabelGroup);
        this.mClusteredHighLowCloseLabel = DialogUtil.createMultiLineLabel(this, "IDS_HILO_CLUSTERED_HILO_CLOSE", 100);
        this.mClusteredHighLowCloseImageLabel = new MatrixImage(this.getResImageURL("IDS_HILO_CLUSTERED_HILO_CLOSE_IMAGE"));
        this.mClusteredHighLowCloseImageLabel.setImageLabelGroup(this.mHighLowImageLabelGroup);
        this.mClusteredRangeBarLabel = DialogUtil.createMultiLineLabel(this, "IDS_HILO_CLUSTERED_RANGE_BAR", 80);
        this.mClusteredRangeBarImageLabel = new MatrixImage(this.getResImageURL("IDS_HILO_CLUSTERED_RANGE_BAR_IMAGE"));
        this.mClusteredRangeBarImageLabel.setImageLabelGroup(this.mHighLowImageLabelGroup);
        this.mDifferenceAreaLabel = new JLabel(this.getResString("IDS_HILO_DIFF_AREA"));
        this.mDifferenceAreaImageLabel = new MatrixImage(this.getResImageURL("IDS_HILO_DIFFERENCE_AREA_IMAGE"));
        this.mDifferenceAreaImageLabel.setImageLabelGroup(this.mHighLowImageLabelGroup);
        Vector<MatrixImage> vector = new Vector<MatrixImage>();
        vector.add(this.mSimpleHighLowCloseImageLabel);
        vector.add(this.mClusteredHighLowCloseImageLabel);
        vector.add(this.mSimpleRangeBarImageLabel);
        vector.add(this.mClusteredRangeBarImageLabel);
        vector.add(this.mDifferenceAreaImageLabel);
        this.mSimpleHighLowCloseImageLabel.addKeyListener(new ImageLabelKeyListener(vector, this.mHighLowImageLabelGroup));
        this.mSimpleRangeBarImageLabel.addKeyListener(new ImageLabelKeyListener(vector, this.mHighLowImageLabelGroup));
        this.mClusteredHighLowCloseImageLabel.addKeyListener(new ImageLabelKeyListener(vector, this.mHighLowImageLabelGroup));
        this.mClusteredRangeBarImageLabel.addKeyListener(new ImageLabelKeyListener(vector, this.mHighLowImageLabelGroup));
        this.mDifferenceAreaImageLabel.addKeyListener(new ImageLabelKeyListener(vector, this.mHighLowImageLabelGroup));
    }

    private void setDefaults() {
        this.mSimpleHighLowCloseImageLabel.setDefaultSelectedImage(true);
        this.mSimpleRangeBarImageLabel.setDefaultSelectedImage(false);
        this.mClusteredHighLowCloseImageLabel.setDefaultSelectedImage(false);
        this.mClusteredRangeBarImageLabel.setDefaultSelectedImage(false);
        this.mDifferenceAreaImageLabel.setDefaultSelectedImage(false);
        this.mSummariesOfSeparateVarsRadio.setSelected(true);
    }

    private void addComponentsToMainPanel(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        int n = 23;
        JPanel jPanel2 = this.setupImageLabelPanel();
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weighty = 1.0;
        JPanel jPanel3 = this.setupDataInChartArePanel();
        Insets insets = new Insets(DialogUtil.getComponentGroupGap(), 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 1, 1, 1, n, insets);
        this.mRadioButtonGroup = DialogUtil.createButtonGroup(jPanel3);
    }

    private JPanel setupImageLabelPanel() {
        JComponent[] jComponentArray = new JComponent[]{this.mSimpleHighLowCloseImageLabel, this.mClusteredHighLowCloseImageLabel, this.mDifferenceAreaImageLabel, this.mSimpleHighLowCloseLabel, this.mClusteredHighLowCloseLabel, this.mDifferenceAreaLabel, this.mSimpleRangeBarImageLabel, this.mClusteredRangeBarImageLabel, new JLabel(), this.mSimpleRangeBarLabel, this.mClusteredRangeBarLabel};
        return PanelFactory.getPanelForImageLabels(jComponentArray, "", 3);
    }

    private JPanel setupDataInChartArePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(this.getResString("IDS_HILO_DATA_IN_CHART_ARE_PANEL_TITLE")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        Insets insets = new Insets(DialogUtil.getGroupBoxInnerMargin(), 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mSummariesForGroupsOfCasesRadio, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mSummariesOfSeparateVarsRadio, gridBagConstraints, 0, 1, 1, 1, n, null);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        insets.set(0, 0, DialogUtil.getGroupBoxInnerMargin(), 0);
        DialogUtil.addUsingGBL(jPanel, this.mValuesOfIndividualCasesRadio, gridBagConstraints, 0, 2, 1, 1, n, insets);
        return jPanel;
    }

    private void setTabPolicy() {
        Vector<Object> vector = new Vector<Object>();
        if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
            vector.add(this.mDefineButton);
            vector.add(this.mSimpleHighLowCloseImageLabel);
            vector.add(this.mRadioButtonGroup);
            vector.add(this.mHelpButton);
            vector.add(this.mCancelButton);
        } else {
            vector.add(this.mDefineButton);
            vector.add(this.mCancelButton);
            vector.add(this.mHelpButton);
            vector.add(this.mSimpleHighLowCloseImageLabel);
            vector.add(this.mRadioButtonGroup);
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private int getSelectedImageIndex() {
        int n = -1;
        if (this.mHighLowImageLabelGroup.isSelected(this.mSimpleHighLowCloseImageLabel)) {
            n = 0;
        } else if (this.mHighLowImageLabelGroup.isSelected(this.mSimpleRangeBarImageLabel)) {
            n = 1;
        } else if (this.mHighLowImageLabelGroup.isSelected(this.mClusteredHighLowCloseImageLabel)) {
            n = 2;
        } else if (this.mHighLowImageLabelGroup.isSelected(this.mClusteredRangeBarImageLabel)) {
            n = 3;
        } else if (this.mHighLowImageLabelGroup.isSelected(this.mDifferenceAreaImageLabel)) {
            n = 4;
        }
        return n;
    }

    private void setImageSelected(int n) {
        switch (n) {
            case 0: {
                this.mSimpleHighLowCloseImageLabel.setDefaultSelectedImage(true);
                break;
            }
            case 1: {
                this.mSimpleRangeBarImageLabel.setDefaultSelectedImage(true);
                break;
            }
            case 2: {
                this.mClusteredHighLowCloseImageLabel.setDefaultSelectedImage(true);
                break;
            }
            case 3: {
                this.mClusteredRangeBarImageLabel.setDefaultSelectedImage(true);
                break;
            }
            case 4: {
                this.mDifferenceAreaImageLabel.setDefaultSelectedImage(true);
            }
        }
    }
}

