/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.graphs.legacy_dialogs.high_low;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.ORIGINATOR_ID;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.CustomVarListCellRenderer;
import com.spss.java_client.ui.controls.FileTextField;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.base.graphs.GraphsRemoteFileChooser;
import com.spss.java_client.ui.dialogs.base.graphs.GraphsUtil;
import com.spss.java_client.ui.dialogs.base.graphs.OptionsSubDialog;
import com.spss.java_client.ui.dialogs.base.graphs.TitlesSubDialog;
import com.spss.java_client.ui.dialogs.base.graphs.legacy_dialogs.high_low.ChangeStatisticSubDlg;
import com.spss.java_client.ui.dialogs.base.graphs.legacy_dialogs.high_low.HighLowCustomVarFormatter;
import com.spss.java_client.ui.dialogs.base.graphs.legacy_dialogs.high_low.HighLowCustomVarListModel;
import com.spss.java_client.ui.dialogs.base.graphs.legacy_dialogs.high_low.HighLowFormatterUtil;
import com.spss.java_client.ui.dialogs.base.graphs.legacy_dialogs.high_low.HighLowPanelFactory;
import com.spss.java_client.ui.dialogs.base.graphs.legacy_dialogs.high_low.HighLowSyntaxUtil;
import com.spss.java_client.ui.dialogs.base.graphs.legacy_dialogs.high_low.HighLowTargetListVarMoveHandler;
import com.spss.java_client.ui.dialogs.base.graphs.res.GraphsResBundle;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.uitools.dialogs.UIToolDialogUtil;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ClusteredRBSeparateVariablesDlg
extends BaseProcedureDialog
implements ListDataListener,
ItemListener,
ListSelectionListener {
    private static final int MAX_LAYERS = 10;
    private static final String LAYER_COUNT_KEY = "IDS_HILO_LAYER_COUNT";
    private static final String LAYERS_KEY = "IDS_HILO_LAYERS";
    private static final String LAYERS_FORMATTED_TEXT_KEY = "IDS_HILO_LAYERS_FORMATTED_TEXT";
    private static final String CURRENT_LAYER_KEY = "IDS_HILO_CURRENT_LAYER";
    private SrcVariableList mSrcVarList;
    private JButton mNextButton;
    private JButton mPreviousButton;
    private JLabel mFirstLabel;
    private TargetVariableList mFirstTargetList;
    private JScrollPane mFirstScrollPane;
    private ArrowButton mFirstArrowButton;
    private JLabel mSecondLabel;
    private TargetVariableList mSecondTargetList;
    private JScrollPane mSecondScrollPane;
    private ArrowButton mSecondArrowButton;
    private JButton mChangeStatisticsButton;
    private JLabel mCategoryAxisLabel;
    private TargetVariableList mCategoryAxisTargetList;
    private JScrollPane mCategoryScrollPane;
    private ArrowButton mCategoryArrowButton;
    private JLabel mRowsLabel;
    private TargetVariableList mRowsTargetList;
    private ArrowButton mRowsArrowButton;
    private JCheckBox mNestVariableRowsCheckBox;
    private JLabel mColumnsLabel;
    private TargetVariableList mColumnTargetList;
    private ArrowButton mColumnsArrowButton;
    private JCheckBox mNestVariableColumnsCheckBox;
    private JCheckBox mChartSpecificationsCheckBox;
    private JButton mFileButton;
    private FileTextField mFileTextField;
    private HighLowCustomVarFormatter mFirstListFormatter;
    private HighLowCustomVarFormatter mSecondListFormatter;
    private GraphsRemoteFileChooser mFileChooser;
    private int mListSelectionType;
    private int mCurrentLayer;
    private Vector<Vector<ISpssVariable>> mLayers;
    private Vector<HashMap<Integer, Object>> mLayersFormattedText;
    private JPanel mPairPanel;

    public ClusteredRBSeparateVariablesDlg(JFrame jFrame) {
        super(jFrame, false, GraphsResBundle.getDefaultResourceBundleName(), GraphsResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_HILO_CLUSTERED_RANGE_BAR_SEPERATE_VARIABLES_DIALOG_TITLE"));
    }

    @Override
    public String getDialogHelpID() {
        return "idh_ghcv";
    }

    @Override
    public String getIActionKey() {
        return "graphs_legacy_dialogs_high_low_clustered_range_bar_seperate_variables";
    }

    public void paint(Graphics graphics) {
        this.mFileTextField.setText(this.mFileTextField.getText());
        super.paint(graphics);
        super.validate();
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        if (listDataEvent.getSource().equals(this.mFirstTargetList.getModel())) {
            this.mChangeStatisticsButton.setEnabled(true);
            this.mSecondTargetList.clearSelection();
            this.updateNextOnItemsAddedOrRemoved();
            this.updateLayersVector();
        } else if (listDataEvent.getSource().equals(this.mSecondTargetList.getModel())) {
            this.mChangeStatisticsButton.setEnabled(true);
            this.mFirstTargetList.clearSelection();
            this.updateNextOnItemsAddedOrRemoved();
            this.updateLayersVector();
        } else if (listDataEvent.getSource().equals(this.mRowsTargetList.getModel())) {
            this.mNestVariableRowsCheckBox.setEnabled(true);
        } else if (listDataEvent.getSource().equals(this.mColumnTargetList.getModel())) {
            this.mNestVariableColumnsCheckBox.setEnabled(true);
        }
        this.updateOkPaste();
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        if (listDataEvent.getSource().equals(this.mFirstTargetList.getModel())) {
            this.enableChangeStatisticButton();
            HighLowFormatterUtil.resetChangeStatisticSubDialog(this.getDialogDataModel());
            this.updateNextOnItemsAddedOrRemoved();
            this.updateLayersVector();
        } else if (listDataEvent.getSource().equals(this.mSecondTargetList.getModel())) {
            this.enableChangeStatisticButton();
            HighLowFormatterUtil.resetChangeStatisticSubDialog(this.getDialogDataModel());
            this.updateNextOnItemsAddedOrRemoved();
            this.updateLayersVector();
        } else if (listDataEvent.getSource().equals(this.mRowsTargetList.getModel())) {
            this.mNestVariableRowsCheckBox.setEnabled(this.mRowsTargetList.getModel().getSize() > 0);
        } else if (listDataEvent.getSource() == this.mColumnTargetList.getModel()) {
            this.mNestVariableColumnsCheckBox.setEnabled(this.mColumnTargetList.getModel().getSize() > 0);
        }
        this.updateOkPaste();
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource().equals(this.mChartSpecificationsCheckBox)) {
            this.mFileButton.setEnabled(this.mChartSpecificationsCheckBox.isSelected());
            this.mFileTextField.setEnabled(this.mChartSpecificationsCheckBox.isSelected());
        }
        this.updateOkPaste();
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getSource().equals(this.mFirstTargetList)) {
            if (this.mFirstTargetList.getSelectedValue() != null) {
                this.mSecondTargetList.clearSelection();
                this.mChangeStatisticsButton.setEnabled(true);
            } else {
                this.mChangeStatisticsButton.setEnabled(false);
            }
        } else if (listSelectionEvent.getSource().equals(this.mSecondTargetList)) {
            if (this.mSecondTargetList.getSelectedValue() != null) {
                this.mFirstTargetList.clearSelection();
                this.mChangeStatisticsButton.setEnabled(true);
            } else {
                this.mChangeStatisticsButton.setEnabled(false);
            }
        }
    }

    @Override
    public String generateSyntax() {
        String string;
        String string2;
        String string3;
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        stringBuffer.append(SyntaxUtil.getMainCommand("GRAPH"));
        stringBuffer.append("\n").append(SyntaxUtil.getSubCommand("/BAR(RANGE)="));
        stringBuffer.append(this.getPairSyntax());
        stringBuffer.append("BY ").append(this.mCategoryAxisTargetList.getModel().getElementAt(0).getName());
        String string4 = HighLowSyntaxUtil.getSyntaxForPanelByPanel(this.getDialogDataModel(), this.mColumnTargetList, this.mRowsTargetList);
        if (string4.length() > 0) {
            stringBuffer.append("\n");
            stringBuffer.append(string4);
        }
        if ((string3 = HighLowSyntaxUtil.getOptionsSubDialogSyntax(this.getDialogDataModel(), false)).length() > 0) {
            stringBuffer.append("\n");
            stringBuffer.append(string3);
        }
        if ((string2 = HighLowSyntaxUtil.getSyntaxForTemplatePanel(this.getDialogDataModel())).length() > 0) {
            stringBuffer.append("\n");
            stringBuffer.append(string2);
        }
        if ((string = GraphsUtil.generateTitlesSubDialogSyntax(this.getDialogDataModel())).length() > 0) {
            stringBuffer.append(string);
        }
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        return stringBuffer.toString();
    }

    @Override
    public boolean okPastePressed() {
        if (!this.saveLayerContents() && this.mCurrentLayer > 0) {
            --this.mCurrentLayer;
        }
        return super.okPastePressed();
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.mFileChooser != null) {
            this.mFileChooser.onDispose();
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.mFirstTargetList.removeAll();
        this.mSecondTargetList.removeAll();
        this.mCurrentLayer = 0;
        this.mLayers.removeAllElements();
        this.mLayersFormattedText.removeAllElements();
        this.addLayer();
        this.mPairPanel.setBorder(BorderFactory.createTitledBorder(this.formatCurrentPanelTitle()));
        this.mCategoryAxisTargetList.removeAll();
        this.mRowsTargetList.removeAll();
        this.mColumnTargetList.removeAll();
        this.mNestVariableColumnsCheckBox.setSelected(false);
        this.mNestVariableRowsCheckBox.setSelected(false);
        this.mChartSpecificationsCheckBox.setSelected(false);
        this.setDefaults();
    }

    int getListSelectionType() {
        return this.mListSelectionType;
    }

    TargetVariableList getFirstTargetList() {
        return this.mFirstTargetList;
    }

    TargetVariableList getSecondTargetList() {
        return this.mSecondTargetList;
    }

    protected void validateSerializableList() {
        int n;
        LocallyUniqueId locallyUniqueId = ProcedureDlgMgr.getMgr().getActiveDatasetId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        Integer n2 = this.getDialogDataModel().getInteger(LAYER_COUNT_KEY);
        int n3 = n2 != null ? n2 : 0;
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        int n4 = 0;
        for (n = 0; n < n3; ++n) {
            int n5;
            Object[] objectArray = this.getDialogDataModel().getArray(LAYERS_KEY + n);
            HashMap<Integer, Object> hashMap = this.getDialogDataModel().getMap(LAYERS_FORMATTED_TEXT_KEY + n);
            int n6 = objectArray.length;
            Vector<ISpssVariable> vector3 = new Vector<ISpssVariable>(n6);
            HashMap<Integer, Object> hashMap2 = new HashMap<Integer, Object>(n6);
            for (n5 = 0; n5 < n6; ++n5) {
                ISpssVariable iSpssVariable = (ISpssVariable)objectArray[n5];
                boolean bl = true;
                if (n5 == 0) {
                    bl = this.mFirstTargetList.canIncludeVariable(iSpssVariable);
                } else if (n5 == 1) {
                    bl = this.mSecondTargetList.canIncludeVariable(iSpssVariable);
                }
                if (!iSpssDataSrc.isVariableInCurrentSet(iSpssVariable) || !bl) break;
                vector3.add(iSpssVariable);
                hashMap2.put(n5, hashMap.get(new Integer(n5)));
            }
            if (n5 == 0 || n5 == 1) continue;
            vector.add(n4, vector3);
            vector2.add(n4, hashMap2);
            ++n4;
        }
        if (n4 > 0) {
            this.getDialogDataModel().putInteger(LAYER_COUNT_KEY, vector.size());
            for (n = 0; n < vector.size(); ++n) {
                this.getDialogDataModel().putArray(LAYERS_KEY + n, ((Vector)vector.get(n)).toArray());
            }
            for (n = 0; n < vector2.size(); ++n) {
                this.getDialogDataModel().putMap(LAYERS_FORMATTED_TEXT_KEY + n, (HashMap)vector2.get(n));
            }
            if (n4 != n3) {
                this.getDialogDataModel().putInteger(CURRENT_LAYER_KEY, 0);
            }
        }
    }

    @Override
    protected void loadDialogState() {
        this.validateSerializableList();
        super.loadDialogState();
        if (this.mChartSpecificationsCheckBox.isSelected()) {
            this.mFileButton.setEnabled(true);
        }
        this.mFirstListFormatter.setVarMap(this.getDialogDataModel().getMap(this.mFirstTargetList.getIdentifier()));
        this.mSecondListFormatter.setVarMap(this.getDialogDataModel().getMap(this.mSecondTargetList.getIdentifier()));
        this.loadLayerListState();
        this.mSrcVarList.setSelectedIndex(0);
    }

    @Override
    protected void saveDialogState() {
        int n;
        super.saveDialogState();
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        dialogDataModel.putMap(this.mFirstTargetList.getIdentifier(), this.mFirstListFormatter.getVarMapForSerialization());
        dialogDataModel.putMap(this.mSecondTargetList.getIdentifier(), this.mSecondListFormatter.getVarMapForSerialization());
        dialogDataModel.putInteger(LAYER_COUNT_KEY, this.mLayers.size());
        for (n = 0; n < this.mLayers.size(); ++n) {
            dialogDataModel.putArray(LAYERS_KEY + n, this.mLayers.get(n).toArray());
        }
        for (n = 0; n < this.mLayersFormattedText.size(); ++n) {
            dialogDataModel.putMap(LAYERS_FORMATTED_TEXT_KEY + n, this.mLayersFormattedText.get(n));
        }
        dialogDataModel.putInteger(CURRENT_LAYER_KEY, this.mCurrentLayer);
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.addComponentsToMainPanel(this.getViewPanel());
        this.addLayer();
        this.mPairPanel.setBorder(BorderFactory.createTitledBorder(this.formatCurrentPanelTitle()));
        this.setTabTraversalOrder();
        this.setDefaults();
        this.pack();
    }

    @Override
    protected JPanel setupOptionsButtonPanel() {
        JPanel jPanel = super.setupOptionsButtonPanel();
        JButton jButton = new JButton(new ToggleButtonAction("IDS_REPORT_COMMON_TITLES_3DOT"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ClusteredRBSeparateVariablesDlg.this.runSubDialog(new TitlesSubDialog(ClusteredRBSeparateVariablesDlg.this));
            }
        });
        this.addOptionsPanelButton(jPanel, jButton);
        JButton jButton2 = new JButton(new ToggleButtonAction("IDS_COMMON_OPTIONS_3DOT"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ClusteredRBSeparateVariablesDlg.this.runSubDialog(new OptionsSubDialog(ClusteredRBSeparateVariablesDlg.this, 1027));
            }
        });
        this.addOptionsPanelButton(jPanel, jButton2);
        return jPanel;
    }

    private void initVars() {
        this.mSrcVarList = new SrcVariableList();
        this.mSrcVarList.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                ClusteredRBSeparateVariablesDlg.this.mFirstTargetList.clearSelection();
                ClusteredRBSeparateVariablesDlg.this.mSecondTargetList.clearSelection();
                ClusteredRBSeparateVariablesDlg.this.mChangeStatisticsButton.setEnabled(false);
            }
        });
        this.mSrcVarList.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                ClusteredRBSeparateVariablesDlg.this.mFirstTargetList.clearSelection();
                ClusteredRBSeparateVariablesDlg.this.mSecondTargetList.clearSelection();
                ClusteredRBSeparateVariablesDlg.this.mChangeStatisticsButton.setEnabled(false);
            }
        });
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, "IDS_HILO_PREVIOUS_BUTTON"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ClusteredRBSeparateVariablesDlg.this.doPrevious();
                ClusteredRBSeparateVariablesDlg.this.updateOkPaste();
                ClusteredRBSeparateVariablesDlg.this.updateNextButton();
            }
        };
        this.mPreviousButton = new JButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_HILO_NEXT_BUTTON"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ClusteredRBSeparateVariablesDlg.this.doNext();
                ClusteredRBSeparateVariablesDlg.this.updateOkPaste();
                ClusteredRBSeparateVariablesDlg.this.updateNextButton();
            }
        };
        this.mNextButton = new JButton(toggleButtonAction);
        SpssVarFilter spssVarFilter = new SpssVarFilter(8, true, false);
        this.mFirstTargetList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mFirstTargetList.setIdentifier("FIRST_TARGET_VARIABLE_LIST_IDENTIFIER");
        this.mFirstTargetList.setDragType(VariableList.VarMoveType.eKeepOriginal);
        this.mFirstTargetList.addVarFilter(spssVarFilter);
        this.mFirstTargetList.addListSelectionListener(this);
        this.mFirstScrollPane = new JScrollPane(this.mFirstTargetList);
        this.mFirstScrollPane.setHorizontalScrollBarPolicy(31);
        this.mFirstScrollPane.setVerticalScrollBarPolicy(21);
        this.mFirstScrollPane.setPreferredSize(this.mFirstTargetList.getMinimumSize());
        this.mFirstLabel = DialogUtil.createLabel(this, "IDS_HILO_FIRST_LABEL");
        this.mFirstLabel.setLabelFor(this.mFirstTargetList);
        this.mFirstArrowButton = new ArrowButton();
        this.mFirstArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mFirstArrowButton.registerVariableList(this.mFirstTargetList, SpssArrowButton.ButtonOrientation.left);
        this.mSecondTargetList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mSecondTargetList.setIdentifier("SECOND_TARGET_VARIABLE_LIST_IDENTIFIER");
        this.mSecondTargetList.setDragType(VariableList.VarMoveType.eKeepOriginal);
        this.mSecondTargetList.addVarFilter(spssVarFilter);
        this.mSecondTargetList.addListSelectionListener(this);
        this.mSecondScrollPane = new JScrollPane(this.mSecondTargetList);
        this.mSecondScrollPane.setHorizontalScrollBarPolicy(31);
        this.mSecondScrollPane.setVerticalScrollBarPolicy(21);
        this.mSecondScrollPane.setPreferredSize(this.mSecondTargetList.getMinimumSize());
        this.mSecondLabel = DialogUtil.createLabel(this, "IDS_HILO_SECOND_LABEL");
        this.mSecondLabel.setLabelFor(this.mSecondTargetList);
        this.mSecondArrowButton = new ArrowButton();
        this.mSecondArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mSecondArrowButton.registerVariableList(this.mSecondTargetList, SpssArrowButton.ButtonOrientation.left);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_HILO_CHANGE_STATISTIC"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ClusteredRBSeparateVariablesDlg.this.runChangeStatisticSubDialog();
            }
        };
        this.mChangeStatisticsButton = new JButton(toggleButtonAction);
        this.mCategoryAxisTargetList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mCategoryAxisTargetList.setIdentifier("CATEGORY_TARGET_VARIABLE_LIST");
        this.mCategoryAxisTargetList.getModel().addListDataListener(this);
        this.mCategoryAxisLabel = DialogUtil.createLabel(this, "IDS_HILO_CATEGORY_AXIS_LABEL");
        this.mCategoryAxisLabel.setLabelFor(this.mCategoryAxisTargetList);
        this.mCategoryArrowButton = new ArrowButton();
        this.mCategoryArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mCategoryArrowButton.registerVariableList(this.mCategoryAxisTargetList, SpssArrowButton.ButtonOrientation.left);
        this.mCategoryScrollPane = new JScrollPane(this.mCategoryAxisTargetList);
        this.mCategoryScrollPane.setHorizontalScrollBarPolicy(31);
        this.mCategoryScrollPane.setVerticalScrollBarPolicy(21);
        this.mCategoryScrollPane.setPreferredSize(this.mCategoryAxisTargetList.getMinimumSize());
        this.mRowsTargetList = new TargetVariableList(TargetVariableList.TargetListType.normal);
        this.mRowsTargetList.setIdentifier("ROWS_TARGET_VARIABLE_LIST");
        this.mRowsTargetList.getModel().addListDataListener(this);
        this.mRowsLabel = DialogUtil.createLabel(this, "IDS_HILO_ROWS_LABEL");
        this.mRowsLabel.setLabelFor(this.mRowsTargetList);
        this.mRowsArrowButton = new ArrowButton();
        this.mRowsArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mRowsArrowButton.registerVariableList(this.mRowsTargetList, SpssArrowButton.ButtonOrientation.left);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_HILO_NEST_VARS_ROWS_CHECKBOX");
        this.mNestVariableRowsCheckBox = new JCheckBox(toggleButtonAction);
        this.mColumnTargetList = new TargetVariableList(TargetVariableList.TargetListType.normal);
        this.mColumnTargetList.setIdentifier("COLUMNS_TARGET_VARIABLE_LIST");
        this.mColumnTargetList.getModel().addListDataListener(this);
        this.mColumnsLabel = DialogUtil.createLabel(this, "IDS_HILO_COLUMNS_LABEL");
        this.mColumnsLabel.setLabelFor(this.mColumnTargetList);
        this.mColumnsArrowButton = new ArrowButton();
        this.mColumnsArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mColumnsArrowButton.registerVariableList(this.mColumnTargetList, SpssArrowButton.ButtonOrientation.left);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_HILO_NEST_VARS_COLUMNS_CHECKBOX");
        this.mNestVariableColumnsCheckBox = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_HILO_USE_CHART_SPEC_FROM_CHECKBOX");
        this.mChartSpecificationsCheckBox = new JCheckBox(toggleButtonAction);
        this.mChartSpecificationsCheckBox.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_HILO_FILE_BUTTON"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = ClusteredRBSeparateVariablesDlg.this.mFileChooser.showOpenDialog((Component)((Object)ClusteredRBSeparateVariablesDlg.this));
                if (n == 0) {
                    ClusteredRBSeparateVariablesDlg.this.mFileTextField.setEnabled(true);
                    ClusteredRBSeparateVariablesDlg.this.mFileTextField.setText(ClusteredRBSeparateVariablesDlg.this.mFileChooser.getSelectedFilePath());
                }
                ClusteredRBSeparateVariablesDlg.this.updateOkPaste();
            }
        };
        this.mFileButton = new JButton(toggleButtonAction);
        this.mFileChooser = new GraphsRemoteFileChooser(this);
        this.mFileTextField = new FileTextField();
        this.mFileTextField.setAction(new TextFieldAction(this, "IDS_HILO_TEMPLATE_FILE_NAME"));
        this.mFileTextField.setEditable(false);
        this.mFileTextField.setOpaque(false);
        this.mFileTextField.setBorder(BorderFactory.createEmptyBorder());
        this.mFirstListFormatter = new HighLowCustomVarFormatter(this.mFirstTargetList);
        this.mFirstTargetList.setModel(new HighLowCustomVarListModel(this.mFirstListFormatter));
        this.mFirstTargetList.getModel().addListDataListener(this);
        this.mFirstTargetList.setCellRenderer(new CustomVarListCellRenderer(this.mFirstListFormatter));
        this.mSecondListFormatter = new HighLowCustomVarFormatter(this.mSecondTargetList);
        this.mSecondTargetList.setModel(new HighLowCustomVarListModel(this.mSecondListFormatter));
        this.mSecondTargetList.getModel().addListDataListener(this);
        this.mSecondTargetList.setCellRenderer(new CustomVarListCellRenderer(this.mSecondListFormatter));
        this.mListSelectionType = -1;
        this.mLayers = new Vector();
        this.mLayersFormattedText = new Vector();
        this.mCurrentLayer = 0;
        this.setupVarMoveHandler();
    }

    private void enableChangeStatisticButton() {
        boolean bl = this.mFirstTargetList.getModel().getSize() > 0 && this.mFirstTargetList.getSelectedValue() != null;
        boolean bl2 = this.mSecondTargetList.getModel().getSize() > 0 && this.mSecondTargetList.getSelectedValue() != null;
        this.mChangeStatisticsButton.setEnabled(bl || bl2);
    }

    private void updateLayers() {
        LocallyUniqueId locallyUniqueId = ProcedureDlgMgr.getMgr().getActiveDatasetId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        for (int i = 0; i < this.mLayers.size(); ++i) {
            Vector<ISpssVariable> vector = this.mLayers.get(i);
            Vector<ISpssVariable> vector2 = new Vector<ISpssVariable>();
            HashMap<Integer, Object> hashMap = this.mLayersFormattedText.get(i);
            HashMap<Integer, Object> hashMap2 = new HashMap<Integer, Object>();
            for (int j = 0; j < vector.size(); ++j) {
                boolean bl;
                ISpssVariable iSpssVariable = vector.get(j);
                boolean bl2 = bl = iSpssVariable.getType() == 0;
                if (iSpssDataSrc.isVariableInCurrentSet(iSpssVariable) && bl) {
                    vector2.add(j, iSpssVariable);
                    hashMap2.put(j, hashMap.get(j));
                    continue;
                }
                vector2.add(j, null);
                hashMap2.put(j, null);
            }
            this.mLayers.set(i, vector2);
            this.mLayersFormattedText.set(i, hashMap2);
        }
        this.updateOkPaste();
    }

    private void loadLayerListState() {
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        Integer n = dialogDataModel.getInteger(LAYER_COUNT_KEY);
        int n2 = n != null ? n : 0;
        for (int i = 0; i < n2; ++i) {
            if (i > 0) {
                this.addLayer();
            }
            Object[] objectArray = dialogDataModel.getArray(LAYERS_KEY + i);
            HashMap<Integer, Object> hashMap = dialogDataModel.getMap(LAYERS_FORMATTED_TEXT_KEY + i);
            int n3 = objectArray.length;
            Vector<ISpssVariable> vector = new Vector<ISpssVariable>(n3);
            HashMap<Integer, Object> hashMap2 = new HashMap<Integer, Object>(n3);
            for (int j = 0; j < n3; ++j) {
                ISpssVariable iSpssVariable = (ISpssVariable)objectArray[j];
                vector.add(iSpssVariable);
                hashMap2.put(j, hashMap.get(new Integer(j)));
            }
            this.mLayers.set(i, vector);
            this.mLayersFormattedText.set(i, hashMap2);
        }
        Integer n4 = dialogDataModel.getInteger(CURRENT_LAYER_KEY);
        this.mCurrentLayer = n4 != null ? n4 : 0;
        this.doLayerPopulate();
        if (this.mLayers.size() > 1) {
            this.mPreviousButton.setEnabled(true);
            this.mPairPanel.setBorder(BorderFactory.createTitledBorder(this.formatCurrentPanelTitle()));
        }
    }

    private void setupVarMoveHandler() {
        HighLowTargetListVarMoveHandler highLowTargetListVarMoveHandler = new HighLowTargetListVarMoveHandler(this, this.mFirstTargetList.getModel(), this.mSecondTargetList.getModel(), null, this.mLayers);
        this.mRowsArrowButton.setVarMoveHandler(highLowTargetListVarMoveHandler);
        this.mColumnsArrowButton.setVarMoveHandler(highLowTargetListVarMoveHandler);
        this.mCategoryArrowButton.setVarMoveHandler(highLowTargetListVarMoveHandler);
        this.mVarMoveHandler = highLowTargetListVarMoveHandler;
    }

    private void setDefaults() {
        this.mPreviousButton.setEnabled(false);
        this.mNextButton.setEnabled(false);
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcVarList.setSelectedIndex(0);
        this.mSrcVarList.requestFocusInWindow();
        this.mChangeStatisticsButton.setEnabled(false);
        this.mNestVariableRowsCheckBox.setEnabled(false);
        this.mNestVariableColumnsCheckBox.setEnabled(false);
        this.mFileButton.setEnabled(false);
        this.mFileTextField.setText("");
    }

    private void doPrevious() {
        if (this.mCurrentLayer == 0) {
            assert (false);
            return;
        }
        this.saveLayerContents();
        --this.mCurrentLayer;
        this.doLayerPopulate();
        this.mSrcVarList.requestFocus();
    }

    private void doLayerPopulate() {
        Vector<ISpssVariable> vector = this.mLayers.get(this.mCurrentLayer);
        HashMap<Integer, Object> hashMap = this.mLayersFormattedText.get(this.mCurrentLayer);
        this.mFirstTargetList.getModel().removeAll();
        this.mSecondTargetList.getModel().removeAll();
        if (vector.size() == 1) {
            ISpssVariable iSpssVariable = vector.get(0);
            if (iSpssVariable != null) {
                this.mFirstTargetList.getModel().addElement(iSpssVariable);
                String string = (String)hashMap.get(0);
                ((HighLowCustomVarListModel)this.mFirstTargetList.getModel()).setElementPropertyAt(0, string);
            }
        } else if (vector.size() == 2) {
            String string;
            ISpssVariable iSpssVariable = vector.get(0);
            if (iSpssVariable != null) {
                this.mFirstTargetList.getModel().addElement(iSpssVariable);
                string = (String)hashMap.get(0);
                ((HighLowCustomVarListModel)this.mFirstTargetList.getModel()).setElementPropertyAt(0, string);
            }
            if ((iSpssVariable = vector.get(1)) != null) {
                this.mSecondTargetList.getModel().addElement(iSpssVariable);
                string = (String)hashMap.get(1);
                ((HighLowCustomVarListModel)this.mSecondTargetList.getModel()).setElementPropertyAt(0, string);
            }
        }
        this.mPairPanel.setBorder(BorderFactory.createTitledBorder(this.formatCurrentPanelTitle()));
    }

    private void doNext() {
        if (this.saveLayerContents()) {
            ++this.mCurrentLayer;
        }
        if (this.mCurrentLayer == this.mLayers.size()) {
            this.addLayer();
        }
        this.doLayerPopulate();
        this.mSrcVarList.requestFocus();
    }

    private void addLayer() {
        this.mLayers.add(new Vector(0));
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        hashMap.put(0, "");
        hashMap.put(1, "");
        this.mLayersFormattedText.add(hashMap);
    }

    private boolean saveLayerContents() {
        boolean bl = false;
        if (this.mCurrentLayer < this.mLayers.size()) {
            String string;
            Vector<ISpssVariable> vector = new Vector<ISpssVariable>();
            HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
            if (this.mFirstTargetList.getModel().getSize() > 0) {
                vector.add(this.mFirstTargetList.getModel().getElementAt(0));
                string = ((HighLowCustomVarListModel)this.mFirstTargetList.getModel()).getElementPropertyAt(0);
                hashMap.put(0, string);
            }
            if (this.mSecondTargetList.getModel().getSize() > 0) {
                vector.add(this.mSecondTargetList.getModel().getElementAt(0));
                string = ((HighLowCustomVarListModel)this.mSecondTargetList.getModel()).getElementPropertyAt(0);
                hashMap.put(1, string);
            }
            if (vector.size() >= 1) {
                bl = true;
                this.mLayers.set(this.mCurrentLayer, vector);
                this.mLayersFormattedText.set(this.mCurrentLayer, hashMap);
            } else {
                this.mLayers.remove(this.mCurrentLayer);
                this.mLayersFormattedText.remove(this.mCurrentLayer);
            }
        }
        return bl;
    }

    private void updateLayersVector() {
        String string;
        Vector<ISpssVariable> vector = new Vector<ISpssVariable>();
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        if (this.mFirstTargetList.getModel().getSize() > 0) {
            vector.add(this.mFirstTargetList.getModel().getElementAt(0));
            string = ((HighLowCustomVarListModel)this.mFirstTargetList.getModel()).getElementPropertyAt(0);
            hashMap.put(0, string);
        }
        if (this.mSecondTargetList.getModel().getSize() > 0) {
            vector.add(this.mSecondTargetList.getModel().getElementAt(0));
            string = ((HighLowCustomVarListModel)this.mSecondTargetList.getModel()).getElementPropertyAt(0);
            hashMap.put(1, string);
        }
        this.mLayers.set(this.mCurrentLayer, vector);
        this.mLayersFormattedText.set(this.mCurrentLayer, hashMap);
    }

    private void runChangeStatisticSubDialog() {
        this.mListSelectionType = this.mFirstTargetList.getSelectedValue() != null ? 0 : 1;
        if (this.runSubDialog(new ChangeStatisticSubDlg(this, this.getResString("IDS_HILO_CHANGE_STATISTIC_TITLE"), true))) {
            String string = HighLowFormatterUtil.getFormattedText(this.getDialogDataModel(), this.mListSelectionType);
            HashMap<Integer, Object> hashMap = this.mLayersFormattedText.get(this.mCurrentLayer);
            if (this.mFirstTargetList.getSelectedValue() != null) {
                ((HighLowCustomVarListModel)this.mFirstTargetList.getModel()).setElementPropertyAt(this.mFirstTargetList.getSelectedIndex(), string);
                hashMap.put(0, string);
            } else if (this.mSecondTargetList.getSelectedValue() != null) {
                ((HighLowCustomVarListModel)this.mSecondTargetList.getModel()).setElementPropertyAt(this.mSecondTargetList.getSelectedIndex(), string);
                hashMap.put(1, string);
            }
            this.mLayersFormattedText.set(this.mCurrentLayer, hashMap);
        }
    }

    private void addComponentsToMainPanel(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = 23;
        JScrollPane jScrollPane = new JScrollPane(this.mSrcVarList);
        jScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBorder(BorderFactory.createEmptyBorder());
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_HILO_SRCLIST_LABEL");
        jLabel.setLabelFor(this.mSrcVarList);
        DialogUtil.addUsingGBL(jPanel2, jLabel, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel2, jScrollPane, gridBagConstraints, 0, 1, 1, 1, n, null);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 3, n, null);
        this.mPairPanel = this.setupPairPanel();
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        Insets insets = new Insets(0, DialogUtil.getComponentGroupGap(), 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mPairPanel, gridBagConstraints, 1, 0, 1, 1, n, insets);
        JPanel jPanel3 = this.setupCategoryPanel();
        insets.set(DialogUtil.getComponentGroupGap(), 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 1, 1, 1, 1, n, insets);
        JPanel jPanel4 = this.setupPanelByPanel();
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        insets.set(DialogUtil.getComponentGroupGap(), DialogUtil.getComponentGroupGap(), 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel4, gridBagConstraints, 1, 2, 1, 1, n, insets);
        JPanel jPanel5 = this.setupTemplatePanel();
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        insets.set(DialogUtil.getComponentGroupGap(), 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel5, gridBagConstraints, 0, 3, 2, 1, n, insets);
    }

    private JPanel setupPairPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.formatCurrentPanelTitle()));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        JPanel jPanel2 = this.setupButtonPanel();
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, null);
        JComponent[] jComponentArray = new JComponent[]{this.mFirstArrowButton, this.mFirstLabel, this.mFirstScrollPane, this.mSecondArrowButton, this.mSecondLabel, this.mSecondScrollPane, this.mChangeStatisticsButton};
        JPanel jPanel3 = HighLowPanelFactory.getFirstSecondChangeStatisticsPanel(jComponentArray, true);
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 1, 1, 1, n, null);
        return jPanel;
    }

    private JPanel setupButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        int n = 23;
        Insets insets = new Insets(3, DialogUtil.getGroupBoxInnerMargin(), 2, 2);
        DialogUtil.addUsingGBL(jPanel, this.mPreviousButton, gridBagConstraints, 0, 0, 1, 1, n, insets);
        n = 24;
        insets.set(3, 3, 2, DialogUtil.getGroupBoxInnerMargin());
        DialogUtil.addUsingGBL(jPanel, this.mNextButton, gridBagConstraints, 1, 0, 1, 1, n, insets);
        UIToolDialogUtil.normalizeButtonWidths((JPanel)jPanel);
        return jPanel;
    }

    private String formatCurrentPanelTitle() {
        return String.format(ComponentState.getSPSSLocale(), this.getResString("IDS_HILO_PAIR_FORMAT"), this.mCurrentLayer + 1, this.mLayers.size());
    }

    private JPanel setupCategoryPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        Insets insets = new Insets(0, 3, 0, n2);
        DialogUtil.addUsingGBL(jPanel, this.mCategoryAxisLabel, gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        insets.set(0, DialogUtil.getArrowButtonInsets().left + n2 + 3, 0, DialogUtil.getArrowButtonInsets().right);
        DialogUtil.addUsingGBL(jPanel, this.mCategoryArrowButton, gridBagConstraints, 0, 0, 1, 2, 20, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        insets.set(0, 3, 0, n2 + 4);
        DialogUtil.addUsingGBL(jPanel, this.mCategoryScrollPane, gridBagConstraints, 1, 1, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setupPanelByPanel() {
        JComponent[] jComponentArray = new JComponent[]{this.mRowsLabel, this.mRowsArrowButton, this.mRowsTargetList, this.mNestVariableRowsCheckBox, this.mColumnsLabel, this.mColumnsArrowButton, this.mColumnTargetList, this.mNestVariableColumnsCheckBox};
        return PanelFactory.getGraphsPanelByPanel(jComponentArray, this.getResString("IDS_HILO_PANEL_BY_PANEL_TITLE"));
    }

    private JPanel setupTemplatePanel() {
        JComponent[] jComponentArray = new JComponent[8];
        jComponentArray[0] = this.mChartSpecificationsCheckBox;
        jComponentArray[1] = this.mFileButton;
        jComponentArray[2] = this.mFileTextField;
        return PanelFactory.getGraphsChartTemplatePanel(jComponentArray, this.getResString("IDS_HILO_TEMPLATE_PANEL_TITLE"));
    }

    private String getPairSyntax() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.mLayers.size(); ++i) {
            Vector<ISpssVariable> vector = this.mLayers.get(i);
            HashMap<Integer, Object> hashMap = this.mLayersFormattedText.get(i);
            ISpssVariable iSpssVariable = vector.get(0);
            stringBuffer.append(hashMap.get(0)).append("(");
            stringBuffer.append(iSpssVariable.getName());
            stringBuffer.append(")");
            iSpssVariable = vector.get(1);
            stringBuffer.append(" ").append(hashMap.get(1)).append("(").append(iSpssVariable.getName()).append(")");
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    private void updateNextButton() {
        boolean bl;
        boolean bl2 = this.mFirstTargetList.getModel().getSize() > 0;
        boolean bl3 = this.mSecondTargetList.getModel().getSize() > 0;
        boolean bl4 = bl = this.mCurrentLayer < 9;
        if (bl2 && bl3) {
            if (bl) {
                this.mNextButton.setEnabled(true);
            }
        } else {
            this.mNextButton.setEnabled(false);
        }
        this.mPreviousButton.setEnabled(this.mCurrentLayer > 0);
    }

    private void updateNextOnItemsAddedOrRemoved() {
        boolean bl;
        boolean bl2 = this.mFirstTargetList.getModel().getSize() > 0;
        boolean bl3 = this.mSecondTargetList.getModel().getSize() > 0;
        boolean bl4 = bl = this.mCurrentLayer < 9;
        if (bl2 && bl3) {
            if (bl) {
                this.mNextButton.setEnabled(true);
            }
            this.mPreviousButton.setEnabled(this.mCurrentLayer > 0);
        } else if (bl2 || bl3) {
            this.mNextButton.setEnabled(false);
            this.mPreviousButton.setEnabled(false);
        } else {
            this.mNextButton.setEnabled(this.mCurrentLayer < this.mLayers.size() - 1);
            this.mPreviousButton.setEnabled(this.mCurrentLayer > 0);
        }
    }

    private void updateOkPaste() {
        boolean bl = true;
        int n = 0;
        for (Vector<ISpssVariable> vector : this.mLayers) {
            if (n == this.mCurrentLayer) {
                if (this.mFirstTargetList.getModel().getSize() == 0 || this.mSecondTargetList.getModel().getSize() == 0) {
                    bl = false;
                    break;
                }
            } else {
                if (vector.size() == 1) {
                    bl = false;
                    break;
                }
                if (vector.size() == 2 && (vector.get(0) == null || vector.get(1) == null)) {
                    bl = false;
                    break;
                }
            }
            ++n;
        }
        boolean bl2 = this.mLayers.size() >= 2;
        boolean bl3 = this.mCategoryAxisTargetList.getModel().getSize() > 0;
        boolean bl4 = true;
        if (this.mChartSpecificationsCheckBox.isSelected()) {
            bl4 = this.mFileTextField.getText() != null && this.mFileTextField.getText().length() > 0;
        }
        this.enableOkPaste(bl && bl3 && bl4 && bl2);
    }

    private void setTabTraversalOrder() {
        int n;
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcVarList);
        vector.add(this.mFirstArrowButton);
        vector.add(this.mSecondArrowButton);
        vector.add(this.mCategoryArrowButton);
        vector.add(this.mRowsArrowButton);
        vector.add(this.mColumnsArrowButton);
        vector.add(this.mFirstTargetList);
        vector.add(this.mSecondTargetList);
        vector.add(this.mChangeStatisticsButton);
        vector.add(this.mNextButton);
        vector.add(this.mPreviousButton);
        vector.add(this.mCategoryAxisTargetList);
        vector.add(this.mRowsTargetList);
        vector.add(this.mNestVariableRowsCheckBox);
        vector.add(this.mColumnTargetList);
        vector.add(this.mNestVariableColumnsCheckBox);
        vector.add(this.mChartSpecificationsCheckBox);
        vector.add(this.mFileButton);
        for (n = 0; n < this.mOptionButtonPanel.getComponentCount(); ++n) {
            Component component = this.mOptionButtonPanel.getComponent(n);
            if (!(component instanceof JButton)) continue;
            vector.add(this.mOptionButtonPanel.getComponent(n));
        }
        for (n = 0; n < this.mCmdButtonPanel.getComponentCount(); ++n) {
            vector.add(this.mCmdButtonPanel.getComponent(n));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    @Override
    protected BaseProcedureDialog.DataViewObserverAdapter createDataSourceObserver() {
        return new CustomDataViewObserverAdapter();
    }

    class CustomDataViewObserverAdapter
    extends BaseProcedureDialog.DataViewObserverAdapter {
        CustomDataViewObserverAdapter() {
            super(ClusteredRBSeparateVariablesDlg.this);
        }

        @Override
        public void notifyVariablesDeleted(int n, int n2, int n3, ORIGINATOR_ID oRIGINATOR_ID) {
            super.notifyVariablesDeleted(n, n2, n3, oRIGINATOR_ID);
            if (ProcedureDlgMgr.getMgr().anyProcedureDialogsRunning(true)) {
                ClusteredRBSeparateVariablesDlg.this.updateLayers();
            }
        }

        @Override
        public void notifyVariableModified(ORIGINATOR_ID oRIGINATOR_ID, int n) {
            super.notifyVariableModified(oRIGINATOR_ID, n);
            if (ProcedureDlgMgr.getMgr().anyProcedureDialogsRunning(true)) {
                ClusteredRBSeparateVariablesDlg.this.updateLayers();
            }
        }
    }
}

