/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.graphs.legacy_dialogs.high_low;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.ORIGINATOR_ID;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.FileTextField;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.base.graphs.GraphsRemoteFileChooser;
import com.spss.java_client.ui.dialogs.base.graphs.GraphsUtil;
import com.spss.java_client.ui.dialogs.base.graphs.TitlesSubDialog;
import com.spss.java_client.ui.dialogs.base.graphs.legacy_dialogs.high_low.HighLowPanelFactory;
import com.spss.java_client.ui.dialogs.base.graphs.legacy_dialogs.high_low.HighLowSyntaxUtil;
import com.spss.java_client.ui.dialogs.base.graphs.legacy_dialogs.high_low.HighLowTargetListVarMoveHandler;
import com.spss.java_client.ui.dialogs.base.graphs.res.GraphsResBundle;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.uitools.dialogs.UIToolDialogUtil;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class ClusteredHLCValuesOfIndividualCasesDlg
extends BaseProcedureDialog
implements ListDataListener,
ItemListener {
    private static final int MAX_LAYERS = 10;
    private static final String LAYER_COUNT_KEY = "IDS_HILO_LAYER_COUNT";
    private static final String LAYERS_KEY = "IDS_HILO_LAYERS";
    private static final String CURRENT_LAYER_KEY = "IDS_HILO_CURRENT_LAYER";
    private SrcVariableList mSrcVarList;
    private JButton mNextButton;
    private JButton mPreviousButton;
    private JLabel mHighLabel;
    private TargetVariableList mHighTargetList;
    private JScrollPane mHighScrollPane;
    private ArrowButton mHighArrowButton;
    private JLabel mLowLabel;
    private TargetVariableList mLowTargetList;
    private JScrollPane mLowScrollPane;
    private ArrowButton mLowArrowButton;
    private JLabel mCloseLabel;
    private TargetVariableList mCloseTargetList;
    private JScrollPane mCloseScrollPane;
    private ArrowButton mCloseArrowButton;
    private JRadioButton mCaseNumberRadio;
    private JRadioButton mVariableRadio;
    private SpssButtonGroup mCategoryButtonGroup;
    private TargetVariableList mVariableTargetList;
    private JScrollPane mVariableScrollPane;
    private ArrowButton mVariableArrowButton;
    private JLabel mRowsLabel;
    private TargetVariableList mRowsTargetList;
    private ArrowButton mRowsArrowButton;
    private JCheckBox mNestVariableRowsCheckBox;
    private JLabel mColumnsLabel;
    private TargetVariableList mColumnTargetList;
    private ArrowButton mColumnsArrowButton;
    private JCheckBox mNestVariableColumnsCheckBox;
    private JCheckBox mChartSpecificationsCheckBox;
    private JButton mFileButton;
    private FileTextField mFileTextField;
    private int mCurrentLayer;
    private Vector<Vector<ISpssVariable>> mLayers;
    private GraphsRemoteFileChooser mFileChooser;
    private JPanel mVariableSetPanel;

    public ClusteredHLCValuesOfIndividualCasesDlg(JFrame jFrame) {
        super(jFrame, false, GraphsResBundle.getDefaultResourceBundleName(), GraphsResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_HILO_CLUSTERED_VALUES_OF_INDIVIDUAL_CASES_DIALOG_TITLE"));
    }

    public void paint(Graphics graphics) {
        this.mFileTextField.setText(this.mFileTextField.getText());
        super.paint(graphics);
        super.validate();
    }

    @Override
    public String getDialogHelpID() {
        return "idh_ghxi";
    }

    @Override
    public String getIActionKey() {
        return "graphs_legacy_dialogs_high_low_clustered_values_of_individual_cases";
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        if (listDataEvent.getSource().equals(this.mRowsTargetList.getModel())) {
            this.mNestVariableRowsCheckBox.setEnabled(true);
        } else if (listDataEvent.getSource().equals(this.mColumnTargetList.getModel())) {
            this.mNestVariableColumnsCheckBox.setEnabled(true);
        } else if (listDataEvent.getSource().equals(this.mHighTargetList.getModel()) || listDataEvent.getSource().equals(this.mLowTargetList.getModel())) {
            this.updateLayersVector();
            this.updateNextOnItemsAddedOrRemoved();
        } else if (listDataEvent.getSource().equals(this.mCloseTargetList.getModel())) {
            this.updateLayersVector();
        }
        this.updateOkPaste();
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        if (listDataEvent.getSource().equals(this.mRowsTargetList.getModel())) {
            this.mNestVariableRowsCheckBox.setEnabled(this.mRowsTargetList.getModel().getSize() > 0);
        } else if (listDataEvent.getSource() == this.mColumnTargetList.getModel()) {
            this.mNestVariableColumnsCheckBox.setEnabled(this.mColumnTargetList.getModel().getSize() > 0);
        } else if (listDataEvent.getSource().equals(this.mHighTargetList.getModel()) || listDataEvent.getSource().equals(this.mLowTargetList.getModel())) {
            this.updateLayersVector();
            this.updateNextOnItemsAddedOrRemoved();
        } else if (listDataEvent.getSource().equals(this.mCloseTargetList.getModel())) {
            this.updateLayersVector();
        }
        this.updateOkPaste();
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        boolean bl;
        boolean bl2 = bl = itemEvent.getStateChange() == 1;
        if (itemEvent.getSource().equals(this.mChartSpecificationsCheckBox)) {
            this.mFileButton.setEnabled(this.mChartSpecificationsCheckBox.isSelected());
            this.mFileTextField.setEnabled(this.mChartSpecificationsCheckBox.isSelected());
        } else if (itemEvent.getSource().equals(this.mCaseNumberRadio) && bl) {
            this.mVariableArrowButton.setEnabled(false);
            this.mVariableTargetList.setEnabled(false);
            this.mVariableTargetList.setOpaque(false);
        } else if (itemEvent.getSource().equals(this.mVariableRadio) && bl) {
            this.mVariableTargetList.setEnabled(true);
            this.mVariableTargetList.setOpaque(true);
            this.mVariableScrollPane.setEnabled(true);
            if (this.mVariableTargetList.getModel().getSize() > 0 && SpssArrowButton.ButtonOrientation.right != this.mVariableArrowButton.getArrowOrientation()) {
                this.mVariableArrowButton.setEnabled(true);
                this.mVariableTargetList.setSelectedIndex(0);
            } else if (this.mVariableTargetList.getModel().getSize() > 0 && SpssArrowButton.ButtonOrientation.right == this.mVariableArrowButton.getArrowOrientation()) {
                this.mVariableArrowButton.setEnabled(false);
            } else if (this.mSrcVarList.getSelectedValue() != null && this.mSrcVarList.getSelectedIndices().length == 1) {
                this.mVariableArrowButton.setEnabled(true);
            } else {
                this.mVariableArrowButton.setEnabled(false);
            }
        }
        this.updateOkPaste();
    }

    @Override
    public String generateSyntax() {
        String string;
        String string2;
        String string3;
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        stringBuffer.append(SyntaxUtil.getMainCommand("GRAPH"));
        stringBuffer.append("\n").append(SyntaxUtil.getSubCommand("/HILO(GROUPED)="));
        stringBuffer.append(this.getVariableSetSyntax());
        String string4 = HighLowSyntaxUtil.getSyntaxForCategoryLabelsPanel(this.mVariableRadio, this.mVariableTargetList);
        if (string4.length() > 0) {
            stringBuffer.append(string4);
        }
        if ((string3 = HighLowSyntaxUtil.getSyntaxForPanelByPanel(this.getDialogDataModel(), this.mColumnTargetList, this.mRowsTargetList)).length() > 0) {
            stringBuffer.append("\n");
            stringBuffer.append(string3);
        }
        if ((string2 = HighLowSyntaxUtil.getSyntaxForTemplatePanel(this.getDialogDataModel())).length() > 0) {
            stringBuffer.append("\n");
            stringBuffer.append(string2);
        }
        if ((string = GraphsUtil.generateTitlesSubDialogSyntax(this.getDialogDataModel())).length() > 0) {
            stringBuffer.append(string);
        }
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        return stringBuffer.toString();
    }

    @Override
    public boolean okPastePressed() {
        if (!this.saveLayerContents() && this.mCurrentLayer > 0) {
            --this.mCurrentLayer;
        }
        return super.okPastePressed();
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.mFileChooser != null) {
            this.mFileChooser.onDispose();
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.mHighTargetList.removeAll();
        this.mLowTargetList.removeAll();
        this.mCloseTargetList.removeAll();
        this.mCurrentLayer = 0;
        this.mLayers.removeAllElements();
        this.addLayer();
        this.mVariableSetPanel.setBorder(BorderFactory.createTitledBorder(this.formatCurrentPanelTitle()));
        this.mVariableTargetList.removeAll();
        this.mRowsTargetList.removeAll();
        this.mColumnTargetList.removeAll();
        this.mNestVariableColumnsCheckBox.setSelected(false);
        this.mNestVariableRowsCheckBox.setSelected(false);
        this.mChartSpecificationsCheckBox.setSelected(false);
        this.setDefaults();
        this.updateOkPaste();
    }

    protected void validateSerializableList() {
        int n;
        LocallyUniqueId locallyUniqueId = ProcedureDlgMgr.getMgr().getActiveDatasetId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        Integer n2 = this.getDialogDataModel().getInteger(LAYER_COUNT_KEY);
        int n3 = n2 != null ? n2 : 0;
        Vector vector = new Vector();
        int n4 = 0;
        for (n = 0; n < n3; ++n) {
            int n5;
            Object[] objectArray = this.getDialogDataModel().getArray(LAYERS_KEY + n);
            int n6 = objectArray.length;
            Vector<ISpssVariable> vector2 = new Vector<ISpssVariable>(n6);
            for (n5 = 0; n5 < n6; ++n5) {
                ISpssVariable iSpssVariable = (ISpssVariable)objectArray[n5];
                boolean bl = true;
                if (n5 == 0) {
                    bl = this.mHighTargetList.canIncludeVariable(iSpssVariable);
                } else if (n5 == 1) {
                    bl = this.mLowTargetList.canIncludeVariable(iSpssVariable);
                } else if (n5 == 2) {
                    bl = this.mCloseTargetList.canIncludeVariable(iSpssVariable);
                }
                if (!iSpssDataSrc.isVariableInCurrentSet(iSpssVariable) || !bl) break;
                vector2.add(iSpssVariable);
            }
            if (n5 == 0 || n5 == 1) continue;
            vector.add(n4, vector2);
            ++n4;
        }
        if (n4 > 0) {
            this.getDialogDataModel().putInteger(LAYER_COUNT_KEY, vector.size());
            for (n = 0; n < vector.size(); ++n) {
                this.getDialogDataModel().putArray(LAYERS_KEY + n, ((Vector)vector.get(n)).toArray());
            }
            if (n4 != n3) {
                this.getDialogDataModel().putInteger(CURRENT_LAYER_KEY, 0);
            }
        }
    }

    @Override
    protected void loadDialogState() {
        this.validateSerializableList();
        super.loadDialogState();
        if (this.mChartSpecificationsCheckBox.isSelected()) {
            this.mFileButton.setEnabled(true);
        }
        this.loadLayerListState();
        this.mSrcVarList.setSelectedIndex(0);
    }

    @Override
    protected void saveDialogState() {
        super.saveDialogState();
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        dialogDataModel.putInteger(LAYER_COUNT_KEY, this.mLayers.size());
        for (int i = 0; i < this.mLayers.size(); ++i) {
            dialogDataModel.putArray(LAYERS_KEY + i, this.mLayers.get(i).toArray());
        }
        dialogDataModel.putInteger(CURRENT_LAYER_KEY, this.mCurrentLayer);
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.addComponentsToMainPanel(this.getViewPanel());
        this.addLayer();
        this.mVariableSetPanel.setBorder(BorderFactory.createTitledBorder(this.formatCurrentPanelTitle()));
        this.setTabTraversalOrder();
        this.setDefaults();
        this.pack();
    }

    @Override
    protected JPanel setupOptionsButtonPanel() {
        JPanel jPanel = super.setupOptionsButtonPanel();
        JButton jButton = new JButton(new ToggleButtonAction("IDS_REPORT_COMMON_TITLES_3DOT"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ClusteredHLCValuesOfIndividualCasesDlg.this.runSubDialog(new TitlesSubDialog(ClusteredHLCValuesOfIndividualCasesDlg.this));
            }
        });
        this.addOptionsPanelButton(jPanel, jButton);
        return jPanel;
    }

    private void initVars() {
        this.mSrcVarList = new SrcVariableList();
        this.mSrcVarList.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                ClusteredHLCValuesOfIndividualCasesDlg.this.mHighTargetList.clearSelection();
                ClusteredHLCValuesOfIndividualCasesDlg.this.mLowTargetList.clearSelection();
                ClusteredHLCValuesOfIndividualCasesDlg.this.mCloseTargetList.clearSelection();
            }
        });
        this.mSrcVarList.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                ClusteredHLCValuesOfIndividualCasesDlg.this.mHighTargetList.clearSelection();
                ClusteredHLCValuesOfIndividualCasesDlg.this.mLowTargetList.clearSelection();
                ClusteredHLCValuesOfIndividualCasesDlg.this.mCloseTargetList.clearSelection();
            }
        });
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, "IDS_HILO_PREVIOUS_BUTTON"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ClusteredHLCValuesOfIndividualCasesDlg.this.doPrevious();
                ClusteredHLCValuesOfIndividualCasesDlg.this.updateOkPaste();
                ClusteredHLCValuesOfIndividualCasesDlg.this.updateNextButton();
            }
        };
        this.mPreviousButton = new JButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_HILO_NEXT_BUTTON"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ClusteredHLCValuesOfIndividualCasesDlg.this.doNext();
                ClusteredHLCValuesOfIndividualCasesDlg.this.updateOkPaste();
                ClusteredHLCValuesOfIndividualCasesDlg.this.updateNextButton();
            }
        };
        this.mNextButton = new JButton(toggleButtonAction);
        SpssVarFilter spssVarFilter = new SpssVarFilter(8, true, false);
        this.mHighTargetList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mHighTargetList.setIdentifier("HIGH_TARGET_VARIABLE_LIST_IDENTIFIER");
        this.mHighTargetList.setDragType(VariableList.VarMoveType.eKeepOriginal);
        this.mHighTargetList.getModel().addListDataListener(this);
        this.mHighTargetList.addVarFilter(spssVarFilter);
        this.mHighScrollPane = new JScrollPane(this.mHighTargetList);
        this.mHighScrollPane.setHorizontalScrollBarPolicy(31);
        this.mHighScrollPane.setVerticalScrollBarPolicy(21);
        this.mHighScrollPane.setPreferredSize(this.mHighTargetList.getMinimumSize());
        this.mHighLabel = DialogUtil.createLabel(this, "IDS_HILO_HIGH_LABEL");
        this.mHighLabel.setLabelFor(this.mHighTargetList);
        this.mHighArrowButton = new ArrowButton();
        this.mHighArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mHighArrowButton.registerVariableList(this.mHighTargetList, SpssArrowButton.ButtonOrientation.left);
        this.mLowTargetList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mLowTargetList.setIdentifier("LOW_TARGET_VARIABLE_LIST_IDENTIFIER");
        this.mLowTargetList.setDragType(VariableList.VarMoveType.eKeepOriginal);
        this.mLowTargetList.getModel().addListDataListener(this);
        this.mLowTargetList.addVarFilter(spssVarFilter);
        this.mLowScrollPane = new JScrollPane(this.mLowTargetList);
        this.mLowScrollPane.setHorizontalScrollBarPolicy(31);
        this.mLowScrollPane.setVerticalScrollBarPolicy(21);
        this.mLowScrollPane.setPreferredSize(this.mLowTargetList.getMinimumSize());
        this.mLowLabel = DialogUtil.createLabel(this, "IDS_HILO_LOW_LABEL");
        this.mLowLabel.setLabelFor(this.mLowTargetList);
        this.mLowArrowButton = new ArrowButton();
        this.mLowArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mLowArrowButton.registerVariableList(this.mLowTargetList, SpssArrowButton.ButtonOrientation.left);
        this.mCloseTargetList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mCloseTargetList.setIdentifier("CLOSE_TARGET_VARIABLE_LIST_IDENTIFIER");
        this.mCloseTargetList.setDragType(VariableList.VarMoveType.eKeepOriginal);
        this.mCloseTargetList.getModel().addListDataListener(this);
        this.mCloseTargetList.addVarFilter(spssVarFilter);
        this.mCloseScrollPane = new JScrollPane(this.mCloseTargetList);
        this.mCloseScrollPane.setHorizontalScrollBarPolicy(31);
        this.mCloseScrollPane.setVerticalScrollBarPolicy(21);
        this.mCloseScrollPane.setPreferredSize(this.mCloseTargetList.getMinimumSize());
        this.mCloseLabel = DialogUtil.createLabel(this, "IDS_HILO_CLOSE_LABEL");
        this.mCloseLabel.setLabelFor(this.mCloseTargetList);
        this.mCloseArrowButton = new ArrowButton();
        this.mCloseArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mCloseArrowButton.registerVariableList(this.mCloseTargetList, SpssArrowButton.ButtonOrientation.left);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_HILO_CASE_NUMBER");
        this.mCaseNumberRadio = new JRadioButton(toggleButtonAction);
        this.mCaseNumberRadio.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_HILO_CLUSTERED_VARIABLE");
        this.mVariableRadio = new JRadioButton(toggleButtonAction);
        this.mVariableRadio.addItemListener(this);
        this.mVariableTargetList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mVariableTargetList.setIdentifier("VARIABLE_LIST_IDENTIFIER");
        this.mVariableTargetList.getModel().addListDataListener(this);
        this.mVariableArrowButton = new ArrowButton();
        this.mVariableArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mVariableArrowButton.registerVariableList(this.mVariableTargetList, SpssArrowButton.ButtonOrientation.left);
        this.mVariableScrollPane = new JScrollPane(this.mVariableTargetList);
        this.mVariableScrollPane.setHorizontalScrollBarPolicy(31);
        this.mVariableScrollPane.setVerticalScrollBarPolicy(21);
        this.mVariableScrollPane.setPreferredSize(this.mVariableTargetList.getMinimumSize());
        this.mRowsTargetList = new TargetVariableList(TargetVariableList.TargetListType.normal);
        this.mRowsTargetList.setIdentifier("ROWS_TARGET_VARIABLE_LIST");
        this.mRowsTargetList.getModel().addListDataListener(this);
        this.mRowsLabel = DialogUtil.createLabel(this, "IDS_HILO_ROWS_LABEL");
        this.mRowsLabel.setLabelFor(this.mRowsTargetList);
        this.mRowsArrowButton = new ArrowButton();
        this.mRowsArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mRowsArrowButton.registerVariableList(this.mRowsTargetList, SpssArrowButton.ButtonOrientation.left);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_HILO_NEST_VARS_ROWS_CHECKBOX");
        this.mNestVariableRowsCheckBox = new JCheckBox(toggleButtonAction);
        this.mColumnTargetList = new TargetVariableList(TargetVariableList.TargetListType.normal);
        this.mColumnTargetList.setIdentifier("COLUMNS_TARGET_VARIABLE_LIST");
        this.mColumnTargetList.getModel().addListDataListener(this);
        this.mColumnsLabel = DialogUtil.createLabel(this, "IDS_HILO_SIMPLE_COLUMNS_LABEL");
        this.mColumnsLabel.setLabelFor(this.mColumnTargetList);
        this.mColumnsArrowButton = new ArrowButton();
        this.mColumnsArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mColumnsArrowButton.registerVariableList(this.mColumnTargetList, SpssArrowButton.ButtonOrientation.left);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_HILO_NEST_VARS_COLUMNS_CHECKBOX");
        this.mNestVariableColumnsCheckBox = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_HILO_USE_CHART_SPEC_FROM_CHECKBOX");
        this.mChartSpecificationsCheckBox = new JCheckBox(toggleButtonAction);
        this.mChartSpecificationsCheckBox.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_HILO_FILE_BUTTON"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = ClusteredHLCValuesOfIndividualCasesDlg.this.mFileChooser.showOpenDialog((Component)((Object)ClusteredHLCValuesOfIndividualCasesDlg.this));
                if (n == 0) {
                    ClusteredHLCValuesOfIndividualCasesDlg.this.mFileTextField.setEnabled(true);
                    ClusteredHLCValuesOfIndividualCasesDlg.this.mFileTextField.setText(ClusteredHLCValuesOfIndividualCasesDlg.this.mFileChooser.getSelectedFilePath());
                }
                ClusteredHLCValuesOfIndividualCasesDlg.this.updateOkPaste();
            }
        };
        this.mFileButton = new JButton(toggleButtonAction);
        this.mFileChooser = new GraphsRemoteFileChooser(this);
        this.mFileTextField = new FileTextField();
        this.mFileTextField.setAction(new TextFieldAction(this, "IDS_HILO_TEMPLATE_FILE_NAME"));
        this.mFileTextField.setEditable(false);
        this.mFileTextField.setOpaque(false);
        this.mFileTextField.setBorder(BorderFactory.createEmptyBorder());
        this.mLayers = new Vector();
        this.mCurrentLayer = 0;
        this.setupVarMoveHandler();
    }

    private void setupVarMoveHandler() {
        HighLowTargetListVarMoveHandler highLowTargetListVarMoveHandler = new HighLowTargetListVarMoveHandler(this, this.mHighTargetList.getModel(), this.mLowTargetList.getModel(), this.mCloseTargetList.getModel(), this.mLayers);
        this.mRowsArrowButton.setVarMoveHandler(highLowTargetListVarMoveHandler);
        this.mColumnsArrowButton.setVarMoveHandler(highLowTargetListVarMoveHandler);
        this.mVariableArrowButton.setVarMoveHandler(highLowTargetListVarMoveHandler);
        this.mVarMoveHandler = highLowTargetListVarMoveHandler;
    }

    private void setDefaults() {
        this.mPreviousButton.setEnabled(false);
        this.mNextButton.setEnabled(false);
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcVarList.setSelectedIndex(0);
        this.mSrcVarList.requestFocusInWindow();
        this.mCaseNumberRadio.setSelected(true);
        this.mVariableArrowButton.setEnabled(false);
        this.mVariableTargetList.setEnabled(false);
        this.mVariableTargetList.setOpaque(false);
        this.mNestVariableRowsCheckBox.setEnabled(false);
        this.mNestVariableColumnsCheckBox.setEnabled(false);
        this.mFileButton.setEnabled(false);
        this.mFileTextField.setText("");
    }

    private void updateLayers() {
        LocallyUniqueId locallyUniqueId = ProcedureDlgMgr.getMgr().getActiveDatasetId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        for (int i = 0; i < this.mLayers.size(); ++i) {
            Vector<ISpssVariable> vector = this.mLayers.get(i);
            Vector<ISpssVariable> vector2 = new Vector<ISpssVariable>();
            for (int j = 0; j < vector.size(); ++j) {
                boolean bl;
                ISpssVariable iSpssVariable = vector.get(j);
                boolean bl2 = bl = iSpssVariable.getType() == 0;
                if (iSpssVariable != null && iSpssDataSrc.isVariableInCurrentSet(iSpssVariable) && bl) {
                    vector2.add(j, iSpssVariable);
                    continue;
                }
                vector2.add(j, null);
            }
            this.mLayers.set(i, vector2);
        }
        this.updateOkPaste();
    }

    private void doPrevious() {
        if (this.mCurrentLayer == 0) {
            assert (false);
            return;
        }
        this.saveLayerContents();
        --this.mCurrentLayer;
        this.doLayerPopulate();
        this.mSrcVarList.requestFocus();
    }

    private void doLayerPopulate() {
        Vector<ISpssVariable> vector = this.mLayers.get(this.mCurrentLayer);
        this.mHighTargetList.getModel().removeAll();
        this.mLowTargetList.getModel().removeAll();
        this.mCloseTargetList.getModel().removeAll();
        if (vector.size() == 1) {
            ISpssVariable iSpssVariable = vector.get(0);
            if (iSpssVariable != null) {
                this.mHighTargetList.getModel().addElement(iSpssVariable);
            }
        } else if (vector.size() == 2) {
            ISpssVariable iSpssVariable = vector.get(0);
            if (iSpssVariable != null) {
                this.mHighTargetList.getModel().addElement(iSpssVariable);
            }
            if ((iSpssVariable = vector.get(1)) != null) {
                this.mLowTargetList.getModel().addElement(iSpssVariable);
            }
        } else if (vector.size() == 3) {
            ISpssVariable iSpssVariable = vector.get(0);
            if (iSpssVariable != null) {
                this.mHighTargetList.getModel().addElement(iSpssVariable);
            }
            if ((iSpssVariable = vector.get(1)) != null) {
                this.mLowTargetList.getModel().addElement(iSpssVariable);
            }
            if ((iSpssVariable = vector.get(2)) != null) {
                this.mCloseTargetList.getModel().addElement(iSpssVariable);
            }
        }
        this.mVariableSetPanel.setBorder(BorderFactory.createTitledBorder(this.formatCurrentPanelTitle()));
    }

    private void doNext() {
        if (this.saveLayerContents()) {
            ++this.mCurrentLayer;
        }
        if (this.mCurrentLayer == this.mLayers.size()) {
            this.addLayer();
        }
        this.doLayerPopulate();
        this.mSrcVarList.requestFocus();
    }

    private void addLayer() {
        this.mLayers.add(new Vector(0));
    }

    private boolean saveLayerContents() {
        boolean bl = false;
        if (this.mCurrentLayer < this.mLayers.size()) {
            Vector<ISpssVariable> vector = new Vector<ISpssVariable>();
            if (this.mHighTargetList.getModel().getSize() > 0) {
                vector.add(this.mHighTargetList.getModel().getElementAt(0));
            }
            if (this.mLowTargetList.getModel().getSize() > 0) {
                vector.add(this.mLowTargetList.getModel().getElementAt(0));
            }
            if (this.mCloseTargetList.getModel().getSize() > 0) {
                vector.add(this.mCloseTargetList.getModel().getElementAt(0));
            }
            if (vector.size() >= 1) {
                bl = true;
                this.mLayers.set(this.mCurrentLayer, vector);
            } else {
                this.mLayers.remove(this.mCurrentLayer);
            }
        }
        return bl;
    }

    private void updateLayersVector() {
        Vector<ISpssVariable> vector = new Vector<ISpssVariable>();
        if (this.mHighTargetList.getModel().getSize() > 0) {
            vector.add(this.mHighTargetList.getModel().getElementAt(0));
        }
        if (this.mLowTargetList.getModel().getSize() > 0) {
            vector.add(this.mLowTargetList.getModel().getElementAt(0));
        }
        if (this.mCloseTargetList.getModel().getSize() > 0) {
            vector.add(this.mCloseTargetList.getModel().getElementAt(0));
        }
        this.mLayers.set(this.mCurrentLayer, vector);
    }

    private void loadLayerListState() {
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        Integer n = dialogDataModel.getInteger(LAYER_COUNT_KEY);
        int n2 = n != null ? n : 0;
        for (int i = 0; i < n2; ++i) {
            if (i > 0) {
                this.addLayer();
            }
            Object[] objectArray = dialogDataModel.getArray(LAYERS_KEY + i);
            int n3 = objectArray.length;
            Vector<ISpssVariable> vector = new Vector<ISpssVariable>(n3);
            for (int j = 0; j < n3; ++j) {
                ISpssVariable iSpssVariable = (ISpssVariable)objectArray[j];
                vector.add(iSpssVariable);
            }
            this.mLayers.set(i, vector);
        }
        Integer n4 = dialogDataModel.getInteger(CURRENT_LAYER_KEY);
        this.mCurrentLayer = n4 != null ? n4 : 0;
        this.doLayerPopulate();
        if (this.mLayers.size() > 1) {
            this.mPreviousButton.setEnabled(true);
            this.mVariableSetPanel.setBorder(BorderFactory.createTitledBorder(this.formatCurrentPanelTitle()));
        }
    }

    private void addComponentsToMainPanel(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = 23;
        JScrollPane jScrollPane = new JScrollPane(this.mSrcVarList);
        jScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBorder(BorderFactory.createEmptyBorder());
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_HILO_SRCLIST_LABEL");
        jLabel.setLabelFor(this.mSrcVarList);
        DialogUtil.addUsingGBL(jPanel2, jLabel, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel2, jScrollPane, gridBagConstraints, 0, 1, 1, 1, n, null);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 3, n, null);
        this.mVariableSetPanel = this.setupVariableSetPanel();
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        Insets insets = new Insets(0, DialogUtil.getComponentGroupGap(), 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mVariableSetPanel, gridBagConstraints, 1, 0, 1, 1, n, insets);
        JPanel jPanel3 = this.setupCategoryLabelsPanel();
        insets.set(DialogUtil.getComponentGroupGap(), DialogUtil.getComponentGroupGap(), 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 1, 1, 1, 1, n, insets);
        this.mCategoryButtonGroup = DialogUtil.createButtonGroup(jPanel3);
        JPanel jPanel4 = this.setupPanelByPanel();
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jPanel4, gridBagConstraints, 1, 2, 1, 1, n, insets);
        JPanel jPanel5 = this.setupTemplatePanel();
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        insets.set(DialogUtil.getComponentGroupGap(), 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel5, gridBagConstraints, 0, 3, 2, 1, n, insets);
    }

    private JPanel setupVariableSetPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.formatCurrentPanelTitle()));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        JPanel jPanel2 = this.setupButtonPanel();
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, null);
        JComponent[] jComponentArray = new JComponent[]{this.mHighArrowButton, this.mHighLabel, this.mHighScrollPane, this.mLowArrowButton, this.mLowLabel, this.mLowScrollPane, this.mCloseArrowButton, this.mCloseLabel, this.mCloseScrollPane};
        JPanel jPanel3 = HighLowPanelFactory.getHighLowCloseChangeStatisticsPanel(jComponentArray, false);
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 1, 1, 1, n, null);
        return jPanel;
    }

    private JPanel setupButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        int n = 23;
        Insets insets = new Insets(0, DialogUtil.getGroupBoxInnerMargin(), 2, 2);
        DialogUtil.addUsingGBL(jPanel, this.mPreviousButton, gridBagConstraints, 0, 0, 1, 1, n, insets);
        n = 24;
        insets.set(0, 3, 2, DialogUtil.getGroupBoxInnerMargin());
        DialogUtil.addUsingGBL(jPanel, this.mNextButton, gridBagConstraints, 1, 0, 1, 1, n, insets);
        UIToolDialogUtil.normalizeButtonWidths((JPanel)jPanel);
        return jPanel;
    }

    private String formatCurrentPanelTitle() {
        return String.format(ComponentState.getSPSSLocale(), this.getResString("IDS_HILO_VARIABLE_SET_FORMAT"), this.mCurrentLayer + 1, this.mLayers.size());
    }

    private JPanel setupCategoryLabelsPanel() {
        JComponent[] jComponentArray = new JComponent[]{this.mCaseNumberRadio, this.mVariableRadio, this.mVariableArrowButton, this.mVariableScrollPane};
        return HighLowPanelFactory.getCategoryLabelsPanel(jComponentArray, this.getResString("IDS_HILO_CATEGORY_LABELS_PANEL_TITLE"));
    }

    private JPanel setupPanelByPanel() {
        JComponent[] jComponentArray = new JComponent[]{this.mRowsLabel, this.mRowsArrowButton, this.mRowsTargetList, this.mNestVariableRowsCheckBox, this.mColumnsLabel, this.mColumnsArrowButton, this.mColumnTargetList, this.mNestVariableColumnsCheckBox};
        return PanelFactory.getGraphsPanelByPanel(jComponentArray, this.getResString("IDS_HILO_PANEL_BY_PANEL_TITLE"));
    }

    private JPanel setupTemplatePanel() {
        JComponent[] jComponentArray = new JComponent[8];
        jComponentArray[0] = this.mChartSpecificationsCheckBox;
        jComponentArray[1] = this.mFileButton;
        jComponentArray[2] = this.mFileTextField;
        return PanelFactory.getGraphsChartTemplatePanel(jComponentArray, this.getResString("IDS_HILO_TEMPLATE_PANEL_TITLE"));
    }

    private String getVariableSetSyntax() {
        StringBuffer stringBuffer = new StringBuffer();
        for (Vector<ISpssVariable> vector : this.mLayers) {
            ISpssVariable iSpssVariable = vector.get(0);
            stringBuffer.append("VALUE(");
            stringBuffer.append(iSpssVariable.getName());
            iSpssVariable = vector.get(1);
            stringBuffer.append(" ").append(iSpssVariable.getName());
            if (vector.size() == 3 && (iSpssVariable = vector.get(2)) != null) {
                stringBuffer.append(" ").append(iSpssVariable.getName());
            }
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }

    private void updateNextButton() {
        boolean bl;
        boolean bl2 = this.mHighTargetList.getModel().getSize() > 0;
        boolean bl3 = this.mLowTargetList.getModel().getSize() > 0;
        boolean bl4 = bl = this.mCurrentLayer < 9;
        if (bl2 && bl3) {
            if (bl) {
                this.mNextButton.setEnabled(true);
            }
        } else {
            this.mNextButton.setEnabled(false);
        }
        this.mPreviousButton.setEnabled(this.mCurrentLayer > 0);
    }

    private void updateNextOnItemsAddedOrRemoved() {
        boolean bl;
        boolean bl2 = this.mHighTargetList.getModel().getSize() > 0;
        boolean bl3 = this.mLowTargetList.getModel().getSize() > 0;
        boolean bl4 = bl = this.mCurrentLayer < 9;
        if (bl2 && bl3) {
            if (bl) {
                this.mNextButton.setEnabled(true);
            }
            this.mPreviousButton.setEnabled(this.mCurrentLayer > 0);
        } else if (bl2 || bl3) {
            this.mNextButton.setEnabled(false);
            this.mPreviousButton.setEnabled(false);
        } else {
            this.mNextButton.setEnabled(this.mCurrentLayer < this.mLayers.size() - 1);
            this.mPreviousButton.setEnabled(this.mCurrentLayer > 0);
        }
    }

    private void updateOkPaste() {
        boolean bl = true;
        int n = 0;
        for (Vector<ISpssVariable> vector : this.mLayers) {
            if (n == this.mCurrentLayer) {
                if (this.mHighTargetList.getModel().getSize() == 0 || this.mLowTargetList.getModel().getSize() == 0) {
                    bl = false;
                    break;
                }
            } else {
                if (vector.size() == 1) {
                    bl = false;
                    break;
                }
                if (vector.size() == 2 && (vector.get(0) == null || vector.get(1) == null)) {
                    bl = false;
                    break;
                }
            }
            ++n;
        }
        boolean bl2 = this.mLayers.size() >= 2;
        boolean bl3 = true;
        bl3 = this.mCaseNumberRadio.isSelected() ? true : this.mVariableTargetList.getModel().getSize() > 0;
        boolean bl4 = true;
        if (this.mChartSpecificationsCheckBox.isSelected()) {
            bl4 = this.mFileTextField.getText() != null && this.mFileTextField.getText().length() > 0;
        }
        this.enableOkPaste(bl && bl3 && bl4 && bl2);
    }

    private void setTabTraversalOrder() {
        int n;
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcVarList);
        vector.add(this.mHighArrowButton);
        vector.add(this.mLowArrowButton);
        vector.add(this.mCloseArrowButton);
        vector.add(this.mRowsArrowButton);
        vector.add(this.mColumnsArrowButton);
        vector.add(this.mHighTargetList);
        vector.add(this.mLowTargetList);
        vector.add(this.mCloseTargetList);
        vector.add(this.mNextButton);
        vector.add(this.mPreviousButton);
        vector.add(this.mCategoryButtonGroup);
        vector.add(this.mVariableArrowButton);
        vector.add(this.mVariableTargetList);
        vector.add(this.mRowsTargetList);
        vector.add(this.mNestVariableRowsCheckBox);
        vector.add(this.mColumnTargetList);
        vector.add(this.mNestVariableColumnsCheckBox);
        vector.add(this.mChartSpecificationsCheckBox);
        vector.add(this.mFileButton);
        for (n = 0; n < this.mOptionButtonPanel.getComponentCount(); ++n) {
            Component component = this.mOptionButtonPanel.getComponent(n);
            if (!(component instanceof JButton)) continue;
            vector.add(this.mOptionButtonPanel.getComponent(n));
        }
        for (n = 0; n < this.mCmdButtonPanel.getComponentCount(); ++n) {
            vector.add(this.mCmdButtonPanel.getComponent(n));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    @Override
    protected BaseProcedureDialog.DataViewObserverAdapter createDataSourceObserver() {
        return new CustomDataViewObserverAdapter();
    }

    class CustomDataViewObserverAdapter
    extends BaseProcedureDialog.DataViewObserverAdapter {
        CustomDataViewObserverAdapter() {
            super(ClusteredHLCValuesOfIndividualCasesDlg.this);
        }

        @Override
        public void notifyVariablesDeleted(int n, int n2, int n3, ORIGINATOR_ID oRIGINATOR_ID) {
            super.notifyVariablesDeleted(n, n2, n3, oRIGINATOR_ID);
            if (ProcedureDlgMgr.getMgr().anyProcedureDialogsRunning(true)) {
                ClusteredHLCValuesOfIndividualCasesDlg.this.updateLayers();
            }
        }

        @Override
        public void notifyVariableModified(ORIGINATOR_ID oRIGINATOR_ID, int n) {
            super.notifyVariableModified(oRIGINATOR_ID, n);
            if (ProcedureDlgMgr.getMgr().anyProcedureDialogsRunning(true)) {
                ClusteredHLCValuesOfIndividualCasesDlg.this.updateLayers();
            }
        }
    }
}

