/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.graphs.legacy_dialogs.errorbar;

import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.base.graphs.ImageLabelKeyListener;
import com.spss.java_client.ui.dialogs.base.graphs.MatrixImage;
import com.spss.java_client.ui.dialogs.base.graphs.MatrixImagesGroup;
import com.spss.java_client.ui.dialogs.base.graphs.res.GraphsResBundle;
import com.spss.java_client.ui.dialogs.common.BaseGatingDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.shared.core_tools.system.OSInfo;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;

public class ErrorBarDlg
extends BaseGatingDialog {
    private GridBagConstraints mConstraints;
    private JRadioButton mGroupsRadioButton;
    private JRadioButton mSeparateVariablesRadioButton;
    private SpssButtonGroup buttonGroup;
    private JLabel simpleLabel;
    private JLabel clusteredLabel;
    private MatrixImage mSimpleBarImageLabel;
    private MatrixImage mClusteredBarImageLabel;
    private MatrixImagesGroup mErrorBarImageLabelGroup;

    public ErrorBarDlg(JFrame jFrame) throws HeadlessException {
        super(jFrame, GraphsResBundle.getDefaultResourceBundleName(), GraphsResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_ERROR_BAR_TITLE"));
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public String getDialogHelpID() {
        return "idh_gerr";
    }

    @Override
    public String getIActionKey() {
        return "graphs_legacy_dialogs_error_bar";
    }

    @Override
    public String getNextProcDlgActionKey() {
        String string = null;
        if (this.mGroupsRadioButton.isSelected()) {
            if (this.mErrorBarImageLabelGroup.isSelected(this.mSimpleBarImageLabel)) {
                string = "graphs_legacy_dialogs_error_bar_simple_group_of_cases";
            } else if (this.mErrorBarImageLabelGroup.isSelected(this.mClusteredBarImageLabel)) {
                string = "graphs_legacy_dialogs_error_bar_clustered_group_of_cases";
            }
        } else if (this.mSeparateVariablesRadioButton.isSelected()) {
            if (this.mErrorBarImageLabelGroup.isSelected(this.mSimpleBarImageLabel)) {
                string = "graphs_legacy_dialogs_error_bar_simple_separate_variables";
            } else if (this.mErrorBarImageLabelGroup.isSelected(this.mClusteredBarImageLabel)) {
                string = "graphs_legacy_dialogs_error_bar_clustered_separate_variables";
            }
        }
        return string;
    }

    @Override
    public boolean continuePressed() {
        return true;
    }

    @Override
    public void loadDialogState() {
        Integer n = this.mDialogDataModel.getInteger("IDS_ERROR_BAR_SELECTED_IMAGE");
        if (n != null) {
            this.setImageSelected(n);
        }
        super.loadDialogState();
    }

    @Override
    public void saveDialogState() {
        super.saveDialogState();
        this.mDialogDataModel.putInteger("IDS_ERROR_BAR_SELECTED_IMAGE", this.getSelectedImageIndex());
    }

    @Override
    protected void init() {
        super.init();
        this.renameContinueAction("IDS_DEFINE");
        JPanel jPanel = this.getViewPanel();
        this.initVars();
        this.setUpUI(jPanel);
        Vector<Object> vector = new Vector<Object>();
        if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
            vector.add(this.mDefineButton);
            vector.add(this.mSimpleBarImageLabel);
            vector.add(this.buttonGroup);
            vector.add(this.mHelpButton);
            vector.add(this.mCancelButton);
        } else {
            vector.add(this.mDefineButton);
            vector.add(this.mCancelButton);
            vector.add(this.mHelpButton);
            vector.add(this.mSimpleBarImageLabel);
            vector.add(this.buttonGroup);
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
        this.pack();
    }

    private void setUpUI(JPanel jPanel) {
        JPanel jPanel2 = this.setupRadioButtonPanel();
        this.mConstraints.weightx = 0.0;
        this.mConstraints.weighty = 0.0;
        this.mConstraints.fill = 0;
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(0, 0, 0, n2);
        this.mConstraints.weightx = 1.0;
        this.mConstraints.weighty = 0.0;
        this.mConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.setupImageLabelPanel(), this.mConstraints, 1, 0, 1, 1, n, null);
        this.mConstraints.weightx = 1.0;
        this.mConstraints.weighty = 1.0;
        this.mConstraints.fill = 1;
        insets.set(n2, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel2, this.mConstraints, 0, 1, 2, 1, n, insets);
    }

    private JPanel setupImageLabelPanel() {
        JComponent[] jComponentArray = new JComponent[]{this.mSimpleBarImageLabel, this.mClusteredBarImageLabel, this.simpleLabel, this.clusteredLabel, new JLabel()};
        return PanelFactory.getPanelForImageLabels(jComponentArray, "", 2);
    }

    private void initVars() {
        this.mErrorBarImageLabelGroup = new MatrixImagesGroup();
        this.simpleLabel = new JLabel(this.getResString("IDS_ERROR_BAR_SIMPLE"));
        this.mSimpleBarImageLabel = new MatrixImage(this.getResImageURL("IDS_ERRORBAR_SIMPLE_IMAGE"));
        this.mSimpleBarImageLabel.setImageLabelGroup(this.mErrorBarImageLabelGroup);
        this.clusteredLabel = new JLabel(this.getResString("IDS_ERROR_BAR_CLUSTERED"));
        this.mClusteredBarImageLabel = new MatrixImage(this.getResImageURL("IDS_ERRORBAR_CLUSTERED_IMAGE"));
        this.mClusteredBarImageLabel.setImageLabelGroup(this.mErrorBarImageLabelGroup);
        this.mConstraints = new GridBagConstraints();
        this.mGroupsRadioButton = new JRadioButton(new ToggleButtonAction(this, "IDS_ERROR_BAR_SUMMARIES_FOR_GROUPS_OF_CASES"));
        this.mGroupsRadioButton.setSelected(true);
        this.mSeparateVariablesRadioButton = new JRadioButton(new ToggleButtonAction(this, "IDS_ERROR_BAR_SUMMARIES_OF_SEPARATE_VARIABLES"));
        this.buttonGroup = new SpssButtonGroup();
        this.buttonGroup.add(this.mGroupsRadioButton);
        this.buttonGroup.add(this.mSeparateVariablesRadioButton);
        Vector<MatrixImage> vector = new Vector<MatrixImage>();
        vector.add(this.mSimpleBarImageLabel);
        vector.add(this.mClusteredBarImageLabel);
        this.mSimpleBarImageLabel.addKeyListener(new ImageLabelKeyListener(vector, this.mErrorBarImageLabelGroup));
        this.mClusteredBarImageLabel.addKeyListener(new ImageLabelKeyListener(vector, this.mErrorBarImageLabelGroup));
        this.setDefaults();
    }

    private void setDefaults() {
        this.mSimpleBarImageLabel.setDefaultSelectedImage(true);
        this.mClusteredBarImageLabel.setDefaultSelectedImage(false);
        this.mGroupsRadioButton.setSelected(true);
    }

    private JPanel setupRadioButtonPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(this.getResString("IDS_ERROR_BAR_DATA_CHART")));
        this.mConstraints.weightx = 1.0;
        this.mConstraints.weighty = 0.0;
        this.mConstraints.fill = 2;
        int n = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(n, n, 0, n);
        DialogUtil.addUsingGBL(jPanel, this.mGroupsRadioButton, this.mConstraints, 0, 0, 1, 1, 23, insets2);
        this.mConstraints.weighty = 1.0;
        insets2.set(insets.top, n, n, n);
        DialogUtil.addUsingGBL(jPanel, this.mSeparateVariablesRadioButton, this.mConstraints, 0, 1, 1, 1, 23, insets2);
        return jPanel;
    }

    private int getSelectedImageIndex() {
        int n = -1;
        if (this.mErrorBarImageLabelGroup.isSelected(this.mSimpleBarImageLabel)) {
            n = 0;
        } else if (this.mErrorBarImageLabelGroup.isSelected(this.mClusteredBarImageLabel)) {
            n = 1;
        }
        return n;
    }

    private void setImageSelected(int n) {
        switch (n) {
            case 0: {
                this.mSimpleBarImageLabel.setDefaultSelectedImage(true);
                break;
            }
            case 1: {
                this.mClusteredBarImageLabel.setDefaultSelectedImage(true);
            }
        }
    }
}

