/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.graphs.legacy_dialogs.boxplot;

import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.base.graphs.ImageLabelKeyListener;
import com.spss.java_client.ui.dialogs.base.graphs.MatrixImage;
import com.spss.java_client.ui.dialogs.base.graphs.MatrixImagesGroup;
import com.spss.java_client.ui.dialogs.base.graphs.res.GraphsResBundle;
import com.spss.java_client.ui.dialogs.common.BaseGatingDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.shared.core_tools.system.OSInfo;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;

public class BoxplotDlg
extends BaseGatingDialog {
    private JRadioButton mSummariesForGroupsRadioButton;
    private JRadioButton mSummariesOfSeparateRadioButton;
    private JLabel simpleLabel;
    private JLabel clusteredLabel;
    private MatrixImage mSimpleImageLabel;
    private MatrixImage mClusteredImageLabel;
    private MatrixImagesGroup mBoxPlotImageLabelGroup;

    public BoxplotDlg(JFrame jFrame) throws HeadlessException {
        super(jFrame, GraphsResBundle.getDefaultResourceBundleName(), GraphsResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_BOXPLOT_TITLE"));
        this.setLocationRelativeTo(jFrame);
    }

    @Override
    public String getDialogHelpID() {
        return "idh_gbox";
    }

    @Override
    public String getIActionKey() {
        return "graphs_legacy_dialogs_boxplot";
    }

    @Override
    public String getNextProcDlgActionKey() {
        String string = "";
        if (this.mBoxPlotImageLabelGroup.isSelected(this.mSimpleImageLabel) && this.mSummariesForGroupsRadioButton.isSelected()) {
            string = "graphs_legacy_dialogs_simple_boxplot_group_of";
        } else if (this.mBoxPlotImageLabelGroup.isSelected(this.mSimpleImageLabel) && this.mSummariesOfSeparateRadioButton.isSelected()) {
            string = "graphs_legacy_dialogs_simple_boxplot_separate";
        } else if (this.mBoxPlotImageLabelGroup.isSelected(this.mClusteredImageLabel) && this.mSummariesForGroupsRadioButton.isSelected()) {
            string = "graphs_legacy_dialogs_clustered_boxplot_group_of";
        } else if (this.mBoxPlotImageLabelGroup.isSelected(this.mClusteredImageLabel) && this.mSummariesOfSeparateRadioButton.isSelected()) {
            string = "graphs_legacy_dialogs_clustered_boxplot_separate";
        }
        return string;
    }

    @Override
    public boolean continuePressed() {
        return true;
    }

    @Override
    public void loadDialogState() {
        Integer n = this.mDialogDataModel.getInteger("IDS_GRAPH_BOXPLOT_SELECTED_IMAGE");
        if (n != null) {
            this.setImageSelected(n);
        }
        super.loadDialogState();
    }

    @Override
    public void saveDialogState() {
        super.saveDialogState();
        this.mDialogDataModel.putInteger("IDS_GRAPH_BOXPLOT_SELECTED_IMAGE", this.getSelectedImageIndex());
    }

    @Override
    protected void init() {
        super.init();
        this.renameContinueAction("IDS_DEFINE");
        JPanel jPanel = this.getViewPanel();
        this.initVars();
        this.setDefaults();
        this.setUpUI(jPanel);
        this.setFocusTraversalPolicy();
        this.pack();
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        spssButtonGroup.add(this.mSummariesForGroupsRadioButton);
        spssButtonGroup.add(this.mSummariesOfSeparateRadioButton);
        if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
            vector.add(this.mDefineButton);
            vector.add(this.mSimpleImageLabel);
            vector.add(spssButtonGroup);
            vector.add(this.mHelpButton);
            vector.add(this.mCancelButton);
        } else {
            vector.add(this.mDefineButton);
            vector.add(this.mCancelButton);
            vector.add(this.mHelpButton);
            vector.add(this.mClusteredImageLabel);
            vector.add(spssButtonGroup);
        }
        this.setFocusTraversalPolicy(new DialogFocusTraversalPolicy(vector, false));
    }

    private void setUpUI(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel2 = this.setupRadioButtonPanel();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(0, 0, 0, n);
        JPanel jPanel3 = this.setupImageLabelPanel();
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 0, 1, 1, 23, null);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        insets.set(DialogUtil.getComponentGroupGap(), 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 1, 2, 1, 23, insets);
    }

    private void initVars() {
        this.mBoxPlotImageLabelGroup = new MatrixImagesGroup();
        this.simpleLabel = new JLabel(this.getResString("IDS_BOXPLOT_SIMPLE_LIST"));
        this.mSimpleImageLabel = new MatrixImage(this.getResImageURL("IDS_BOXPLOT_SIMPLE_IMAGE"));
        this.mSimpleImageLabel.setImageLabelGroup(this.mBoxPlotImageLabelGroup);
        this.clusteredLabel = new JLabel(this.getResString("IDS_BOXPLOT_CLUSTERED_LIST"));
        this.mClusteredImageLabel = new MatrixImage(this.getResImageURL("IDS_BOXPLOT_CLUSTERED_IMAGE"));
        this.mClusteredImageLabel.setImageLabelGroup(this.mBoxPlotImageLabelGroup);
        Vector<MatrixImage> vector = new Vector<MatrixImage>();
        vector.add(this.mSimpleImageLabel);
        vector.add(this.mClusteredImageLabel);
        this.mSimpleImageLabel.addKeyListener(new ImageLabelKeyListener(vector, this.mBoxPlotImageLabelGroup));
        this.mClusteredImageLabel.addKeyListener(new ImageLabelKeyListener(vector, this.mBoxPlotImageLabelGroup));
        this.mSimpleImageLabel.setSelected(true);
    }

    private JPanel setupImageLabelPanel() {
        JComponent[] jComponentArray = new JComponent[]{this.mSimpleImageLabel, this.mClusteredImageLabel, this.simpleLabel, this.clusteredLabel, new JLabel()};
        return PanelFactory.getPanelForImageLabels(jComponentArray, "", 2);
    }

    private JPanel setupRadioButtonPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(new TitledBorder(this.getResString("IDS_BOXPLOT_DATA_IN_CHART_BORDER")));
        this.mSummariesForGroupsRadioButton = new JRadioButton(new ToggleButtonAction(this, "IDS_BOXPLOT_GROUPS_RADIO_BUTTON"));
        this.mSummariesForGroupsRadioButton.setSelected(true);
        this.mSummariesOfSeparateRadioButton = new JRadioButton(new ToggleButtonAction(this, "IDS_BOXPLOT_SEPARATE_RADIO_BUTTON"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        int n = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(n, n, insets.bottom, n);
        DialogUtil.addUsingGBL(jPanel, this.mSummariesForGroupsRadioButton, gridBagConstraints, 0, 0, 1, 1, 23, insets2);
        insets2.set(0, n, insets.bottom, n);
        DialogUtil.addUsingGBL(jPanel, this.mSummariesOfSeparateRadioButton, gridBagConstraints, 0, 1, 1, 1, 23, insets2);
        return jPanel;
    }

    private int getSelectedImageIndex() {
        int n = -1;
        if (this.mBoxPlotImageLabelGroup.isSelected(this.mSimpleImageLabel)) {
            n = 0;
        } else if (this.mBoxPlotImageLabelGroup.isSelected(this.mClusteredImageLabel)) {
            n = 1;
        }
        return n;
    }

    private void setImageSelected(int n) {
        switch (n) {
            case 0: {
                this.mSimpleImageLabel.setDefaultSelectedImage(true);
                break;
            }
            case 1: {
                this.mClusteredImageLabel.setDefaultSelectedImage(true);
            }
        }
    }

    private void setDefaults() {
        this.mSimpleImageLabel.setDefaultSelectedImage(true);
        this.mClusteredImageLabel.setDefaultSelectedImage(false);
    }
}

