/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.graphs.legacy_dialogs.boxplot;

import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.base.graphs.OptionsSubDialog;
import com.spss.java_client.ui.dialogs.base.graphs.res.GraphsResBundle;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class BoxplotClusteredSeparateVarsDlg
extends BaseProcedureDialog
implements ListDataListener {
    private JButton mOptionsButton;
    private ArrowButton mCasesByListArrow;
    private ArrowButton mBoxesListArrow;
    private ArrowButton mCategoryListArrow;
    private TargetVariableList mCasesByList;
    private TargetVariableList mCategoryList;
    private TargetVariableList mBoxList;
    private SrcVariableList mSrcVarList;
    private ArrowButton mRowsListArrow;
    private ArrowButton mColumnsListArrow;
    private TargetVariableList mRowsList;
    private TargetVariableList mColumnsList;
    private JCheckBox mRowsCheckbox;
    private JCheckBox mColumnsCheckbox;

    public BoxplotClusteredSeparateVarsDlg(JFrame jFrame) {
        super(jFrame, false, GraphsResBundle.getDefaultResourceBundleName(), GraphsResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_CLUSTERED_BOXPLOT_SEPARATE_TITLE"));
    }

    @Override
    public void reset() {
        super.reset();
        this.mBoxList.removeAll();
        this.mCategoryList.removeAll();
        this.mCasesByList.removeAll();
        this.mRowsList.removeAll();
        this.mColumnsList.removeAll();
        this.setDefaults();
    }

    @Override
    public String generateSyntax() {
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        stringBuffer.append(SyntaxUtil.getMainCommand("EXAMINE"));
        stringBuffer.append(SyntaxUtil.getMainCommandParamters("VARIABLES="));
        for (int i = 0; i < this.mBoxList.getModel().getSize(); ++i) {
            stringBuffer.append(this.mBoxList.getModel().getElementAt(i).getName() + " ");
        }
        stringBuffer.append("BY " + this.mCategoryList.getModel().getElementAt(0).getName());
        stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/COMPARE VARIABLE"));
        stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/PLOT=BOXPLOT"));
        stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/STATISTICS=NONE"));
        stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/NOTOTAL"));
        if (this.mCasesByList.getModel().getSize() > 0) {
            stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/ID=") + this.mCasesByList.getModel().getElementAt(0).getName());
        }
        if (this.mColumnsList.getModel().getSize() > 0 || this.mRowsList.getModel().getSize() > 0) {
            stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/PANEL"));
        }
        if (this.mColumnsList.getModel().getSize() > 0) {
            stringBuffer.append(" COLVAR=");
            stringBuffer.append(this.mColumnsList.getVariablesStringList());
            stringBuffer.append(" COLOP=");
            if (this.mColumnsCheckbox.isSelected()) {
                stringBuffer.append("NEST");
            } else {
                stringBuffer.append("CROSS");
            }
        }
        if (this.mRowsList.getModel().getSize() > 0) {
            stringBuffer.append(" ROWVAR=");
            stringBuffer.append(this.mRowsList.getVariablesStringList());
            stringBuffer.append(" ROWOP=");
            if (this.mRowsCheckbox.isSelected()) {
                stringBuffer.append("NEST");
            } else {
                stringBuffer.append("CROSS");
            }
        }
        stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/MISSING="));
        Boolean bl = this.getDialogDataModel().getBoolean("IDS_OPT_SUBDLG_EX_CASES_LISTWISE_RADIO");
        if (bl == null || bl.booleanValue()) {
            stringBuffer.append("LISTWISE");
        } else {
            stringBuffer.append("PAIRWISE");
        }
        bl = this.getDialogDataModel().getBoolean("IDS_OPT_SUBDLG_DISPLAY_GROUPS_CHECK");
        if (bl != null && bl.booleanValue()) {
            stringBuffer.append(" REPORT");
        }
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        return stringBuffer.toString();
    }

    @Override
    public String getDialogHelpID() {
        return "idh_gxcv";
    }

    @Override
    public String getIActionKey() {
        return "graphs_legacy_dialogs_clustered_boxplot_separate";
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.enableRespectiveComponents(listDataEvent);
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.enableRespectiveComponents(listDataEvent);
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefaults();
        JPanel jPanel = this.getViewPanel();
        this.setupViewPanel(jPanel);
        this.setFocusTraversalPolicy();
        this.pack();
    }

    @Override
    protected void loadDialogState() {
        super.loadDialogState();
        this.mSrcVarList.requestFocus();
        this.mSrcVarList.setSelectedIndex(0);
    }

    @Override
    protected JPanel setupOptionsButtonPanel() {
        JPanel jPanel = super.setupOptionsButtonPanel();
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, "IDS_BOXPLOT_BUTTON"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BoxplotClusteredSeparateVarsDlg.this.runOptionSubDlg();
            }
        };
        this.mOptionsButton = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, this.mOptionsButton);
        return jPanel;
    }

    private void enableRespectiveComponents(ListDataEvent listDataEvent) {
        if (listDataEvent.getSource() == this.mRowsList.getModel()) {
            if (this.mRowsList.getModel().getSize() >= 1) {
                this.mRowsCheckbox.setEnabled(true);
            } else {
                this.mRowsCheckbox.setEnabled(false);
            }
        } else if (listDataEvent.getSource() == this.mColumnsList.getModel()) {
            if (this.mColumnsList.getModel().getSize() >= 1) {
                this.mColumnsCheckbox.setEnabled(true);
            } else {
                this.mColumnsCheckbox.setEnabled(false);
            }
        } else if (this.mBoxList.getModel().getSize() >= 2 && this.mCategoryList.getModel().getSize() == 1) {
            this.enableOkPaste(true);
        } else {
            this.enableOkPaste(false);
        }
    }

    private void setDefaults() {
        this.mSrcVarList.loadFromActiveDataset();
        this.enableOkPaste(false);
        this.mSrcVarList.requestFocus();
        this.mSrcVarList.setSelectedIndex(0);
        this.mRowsCheckbox.setSelected(false);
        this.mColumnsCheckbox.setSelected(false);
        this.mRowsCheckbox.setEnabled(false);
        this.mColumnsCheckbox.setEnabled(false);
    }

    private void initVars() {
        this.mSrcVarList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        this.mSrcVarList.setIdentifier(this.getResString("IDS_BOXPLOT_SOURCE_LIST"));
        this.mCasesByList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mCasesByList.setIdentifier(this.getResString("IDS_BOXPLOT_CASES_TARGET_LIST"));
        this.mCategoryList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mCategoryList.getModel().addListDataListener(this);
        this.mCategoryList.setIdentifier(this.getResString("IDS_BOXPLOT_CATEGORY_TARGET_LIST"));
        this.mBoxList = new TargetVariableList();
        this.mBoxList.setIdentifier(this.getResString("IDS_BOXPLOT_BOX_TARGET_LIST"));
        this.mBoxList.getModel().addListDataListener(this);
        this.mBoxList.addVarFilter(new SpssVarFilter(8, false));
        this.mBoxesListArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mBoxesListArrow.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mBoxesListArrow.registerVariableList(this.mBoxList, SpssArrowButton.ButtonOrientation.left);
        this.mCasesByListArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mCasesByListArrow.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mCasesByListArrow.registerVariableList(this.mCasesByList, SpssArrowButton.ButtonOrientation.left);
        this.mCategoryListArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mCategoryListArrow.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mCategoryListArrow.registerVariableList(this.mCategoryList, SpssArrowButton.ButtonOrientation.left);
        this.mRowsList = new TargetVariableList(TargetVariableList.TargetListType.normal, VariableList.VarMoveType.eMoveOriginal);
        this.mRowsList.getModel().addListDataListener(this);
        this.mRowsList.setIdentifier(this.getResString("IDS_BOXPLOT_ROW_TARGET_LIST"));
        this.mRowsListArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mRowsListArrow.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mRowsListArrow.registerVariableList(this.mRowsList, SpssArrowButton.ButtonOrientation.left);
        this.mColumnsList = new TargetVariableList(TargetVariableList.TargetListType.normal, VariableList.VarMoveType.eMoveOriginal);
        this.mColumnsList.getModel().addListDataListener(this);
        this.mColumnsList.setIdentifier(this.getResString("IDS_BOXPLOT_COLUMN_TARGET_LIST"));
        this.mColumnsListArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mColumnsListArrow.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mColumnsListArrow.registerVariableList(this.mColumnsList, SpssArrowButton.ButtonOrientation.left);
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, "IDS_BOXPLOT_ROW_CHECK_BOX");
        this.mRowsCheckbox = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_BOXPLOT_COLUMN_CHECK_BOX");
        this.mColumnsCheckbox = new JCheckBox(toggleButtonAction);
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcVarList);
        vector.add(this.mBoxesListArrow);
        vector.add(this.mCategoryListArrow);
        vector.add(this.mCasesByListArrow);
        vector.add(this.mRowsListArrow);
        vector.add(this.mColumnsListArrow);
        vector.add(this.mBoxList);
        vector.add(this.mCategoryList);
        vector.add(this.mCasesByList);
        vector.add(this.mRowsList);
        vector.add(this.mRowsCheckbox);
        vector.add(this.mColumnsList);
        vector.add(this.mColumnsCheckbox);
        vector.add(this.mOptionsButton);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        this.setFocusTraversalPolicy(new DialogFocusTraversalPolicy(vector, false));
    }

    private void setupViewPanel(JPanel jPanel) {
        JScrollPane jScrollPane = new JScrollPane(this.mCasesByList);
        jScrollPane.setPreferredSize(this.mCasesByList.getMinimumSize());
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setVerticalScrollBarPolicy(21);
        JScrollPane jScrollPane2 = new JScrollPane(this.mBoxList);
        jScrollPane2.setPreferredSize(new Dimension((int)this.mBoxList.getPreferredSize().getWidth(), 100));
        JScrollPane jScrollPane3 = new JScrollPane(this.mCategoryList);
        jScrollPane3.setPreferredSize(this.mCategoryList.getMinimumSize());
        jScrollPane3.setHorizontalScrollBarPolicy(31);
        jScrollPane3.setVerticalScrollBarPolicy(21);
        JScrollPane jScrollPane4 = new JScrollPane(this.mSrcVarList);
        jScrollPane4.setPreferredSize(this.mSrcVarList.getMinimumSize());
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_CLUSTERED_BOXPLOT_SEPARATE_CASES_LABEL");
        jLabel.setLabelFor(this.mCasesByList);
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_BOXPLOT_CATEGORY_LABEL");
        jLabel2.setLabelFor(this.mCategoryList);
        JLabel jLabel3 = DialogUtil.createLabel(this, "IDS_BOXPLOT_BOXES_LABEL");
        jLabel3.setLabelFor(this.mBoxList);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getGroupBoxInnerMargin();
        gridBagConstraints.weightx = 1.0;
        int n2 = 23;
        gridBagConstraints.fill = 2;
        JLabel jLabel4 = DialogUtil.createLabel(this, "IDS_CLUSTERED_BOXPLOT_SEPARATE_SOURCE_LABEL");
        jLabel4.setLabelFor(this.mSrcVarList);
        DialogUtil.addUsingGBL(jPanel, jLabel4, gridBagConstraints, 0, 0, 1, 1, n2, null);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        Insets insets = DialogUtil.getArrowButtonInsets();
        DialogUtil.addUsingGBL(jPanel, jScrollPane4, gridBagConstraints, 0, 1, 1, 6, n2, null);
        n2 = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets2 = new Insets(0, insets.left + n + 3, 0, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mBoxesListArrow, gridBagConstraints, 1, 1, 1, 1, n2, insets2);
        gridBagConstraints.weightx = 1.0;
        n2 = 23;
        gridBagConstraints.fill = 2;
        insets2.set(0, 3, 0, n);
        DialogUtil.addUsingGBL(jPanel, jLabel3, gridBagConstraints, 2, 0, 1, 1, n2, insets2);
        insets2.set(0, 3, 0, n + 4);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jScrollPane2, gridBagConstraints, 2, 1, 1, 1, n2, insets2);
        n2 = 20;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets2.set(0, insets.left + n + 3, 0, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mCategoryListArrow, gridBagConstraints, 1, 2, 1, 2, n2, insets2);
        gridBagConstraints.weightx = 1.0;
        n2 = 23;
        gridBagConstraints.fill = 2;
        insets2.set(n, 3, 0, n);
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 2, 2, 1, 1, n2, insets2);
        insets2.set(0, 3, 0, n + 4);
        DialogUtil.addUsingGBL(jPanel, jScrollPane3, gridBagConstraints, 2, 3, 1, 1, n2, insets2);
        n2 = 20;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        insets2.set(0, insets.left + n + 3, 0, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mCasesByListArrow, gridBagConstraints, 1, 4, 1, 2, n2, insets2);
        gridBagConstraints.weightx = 1.0;
        n2 = 23;
        gridBagConstraints.fill = 2;
        insets2.set(n, 3, 0, n);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 2, 4, 1, 1, n2, insets2);
        insets2.set(0, 3, 0, n + 4);
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 2, 5, 1, 1, n2, insets2);
        JPanel jPanel2 = this.setupPanelByPanel();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        insets2.set(DialogUtil.getComponentGroupGap(), DialogUtil.getComponentGroupGap(), 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 1, 6, 2, 1, n2, insets2);
    }

    private JPanel setupPanelByPanel() {
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_BOXPLOT_ROW_LABEL");
        jLabel.setLabelFor(this.mRowsList);
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_BOXPLOT_COLUMN_LABEL");
        jLabel2.setLabelFor(this.mColumnsList);
        JComponent[] jComponentArray = new JComponent[]{jLabel, this.mRowsListArrow, this.mRowsList, this.mRowsCheckbox, jLabel2, this.mColumnsListArrow, this.mColumnsList, this.mColumnsCheckbox};
        return PanelFactory.getGraphsPanelByPanel(jComponentArray, this.getResString("IDS_BOXPLOT_PANEL_BY_BORDER"));
    }

    private void runOptionSubDlg() {
        int n = 1027;
        this.runSubDialog(new OptionsSubDialog(this, n));
    }
}

