/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.graphs.legacy_dialogs.bar;

import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.FileTextField;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.base.graphs.DefineStatisticSubDlg;
import com.spss.java_client.ui.dialogs.base.graphs.GraphRepresentsListModel;
import com.spss.java_client.ui.dialogs.base.graphs.GraphsRemoteFileChooser;
import com.spss.java_client.ui.dialogs.base.graphs.GraphsUtil;
import com.spss.java_client.ui.dialogs.base.graphs.GraphsVarDecorator;
import com.spss.java_client.ui.dialogs.base.graphs.GraphsVarFormatter;
import com.spss.java_client.ui.dialogs.base.graphs.OptionsSubDialog;
import com.spss.java_client.ui.dialogs.base.graphs.TitlesSubDialog;
import com.spss.java_client.ui.dialogs.base.graphs.legacy_dialogs.LegacyVarListCellRenderer;
import com.spss.java_client.ui.dialogs.base.graphs.res.GraphsResBundle;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.uitools.util.CharacterUtil;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class StackedGroupOfCasesDlg
extends BaseProcedureDialog
implements ListDataListener,
ActionListener,
ItemListener,
ListSelectionListener {
    private static final String COLUMNS_TARGET_VARIABLE_LIST_IDENTIFIER = "COLUMNS_TARGET_VARIABLE_LIST";
    private static final String CATEGORY_TARGET_VARIABLE_LIST_IDENTIFIER = "CATEGORY_TARGET_VARIABLE_LIST";
    private static final String STACKS_BY_TARGET_VARIABLE_LIST_IDENTIFIER = "STACKS_BY_TARGET_VARIABLE_LIST";
    private static final String ROWS_TARGET_VARIABLE_LIST_IDENTIFIER = "ROWS_TARGET_VARIABLE_LIST";
    private final String COUNT_BY = "COUNT BY";
    private final String CUFREQ_BY = "CUFREQ BY";
    private final String PCT_BY = "PCT BY";
    private final String CUPCT_BY = "CUPCT BY";
    private final String BY = "BY";
    private TargetVariableList mVariableTargetList;
    private TargetVariableList mCategoryTargetList;
    private TargetVariableList mRowsTargetList;
    private TargetVariableList mColumnTargetList;
    private SrcVariableList mSrcList;
    private JButton mStatisticsButton;
    private JButton mFileButton;
    private ArrowButton mVariableArrowButton;
    private JCheckBox mChartSpecificationsCheckBox;
    private JCheckBox mNestVariableColumnsCheckBox;
    private JCheckBox mNestVariableRowsCheckBox;
    private JRadioButton mNOfCasesRadioButton;
    private JRadioButton mCumDotNRadioButton;
    private JRadioButton mOtherStatisticRadioButton;
    private JRadioButton mPercentOfCasesRadioButton;
    private JRadioButton mCumulativePercentRadioButton;
    private FileTextField mFilePath;
    private JLabel mVariableLabel;
    private GraphsVarFormatter mFormatter;
    private ArrowButton mCategoryArrowButton;
    private ArrowButton mRowsArrowButton;
    private ArrowButton mColumnsArrowButton;
    private RemoteFileChooser mFileChooser;
    private ArrowButton mStacksByArrowButton;
    private JScrollPane mStacksByScrollPane;
    private TargetVariableList mStacksByTargetList;

    public StackedGroupOfCasesDlg(JFrame jFrame) {
        super(jFrame, false, GraphsResBundle.getDefaultResourceBundleName(), GraphsResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_DEFINE_STACKED_BAR_SUMMARIES_FOR_GROUPS_OF_CASES_TITLE"));
    }

    @Override
    public String getDialogHelpID() {
        return "idh_gbtg";
    }

    @Override
    public String getIActionKey() {
        return "graphs_legacy_dialogs_bar_stacked_group_of_cases";
    }

    public void paint(Graphics graphics) {
        this.mFilePath.setText(this.mFilePath.getText());
        super.paint(graphics);
        super.validate();
    }

    @Override
    public String generateSyntax() {
        String string;
        String string2;
        String string3;
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        stringBuffer.append(SyntaxUtil.getCommand("GRAPH", true));
        stringBuffer.append(SyntaxUtil.getSingleValueSubCommand("BAR(STACK)", this.getSyntaxForRadioButton() + " " + this.mCategoryTargetList.getModel().getElementAt(0).getName() + " BY " + this.mStacksByTargetList.getModel().getElementAt(0).getName(), false));
        String string4 = this.getSyntaxForPanelBy();
        if (string4.length() != 0) {
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand("/PANEL"));
            stringBuffer.append(string4);
        }
        if ((string3 = this.getSyntaxForOptionsDialog()).length() != 0) {
            stringBuffer.append(string3);
        }
        if ((string2 = this.getSyntaxForFile()).length() != 0) {
            stringBuffer.append("\n");
            stringBuffer.append(string2);
        }
        if ((string = GraphsUtil.generateTitlesSubDialogSyntax(this.getDialogDataModel())).length() != 0) {
            stringBuffer.append(string);
        }
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        return stringBuffer.toString();
    }

    @Override
    public void reset() {
        super.reset();
        this.mFormatter.getVarMap().clear();
        this.mVariableTargetList.removeAll();
        this.mCategoryTargetList.removeAll();
        this.mStacksByTargetList.removeAll();
        this.mRowsTargetList.removeAll();
        this.mColumnTargetList.removeAll();
        this.mSrcList.loadFromActiveDataset();
        this.mSrcList.requestFocus();
        this.setDefaults();
        this.getDialogDataModel().clear();
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        if (listDataEvent.getSource() == this.mRowsTargetList.getModel()) {
            this.mNestVariableRowsCheckBox.setEnabled(true);
        }
        if (listDataEvent.getSource() == this.mColumnTargetList.getModel()) {
            this.mNestVariableColumnsCheckBox.setEnabled(true);
        }
        this.checkEnableOkPaste();
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        if (listDataEvent.getSource() == this.mVariableTargetList.getModel()) {
            GraphsVarDecorator.resetComponentsOfStatisticDialog(this.getDialogDataModel());
        }
        if (listDataEvent.getSource() == this.mRowsTargetList.getModel() && this.mRowsTargetList.getModel().getSize() == 0) {
            this.mNestVariableRowsCheckBox.setEnabled(false);
        }
        if (listDataEvent.getSource() == this.mColumnTargetList.getModel() && this.mColumnTargetList.getModel().getSize() == 0) {
            this.mNestVariableColumnsCheckBox.setEnabled(false);
        }
        this.checkEnableOkPaste();
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.mFileButton) {
            int n = this.mFileChooser.showOpenDialog((Component)((Object)this));
            if (n == 0) {
                this.mFilePath.setText(this.mFileChooser.getSelectedFilePath());
            }
            this.checkEnableOkPaste();
        }
        if (object == this.mStatisticsButton) {
            ISpssVariable iSpssVariable = this.mVariableTargetList.getModel().getElementAt(0);
            this.getDialogDataModel().putString("IDS_CURRENT_STATISTIC_FUNCTION", (String)this.mFormatter.getVarMap().get(iSpssVariable.getId().asInt()));
            if (this.runSubDialog(new DefineStatisticSubDlg(this, this.getResString("IDS_GRAPHS_STATISTIC_TITLE"), true))) {
                String string = GraphsVarDecorator.getDecoration(this.getDialogDataModel(), GraphsVarDecorator.getVariableTargetMap());
                ((GraphRepresentsListModel)this.mVariableTargetList.getModel()).setElementPropertyAt(0, string);
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.mChartSpecificationsCheckBox) {
            boolean bl = this.mChartSpecificationsCheckBox.isSelected();
            this.mFileButton.setEnabled(bl);
            this.mFilePath.setEnabled(bl);
        } else if (this.mOtherStatisticRadioButton.isSelected()) {
            this.enableCompOnOtherStatRadio();
        } else if (this.mNOfCasesRadioButton.isSelected() || this.mPercentOfCasesRadioButton.isSelected() || this.mCumDotNRadioButton.isSelected() || this.mCumulativePercentRadioButton.isSelected()) {
            this.mVariableArrowButton.setEnabled(false);
            this.mVariableLabel.setEnabled(false);
            this.mVariableTargetList.setEnabled(false);
            this.mVariableTargetList.setOpaque(false);
            this.mStatisticsButton.setEnabled(false);
        }
        this.checkEnableOkPaste();
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getSource() == this.mSrcList) {
            this.mStatisticsButton.setEnabled(false);
        } else if (listSelectionEvent.getSource() == this.mVariableTargetList && this.mVariableTargetList.getSelectedIndex() != -1) {
            this.mStatisticsButton.setEnabled(this.mOtherStatisticRadioButton.isSelected());
        } else if (listSelectionEvent.getSource() == this.mVariableTargetList && this.mVariableTargetList.getSelectedIndex() == -1) {
            this.mStatisticsButton.setEnabled(false);
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.mFileChooser != null) {
            this.mFileChooser.onDispose();
        }
    }

    @Override
    protected void loadDialogState() {
        super.loadDialogState();
        this.checkEnableOkPaste();
        this.mFormatter.setLegacyVarMap(this.getDialogDataModel().getMap(this.mVariableTargetList.getIdentifier()));
        this.mSrcList.setSelectedIndex(0);
    }

    @Override
    protected void saveDialogState() {
        super.saveDialogState();
        this.getDialogDataModel().putMap(this.mVariableTargetList.getIdentifier(), this.mFormatter.getVarMapForSerialization());
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefaults();
        JPanel jPanel = this.getViewPanel();
        JPanel jPanel2 = this.setupViewPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        int n = 23;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, null);
        this.setTabTraversalOrder();
        this.pack();
    }

    @Override
    protected JPanel setupOptionsButtonPanel() {
        JPanel jPanel = super.setupOptionsButtonPanel();
        JButton jButton = new JButton(new ToggleButtonAction("IDS_REPORT_COMMON_TITLES_3DOT"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StackedGroupOfCasesDlg.this.runSubDialog(new TitlesSubDialog(StackedGroupOfCasesDlg.this));
            }
        });
        this.addOptionsPanelButton(jPanel, jButton);
        JButton jButton2 = new JButton(new ToggleButtonAction("IDS_COMMON_OPTIONS_3DOT"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StackedGroupOfCasesDlg.this.runSubDialog(new OptionsSubDialog(StackedGroupOfCasesDlg.this, 1042));
            }
        });
        this.addOptionsPanelButton(jPanel, jButton2);
        return jPanel;
    }

    private void initVars() {
        this.mSrcList = new SrcVariableList();
        this.mSrcList.loadFromActiveDataset();
        this.mSrcList.addListSelectionListener(this);
        this.mStatisticsButton = new JButton();
        this.mStatisticsButton.setAction(new ToggleButtonAction(this, "IDS_GRAPH_BAR_CHANGE_STATISTIC_BUTTON"));
        this.mStatisticsButton.addActionListener(this);
        SpssVarFilter spssVarFilter = new SpssVarFilter(8, true, false);
        this.mVariableTargetList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mVariableTargetList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mVariableTargetList.addVarFilter(spssVarFilter);
        this.mVariableTargetList.addListSelectionListener(this);
        this.mSrcList.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                StackedGroupOfCasesDlg.this.mStatisticsButton.setEnabled(false);
                StackedGroupOfCasesDlg.this.mVariableTargetList.clearSelection();
            }
        });
        this.mVariableTargetList.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                if (StackedGroupOfCasesDlg.this.mVariableTargetList.getModel().getSize() > 0) {
                    StackedGroupOfCasesDlg.this.mVariableTargetList.setSelectedIndex(0);
                    StackedGroupOfCasesDlg.this.mStatisticsButton.setEnabled(true);
                }
            }
        });
        this.mVariableTargetList.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (StackedGroupOfCasesDlg.this.mVariableTargetList.getSelectedValue() != null) {
                    StackedGroupOfCasesDlg.this.mVariableArrowButton.setEnabled(StackedGroupOfCasesDlg.this.mOtherStatisticRadioButton.isSelected());
                    StackedGroupOfCasesDlg.this.mStatisticsButton.setEnabled(StackedGroupOfCasesDlg.this.mOtherStatisticRadioButton.isSelected());
                } else {
                    StackedGroupOfCasesDlg.this.mStatisticsButton.setEnabled(false);
                }
            }
        });
        this.mNOfCasesRadioButton = DialogUtil.createRadioButton(this, "IDS_GRAPHS_BAR_N_OF_CASES_RADIO", null);
        this.mCumDotNRadioButton = DialogUtil.createRadioButton(this, "IDS_GRAPHS_BAR_CUM_DOT_N_RADIO", null);
        this.mOtherStatisticRadioButton = DialogUtil.createRadioButton(this, "IDS_GRAPHS_BAR_OTHER_STATISTIC_RADIO", null);
        this.mPercentOfCasesRadioButton = DialogUtil.createRadioButton(this, "IDS_GRAPHS_BAR_PERCENT_OF_CASES_RADIO", null);
        this.mCumulativePercentRadioButton = DialogUtil.createRadioButton(this, "IDS_GRAPHS_BAR_CUM_DOT_PERCENT_RADIO", null);
        this.mNOfCasesRadioButton.addItemListener(this);
        this.mCumDotNRadioButton.addItemListener(this);
        this.mOtherStatisticRadioButton.addItemListener(this);
        this.mOtherStatisticRadioButton.addActionListener(this);
        this.mPercentOfCasesRadioButton.addItemListener(this);
        this.mCumulativePercentRadioButton.addItemListener(this);
        this.mVariableLabel = DialogUtil.createLabel(this, "IDS_VARIABLE");
        this.mVariableLabel.setLabelFor(this.mVariableTargetList);
        this.mVariableArrowButton = new ArrowButton();
        this.mVariableArrowButton.registerVariableList(this.mSrcList, SpssArrowButton.ButtonOrientation.right);
        this.mVariableArrowButton.registerVariableList(this.mVariableTargetList, SpssArrowButton.ButtonOrientation.left);
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, "IDS_NEST_VARIABLES_ROWS");
        this.mNestVariableRowsCheckBox = new JCheckBox();
        this.mNestVariableRowsCheckBox.setAction(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_GRAPHS_BAR_NEST_VARIABLES_COLUMNS_CHECK");
        this.mNestVariableColumnsCheckBox = new JCheckBox();
        this.mNestVariableColumnsCheckBox.setAction(toggleButtonAction);
        this.mFilePath = new FileTextField();
        this.mFilePath.setAction(new TextFieldAction(this, this.getResString("IDS_GRAPHS_BAR_SIMPLE_GROUPS_OF_CASES_FILEPATH")));
        this.mFilePath.setEditable(false);
        this.mFilePath.setOpaque(false);
        this.mFilePath.setBorder(BorderFactory.createEmptyBorder());
        this.mChartSpecificationsCheckBox = DialogUtil.createCheckBox(this, "IDS_GRAPHS_BAR_USE_CHART_SPECIFICATIONS_FROM_CHECK", null);
        this.mChartSpecificationsCheckBox.addItemListener(this);
        this.mFormatter = new GraphsVarFormatter(this.getTargetVariableList());
        this.mVariableTargetList.setModel(new GraphRepresentsListModel(this.mFormatter));
        this.mVariableTargetList.getModel().addListDataListener(this);
        this.mVariableTargetList.setCellRenderer(new LegacyVarListCellRenderer(this.mFormatter));
        this.mCategoryTargetList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mCategoryTargetList.getModel().addListDataListener(this);
        this.mCategoryTargetList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mCategoryTargetList.setIdentifier(CATEGORY_TARGET_VARIABLE_LIST_IDENTIFIER);
        this.mCategoryArrowButton = new ArrowButton();
        this.mCategoryArrowButton.registerVariableList(this.mSrcList, SpssArrowButton.ButtonOrientation.right);
        this.mCategoryArrowButton.registerVariableList(this.mCategoryTargetList, SpssArrowButton.ButtonOrientation.left);
        this.mStacksByTargetList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mStacksByTargetList.getModel().addListDataListener(this);
        this.mStacksByTargetList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mStacksByTargetList.setIdentifier(STACKS_BY_TARGET_VARIABLE_LIST_IDENTIFIER);
        this.mStacksByArrowButton = new ArrowButton();
        this.mStacksByArrowButton.registerVariableList(this.mSrcList, SpssArrowButton.ButtonOrientation.right);
        this.mStacksByArrowButton.registerVariableList(this.mStacksByTargetList, SpssArrowButton.ButtonOrientation.left);
        this.mStacksByScrollPane = new JScrollPane(this.mStacksByTargetList);
        this.mStacksByScrollPane.setHorizontalScrollBarPolicy(31);
        this.mStacksByScrollPane.setVerticalScrollBarPolicy(21);
        this.mStacksByScrollPane.setPreferredSize(this.mStacksByTargetList.getMinimumSize());
        this.mRowsTargetList = new TargetVariableList(TargetVariableList.TargetListType.normal);
        this.mRowsTargetList.getModel().addListDataListener(this);
        this.mRowsTargetList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mRowsTargetList.setIdentifier(ROWS_TARGET_VARIABLE_LIST_IDENTIFIER);
        this.mColumnTargetList = new TargetVariableList(TargetVariableList.TargetListType.normal);
        this.mColumnTargetList.getModel().addListDataListener(this);
        this.mColumnTargetList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mColumnTargetList.setIdentifier(COLUMNS_TARGET_VARIABLE_LIST_IDENTIFIER);
        this.mRowsArrowButton = new ArrowButton();
        this.mRowsArrowButton.registerVariableList(this.mSrcList, SpssArrowButton.ButtonOrientation.right);
        this.mRowsArrowButton.registerVariableList(this.mRowsTargetList, SpssArrowButton.ButtonOrientation.left);
        this.mColumnsArrowButton = new ArrowButton();
        this.mColumnsArrowButton.registerVariableList(this.mSrcList, SpssArrowButton.ButtonOrientation.right);
        this.mColumnsArrowButton.registerVariableList(this.mColumnTargetList, SpssArrowButton.ButtonOrientation.left);
        this.mFileButton = DialogUtil.createButton(this, "IDS_GRAPHS_BAR_SIMPLE_GROUPS_OF_CASES_FILEPATH", null);
        this.mFileChooser = new GraphsRemoteFileChooser(this);
        this.mFileButton.addActionListener(this);
    }

    private void setDefaults() {
        this.mSrcList.setSelectedIndex(0);
        this.mVariableTargetList.setEnabled(false);
        this.mVariableTargetList.setOpaque(false);
        this.mVariableLabel.setEnabled(false);
        this.mNOfCasesRadioButton.setSelected(true);
        this.mVariableArrowButton.setEnabled(false);
        this.mStatisticsButton.setEnabled(false);
        this.mNestVariableRowsCheckBox.setEnabled(false);
        this.mNestVariableColumnsCheckBox.setEnabled(false);
        this.mNestVariableRowsCheckBox.setSelected(false);
        this.mNestVariableColumnsCheckBox.setSelected(false);
        this.mChartSpecificationsCheckBox.setSelected(false);
        this.mFileButton.setEnabled(false);
        this.mFilePath.setText("");
    }

    private String getSyntaxForRadioButton() {
        String string = "";
        if (this.mCumDotNRadioButton.isSelected()) {
            string = "CUFREQ BY";
        } else if (this.mPercentOfCasesRadioButton.isSelected()) {
            string = "PCT BY";
        } else if (this.mCumulativePercentRadioButton.isSelected()) {
            string = "CUPCT BY";
        } else if (this.mOtherStatisticRadioButton.isSelected()) {
            ISpssVariable iSpssVariable = this.mVariableTargetList.getModel().getElementAt(0);
            Boolean bl = this.getDialogDataModel().getBoolean("IDS_GRAPHS_MEAN_OF_VALUES_RADIO");
            string = bl != null && !bl.booleanValue() ? this.getDecorationType(0) + "(" + iSpssVariable.getName() + ")" + " " + "BY" : "MEAN(" + iSpssVariable.getName() + ")" + " " + "BY";
        } else {
            string = "COUNT BY";
        }
        return string;
    }

    private String getSyntaxForPanelBy() {
        boolean bl;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = this.mColumnTargetList.getModel().getSize() > 0;
        boolean bl3 = bl = this.mRowsTargetList.getModel().getSize() > 0;
        if (bl2 || bl) {
            if (bl2) {
                stringBuffer.append(" COLVAR=" + this.mColumnTargetList.getVariablesStringList());
                stringBuffer.append(" COLOP=");
                if (this.mNestVariableColumnsCheckBox.isSelected()) {
                    stringBuffer.append("NEST");
                } else {
                    stringBuffer.append("CROSS");
                }
            }
            if (bl) {
                stringBuffer.append(" ROWVAR=" + this.mRowsTargetList.getVariablesStringList());
                stringBuffer.append(" ROWOP=");
                if (this.mNestVariableRowsCheckBox.isSelected()) {
                    stringBuffer.append("NEST");
                } else {
                    stringBuffer.append("CROSS");
                }
            }
        }
        return stringBuffer.toString();
    }

    private String getSyntaxForFile() {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.mChartSpecificationsCheckBox.isSelected() && (string = this.mFilePath.getText()) != null && string.length() > 0) {
            stringBuffer.append(SyntaxUtil.getSubCommand("/TEMPLATE=") + CharacterUtil.smartQuote((String)string));
        }
        return stringBuffer.toString();
    }

    private String getSyntaxForOptionsDialog() {
        StringBuffer stringBuffer = new StringBuffer();
        Boolean bl = this.getDialogDataModel().getBoolean("IDS_OPT_SUBDLG_DISPLAY_GROUPS_CHECK");
        if (bl != null && bl.booleanValue()) {
            stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/MISSING=REPORT"));
        }
        return stringBuffer.toString();
    }

    private JPanel setupViewPanel() {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JScrollPane jScrollPane = new JScrollPane(this.mSrcList);
        jScrollPane.setPreferredSize(this.mSrcList.getMinimumSize());
        JPanel jPanel2 = this.setupSummariesPanel(jScrollPane, this.setupBarsRepresentPanel(), this.setupCategoryPanel(), this.setupStacksByPanel(), this.setupPanelBy());
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n = DialogUtil.getGroupBoxInnerMargin();
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 2, 1, 23, null);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        n = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(n, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.setupTemplatePanel(), gridBagConstraints, 0, 1, 1, 1, 23, insets);
        return jPanel;
    }

    private JPanel setupBarsRepresentPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        TitledBorder titledBorder = new TitledBorder(this.getResString("IDS_GRAPHS_BAR_BARS_REPRESENT_RADIO"));
        jPanel.setBorder(titledBorder);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        int n = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(n, n, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mNOfCasesRadioButton, gridBagConstraints, 0, 0, 1, 1, 23, insets2);
        insets2.set(insets.top, n, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mCumDotNRadioButton, gridBagConstraints, 0, 1, 1, 1, 23, insets2);
        gridBagConstraints.weightx = 0.0;
        insets2.set(insets.top, n, n, n);
        DialogUtil.addUsingGBL(jPanel, this.mOtherStatisticRadioButton, gridBagConstraints, 0, 2, 1, 1, 23, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets2.set(n, insets.left, 0, n);
        DialogUtil.addUsingGBL(jPanel, this.mPercentOfCasesRadioButton, gridBagConstraints, 1, 0, 1, 1, 23, insets2);
        insets2.set(insets.top, insets.left, 0, n);
        DialogUtil.addUsingGBL(jPanel, this.mCumulativePercentRadioButton, gridBagConstraints, 1, 1, 1, 1, 23, insets2);
        JPanel jPanel2 = this.setupVariablePanel();
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        insets2.set(insets.top, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 3, 2, 1, 23, insets2);
        return jPanel;
    }

    private JPanel setupVariablePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = DialogUtil.getStandardControlInsets();
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets2 = new Insets(n, 3, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mVariableLabel, gridBagConstraints, 1, 0, 1, 1, 23, insets2);
        insets2.set(0, n, 0, DialogUtil.getArrowButtonInsets().right);
        DialogUtil.addUsingGBL(jPanel, this.mVariableArrowButton, gridBagConstraints, 0, 0, 1, 2, 20, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        insets2.set(0, 3, 0, n);
        JScrollPane jScrollPane = new JScrollPane(this.mVariableTargetList);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setVerticalScrollBarPolicy(21);
        jScrollPane.setPreferredSize(this.mVariableTargetList.getMinimumSize());
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 1, 1, 1, 1, 20, insets2);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weighty = 1.0;
        insets2.set(n * 2, insets.left, n, n2);
        DialogUtil.addUsingGBL(jPanel, this.mStatisticsButton, gridBagConstraints, 1, 2, 1, 1, 10, insets2);
        return jPanel;
    }

    private JPanel setupCategoryPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getComponentGroupGap();
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_GRAPHS_BAR_CATEGORY_AXIS_LABEL");
        jLabel.setLabelFor(this.mCategoryTargetList);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        Insets insets = new Insets(n, 3, 0, n2);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 1, 0, 1, 1, 23, insets);
        gridBagConstraints.weightx = 0.0;
        insets.set(0, DialogUtil.getArrowButtonInsets().left + n2 + 3, 0, DialogUtil.getArrowButtonInsets().right);
        DialogUtil.addUsingGBL(jPanel, this.mCategoryArrowButton, gridBagConstraints, 0, 0, 1, 2, 20, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        insets.set(0, 3, 0, n2 + 4);
        JScrollPane jScrollPane = new JScrollPane(this.mCategoryTargetList);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setVerticalScrollBarPolicy(21);
        jScrollPane.setPreferredSize(this.mCategoryTargetList.getMinimumSize());
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 1, 1, 1, 1, 20, insets);
        return jPanel;
    }

    private JPanel setupStacksByPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getComponentGroupGap();
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_GRAPHS_BAR_STACKS_BY_LABEL");
        jLabel.setLabelFor(this.mStacksByTargetList);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        Insets insets = new Insets(n, 3, 0, n2);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 1, 0, 1, 1, 23, insets);
        gridBagConstraints.weightx = 0.0;
        insets.set(0, DialogUtil.getArrowButtonInsets().left + n2 + 3, 0, DialogUtil.getArrowButtonInsets().right);
        DialogUtil.addUsingGBL(jPanel, this.mStacksByArrowButton, gridBagConstraints, 0, 0, 1, 2, 20, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        insets.set(0, 3, 0, n2 + 4);
        DialogUtil.addUsingGBL(jPanel, this.mStacksByScrollPane, gridBagConstraints, 1, 1, 1, 1, 20, insets);
        return jPanel;
    }

    private JPanel setupPanelBy() {
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_GRAPH_BAR_ROWS_COLON_LABEL");
        jLabel.setLabelFor(this.mRowsTargetList);
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_GRAPH_BAR_COLUMNS_COLON_LABEL");
        jLabel2.setLabelFor(this.mColumnTargetList);
        JComponent[] jComponentArray = new JComponent[]{jLabel, this.mRowsArrowButton, this.mRowsTargetList, this.mNestVariableRowsCheckBox, jLabel2, this.mColumnsArrowButton, this.mColumnTargetList, this.mNestVariableColumnsCheckBox};
        return PanelFactory.getGraphsPanelByPanel(jComponentArray, this.getResString("IDS_GRAPHS_BAR_PANEL_BY_TITLE"));
    }

    private JPanel setupTemplatePanel() {
        JComponent[] jComponentArray = new JComponent[8];
        jComponentArray[0] = this.mChartSpecificationsCheckBox;
        jComponentArray[1] = this.mFileButton;
        jComponentArray[2] = this.mFilePath;
        return PanelFactory.getGraphsChartTemplatePanel(jComponentArray, this.getResString("IDS_GRAPH_BAR_TEMPLATE_TITLE"));
    }

    private JPanel setupSummariesPanel(JScrollPane jScrollPane, JPanel jPanel, JPanel jPanel2, JPanel jPanel3, JPanel jPanel4) {
        JPanel jPanel5 = new JPanel(new GridBagLayout());
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_SOURCE_LIST_LABEL");
        jLabel.setLabelFor(this.mSrcList);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        JPanel jPanel6 = new JPanel(new GridBagLayout());
        jPanel6.setBorder(BorderFactory.createEmptyBorder());
        DialogUtil.addUsingGBL(jPanel6, jLabel, gridBagConstraints, 0, 0, 1, 1, 23, null);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n = DialogUtil.getComponentGroupGap();
        DialogUtil.addUsingGBL(jPanel6, jScrollPane, gridBagConstraints, 0, 1, 1, 1, 23, null);
        DialogUtil.addUsingGBL(jPanel5, jPanel6, gridBagConstraints, 0, 0, 1, 4, 23, null);
        Insets insets = new Insets(0, n, 0, 0);
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel5, jPanel, gridBagConstraints, 1, 0, 1, 1, 23, insets);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        insets.set(0, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel5, jPanel2, gridBagConstraints, 1, 1, 1, 1, 23, insets);
        DialogUtil.addUsingGBL(jPanel5, jPanel3, gridBagConstraints, 1, 2, 1, 1, 23, insets);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        insets.set(n, n, 0, 0);
        DialogUtil.addUsingGBL(jPanel5, jPanel4, gridBagConstraints, 1, 3, 1, 1, 23, insets);
        return jPanel5;
    }

    private String getDecorationType(int n) {
        ISpssVariable iSpssVariable = this.mVariableTargetList.getModel().getElementAt(n);
        return this.mFormatter.getVarMap().get(iSpssVariable.getId().asInt()).toString();
    }

    private void checkEnableOkPaste() {
        boolean bl;
        boolean bl2 = this.mCategoryTargetList.getModel().getSize() > 0;
        boolean bl3 = true;
        boolean bl4 = bl = this.mStacksByTargetList.getModel().getSize() > 0;
        if (this.mOtherStatisticRadioButton.isSelected()) {
            bl3 = this.mVariableTargetList.getModel().getSize() > 0;
        }
        boolean bl5 = true;
        if (this.mChartSpecificationsCheckBox.isSelected()) {
            bl5 = this.mFilePath.getText() != null && this.mFilePath.getText().length() > 0;
        }
        this.enableOkPaste(bl2 && bl3 && bl5 && bl);
    }

    private TargetVariableList getTargetVariableList() {
        return this.mVariableTargetList;
    }

    private void setTabTraversalOrder() {
        Component[] componentArray;
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcList);
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        spssButtonGroup.add(this.mNOfCasesRadioButton);
        spssButtonGroup.add(this.mCumDotNRadioButton);
        spssButtonGroup.add(this.mOtherStatisticRadioButton);
        spssButtonGroup.add(this.mPercentOfCasesRadioButton);
        spssButtonGroup.add(this.mCumulativePercentRadioButton);
        vector.add(spssButtonGroup);
        vector.add(this.mVariableArrowButton);
        vector.add(this.mVariableTargetList);
        vector.add(this.mStatisticsButton);
        vector.add(this.mCategoryArrowButton);
        vector.add(this.mStacksByArrowButton);
        vector.add(this.mRowsArrowButton);
        vector.add(this.mColumnsArrowButton);
        vector.add(this.mCategoryTargetList);
        vector.add(this.mStacksByTargetList);
        vector.add(this.mRowsTargetList);
        vector.add(this.mNestVariableRowsCheckBox);
        vector.add(this.mColumnTargetList);
        vector.add(this.mNestVariableColumnsCheckBox);
        vector.add(this.mChartSpecificationsCheckBox);
        vector.add(this.mFileButton);
        for (Component component : componentArray = this.mOptionButtonPanel.getComponents()) {
            if (!(component instanceof JButton)) continue;
            vector.add(component);
        }
        for (Component component : componentArray = this.mCmdButtonPanel.getComponents()) {
            vector.add(component);
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private void enableCompOnOtherStatRadio() {
        this.mVariableLabel.setEnabled(true);
        this.mVariableTargetList.setEnabled(true);
        this.mVariableTargetList.setOpaque(true);
        this.mVariableArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
        if (this.mVariableTargetList.getModel().getSize() > 0 && SpssArrowButton.ButtonOrientation.right != this.mVariableArrowButton.getArrowOrientation()) {
            this.mVariableArrowButton.setEnabled(true);
            this.mVariableTargetList.setSelectedIndex(0);
            this.mStatisticsButton.setEnabled(true);
        } else if (this.mVariableTargetList.getModel().getSize() > 0 && SpssArrowButton.ButtonOrientation.right == this.mVariableArrowButton.getArrowOrientation()) {
            this.mVariableArrowButton.setEnabled(false);
            this.mStatisticsButton.setEnabled(false);
        } else if (this.mSrcList.getSelectedValue() != null && this.mSrcList.getSelectedIndices().length == 1) {
            this.mVariableArrowButton.setEnabled(true);
        } else {
            this.mVariableArrowButton.setEnabled(false);
        }
    }
}

