/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.graphs.legacy_dialogs.bar;

import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.FileTextField;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.dialogs.base.graphs.GraphsRemoteFileChooser;
import com.spss.java_client.ui.dialogs.base.graphs.GraphsUtil;
import com.spss.java_client.ui.dialogs.base.graphs.TitlesSubDialog;
import com.spss.java_client.ui.dialogs.base.graphs.res.GraphsResBundle;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.uitools.util.CharacterUtil;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class SimpleValueOfIndividualCasesDlg
extends BaseProcedureDialog
implements ActionListener,
ItemListener,
ListDataListener,
DocumentListener {
    private static final String SOURCE_VARIABLE_LIST = "SOURCE_VARIABLE_LIST";
    private static final String BARS_REPRESENT_TARGET_VAR_LIST = "BARS_REPRESENT_TARGET_VAR_LIST";
    private static final String VARIABLE_TARGET_VAR_LIST = "VARIABLE_TARGET_VAR_LIST";
    private static final String COLUMNS_TARGET_VAR_LIST = "COLUMNS_TARGET_VAR_LIST";
    private static final String ROWS_TARGET_VAR_LIST = "ROWS_TARGET_VAR_LIST";
    private static final String FILEPATH_EDIT = "IDS_FILEPATH_EDIT";
    private SrcVariableList mSrcVariableList;
    private TargetVariableList mBarRepresentTargetList;
    private TargetVariableList mVariableTargetList;
    private TargetVariableList mRowsTargetList;
    private TargetVariableList mColumnsTargetList;
    private ArrowButton mBarRepresentArrowButton;
    private ArrowButton mVariableArrowButton;
    private ArrowButton mRowsArrowButton;
    private ArrowButton mColumnsArrowButton;
    private JRadioButton mCaseNumberRadio;
    private JRadioButton mVariableRadio;
    private JCheckBox mNestVariableRowsCheck;
    private JCheckBox mNestVariableColumnsCheck;
    private JCheckBox mUseChartSpecCheck;
    private JButton mFileButton;
    private FileTextField mFilePathEdit;
    private RemoteFileChooser mFileChooser;
    private SpssButtonGroup mLabelsRadioGroup;

    public SimpleValueOfIndividualCasesDlg(JFrame jFrame) throws HeadlessException {
        super(jFrame, false, GraphsResBundle.getDefaultResourceBundleName(), GraphsResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_DEFINE_SIMPLE_BAR_VALUES_OF_INDV_CASES_TITLE"));
    }

    @Override
    public String getIActionKey() {
        return "graphs_legacy_dialogs_bar_simple_individual_cases";
    }

    @Override
    public String getDialogHelpID() {
        return "idh_gbsi";
    }

    public void paint(Graphics graphics) {
        this.mFilePathEdit.setText(this.mFilePathEdit.getText());
        super.paint(graphics);
        super.validate();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.mUseChartSpecCheck) {
            boolean bl = this.mUseChartSpecCheck.isSelected();
            this.mFileButton.setEnabled(bl);
            this.mFilePathEdit.setEnabled(bl);
        } else if (object == this.mVariableRadio && this.mVariableRadio.isSelected()) {
            this.enableCompOnVariableRadio();
        } else if (object.equals(this.mCaseNumberRadio) && this.mCaseNumberRadio.isSelected()) {
            this.mVariableArrowButton.setEnabled(false);
            this.mVariableTargetList.setEnabled(false);
            this.mVariableTargetList.setOpaque(false);
        }
        this.checkEnableOkPaste();
    }

    @Override
    public String generateSyntax() {
        String string;
        Object object;
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        stringBuffer.append(SyntaxUtil.getMainCommand("GRAPH"));
        if (this.mBarRepresentTargetList.getModel().getSize() > 0) {
            stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/BAR(SIMPLE)=") + "VALUE(" + this.mBarRepresentTargetList.getVariablesStringList() + ")");
            if (this.mVariableRadio.isSelected() && this.mVariableTargetList.getModel().getSize() > 0) {
                stringBuffer.append(" BY " + this.mVariableTargetList.getVariablesStringList());
            }
        }
        stringBuffer.append(this.getSyntaxForPanelBy());
        if (this.mUseChartSpecCheck.isSelected() && (object = this.mFilePathEdit.getText()) != null && ((String)object).length() > 0) {
            stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/TEMPLATE=") + CharacterUtil.smartQuote((String)object));
        }
        if ((string = GraphsUtil.generateTitlesSubDialogSyntax((DialogDataModel)(object = this.getDialogDataModel()))).length() != 0) {
            stringBuffer.append(string);
        }
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        return stringBuffer.toString();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        int n;
        Object object = actionEvent.getSource();
        this.enableCompOnVariableRadio();
        if (object == this.mFileButton && (n = this.mFileChooser.showOpenDialog((Component)((Object)this))) == 0) {
            this.mFilePathEdit.setText(this.mFileChooser.getSelectedFilePath());
        }
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.doListDataChange(listDataEvent);
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.doListDataChange(listDataEvent);
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.doListDataChange(listDataEvent);
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.checkEnableOkPaste();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.checkEnableOkPaste();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.checkEnableOkPaste();
    }

    @Override
    public void reset() {
        super.reset();
        this.mBarRepresentTargetList.removeAll();
        this.mVariableTargetList.removeAll();
        this.mRowsTargetList.removeAll();
        this.mColumnsTargetList.removeAll();
        this.mNestVariableRowsCheck.setSelected(false);
        this.mNestVariableColumnsCheck.setSelected(false);
        this.mUseChartSpecCheck.setSelected(false);
        this.mBarRepresentArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
        this.mVariableArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
        this.mRowsArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
        this.mColumnsArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
        this.setDefaults();
    }

    @Override
    public void loadDialogState() {
        super.loadDialogState();
        this.mSrcVariableList.setSelectedIndex(0);
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.mFileChooser != null) {
            this.mFileChooser.onDispose();
        }
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        this.setupUI(jPanel);
        this.setTabTraversalOrder();
        this.pack();
    }

    @Override
    protected JPanel setupOptionsButtonPanel() {
        JPanel jPanel = super.setupOptionsButtonPanel();
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction("IDS_REPORT_COMMON_TITLES_3DOT"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SimpleValueOfIndividualCasesDlg.this.runTitlesSubDialog();
            }
        };
        JButton jButton = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, jButton);
        return jPanel;
    }

    protected void runTitlesSubDialog() {
        this.runSubDialog(new TitlesSubDialog(this));
    }

    private void initVars() {
        this.mSrcVariableList = new SrcVariableList();
        this.mSrcVariableList.setIdentifier(SOURCE_VARIABLE_LIST);
        this.mBarRepresentTargetList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mBarRepresentTargetList.setIdentifier(BARS_REPRESENT_TARGET_VAR_LIST);
        this.mBarRepresentArrowButton = new ArrowButton();
        SpssVarFilter spssVarFilter = new SpssVarFilter(8, true, false);
        this.mBarRepresentTargetList.addVarFilter(spssVarFilter);
        this.mVariableTargetList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mVariableTargetList.setIdentifier(VARIABLE_TARGET_VAR_LIST);
        this.mVariableArrowButton = new ArrowButton();
        this.mRowsTargetList = new TargetVariableList();
        this.mRowsTargetList.setIdentifier(ROWS_TARGET_VAR_LIST);
        this.mRowsArrowButton = new ArrowButton();
        this.mColumnsTargetList = new TargetVariableList();
        this.mColumnsTargetList.setIdentifier(COLUMNS_TARGET_VAR_LIST);
        this.mColumnsArrowButton = new ArrowButton();
        this.mCaseNumberRadio = DialogUtil.createRadioButton(this, "IDS_GRAPHS_BAR_CASE_NUMBER_RADIO", null);
        this.mVariableRadio = DialogUtil.createRadioButton(this, "IDS_VARIABLE", null);
        this.mLabelsRadioGroup = new SpssButtonGroup();
        this.mLabelsRadioGroup.add(this.mCaseNumberRadio);
        this.mLabelsRadioGroup.add(this.mVariableRadio);
        this.mNestVariableRowsCheck = DialogUtil.createCheckBox(this, "IDS_NEST_VARIABLES_ROWS", null);
        this.mNestVariableColumnsCheck = DialogUtil.createCheckBox(this, "IDS_GRAPHS_BAR_NEST_VARIABLES_COLUMNS_CHECK", null);
        this.mUseChartSpecCheck = DialogUtil.createCheckBox(this, "IDS_GRAPHS_BAR_USE_CHART_SPECIFICATIONS_FROM_CHECK", null);
        this.mFileButton = DialogUtil.createButton(this, "IDS_GRAPHS_BAR_SIMPLE_GROUPS_OF_CASES_FILEPATH", null);
        this.mFilePathEdit = new FileTextField();
        this.mFilePathEdit.setAction(new TextFieldAction(this, FILEPATH_EDIT));
        this.mFilePathEdit.setBorder(BorderFactory.createEmptyBorder());
        this.mFileChooser = new GraphsRemoteFileChooser(this);
        this.setDefaults();
        this.mFileButton.addActionListener(this);
        this.mUseChartSpecCheck.addItemListener(this);
        this.mFilePathEdit.getDocument().addDocumentListener(this);
        this.mVariableRadio.addItemListener(this);
        this.mVariableRadio.addActionListener(this);
        this.mCaseNumberRadio.addItemListener(this);
        this.mRowsTargetList.getModel().addListDataListener(this);
        this.mColumnsTargetList.getModel().addListDataListener(this);
        this.mBarRepresentTargetList.getModel().addListDataListener(this);
        this.mVariableTargetList.getModel().addListDataListener(this);
        this.mBarRepresentArrowButton.registerVariableList(this.mSrcVariableList, SpssArrowButton.ButtonOrientation.right);
        this.mBarRepresentArrowButton.registerVariableList(this.mBarRepresentTargetList, SpssArrowButton.ButtonOrientation.left);
        this.mVariableArrowButton.registerVariableList(this.mSrcVariableList, SpssArrowButton.ButtonOrientation.right);
        this.mVariableArrowButton.registerVariableList(this.mVariableTargetList, SpssArrowButton.ButtonOrientation.left);
        this.mRowsArrowButton.registerVariableList(this.mSrcVariableList, SpssArrowButton.ButtonOrientation.right);
        this.mRowsArrowButton.registerVariableList(this.mRowsTargetList, SpssArrowButton.ButtonOrientation.left);
        this.mColumnsArrowButton.registerVariableList(this.mSrcVariableList, SpssArrowButton.ButtonOrientation.right);
        this.mColumnsArrowButton.registerVariableList(this.mColumnsTargetList, SpssArrowButton.ButtonOrientation.left);
    }

    private void setDefaults() {
        this.mFilePathEdit.setOpaque(false);
        this.mFilePathEdit.setEditable(false);
        this.mSrcVariableList.removeAll();
        this.mSrcVariableList.loadFromActiveDataset();
        this.mSrcVariableList.setSelectedIndex(0);
        this.mSrcVariableList.requestFocus();
        this.mFileButton.setEnabled(false);
        this.mFilePathEdit.setText("");
        this.mFilePathEdit.setEnabled(false);
        this.mCaseNumberRadio.setSelected(true);
        this.mVariableArrowButton.setEnabled(false);
        this.mVariableTargetList.setEnabled(false);
        this.mVariableTargetList.setOpaque(false);
        this.mNestVariableRowsCheck.setEnabled(false);
        this.mNestVariableColumnsCheck.setEnabled(false);
    }

    private void setTabTraversalOrder() {
        Component[] componentArray;
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcVariableList);
        vector.add(this.mBarRepresentArrowButton);
        vector.add(this.mRowsArrowButton);
        vector.add(this.mColumnsArrowButton);
        vector.add(this.mBarRepresentTargetList);
        vector.add(this.mLabelsRadioGroup);
        vector.add(this.mVariableArrowButton);
        vector.add(this.mVariableTargetList);
        vector.add(this.mRowsTargetList);
        vector.add(this.mNestVariableRowsCheck);
        vector.add(this.mColumnsTargetList);
        vector.add(this.mNestVariableColumnsCheck);
        vector.add(this.mUseChartSpecCheck);
        vector.add(this.mFileButton);
        for (Component component : componentArray = this.mOptionButtonPanel.getComponents()) {
            if (!(component instanceof JButton)) continue;
            vector.add(component);
        }
        for (Component component : componentArray = this.mCmdButtonPanel.getComponents()) {
            vector.add(component);
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private void doListDataChange(ListDataEvent listDataEvent) {
        Object object = listDataEvent.getSource();
        if (object == this.mRowsTargetList.getModel()) {
            this.mNestVariableRowsCheck.setEnabled(this.mRowsTargetList.getModel().getSize() > 0);
        } else if (object == this.mColumnsTargetList.getModel()) {
            this.mNestVariableColumnsCheck.setEnabled(this.mColumnsTargetList.getModel().getSize() > 0);
        } else if (object == this.mBarRepresentTargetList.getModel()) {
            this.checkEnableOkPaste();
        } else if (object == this.mVariableTargetList.getModel()) {
            this.checkEnableOkPaste();
        }
    }

    private void checkEnableOkPaste() {
        boolean bl;
        boolean bl2 = bl = this.mBarRepresentTargetList.getModel().getSize() > 0;
        if (bl && this.mVariableRadio.isSelected()) {
            boolean bl3 = bl = this.mVariableTargetList.getModel().getSize() > 0;
        }
        if (bl && this.mUseChartSpecCheck.isSelected()) {
            String string = this.mFilePathEdit.getText();
            bl = string != null && string.length() > 0;
        }
        this.enableOkPaste(bl);
    }

    private void setupUI(JPanel jPanel) {
        JPanel jPanel2 = this.setupIndividualCasesPanel();
        JPanel jPanel3 = this.setupTemplatePanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n = DialogUtil.getGroupBoxInnerMargin();
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, 23, null);
        Insets insets = new Insets(n, 0, 0, 0);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 1, 1, 1, 23, insets);
    }

    private JPanel setupIndividualCasesPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_SOURCE_LIST_LABEL");
        jLabel.setLabelFor(this.mSrcVariableList);
        JScrollPane jScrollPane = new JScrollPane(this.mSrcVariableList);
        jScrollPane.setPreferredSize(this.mSrcVariableList.getMinimumSize());
        JPanel jPanel2 = this.setupCategoryLabelPanel();
        JPanel jPanel3 = this.setupPanelByPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, 23, null);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n = DialogUtil.getGroupBoxInnerMargin();
        int n2 = DialogUtil.getComponentGroupGap();
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 1, 1, 3, 23, null);
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_GRAPHS_BAR_BARS_REPRESENTS_COLON_LABEL");
        jLabel2.setLabelFor(this.mBarRepresentTargetList);
        JScrollPane jScrollPane2 = new JScrollPane(this.mBarRepresentTargetList);
        jScrollPane2.setPreferredSize(this.mBarRepresentTargetList.getMinimumSize());
        jScrollPane2.setVerticalScrollBarPolicy(21);
        jScrollPane2.setHorizontalScrollBarPolicy(31);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        int n3 = 23;
        Insets insets = new Insets(0, 3, 0, n);
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 2, 0, 1, 1, n3, insets);
        gridBagConstraints.weightx = 0.0;
        Insets insets2 = DialogUtil.getArrowButtonInsets();
        insets.set(0, insets2.left + n + 3, 0, insets2.right);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        n3 = 20;
        DialogUtil.addUsingGBL(jPanel, this.mBarRepresentArrowButton, gridBagConstraints, 1, 0, 1, 2, n3, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        n3 = 20;
        insets.set(0, 3, 0, n + 4);
        DialogUtil.addUsingGBL(jPanel, jScrollPane2, gridBagConstraints, 2, 1, 1, 1, n3, insets);
        insets.set(n, n2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 1, 2, 2, 1, n3, insets);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        insets.set(0, n2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 1, 3, 2, 1, 23, insets);
        return jPanel;
    }

    private JPanel setupCategoryLabelPanel() {
        JComponent[] jComponentArray = new JComponent[]{this.mVariableTargetList, this.mVariableArrowButton, this.mCaseNumberRadio, this.mVariableRadio};
        return PanelFactory.getGraphsLabelPanel(jComponentArray, this.getResString("IDS_GRAPHS_BAR_CATEGORY_LABELS_CAPTION"));
    }

    private JPanel setupPanelByPanel() {
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_GRAPH_BAR_ROWS_COLON_LABEL");
        jLabel.setLabelFor(this.mRowsTargetList);
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_GRAPH_BAR_COLUMNS_COLON_LABEL");
        jLabel2.setLabelFor(this.mColumnsTargetList);
        JComponent[] jComponentArray = new JComponent[]{jLabel, this.mRowsArrowButton, this.mRowsTargetList, this.mNestVariableRowsCheck, jLabel2, this.mColumnsArrowButton, this.mColumnsTargetList, this.mNestVariableColumnsCheck};
        return PanelFactory.getGraphsPanelByPanel(jComponentArray, this.getResString("IDS_GRAPHS_BAR_PANEL_BY_TITLE"));
    }

    private JPanel setupTemplatePanel() {
        JComponent[] jComponentArray = new JComponent[8];
        jComponentArray[0] = this.mUseChartSpecCheck;
        jComponentArray[1] = this.mFileButton;
        jComponentArray[2] = this.mFilePathEdit;
        return PanelFactory.getGraphsChartTemplatePanel(jComponentArray, this.getResString("IDS_GRAPH_BAR_TEMPLATE_TITLE"));
    }

    private String getSyntaxForPanelBy() {
        boolean bl;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = this.mColumnsTargetList.getModel().getSize() > 0;
        boolean bl3 = bl = this.mRowsTargetList.getModel().getSize() > 0;
        if (bl2 || bl) {
            stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/PANEL"));
            if (bl2) {
                stringBuffer.append(" COLVAR=" + this.mColumnsTargetList.getVariablesStringList());
                stringBuffer.append(" COLOP=");
                if (this.mNestVariableColumnsCheck.isSelected()) {
                    stringBuffer.append("NEST");
                } else {
                    stringBuffer.append("CROSS");
                }
            }
            if (bl) {
                stringBuffer.append(" ROWVAR=" + this.mRowsTargetList.getVariablesStringList());
                stringBuffer.append(" ROWOP=");
                if (this.mNestVariableRowsCheck.isSelected()) {
                    stringBuffer.append("NEST");
                } else {
                    stringBuffer.append("CROSS");
                }
            }
        }
        return stringBuffer.toString();
    }

    private void enableCompOnVariableRadio() {
        this.mVariableTargetList.setEnabled(true);
        this.mVariableTargetList.setOpaque(true);
        this.mVariableArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
        if (this.mVariableTargetList.getModel().getSize() > 0 && SpssArrowButton.ButtonOrientation.right != this.mVariableArrowButton.getArrowOrientation()) {
            this.mVariableArrowButton.setEnabled(true);
            this.mVariableTargetList.setSelectedIndex(0);
        } else if (this.mVariableTargetList.getModel().getSize() > 0 && SpssArrowButton.ButtonOrientation.right == this.mVariableArrowButton.getArrowOrientation()) {
            this.mVariableArrowButton.setEnabled(false);
        } else if (this.mSrcVariableList.getSelectedValue() != null && this.mSrcVariableList.getSelectedIndices().length == 1) {
            this.mVariableArrowButton.setEnabled(true);
        } else {
            this.mVariableArrowButton.setEnabled(false);
        }
    }
}

