/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.graphs.legacy_dialogs.bar;

import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.base.graphs.IMatrixListener;
import com.spss.java_client.ui.dialogs.base.graphs.ImageLabelKeyListener;
import com.spss.java_client.ui.dialogs.base.graphs.MatrixImage;
import com.spss.java_client.ui.dialogs.base.graphs.MatrixImagesGroup;
import com.spss.java_client.ui.dialogs.base.graphs.res.GraphsResBundle;
import com.spss.java_client.ui.dialogs.common.BaseGatingDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.shared.core_tools.system.OSInfo;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;

public class BarDlg
extends BaseGatingDialog
implements IMatrixListener {
    private JRadioButton mSummariesForGroupsOfCasesRadio;
    private JRadioButton mSummariesOfSeparateVarsRadio;
    private JRadioButton mValuesOfIndividualCasesRadio;
    private SpssButtonGroup mRadioButtonGroup;
    private MatrixImage mSimpleBarImageLabel;
    private MatrixImage mClusteredBarImageLabel;
    private MatrixImage mStackedImageLabel;
    private JLabel mSimpleBarLabel;
    private JLabel mClusteredLabel;
    private JLabel mStackedLabel;
    private MatrixImagesGroup mGraphsBarImageLabelGroup;

    public BarDlg(JFrame jFrame) throws HeadlessException {
        super(jFrame, GraphsResBundle.getDefaultResourceBundleName(), GraphsResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_BAR_CHARTS_TITLE"));
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public String getDialogHelpID() {
        return "idh_gbar";
    }

    @Override
    public String getIActionKey() {
        return "graphs_legacy_dialogs_bar";
    }

    @Override
    public String getNextProcDlgActionKey() {
        String string = null;
        if (this.mSummariesForGroupsOfCasesRadio.isSelected()) {
            if (this.mGraphsBarImageLabelGroup.isSelected(this.mSimpleBarImageLabel)) {
                string = "graphs_legacy_dialogs_bar_simple_group_of_cases";
            } else if (this.mGraphsBarImageLabelGroup.isSelected(this.mClusteredBarImageLabel)) {
                string = "graphs_legacy_dialogs_bar_clustered_group_of_cases";
            } else if (this.mGraphsBarImageLabelGroup.isSelected(this.mStackedImageLabel)) {
                string = "graphs_legacy_dialogs_bar_stacked_group_of_cases";
            }
        } else if (this.mSummariesOfSeparateVarsRadio.isSelected()) {
            if (this.mGraphsBarImageLabelGroup.isSelected(this.mSimpleBarImageLabel)) {
                string = "graphs_legacy_dialogs_bar_simple_separate_variable";
            } else if (this.mGraphsBarImageLabelGroup.isSelected(this.mClusteredBarImageLabel)) {
                string = "graphs_legacy_dialogs_bar_clustered_separate_variable";
            } else if (this.mGraphsBarImageLabelGroup.isSelected(this.mStackedImageLabel)) {
                string = "graphs_legacy_dialogs_bar_stacked_separate_variable";
            }
        } else if (this.mGraphsBarImageLabelGroup.isSelected(this.mSimpleBarImageLabel)) {
            string = "graphs_legacy_dialogs_bar_simple_individual_cases";
        } else if (this.mGraphsBarImageLabelGroup.isSelected(this.mClusteredBarImageLabel)) {
            string = "graphs_legacy_dialogs_bar_clustered_individual_cases";
        } else if (this.mGraphsBarImageLabelGroup.isSelected(this.mStackedImageLabel)) {
            string = "graphs_legacy_dialogs_bar_stacked_individual_cases";
        }
        return string;
    }

    @Override
    public boolean continuePressed() {
        return true;
    }

    @Override
    public void loadDialogState() {
        Integer n = this.mDialogDataModel.getInteger("IDS_GRAPHS_BAR_SELECTED_IMAGE");
        if (n != null) {
            this.setImageSelected(n);
        }
        super.loadDialogState();
    }

    @Override
    public void saveDialogState() {
        super.saveDialogState();
        this.mDialogDataModel.putInteger("IDS_GRAPHS_BAR_SELECTED_IMAGE", this.getSelectedImageIndex());
    }

    @Override
    public void matrixImageEvent(IMatrixListener.EventType eventType, int n) {
        if (eventType == IMatrixListener.EventType.doubleClick) {
            this.mDefineButton.doClick();
        }
    }

    @Override
    protected void init() {
        super.init();
        this.renameContinueAction("IDS_DEFINE");
        this.initVars();
        this.setDefaults();
        this.addComponentsToMainPanel(this.getViewPanel());
        this.setTabPolicy();
        this.pack();
    }

    private void initVars() {
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, "IDS_SUMMARIES_FOR_GROUPS_OF_CASES_RADIO");
        this.mSummariesForGroupsOfCasesRadio = new JRadioButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_SUMMARIES_OF_SEPARATE_VARIABLES_RADIO");
        this.mSummariesOfSeparateVarsRadio = new JRadioButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_VALUES_OF_INDIVIDUAL_CASES_RADIO");
        this.mValuesOfIndividualCasesRadio = new JRadioButton(toggleButtonAction);
        this.mGraphsBarImageLabelGroup = new MatrixImagesGroup();
        this.mSimpleBarLabel = new JLabel(this.getResString("IDS_SIMPLE"));
        this.mSimpleBarImageLabel = new MatrixImage(this.getResImageURL("IDS_SIMPLE_BAR_IMAGE"));
        this.mSimpleBarImageLabel.setImageLabelGroup(this.mGraphsBarImageLabelGroup);
        this.mSimpleBarImageLabel.addMatrixListener(this);
        this.mClusteredLabel = new JLabel(this.getResString("IDS_CLUSTERED"));
        this.mClusteredBarImageLabel = new MatrixImage(this.getResImageURL("IDS_CLUSTERED_BAR_IMAGE"));
        this.mClusteredBarImageLabel.setImageLabelGroup(this.mGraphsBarImageLabelGroup);
        this.mClusteredBarImageLabel.addMatrixListener(this);
        this.mStackedLabel = new JLabel(this.getResString("IDS_STACKED"));
        this.mStackedImageLabel = new MatrixImage(this.getResImageURL("IDS_STACKED_BAR_IMAGE"));
        this.mStackedImageLabel.setImageLabelGroup(this.mGraphsBarImageLabelGroup);
        this.mStackedImageLabel.addMatrixListener(this);
        Vector<MatrixImage> vector = new Vector<MatrixImage>();
        vector.add(this.mSimpleBarImageLabel);
        vector.add(this.mClusteredBarImageLabel);
        vector.add(this.mStackedImageLabel);
        this.mSimpleBarImageLabel.addKeyListener(new ImageLabelKeyListener(vector, this.mGraphsBarImageLabelGroup));
        this.mClusteredBarImageLabel.addKeyListener(new ImageLabelKeyListener(vector, this.mGraphsBarImageLabelGroup));
        this.mStackedImageLabel.addKeyListener(new ImageLabelKeyListener(vector, this.mGraphsBarImageLabelGroup));
    }

    private void setDefaults() {
        this.mSummariesForGroupsOfCasesRadio.setSelected(true);
        this.mSimpleBarImageLabel.setDefaultSelectedImage(true);
        this.mClusteredBarImageLabel.setDefaultSelectedImage(false);
        this.mStackedImageLabel.setDefaultSelectedImage(false);
    }

    private void addComponentsToMainPanel(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        int n = 23;
        JPanel jPanel2 = this.setupImageLabelPanel();
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weighty = 1.0;
        JPanel jPanel3 = this.setupDataInChartArePanel();
        Insets insets = new Insets(DialogUtil.getComponentGroupGap(), 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 1, 1, 1, n, insets);
        this.mRadioButtonGroup = DialogUtil.createButtonGroup(jPanel3);
    }

    private JPanel setupImageLabelPanel() {
        JComponent[] jComponentArray = new JComponent[]{this.mSimpleBarImageLabel, this.mClusteredBarImageLabel, this.mStackedImageLabel, this.mSimpleBarLabel, this.mClusteredLabel, this.mStackedLabel, new JLabel()};
        return PanelFactory.getPanelForImageLabels(jComponentArray, "", 3);
    }

    private JPanel setupDataInChartArePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(this.getResString("IDS_HILO_DATA_IN_CHART_ARE_PANEL_TITLE")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        Insets insets = new Insets(DialogUtil.getGroupBoxInnerMargin(), 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mSummariesForGroupsOfCasesRadio, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mSummariesOfSeparateVarsRadio, gridBagConstraints, 0, 1, 1, 1, n, null);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        insets.set(0, 0, DialogUtil.getGroupBoxInnerMargin(), 0);
        DialogUtil.addUsingGBL(jPanel, this.mValuesOfIndividualCasesRadio, gridBagConstraints, 0, 2, 1, 1, n, insets);
        return jPanel;
    }

    private void setTabPolicy() {
        Vector<Object> vector = new Vector<Object>();
        if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
            vector.add(this.mDefineButton);
            vector.add(this.mSimpleBarImageLabel);
            vector.add(this.mRadioButtonGroup);
            vector.add(this.mHelpButton);
            vector.add(this.mCancelButton);
        } else {
            vector.add(this.mDefineButton);
            vector.add(this.mCancelButton);
            vector.add(this.mHelpButton);
            vector.add(this.mSimpleBarImageLabel);
            vector.add(this.mRadioButtonGroup);
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private int getSelectedImageIndex() {
        int n = -1;
        if (this.mGraphsBarImageLabelGroup.isSelected(this.mSimpleBarImageLabel)) {
            n = 0;
        } else if (this.mGraphsBarImageLabelGroup.isSelected(this.mClusteredBarImageLabel)) {
            n = 1;
        } else if (this.mGraphsBarImageLabelGroup.isSelected(this.mStackedImageLabel)) {
            n = 2;
        }
        return n;
    }

    private void setImageSelected(int n) {
        switch (n) {
            case 0: {
                this.mSimpleBarImageLabel.setDefaultSelectedImage(true);
                break;
            }
            case 1: {
                this.mClusteredBarImageLabel.setDefaultSelectedImage(true);
                break;
            }
            case 2: {
                this.mStackedImageLabel.setDefaultSelectedImage(true);
            }
        }
    }
}

