/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.graphs.legacy_dialogs.area;

import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.FileTextField;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.base.graphs.DefineStatisticSubDlg;
import com.spss.java_client.ui.dialogs.base.graphs.GraphRepresentsListModel;
import com.spss.java_client.ui.dialogs.base.graphs.GraphsRemoteFileChooser;
import com.spss.java_client.ui.dialogs.base.graphs.GraphsTargetListMoveHandler;
import com.spss.java_client.ui.dialogs.base.graphs.GraphsUtil;
import com.spss.java_client.ui.dialogs.base.graphs.GraphsVarDecorator;
import com.spss.java_client.ui.dialogs.base.graphs.GraphsVarFormatter;
import com.spss.java_client.ui.dialogs.base.graphs.OptionsSubDialog;
import com.spss.java_client.ui.dialogs.base.graphs.TitlesSubDialog;
import com.spss.java_client.ui.dialogs.base.graphs.legacy_dialogs.LegacyArrowButton;
import com.spss.java_client.ui.dialogs.base.graphs.legacy_dialogs.LegacyVarListCellRenderer;
import com.spss.java_client.ui.dialogs.base.graphs.res.GraphsResBundle;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.uitools.util.CharacterUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class StackedSummariesOfSeparateVarsDlg
extends BaseProcedureDialog
implements ListDataListener,
ItemListener,
ActionListener,
ListSelectionListener {
    private static final String COLUMNS_TARGET_VARIABLE_LIST_IDENTIFIER = "COLUMNS_TARGET_VARIABLE_LIST";
    private static final String ROWS_TARGET_VARIABLE_LIST_IDENTIFIER = "ROWS_TARGET_VARIABLE_LIST";
    private static final String CATEGORY_TARGET_VARIABLE_LIST_IDENTIFIER = "CATEGORY_TARGET_VARIABLE_LIST";
    protected TargetVariableList mAreaRepresentsTargetList;
    protected JButton mStatisticsButton;
    private TargetVariableList mRowsTargetList;
    private TargetVariableList mColumnTargetList;
    private ArrowButton mCategoryArrowButton;
    private JScrollPane mCategoryScrollPane;
    private TargetVariableList mCategoryTargetList;
    private SrcVariableList mSrcList;
    private JButton mFileButton;
    private JCheckBox mChartSpecificationsCheckBox;
    private JCheckBox mNestVariableColumnsCheckBox;
    private JCheckBox mNestVariableRowsCheckBox;
    private FileTextField mFilePath;
    private JScrollPane mAreaRepresentsScrollPane;
    private GraphsVarFormatter mFormatter;
    private ArrowButton mAreaRepresentsArrowButton;
    private ArrowButton mRowsArrowButton;
    private ArrowButton mColumnsArrowButton;
    private RemoteFileChooser mFileChooser;

    public StackedSummariesOfSeparateVarsDlg(JFrame jFrame) throws HeadlessException {
        super(jFrame, false, GraphsResBundle.getDefaultResourceBundleName(), GraphsResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_DEFINE_STACKED_AREA_SUMMARIES_OF_SEPARATE_VARS_TITLE"));
    }

    @Override
    public String getDialogHelpID() {
        return "idh_gamv";
    }

    @Override
    public String getIActionKey() {
        return "graphs_legacy_dialogs_area_stacked_separate_variable";
    }

    public void paint(Graphics graphics) {
        this.mFilePath.setText(this.mFilePath.getText());
        super.paint(graphics);
        super.validate();
    }

    @Override
    public String generateSyntax() {
        String string;
        String string2;
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        stringBuffer.append(SyntaxUtil.getCommand("GRAPH", true));
        stringBuffer.append(SyntaxUtil.getSingleValueSubCommand("LINE(AREA)", this.getSyntaxForAreaRepresentList() + " BY " + this.mCategoryTargetList.getModel().getElementAt(0).getName(), false));
        String string3 = this.getSyntaxForPanelBy();
        if (string3.length() != 0) {
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand("/PANEL"));
            stringBuffer.append(string3);
        }
        if ((string2 = this.getSyntaxForOptionsDialog()).length() != 0) {
            stringBuffer.append(string2);
        } else {
            stringBuffer.append("\n").append(SyntaxUtil.getSubCommand("/MISSING=LISTWISE"));
        }
        String string4 = this.getSyntaxForFile();
        if (string4.length() != 0) {
            stringBuffer.append(string4);
        }
        if ((string = GraphsUtil.generateTitlesSubDialogSyntax(this.getDialogDataModel())).length() != 0) {
            stringBuffer.append(string);
        }
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        return stringBuffer.toString();
    }

    @Override
    public void reset() {
        super.reset();
        this.mFormatter.getVarMap().clear();
        this.mAreaRepresentsTargetList.removeAll();
        this.mCategoryTargetList.removeAll();
        this.mRowsTargetList.removeAll();
        this.mColumnTargetList.removeAll();
        this.mSrcList.loadFromActiveDataset();
        this.mSrcList.requestFocus();
        this.setDefaults();
        this.getDialogDataModel().clear();
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        if (listDataEvent.getSource().equals(this.mRowsTargetList.getModel())) {
            this.mNestVariableRowsCheckBox.setEnabled(true);
        } else if (listDataEvent.getSource().equals(this.mColumnTargetList.getModel())) {
            this.mNestVariableColumnsCheckBox.setEnabled(true);
        }
        this.checkEnableOkPaste();
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        if (listDataEvent.getSource().equals(this.mAreaRepresentsTargetList.getModel())) {
            if (this.mAreaRepresentsTargetList.getModel().getSize() == 0) {
                GraphsVarDecorator.resetComponentsOfStatisticDialog(this.getDialogDataModel());
                this.mStatisticsButton.setEnabled(false);
            }
        } else if (listDataEvent.getSource().equals(this.mRowsTargetList.getModel()) && this.mRowsTargetList.getModel().getSize() == 0) {
            this.mNestVariableRowsCheckBox.setEnabled(false);
        } else if (listDataEvent.getSource().equals(this.mColumnTargetList.getModel()) && this.mColumnTargetList.getModel().getSize() == 0) {
            this.mNestVariableColumnsCheckBox.setEnabled(false);
        }
        this.checkEnableOkPaste();
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object.equals(this.mChartSpecificationsCheckBox)) {
            boolean bl = this.mChartSpecificationsCheckBox.isSelected();
            this.mFileButton.setEnabled(bl);
            this.mFilePath.setEnabled(bl);
        }
        this.checkEnableOkPaste();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object.equals(this.mFileButton)) {
            int n = this.mFileChooser.showOpenDialog((Component)((Object)this));
            if (n == 0) {
                this.mFilePath.setText(this.mFileChooser.getSelectedFilePath());
            }
            this.checkEnableOkPaste();
        } else if (object.equals(this.mStatisticsButton)) {
            String string;
            int[] nArray = this.mAreaRepresentsTargetList.getSelectedIndices();
            int n = nArray.length;
            if (n == 1) {
                string = this.mAreaRepresentsTargetList.getModel().getElementAt(this.mAreaRepresentsTargetList.getSelectedIndex());
                this.getDialogDataModel().putString("IDS_CURRENT_STATISTIC_FUNCTION", (String)this.mFormatter.getVarMap().get(string.getId().asInt()));
            } else {
                string = "";
                boolean bl = true;
                for (int i = 0; i < n; ++i) {
                    ISpssVariable iSpssVariable;
                    if (i == 0) {
                        iSpssVariable = this.mAreaRepresentsTargetList.getModel().getElementAt(0);
                        string = (String)this.mFormatter.getVarMap().get(iSpssVariable.getId().asInt());
                        continue;
                    }
                    iSpssVariable = this.mAreaRepresentsTargetList.getModel().getElementAt(i);
                    String string2 = (String)this.mFormatter.getVarMap().get(iSpssVariable.getId().asInt());
                    if (!string2.equals(string)) {
                        bl = true;
                        break;
                    }
                    bl = false;
                }
                if (bl) {
                    this.getDialogDataModel().putString("IDS_CURRENT_STATISTIC_FUNCTION", "SUM");
                } else {
                    this.getDialogDataModel().putString("IDS_CURRENT_STATISTIC_FUNCTION", string);
                }
            }
            if (this.runSubDialog(new DefineStatisticSubDlg(this, this.getResString("IDS_GRAPHS_STATISTIC_TITLE"), true))) {
                string = GraphsVarDecorator.getDecoration(this.getDialogDataModel(), GraphsVarDecorator.getVariableTargetMap());
                for (int n2 : nArray) {
                    ((GraphRepresentsListModel)this.mAreaRepresentsTargetList.getModel()).setElementPropertyAt(n2, string);
                }
            }
        }
    }

    @Override
    public void loadDialogState() {
        super.loadDialogState();
        if (this.mChartSpecificationsCheckBox.isSelected()) {
            this.mFileButton.setEnabled(true);
        }
        this.mFormatter.setLegacyVarMap(this.getDialogDataModel().getMap(this.mAreaRepresentsTargetList.getIdentifier()));
        this.checkEnableOkPaste();
        this.mSrcList.setSelectedIndex(0);
    }

    @Override
    public void saveDialogState() {
        super.saveDialogState();
        this.getDialogDataModel().putMap(this.mAreaRepresentsTargetList.getIdentifier(), this.mFormatter.getVarMapForSerialization());
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getSource() == this.mSrcList) {
            this.mStatisticsButton.setEnabled(false);
        } else if (listSelectionEvent.getSource() == this.mAreaRepresentsTargetList && this.mAreaRepresentsTargetList.getSelectedIndex() != -1) {
            this.mStatisticsButton.setEnabled(true);
        } else if (listSelectionEvent.getSource() == this.mAreaRepresentsTargetList && this.mAreaRepresentsTargetList.getSelectedIndex() == -1) {
            this.mStatisticsButton.setEnabled(false);
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.mFileChooser != null) {
            this.mFileChooser.onDispose();
        }
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefaults();
        JPanel jPanel = this.getViewPanel();
        JPanel jPanel2 = this.setupViewPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        int n = 23;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, null);
        this.setTabTraversalOrder();
        this.pack();
    }

    @Override
    protected JPanel setupOptionsButtonPanel() {
        JPanel jPanel = super.setupOptionsButtonPanel();
        JButton jButton = new JButton(new ToggleButtonAction("IDS_REPORT_COMMON_TITLES_3DOT"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StackedSummariesOfSeparateVarsDlg.this.runSubDialog(new TitlesSubDialog(StackedSummariesOfSeparateVarsDlg.this));
            }
        });
        this.addOptionsPanelButton(jPanel, jButton);
        JButton jButton2 = new JButton(new ToggleButtonAction("IDS_COMMON_OPTIONS_3DOT"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StackedSummariesOfSeparateVarsDlg.this.runOptionsDialog();
            }
        });
        this.addOptionsPanelButton(jPanel, jButton2);
        return jPanel;
    }

    void runOptionsDialog() {
        this.runSubDialog(new OptionsSubDialog(this, 1027));
    }

    private void initVars() {
        this.mSrcList = new SrcVariableList();
        this.mSrcList.loadFromActiveDataset();
        this.mSrcList.addListSelectionListener(this);
        this.mSrcList.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                StackedSummariesOfSeparateVarsDlg.this.mStatisticsButton.setEnabled(false);
            }
        });
        this.mStatisticsButton = new JButton();
        this.mStatisticsButton.setAction(new ToggleButtonAction(this, "IDS_GRAPH_AREA_CHANGE_STATISTIC_BUTTON"));
        this.mStatisticsButton.addActionListener(this);
        this.mAreaRepresentsTargetList = new TargetVariableList();
        this.mAreaRepresentsTargetList.setDragType(VariableList.VarMoveType.eKeepOriginal);
        this.mAreaRepresentsTargetList.setAllowDuplicates(true);
        this.mAreaRepresentsTargetList.setMinimumSize(new Dimension(50, 100));
        SpssVarFilter spssVarFilter = new SpssVarFilter(8, true, false);
        this.mAreaRepresentsTargetList.addVarFilter(spssVarFilter);
        this.mFormatter = new GraphsVarFormatter(this.mAreaRepresentsTargetList);
        this.mAreaRepresentsTargetList.setModel(new GraphRepresentsListModel(this.mFormatter, "SUM"));
        this.mAreaRepresentsTargetList.setCellRenderer(new LegacyVarListCellRenderer(this.mFormatter));
        this.mAreaRepresentsScrollPane = new JScrollPane(this.mAreaRepresentsTargetList);
        this.mAreaRepresentsScrollPane.setPreferredSize(this.mAreaRepresentsTargetList.getMinimumSize());
        this.mAreaRepresentsTargetList.addListSelectionListener(this);
        this.mAreaRepresentsTargetList.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                StackedSummariesOfSeparateVarsDlg.this.mStatisticsButton.setEnabled(StackedSummariesOfSeparateVarsDlg.this.mAreaRepresentsTargetList.getModel().getSize() > 0 && StackedSummariesOfSeparateVarsDlg.this.mAreaRepresentsTargetList.getSelectedIndex() != -1);
            }
        });
        this.mAreaRepresentsTargetList.getModel().addListDataListener(this);
        this.mAreaRepresentsArrowButton = new LegacyArrowButton();
        this.mAreaRepresentsArrowButton.registerVariableList(this.mSrcList, SpssArrowButton.ButtonOrientation.right);
        this.mAreaRepresentsArrowButton.registerVariableList(this.mAreaRepresentsTargetList, SpssArrowButton.ButtonOrientation.left);
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, "IDS_NEST_VARIABLES_ROWS");
        this.mNestVariableRowsCheckBox = new JCheckBox();
        this.mNestVariableRowsCheckBox.setAction(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_GRAPHS_AREA_NEST_VARIABLES_COLUMNS_CHECK");
        this.mNestVariableColumnsCheckBox = new JCheckBox();
        this.mNestVariableColumnsCheckBox.setAction(toggleButtonAction);
        this.mFilePath = new FileTextField();
        this.mFilePath.setAction(new TextFieldAction(this, "IDS_GRAPHS_AREA_SIMPLE_GROUPS_OF_CASES_FILEPATH"));
        this.mFilePath.setBorder(BorderFactory.createEmptyBorder());
        this.mChartSpecificationsCheckBox = DialogUtil.createCheckBox(this, "IDS_GRAPHS_AREA_USE_CHART_SPECIFICATIONS_FROM_CHECK", null);
        this.mChartSpecificationsCheckBox.addItemListener(this);
        this.mCategoryTargetList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mCategoryTargetList.getModel().addListDataListener(this);
        this.mCategoryTargetList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mCategoryTargetList.setIdentifier(CATEGORY_TARGET_VARIABLE_LIST_IDENTIFIER);
        this.mCategoryScrollPane = new JScrollPane(this.mCategoryTargetList);
        this.mCategoryScrollPane.setHorizontalScrollBarPolicy(31);
        this.mCategoryScrollPane.setVerticalScrollBarPolicy(21);
        this.mCategoryScrollPane.setPreferredSize(this.mCategoryTargetList.getMinimumSize());
        this.mCategoryArrowButton = new ArrowButton();
        this.mCategoryArrowButton.registerVariableList(this.mSrcList, SpssArrowButton.ButtonOrientation.right);
        this.mCategoryArrowButton.registerVariableList(this.mCategoryTargetList, SpssArrowButton.ButtonOrientation.left);
        this.mRowsTargetList = new TargetVariableList(TargetVariableList.TargetListType.normal);
        this.mRowsTargetList.getModel().addListDataListener(this);
        this.mRowsTargetList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mRowsTargetList.setIdentifier(ROWS_TARGET_VARIABLE_LIST_IDENTIFIER);
        this.mColumnTargetList = new TargetVariableList(TargetVariableList.TargetListType.normal);
        this.mColumnTargetList.getModel().addListDataListener(this);
        this.mColumnTargetList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mColumnTargetList.setIdentifier(COLUMNS_TARGET_VARIABLE_LIST_IDENTIFIER);
        this.mRowsArrowButton = new ArrowButton();
        this.mColumnsArrowButton = new ArrowButton();
        this.mRowsArrowButton.registerVariableList(this.mSrcList, SpssArrowButton.ButtonOrientation.right);
        this.mRowsArrowButton.registerVariableList(this.mRowsTargetList, SpssArrowButton.ButtonOrientation.left);
        this.mColumnsArrowButton.registerVariableList(this.mSrcList, SpssArrowButton.ButtonOrientation.right);
        this.mColumnsArrowButton.registerVariableList(this.mColumnTargetList, SpssArrowButton.ButtonOrientation.left);
        this.mFileButton = DialogUtil.createButton(this, "IDS_GRAPHS_AREA_SIMPLE_GROUPS_OF_CASES_FILEPATH", null);
        this.mFileButton.addActionListener(this);
        this.mFileChooser = new GraphsRemoteFileChooser(this);
        this.setupMoveHandler();
    }

    private void setDefaults() {
        this.mSrcList.setSelectedIndex(0);
        this.mNestVariableColumnsCheckBox.setEnabled(false);
        this.mNestVariableColumnsCheckBox.setSelected(false);
        this.mNestVariableRowsCheckBox.setEnabled(false);
        this.mNestVariableRowsCheckBox.setSelected(false);
        this.mStatisticsButton.setEnabled(false);
        this.mFilePath.setOpaque(false);
        this.mFilePath.setEditable(false);
        this.mChartSpecificationsCheckBox.setSelected(false);
        this.mFileButton.setEnabled(false);
        this.mFilePath.setText("");
    }

    private JPanel setupViewPanel() {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JScrollPane jScrollPane = new JScrollPane(this.mSrcList);
        jScrollPane.setPreferredSize(this.mSrcList.getMinimumSize());
        JPanel jPanel2 = this.setupSummariesPanel(jScrollPane, this.setupPanelBy());
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, 23, null);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(n, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.setupTemplatePanel(), gridBagConstraints, 0, 1, 1, 1, 23, insets);
        return jPanel;
    }

    private JPanel setupPanelBy() {
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_GRAPH_AREA_ROWS_COLON_LABEL");
        jLabel.setLabelFor(this.mRowsTargetList);
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_GRAPH_AREA_COLUMNS_COLON_LABEL");
        jLabel2.setLabelFor(this.mColumnTargetList);
        JComponent[] jComponentArray = new JComponent[]{jLabel, this.mRowsArrowButton, this.mRowsTargetList, this.mNestVariableRowsCheckBox, jLabel2, this.mColumnsArrowButton, this.mColumnTargetList, this.mNestVariableColumnsCheckBox};
        return PanelFactory.getGraphsPanelByPanel(jComponentArray, this.getResString("IDS_GRAPHS_AREA_PANEL_BY_TITLE"));
    }

    private JPanel setupTemplatePanel() {
        JComponent[] jComponentArray = new JComponent[8];
        jComponentArray[0] = this.mChartSpecificationsCheckBox;
        jComponentArray[1] = this.mFileButton;
        jComponentArray[2] = this.mFilePath;
        return PanelFactory.getGraphsChartTemplatePanel(jComponentArray, this.getResString("IDS_GRAPH_AREA_TEMPLATE_TITLE"));
    }

    private JPanel setupSummariesPanel(JScrollPane jScrollPane, JPanel jPanel) {
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_SOURCE_LIST_LABEL");
        jLabel.setLabelFor(this.mSrcList);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel2, jLabel, gridBagConstraints, 0, 0, 1, 1, 23, null);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n = DialogUtil.getGroupBoxInnerMargin();
        int n2 = DialogUtil.getComponentGroupGap();
        DialogUtil.addUsingGBL(jPanel2, jScrollPane, gridBagConstraints, 0, 1, 1, 5, 23, null);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        Insets insets = DialogUtil.getStandardControlInsets();
        gridBagConstraints.fill = 0;
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_GRAPHS_AREA_AREAS_REPRESENTS_COLON_LABEL");
        jLabel2.setLabelFor(this.mAreaRepresentsTargetList);
        Insets insets2 = new Insets(n, 3, 0, n);
        DialogUtil.addUsingGBL(jPanel2, jLabel2, gridBagConstraints, 2, 0, 1, 1, 23, insets2);
        Insets insets3 = DialogUtil.getArrowButtonInsets();
        insets2.set(0, insets3.left + n + 3, 0, insets3.right);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel2, this.mAreaRepresentsArrowButton, gridBagConstraints, 1, 1, 1, 1, 10, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        insets2.set(0, 3, 0, n + 4);
        DialogUtil.addUsingGBL(jPanel2, this.mAreaRepresentsScrollPane, gridBagConstraints, 2, 1, 1, 1, 23, insets2);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets2.set(n * 2, insets.left, n, n2);
        DialogUtil.addUsingGBL(jPanel2, this.mStatisticsButton, gridBagConstraints, 2, 2, 1, 1, 10, insets2);
        JLabel jLabel3 = DialogUtil.createLabel(this, "IDS_GRAPHS_AREA_CATEGORY_AXIS_LABEL");
        jLabel3.setLabelFor(this.mCategoryTargetList);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets2.set(n, 3, 0, n);
        DialogUtil.addUsingGBL(jPanel2, jLabel3, gridBagConstraints, 2, 3, 1, 1, 23, insets2);
        gridBagConstraints.weightx = 0.0;
        insets2.set(0, insets3.left + n + 3, 0, insets3.right);
        DialogUtil.addUsingGBL(jPanel2, this.mCategoryArrowButton, gridBagConstraints, 1, 3, 1, 2, 20, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        insets2.set(0, 3, 0, n + 4);
        DialogUtil.addUsingGBL(jPanel2, this.mCategoryScrollPane, gridBagConstraints, 2, 4, 1, 1, 20, insets2);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        insets2.set(n2, n2, 0, 0);
        DialogUtil.addUsingGBL(jPanel2, jPanel, gridBagConstraints, 1, 5, 2, 1, 23, insets2);
        return jPanel2;
    }

    private String getSyntaxForPanelBy() {
        boolean bl;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = this.mColumnTargetList.getModel().getSize() > 0;
        boolean bl3 = bl = this.mRowsTargetList.getModel().getSize() > 0;
        if (bl2 || bl) {
            if (bl2) {
                stringBuffer.append(" COLVAR=").append(this.mColumnTargetList.getVariablesStringList());
                stringBuffer.append(" COLOP=");
                if (this.mNestVariableColumnsCheckBox.isSelected()) {
                    stringBuffer.append("NEST");
                } else {
                    stringBuffer.append("CROSS");
                }
            }
            if (bl) {
                stringBuffer.append(" ROWVAR=").append(this.mRowsTargetList.getVariablesStringList());
                stringBuffer.append(" ROWOP=");
                if (this.mNestVariableRowsCheckBox.isSelected()) {
                    stringBuffer.append("NEST");
                } else {
                    stringBuffer.append("CROSS");
                }
            }
        }
        return stringBuffer.toString();
    }

    private String getSyntaxForFile() {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.mChartSpecificationsCheckBox.isSelected() && (string = this.mFilePath.getText()) != null && string.length() > 0) {
            stringBuffer.append("\n").append(SyntaxUtil.getSubCommand("/TEMPLATE=")).append(CharacterUtil.smartQuote((String)string));
        }
        return stringBuffer.toString();
    }

    private String getSyntaxForAreaRepresentList() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.mAreaRepresentsTargetList.getModel().getSize();
        for (int i = 0; i < n; ++i) {
            ISpssVariable iSpssVariable = this.mAreaRepresentsTargetList.getModel().getElementAt(i);
            String string = this.getDecorationType(i);
            stringBuffer.append(" ").append(string).append("(").append(iSpssVariable.getName()).append(")");
        }
        return stringBuffer.toString();
    }

    private String getSyntaxForOptionsDialog() {
        Boolean bl;
        StringBuffer stringBuffer = new StringBuffer();
        Boolean bl2 = this.getDialogDataModel().getBoolean("IDS_OPT_SUBDLG_EX_CASES_LISTWISE_RADIO");
        if (bl2 != null && bl2.booleanValue()) {
            stringBuffer.append("\n").append(SyntaxUtil.getSubCommand("/MISSING=LISTWISE"));
            bl = this.getDialogDataModel().getBoolean("IDS_OPT_SUBDLG_DISPLAY_GROUPS_CHECK");
            if (bl != null && bl.booleanValue()) {
                stringBuffer.append(" REPORT");
            }
        }
        if ((bl2 = this.getDialogDataModel().getBoolean("IDS_OPT_SUBDLG_EX_CASES_VAR_BY_VAR_RADIO")) != null && bl2.booleanValue()) {
            stringBuffer.append("\n").append(SyntaxUtil.getSubCommand("/MISSING=VARIABLEWISE"));
            bl = this.getDialogDataModel().getBoolean("IDS_OPT_SUBDLG_DISPLAY_GROUPS_CHECK");
            if (bl != null && bl.booleanValue()) {
                stringBuffer.append(" REPORT");
            }
        }
        return stringBuffer.toString();
    }

    private void checkEnableOkPaste() {
        boolean bl = this.mCategoryTargetList.getModel().getSize() > 0;
        boolean bl2 = this.mAreaRepresentsTargetList.getModel().getSize() > 1;
        boolean bl3 = true;
        if (this.mChartSpecificationsCheckBox.isSelected()) {
            bl3 = this.mFilePath.getText() != null && this.mFilePath.getText().length() > 0;
        }
        this.enableOkPaste(bl && bl3 && bl2);
    }

    private String getDecorationType(int n) {
        ISpssVariable iSpssVariable = this.mAreaRepresentsTargetList.getModel().getElementAt(n);
        return this.mFormatter.getVarMap().get(iSpssVariable.getId().asInt()).toString();
    }

    private void setupMoveHandler() {
        GraphsTargetListMoveHandler graphsTargetListMoveHandler = new GraphsTargetListMoveHandler(this, this.mSrcList, this.mAreaRepresentsTargetList.getModel());
        this.mRowsArrowButton.setVarMoveHandler(graphsTargetListMoveHandler);
        this.mColumnsArrowButton.setVarMoveHandler(graphsTargetListMoveHandler);
        this.mCategoryArrowButton.setVarMoveHandler(graphsTargetListMoveHandler);
        this.mVarMoveHandler = graphsTargetListMoveHandler;
    }

    private void setTabTraversalOrder() {
        Component[] componentArray;
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcList);
        vector.add(this.mAreaRepresentsArrowButton);
        vector.add(this.mStatisticsButton);
        vector.add(this.mCategoryArrowButton);
        vector.add(this.mRowsArrowButton);
        vector.add(this.mColumnsArrowButton);
        vector.add(this.mAreaRepresentsTargetList);
        vector.add(this.mStatisticsButton);
        vector.add(this.mCategoryTargetList);
        vector.add(this.mRowsTargetList);
        vector.add(this.mNestVariableRowsCheckBox);
        vector.add(this.mColumnTargetList);
        vector.add(this.mNestVariableColumnsCheckBox);
        vector.add(this.mChartSpecificationsCheckBox);
        vector.add(this.mFileButton);
        for (Component component : componentArray = this.mOptionButtonPanel.getComponents()) {
            if (!(component instanceof JButton)) continue;
            vector.add(component);
        }
        componentArray = this.mCmdButtonPanel.getComponents();
        vector.addAll(Arrays.asList(componentArray));
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }
}

