/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.graphs.legacy_dialogs;

import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.FileTextField;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.base.graphs.GraphsRemoteFileChooser;
import com.spss.java_client.ui.dialogs.base.graphs.GraphsUtil;
import com.spss.java_client.ui.dialogs.base.graphs.TitlesSubDialog;
import com.spss.java_client.ui.dialogs.base.graphs.res.GraphsResBundle;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.ControlAction;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class HistogramDlg
extends BaseProcedureDialog
implements ListDataListener,
DocumentListener,
ItemListener {
    private JButton mTitlesButton;
    private ArrowButton mVariableListArrow;
    private TargetVariableList mVariableList;
    private SrcVariableList mSrcVarList;
    private ArrowButton mRowsListArrow;
    private ArrowButton mColumnsListArrow;
    private TargetVariableList mRowsList;
    private TargetVariableList mColumnsList;
    private JCheckBox mRowsCheckbox;
    private JCheckBox mColumnsCheckbox;
    private JCheckBox mDisplayCheckbox;
    private JCheckBox mUseChartCheckbox;
    private JButton mFileButton;
    private FileTextField mFileTxt;
    private String mFileTxtpath;

    public HistogramDlg(JFrame jFrame) {
        super(jFrame, false, GraphsResBundle.getDefaultResourceBundleName(), GraphsResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_HISTOGRAM_TITLE"));
    }

    @Override
    public void reset() {
        super.reset();
        this.mVariableList.removeAll();
        this.mRowsList.removeAll();
        this.mColumnsList.removeAll();
        this.mUseChartCheckbox.setSelected(false);
        this.mDisplayCheckbox.setSelected(false);
        this.setDefaults();
    }

    @Override
    public String generateSyntax() {
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        stringBuffer.append("GRAPH");
        stringBuffer.append("\n  /HISTOGRAM");
        if (this.mDisplayCheckbox.isSelected()) {
            stringBuffer.append("(NORMAL)");
        }
        stringBuffer.append("=").append(this.mVariableList.getModel().getElementAt(0).getName());
        if (this.mColumnsList.getModel().getSize() > 0 || this.mRowsList.getModel().getSize() > 0) {
            stringBuffer.append("\n  /PANEL");
        }
        if (this.mColumnsList.getModel().getSize() > 0) {
            stringBuffer.append(" COLVAR=");
            stringBuffer.append(this.mColumnsList.getVariablesStringList());
            stringBuffer.append(" COLOP=");
            if (this.mColumnsCheckbox.isSelected()) {
                stringBuffer.append("NEST");
            } else {
                stringBuffer.append("CROSS");
            }
        }
        if (this.mRowsList.getModel().getSize() > 0) {
            stringBuffer.append(" ROWVAR=");
            stringBuffer.append(this.mRowsList.getVariablesStringList());
            stringBuffer.append(" ROWOP=");
            if (this.mRowsCheckbox.isSelected()) {
                stringBuffer.append("NEST");
            } else {
                stringBuffer.append("CROSS");
            }
        }
        if (this.mUseChartCheckbox.isSelected()) {
            stringBuffer.append("\n  /TEMPLATE='").append(this.mFileTxt.getText()).append("'");
        }
        stringBuffer.append(GraphsUtil.generateTitlesSubDialogSyntax(this.getDialogDataModel()));
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        return stringBuffer.toString();
    }

    @Override
    public String getDialogHelpID() {
        return "idh_ghis";
    }

    @Override
    public String getIActionKey() {
        return "graphs_legacy_dialogs_histogram";
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.enableRespectiveComponents(listDataEvent);
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.enableRespectiveComponents(listDataEvent);
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.enableOkPaste(this.isFilePathEmpty() && this.mVariableList.getModel().getSize() == 1);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.enableOkPaste(this.isFilePathEmpty() && this.mVariableList.getModel().getSize() == 1);
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.enableOkPaste(this.isFilePathEmpty() && this.mVariableList.getModel().getSize() == 1);
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.mFileTxtpath != null && !this.mFileTxtpath.equals("")) {
            this.mFileTxt.setText(this.mFileTxtpath);
        }
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefaults();
        JPanel jPanel = this.getViewPanel();
        this.setupViewPanel(jPanel);
        this.setFocusTraversalPolicy();
        this.pack();
    }

    @Override
    protected void loadDialogState() {
        super.loadDialogState();
        this.mSrcVarList.requestFocus();
        this.mSrcVarList.setSelectedIndex(0);
    }

    @Override
    protected JPanel setupOptionsButtonPanel() {
        JPanel jPanel = super.setupOptionsButtonPanel();
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, "IDS_HISTOGRAM_OPTION_BUTTON"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HistogramDlg.this.runTitlesSubDlg();
            }
        };
        this.mTitlesButton = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, this.mTitlesButton);
        return jPanel;
    }

    private void setDefaults() {
        this.mSrcVarList.loadFromActiveDataset();
        this.enableOkPaste(false);
        this.mFileButton.setEnabled(false);
        this.mSrcVarList.requestFocus();
        this.mSrcVarList.setSelectedIndex(0);
        this.mRowsCheckbox.setSelected(false);
        this.mRowsCheckbox.setEnabled(false);
        this.mColumnsCheckbox.setSelected(false);
        this.mColumnsCheckbox.setEnabled(false);
        this.mFileTxt.setText("");
    }

    private boolean isFilePathEmpty() {
        if (this.mUseChartCheckbox.isSelected()) {
            this.mFileButton.setEnabled(true);
            this.mFileTxt.setEnabled(true);
            return this.mFileTxt.getText().length() > 0;
        }
        this.mFileButton.setEnabled(false);
        this.mFileTxt.setEnabled(false);
        return true;
    }

    private void enableRespectiveComponents(ListDataEvent listDataEvent) {
        if (listDataEvent.getSource() == this.mRowsList.getModel()) {
            if (this.mRowsList.getModel().getSize() >= 1) {
                this.mRowsCheckbox.setEnabled(true);
            } else {
                this.mRowsCheckbox.setEnabled(false);
            }
        } else if (listDataEvent.getSource() == this.mColumnsList.getModel()) {
            if (this.mColumnsList.getModel().getSize() >= 1) {
                this.mColumnsCheckbox.setEnabled(true);
            } else {
                this.mColumnsCheckbox.setEnabled(false);
            }
        } else if (this.mVariableList.getModel().getSize() == 1 && this.isFilePathEmpty()) {
            this.enableOkPaste(true);
        } else {
            this.enableOkPaste(false);
        }
    }

    private void initVars() {
        this.mSrcVarList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        this.mSrcVarList.setIdentifier(this.getResString("IDS_HISTOGRAM_SOURCE_LIST"));
        this.mVariableList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mVariableList.setIdentifier(this.getResString("IDS_HISTOGRAM_VARIABLE_TARGET_LIST"));
        this.mVariableList.getModel().addListDataListener(this);
        this.mVariableList.addVarFilter(new SpssVarFilter(8, false));
        this.mVariableListArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mVariableListArrow.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mVariableListArrow.registerVariableList(this.mVariableList, SpssArrowButton.ButtonOrientation.left);
        this.mRowsList = new TargetVariableList(TargetVariableList.TargetListType.normal, VariableList.VarMoveType.eMoveOriginal);
        this.mRowsList.getModel().addListDataListener(this);
        this.mRowsList.setIdentifier(this.getResString("IDS_HISTOGRAM_ROW_TARGET_LIST"));
        this.mRowsListArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mRowsListArrow.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mRowsListArrow.registerVariableList(this.mRowsList, SpssArrowButton.ButtonOrientation.left);
        this.mColumnsList = new TargetVariableList(TargetVariableList.TargetListType.normal, VariableList.VarMoveType.eMoveOriginal);
        this.mColumnsList.getModel().addListDataListener(this);
        this.mColumnsList.setIdentifier(this.getResString("IDS_HISTOGRAM_COLUMN_TARGET_LIST"));
        this.mColumnsListArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mColumnsListArrow.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mColumnsListArrow.registerVariableList(this.mColumnsList, SpssArrowButton.ButtonOrientation.left);
        ControlAction controlAction = new ToggleButtonAction(this, "IDS_HISTOGRAM_ROW_CHECK_BOX");
        this.mRowsCheckbox = new JCheckBox(controlAction);
        controlAction = new ToggleButtonAction(this, "IDS_HISTOGRAM_COLUMN_CHECK_BOX");
        this.mColumnsCheckbox = new JCheckBox(controlAction);
        controlAction = new ToggleButtonAction(this, "IDS_HISTOGRAM_DISPLAY_CHECK_BOX");
        this.mDisplayCheckbox = new JCheckBox(controlAction);
        controlAction = new ToggleButtonAction(this, "IDS_HISTOGRAM_TEMPLATE_CHART_CHECK_BOX");
        this.mUseChartCheckbox = new JCheckBox(controlAction);
        this.mUseChartCheckbox.addItemListener(this);
        this.mFileTxt = new FileTextField();
        this.mFileTxt.setBorder(BorderFactory.createEmptyBorder());
        controlAction = new TextFieldAction(this, "IDS_HISTOGRAM_FILE_TXT");
        this.mFileTxt.setAction(controlAction);
        this.mFileTxt.setEditable(false);
        this.mFileTxt.setOpaque(false);
        this.mFileTxt.setColumns(30);
        controlAction = new ToggleButtonAction(this, "IDS_HISTOGRAM_FILE"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GraphsRemoteFileChooser graphsRemoteFileChooser = new GraphsRemoteFileChooser(HistogramDlg.this);
                int n = graphsRemoteFileChooser.showOpenDialog((Component)((Object)HistogramDlg.this));
                if (n == 0) {
                    HistogramDlg.this.mFileTxtpath = graphsRemoteFileChooser.getSelectedFilePath();
                    HistogramDlg.this.mFileTxt.setText(HistogramDlg.this.mFileTxtpath);
                }
            }
        };
        this.mFileTxt.getDocument().addDocumentListener(this);
        this.mFileButton = new JButton(controlAction);
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcVarList);
        vector.add(this.mVariableListArrow);
        vector.add(this.mRowsListArrow);
        vector.add(this.mColumnsListArrow);
        vector.add(this.mVariableList);
        vector.add(this.mDisplayCheckbox);
        vector.add(this.mRowsList);
        vector.add(this.mRowsCheckbox);
        vector.add(this.mColumnsList);
        vector.add(this.mColumnsCheckbox);
        vector.add(this.mUseChartCheckbox);
        vector.add(this.mFileButton);
        vector.add(this.mTitlesButton);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        this.setFocusTraversalPolicy(new DialogFocusTraversalPolicy(vector, false));
    }

    private void setupViewPanel(JPanel jPanel) {
        JScrollPane jScrollPane = new JScrollPane(this.mVariableList);
        jScrollPane.setPreferredSize(this.mVariableList.getMinimumSize());
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setVerticalScrollBarPolicy(21);
        JScrollPane jScrollPane2 = new JScrollPane(this.mSrcVarList);
        jScrollPane2.setPreferredSize(this.mSrcVarList.getMinimumSize());
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_VARIABLE");
        jLabel.setLabelFor(this.mVariableList);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getGroupBoxInnerMargin();
        gridBagConstraints.weightx = 1.0;
        int n2 = 23;
        gridBagConstraints.fill = 2;
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_HISTOGRAM_SOURCE_LABEL");
        jLabel2.setLabelFor(this.mSrcVarList);
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 0, 0, 1, 1, n2, null);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        Insets insets = DialogUtil.getArrowButtonInsets();
        DialogUtil.addUsingGBL(jPanel, jScrollPane2, gridBagConstraints, 0, 1, 1, 3, n2, null);
        n2 = 20;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets2 = new Insets(0, insets.left + n + 3, 0, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mVariableListArrow, gridBagConstraints, 1, 0, 1, 2, n2, insets2);
        gridBagConstraints.weightx = 1.0;
        n2 = 23;
        gridBagConstraints.fill = 2;
        insets2.set(0, 3, 0, n);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 2, 0, 1, 1, n2, insets2);
        insets2.set(0, 3, 0, n + 4);
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 2, 1, 1, 1, n2, insets2);
        gridBagConstraints.fill = 0;
        insets2.set(n, insets.left, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mDisplayCheckbox, gridBagConstraints, 1, 2, 2, 1, n2, insets2);
        JPanel jPanel2 = this.setupPanelByPanel();
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        insets2.set(DialogUtil.getComponentGroupGap(), DialogUtil.getComponentGroupGap(), 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 1, 3, 2, 1, n2, insets2);
        JPanel jPanel3 = this.setupTemplatePanel();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 0.0;
        insets2.set(DialogUtil.getComponentGroupGap(), 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 4, 3, 1, n2, insets2);
    }

    private JPanel setupTemplatePanel() {
        JComponent[] jComponentArray = new JComponent[]{this.mUseChartCheckbox, this.mFileButton, this.mFileTxt};
        return PanelFactory.getGraphsChartTemplatePanel(jComponentArray, this.getResString("IDS_HISTOGRAM_TEMPLATE"));
    }

    private JPanel setupPanelByPanel() {
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_HISTOGRAM_ROW_LABEL");
        jLabel.setLabelFor(this.mRowsList);
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_HISTOGRAM_COLUMN_LABEL");
        jLabel2.setLabelFor(this.mColumnsList);
        JComponent[] jComponentArray = new JComponent[]{jLabel, this.mRowsListArrow, this.mRowsList, this.mRowsCheckbox, jLabel2, this.mColumnsListArrow, this.mColumnsList, this.mColumnsCheckbox};
        return PanelFactory.getGraphsPanelByPanel(jComponentArray, this.getResString("IDS_HISTOGRAM_PANEL_BY_BORDER"));
    }

    private void runTitlesSubDlg() {
        this.runSubDialog(new TitlesSubDialog(this, this.getResString("IDS_HISTOGRAM_SUB_DIALOG_TITLES"), true));
    }
}

