/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.graphs.chart_builder.undo;

import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.CanvasChangeEvent;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ChartBuilderDlg;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ChartCanvas;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.DropZone;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ZoneChangeType;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ZoneType;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.properties.ChartProps;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.properties.ElementStat;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.properties.IPropEnum;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.properties.Props;
import com.spss.vizimager.VizDataReader;
import com.spss.vizimager.VizDataWriter;
import java.awt.Cursor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.nio.ByteBuffer;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;

public class RemoveZoneEdit
extends AbstractUndoableEdit {
    private ChartBuilderDlg mMainDialog;
    private ByteBuffer mBuffer;

    public RemoveZoneEdit(UndoManager undoManager, ChartBuilderDlg chartBuilderDlg, ZoneType zoneType) {
        this.mMainDialog = chartBuilderDlg;
        ChartCanvas chartCanvas = this.mMainDialog.getCanvas();
        boolean bl = chartCanvas.getImager().hasSSVs();
        boolean bl2 = bl && zoneType == chartCanvas.getZoneMgr().getIndexVarZoneType();
        boolean bl3 = chartCanvas.getImager().isOverlayScatter();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        boolean bl4 = chartCanvas.serializeOut(dataOutputStream);
        if (bl4) {
            ChartProps chartProps;
            Props.ElProps elProps;
            this.mBuffer = VizDataWriter.compressStream((ByteBuffer)ByteBuffer.wrap(byteArrayOutputStream.toByteArray()));
            this.mMainDialog.setCursor(Cursor.getPredefinedCursor(3));
            chartCanvas.getZoneMgr().removeZone(zoneType);
            chartCanvas.getImager().zoneChange(chartCanvas.getZoneMgr(), zoneType, ZoneChangeType.removeZone);
            if (bl3 && zoneType == ZoneType.zt_group) {
                chartCanvas.removeOverlayScatterVariables();
            }
            if (bl2) {
                chartCanvas.getZoneMgr().removeSSVVariables();
            }
            if ((elProps = (chartProps = chartCanvas.getProperties()).getElementProp(0)) != null) {
                ElementStat elementStat = elProps.getStatistic();
                elementStat.setPctBaseType(IPropEnum.PercentageBaseType.pbt_GrandTotal);
                chartCanvas.setProperties(chartProps);
            }
            DropZone.setRoleStatDisplay(chartCanvas.getZoneMgr().hasVariables());
            chartCanvas.fireChangeEvent(CanvasChangeEvent.ChangeType.elementChange);
            chartCanvas.requestFocusInWindow();
            this.mMainDialog.setCursor(null);
            undoManager.addEdit(this);
        }
    }

    @Override
    public String getPresentationName() {
        return this.mMainDialog.getResString("IDS_DELETE_ZONE");
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.doAction();
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.doAction();
    }

    @Override
    public void die() {
        super.die();
        this.mBuffer = null;
    }

    private void doAction() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        boolean bl = this.mMainDialog.getCanvas().serializeOut(dataOutputStream);
        if (bl) {
            ByteBuffer byteBuffer = VizDataWriter.compressStream((ByteBuffer)ByteBuffer.wrap(byteArrayOutputStream.toByteArray()));
            ByteBuffer byteBuffer2 = VizDataReader.decompressStream((ByteBuffer)this.mBuffer);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteBuffer2.array());
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            this.mMainDialog.getCanvas().serializeIn(dataInputStream);
            this.mBuffer = byteBuffer;
            this.mMainDialog.getCanvas().fireChangeEvent(CanvasChangeEvent.ChangeType.coordinateChange);
        }
    }
}

