/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.graphs.chart_builder.undo;

import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.CanvasChangeEvent;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ChartBuilderDlg;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ChartCanvas;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.DropZone;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.IndexVariable;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ZoneChangeType;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ZoneType;
import com.spss.vizimager.VizDataReader;
import com.spss.vizimager.VizDataWriter;
import java.awt.Cursor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.nio.ByteBuffer;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;

public class RemoveVariablesEdit
extends AbstractUndoableEdit {
    private ChartBuilderDlg mMainDialog;
    private ByteBuffer mBuffer;

    public RemoveVariablesEdit(UndoManager undoManager, ChartBuilderDlg chartBuilderDlg, ZoneType zoneType) {
        this.mMainDialog = chartBuilderDlg;
        this.initialAction(undoManager, zoneType, null);
    }

    public RemoveVariablesEdit(UndoManager undoManager, ChartBuilderDlg chartBuilderDlg, ZoneType zoneType, ISpssVariable iSpssVariable) {
        this.mMainDialog = chartBuilderDlg;
        this.initialAction(undoManager, zoneType, iSpssVariable);
    }

    @Override
    public String getPresentationName() {
        return this.mMainDialog.getResString("IDS_DELETE_VAR");
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.doAction();
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.doAction();
    }

    @Override
    public void die() {
        super.die();
        this.mBuffer = null;
    }

    private void initialAction(UndoManager undoManager, ZoneType zoneType, ISpssVariable iSpssVariable) {
        this.mMainDialog.setCursor(Cursor.getPredefinedCursor(3));
        ChartCanvas chartCanvas = this.mMainDialog.getCanvas();
        boolean bl = chartCanvas.getImager().isOverlayScatter();
        boolean bl2 = chartCanvas.getImager().hasSSVs();
        boolean bl3 = bl2 && zoneType == ZoneType.zt_y || zoneType == ZoneType.zt_angle;
        DropZone dropZone = chartCanvas.getZoneMgr().getZone(zoneType);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        boolean bl4 = chartCanvas.serializeOut(dataOutputStream);
        if (bl4) {
            this.mBuffer = VizDataWriter.compressStream((ByteBuffer)ByteBuffer.wrap(byteArrayOutputStream.toByteArray()));
            this.mMainDialog.setCursor(Cursor.getPredefinedCursor(3));
            if (iSpssVariable != null) {
                dropZone.getVariables().remove(iSpssVariable);
            } else {
                dropZone.clear();
            }
            chartCanvas.getImager().zoneChange(chartCanvas.getZoneMgr(), dropZone.getZoneType(), ZoneChangeType.removeVariable);
            ZoneType zoneType2 = chartCanvas.getZoneMgr().getIndexVarZoneType();
            if (iSpssVariable != null && zoneType2 != null) {
                DropZone dropZone2 = chartCanvas.getZoneMgr().getZone(zoneType2);
                DropZone.updateIndexValueLabelMap(chartCanvas, (IndexVariable)dropZone2.getVariables().get(0));
                chartCanvas.getImager().zoneChange(chartCanvas.getZoneMgr(), zoneType2, ZoneChangeType.removeVariable);
            }
            boolean bl5 = chartCanvas.getImager().isOverlayScatter();
            if (bl && !bl5) {
                chartCanvas.adjustOverlayGrouping(false);
                chartCanvas.removeOverlayScatterVariables();
            }
            if (bl || bl5) {
                chartCanvas.getImager().updateOverlayYXPairs();
            }
            if (bl3 && dropZone.getVariables().size() < 2) {
                chartCanvas.getZoneMgr().removeSSVVariables();
            }
            DropZone.setRoleStatDisplay(chartCanvas.getZoneMgr().hasVariables());
            chartCanvas.fireChangeEvent(CanvasChangeEvent.ChangeType.variableChange);
            undoManager.addEdit(this);
        }
        this.mMainDialog.setCursor(null);
    }

    private void doAction() {
        this.mMainDialog.setCursor(Cursor.getPredefinedCursor(3));
        ChartCanvas chartCanvas = this.mMainDialog.getCanvas();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        boolean bl = chartCanvas.serializeOut(dataOutputStream);
        if (bl) {
            ByteBuffer byteBuffer = VizDataWriter.compressStream((ByteBuffer)ByteBuffer.wrap(byteArrayOutputStream.toByteArray()));
            ByteBuffer byteBuffer2 = VizDataReader.decompressStream((ByteBuffer)this.mBuffer);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteBuffer2.array());
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            this.mMainDialog.getCanvas().serializeIn(dataInputStream);
            this.mBuffer = byteBuffer;
        }
        chartCanvas.repaint();
        chartCanvas.fireChangeEvent(CanvasChangeEvent.ChangeType.variableChange);
        this.mMainDialog.setCursor(null);
        chartCanvas.requestFocusInWindow();
    }
}

