/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.graphs.chart_builder.undo;

import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.CanvasChangeEvent;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ChartBuilderDlg;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ChartCanvas;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ITitles;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.properties.IPropEnum;
import java.awt.Cursor;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;

public class ModifyTitleEdit
extends AbstractUndoableEdit {
    private ChartBuilderDlg mMainDialog;
    private ITitles.TitleType mType;
    private boolean mAdding;

    public ModifyTitleEdit(UndoManager undoManager, ChartBuilderDlg chartBuilderDlg, ITitles.TitleType titleType, boolean bl, int n, boolean bl2) {
        this.mMainDialog = chartBuilderDlg;
        this.mType = titleType;
        this.mAdding = bl;
        this.doAction(bl);
        if (bl) {
            this.mMainDialog.getCanvas().getParentDlg().showElementProperties(true);
            if (!bl2) {
                this.mMainDialog.getCanvas().getParentDlg().selectEPItem(IPropEnum.ElementPanelType.ept_TitleFootnote, n);
            }
        }
        undoManager.addEdit(this);
    }

    @Override
    public String getPresentationName() {
        boolean bl;
        boolean bl2 = bl = this.mType == ITitles.TitleType.footnote1 || this.mType == ITitles.TitleType.footnote2;
        if (this.mAdding) {
            if (bl) {
                return this.mMainDialog.getResString("IDS_ADD_FOOTNOTE");
            }
            return this.mMainDialog.getResString("IDS_ADD_TITLE");
        }
        if (bl) {
            return this.mMainDialog.getResString("IDS_REMOVE_FOOTNOTE");
        }
        return this.mMainDialog.getResString("IDS_REMOVE_TITLE");
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.doAction(this.mAdding);
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.doAction(!this.mAdding);
    }

    @Override
    public void die() {
        super.die();
    }

    private void doAction(boolean bl) {
        ChartCanvas chartCanvas = this.mMainDialog.getCanvas();
        this.mMainDialog.setCursor(Cursor.getPredefinedCursor(3));
        chartCanvas.getTitleMgr().setTitle(this.mType, bl);
        chartCanvas.getImager().setTitle(this.mType, bl);
        chartCanvas.getTitleMgr().setTitleText(this.mType, chartCanvas.getTitleText(chartCanvas.titleTypeToTitleFlag(this.mType)));
        if (this.mType == ITitles.TitleType.footnote1 || this.mType == ITitles.TitleType.footnote2) {
            chartCanvas.recalcCanvasSize();
        }
        chartCanvas.repaint();
        chartCanvas.fireChangeEvent(CanvasChangeEvent.ChangeType.propertiesChange);
        this.mMainDialog.setCursor(null);
    }
}

