/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.graphs.chart_builder.undo;

import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.CanvasChangeEvent;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.CanvasImager;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ChartBuilderDlg;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ChartCanvas;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.Coords;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.DropZone;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ZoneChangeType;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ZoneMgr;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ZoneType;
import com.spss.vizimager.VizDataReader;
import com.spss.vizimager.VizDataWriter;
import java.awt.Cursor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.nio.ByteBuffer;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;

public class ModifyLegendZoneEdit
extends AbstractUndoableEdit {
    private ChartBuilderDlg mMainDialog;
    private ByteBuffer mBuffer;

    public ModifyLegendZoneEdit(UndoManager undoManager, ChartBuilderDlg chartBuilderDlg, ModifyContainer modifyContainer) {
        this.mMainDialog = chartBuilderDlg;
        ChartCanvas chartCanvas = chartBuilderDlg.getCanvas();
        ZoneMgr zoneMgr = chartCanvas.getZoneMgr();
        CanvasImager canvasImager = chartCanvas.getImager();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        boolean bl = chartBuilderDlg.getCanvas().serializeOut(dataOutputStream);
        if (bl) {
            this.mBuffer = VizDataWriter.compressStream((ByteBuffer)ByteBuffer.wrap(byteArrayOutputStream.toByteArray()));
            this.mMainDialog.setCursor(Cursor.getPredefinedCursor(3));
            if (modifyContainer.mArrangementChanged) {
                ZoneType zoneType = this.getZoneType(modifyContainer.mArrangement);
                ZoneType zoneType2 = this.getZoneType(modifyContainer.mOldArrangement);
                zoneMgr.setZoneType(modifyContainer.mZone, zoneType);
                canvasImager.zoneChange(zoneMgr, zoneType2, ZoneChangeType.removeZone);
                canvasImager.zoneChange(zoneMgr, zoneType, ZoneChangeType.addZone);
            }
            if (modifyContainer.mColorsChanged || modifyContainer.mArrangementChanged) {
                modifyContainer.mZone.setUsesColorStyling(modifyContainer.mWantColors);
                canvasImager.setCycleForZoneType(modifyContainer.mZone.getZoneType(), modifyContainer.mWantColors);
                if (modifyContainer.mColorsChanged && canvasImager.getCoordinates() == Coords.coords_3D) {
                    this.handle3DAestheticSwap(modifyContainer.mZone, !modifyContainer.mWantColors);
                }
                chartCanvas.repaint();
            }
            this.mMainDialog.getCanvas().fireChangeEvent(CanvasChangeEvent.ChangeType.propertiesChange);
            this.mMainDialog.setCursor(null);
            this.mMainDialog.getCanvas().requestFocusInWindow();
            undoManager.addEdit(this);
        }
    }

    @Override
    public String getPresentationName() {
        return this.mMainDialog.getResString("IDS_EDIT_ZONE");
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.doAction();
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.doAction();
    }

    @Override
    public void die() {
        super.die();
        this.mBuffer = null;
    }

    private void doAction() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        boolean bl = this.mMainDialog.getCanvas().serializeOut(dataOutputStream);
        if (bl) {
            ByteBuffer byteBuffer = VizDataWriter.compressStream((ByteBuffer)ByteBuffer.wrap(byteArrayOutputStream.toByteArray()));
            ByteBuffer byteBuffer2 = VizDataReader.decompressStream((ByteBuffer)this.mBuffer);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteBuffer2.array());
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            this.mMainDialog.getCanvas().serializeIn(dataInputStream);
            this.mBuffer = byteBuffer;
            this.mMainDialog.getCanvas().fireChangeEvent(CanvasChangeEvent.ChangeType.coordinateChange);
        }
    }

    private ZoneType getZoneType(int n) {
        ZoneType zoneType = ZoneType.zt_cluster_x;
        if (n == 2) {
            zoneType = ZoneType.zt_cluster_x;
        } else if (n == 4) {
            zoneType = ZoneType.zt_cluster_z;
        } else if (n == 1) {
            zoneType = ZoneType.zt_group;
        }
        return zoneType;
    }

    private void handle3DAestheticSwap(DropZone dropZone, boolean bl) {
        ZoneMgr zoneMgr = this.mMainDialog.getCanvas().getZoneMgr();
        DropZone dropZone2 = null;
        DropZone dropZone3 = zoneMgr.getZone(ZoneType.zt_cluster_x);
        if (dropZone3 != null && dropZone3.getZoneType() != dropZone.getZoneType()) {
            dropZone2 = dropZone3;
        } else {
            dropZone3 = zoneMgr.getZone(ZoneType.zt_cluster_z);
            if (dropZone3 != null && dropZone3.getZoneType() != dropZone.getZoneType()) {
                dropZone2 = dropZone3;
            } else {
                dropZone3 = zoneMgr.getZone(ZoneType.zt_group);
                if (dropZone3 != null && dropZone3.getZoneType() != dropZone.getZoneType()) {
                    dropZone2 = dropZone3;
                }
            }
        }
        if (dropZone2 == null) {
            return;
        }
        dropZone2.setUsesColorStyling(bl);
        this.mMainDialog.getCanvas().getImager().setCycleForZoneType(dropZone2.getZoneType(), bl);
    }

    public static class ModifyContainer {
        boolean mArrangementChanged;
        boolean mColorsChanged;
        boolean mWantColors;
        int mArrangement;
        int mOldArrangement;
        DropZone mZone;

        public ModifyContainer(DropZone dropZone, boolean bl, boolean bl2, boolean bl3, int n, int n2) {
            this.mZone = dropZone;
            this.mArrangementChanged = bl;
            this.mColorsChanged = bl2;
            this.mWantColors = bl3;
            this.mArrangement = n;
            this.mOldArrangement = n2;
        }
    }
}

