/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.graphs.chart_builder.undo;

import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.CanvasChangeEvent;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ChartBuilderDlg;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.DropZone;
import com.spss.vizimager.VizDataReader;
import com.spss.vizimager.VizDataWriter;
import java.awt.Cursor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.nio.ByteBuffer;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;

public class ClearCanvasEdit
extends AbstractUndoableEdit {
    private ChartBuilderDlg mMainDialog;
    private ByteBuffer mBuffer;

    public ClearCanvasEdit(UndoManager undoManager, ChartBuilderDlg chartBuilderDlg) {
        this.mMainDialog = chartBuilderDlg;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        boolean bl = chartBuilderDlg.getCanvas().serializeOut(dataOutputStream);
        if (bl) {
            this.mBuffer = VizDataWriter.compressStream((ByteBuffer)ByteBuffer.wrap(byteArrayOutputStream.toByteArray()));
            this.mMainDialog.setCursor(Cursor.getPredefinedCursor(3));
            this.mMainDialog.getCanvas().reset();
            DropZone.setRoleStatDisplay(this.mMainDialog.getCanvas().getZoneMgr().hasVariables());
            this.mMainDialog.getCanvas().getParentDlg().showElementProperties(false);
            this.mMainDialog.getCanvas().fireChangeEvent(CanvasChangeEvent.ChangeType.coordinateChange);
            this.mMainDialog.setCursor(null);
            this.mMainDialog.getCanvas().requestFocusInWindow();
            undoManager.addEdit(this);
        }
    }

    @Override
    public String getPresentationName() {
        return this.mMainDialog.getResString("IDS_CLEAR_CANVAS");
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.doAction();
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.doAction();
    }

    @Override
    public void die() {
        super.die();
        this.mBuffer = null;
    }

    private void doAction() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        boolean bl = this.mMainDialog.getCanvas().serializeOut(dataOutputStream);
        if (bl) {
            ByteBuffer byteBuffer = VizDataWriter.compressStream((ByteBuffer)ByteBuffer.wrap(byteArrayOutputStream.toByteArray()));
            ByteBuffer byteBuffer2 = VizDataReader.decompressStream((ByteBuffer)this.mBuffer);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteBuffer2.array());
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            this.mMainDialog.getCanvas().serializeIn(dataInputStream);
            this.mBuffer = byteBuffer;
            this.mMainDialog.getCanvas().fireChangeEvent(CanvasChangeEvent.ChangeType.coordinateChange);
        }
    }
}

