/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.graphs.chart_builder.undo;

import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.CanvasChangeEvent;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ChartBuilderDlg;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ChartCanvas;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.Coords;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.DropZone;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ZoneType;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.properties.IPropEnum;
import com.spss.vizimager.VizDataReader;
import com.spss.vizimager.VizDataWriter;
import java.awt.Cursor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.nio.ByteBuffer;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;

public class ChangeCoordsEdit
extends AbstractUndoableEdit {
    private ChartBuilderDlg mMainDialog;
    private ByteBuffer mBuffer;

    public ChangeCoordsEdit(UndoManager undoManager, ChartBuilderDlg chartBuilderDlg, Coords coords) {
        this.mMainDialog = chartBuilderDlg;
        ChartCanvas chartCanvas = this.mMainDialog.getCanvas();
        boolean bl = chartCanvas.getImager().hasSSVs();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        boolean bl2 = chartBuilderDlg.getCanvas().serializeOut(dataOutputStream);
        if (bl2) {
            this.mBuffer = VizDataWriter.compressStream((ByteBuffer)ByteBuffer.wrap(byteArrayOutputStream.toByteArray()));
            this.mMainDialog.setCursor(Cursor.getPredefinedCursor(3));
            Coords coords2 = chartCanvas.getImager().getCoordinates();
            if (chartCanvas.isTransposed()) {
                chartCanvas.transpose();
            }
            chartCanvas.getImager().setCoordinates(coords);
            chartCanvas.rebuildZones(coords2, true);
            if (bl) {
                ZoneType zoneType = chartCanvas.getZoneMgr().getIndexVarZoneType();
                if (!chartCanvas.getImager().hasSSVs() || zoneType == null) {
                    chartCanvas.getZoneMgr().removeSSVVariables();
                }
            }
            chartCanvas.recalcLayout();
            DropZone.setRoleStatDisplay(chartCanvas.getZoneMgr().hasVariables());
            chartCanvas.getParentDlg().showElementProperties(true);
            chartCanvas.fireChangeEvent(CanvasChangeEvent.ChangeType.coordinateChange);
            chartBuilderDlg.selectEPItem(IPropEnum.ElementPanelType.ept_Axis, 0);
            this.mMainDialog.setCursor(null);
            chartCanvas.requestFocusInWindow();
            undoManager.addEdit(this);
        }
    }

    @Override
    public String getPresentationName() {
        return this.mMainDialog.getResString("IDS_CHANGE_COORDINATES");
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.doAction();
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.doAction();
    }

    @Override
    public void die() {
        super.die();
        this.mBuffer = null;
    }

    private void doAction() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        boolean bl = this.mMainDialog.getCanvas().serializeOut(dataOutputStream);
        if (bl) {
            ByteBuffer byteBuffer = VizDataWriter.compressStream((ByteBuffer)ByteBuffer.wrap(byteArrayOutputStream.toByteArray()));
            ByteBuffer byteBuffer2 = VizDataReader.decompressStream((ByteBuffer)this.mBuffer);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteBuffer2.array());
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            this.mMainDialog.getCanvas().serializeIn(dataInputStream);
            this.mBuffer = byteBuffer;
            this.mMainDialog.getCanvas().fireChangeEvent(CanvasChangeEvent.ChangeType.coordinateChange);
        }
    }
}

