/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.graphs.chart_builder.undo;

import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.CanvasChangeEvent;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ChartBuilderDlg;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ChartCanvas;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.DropZone;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ZoneChangeType;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ZoneType;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.properties.IPropEnum;
import com.spss.vizimager.VizDataReader;
import com.spss.vizimager.VizDataWriter;
import java.awt.Cursor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.nio.ByteBuffer;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;

public class AddZoneEdit
extends AbstractUndoableEdit {
    private ChartBuilderDlg mMainDialog;
    private ByteBuffer mBuffer;

    public AddZoneEdit(UndoManager undoManager, ChartBuilderDlg chartBuilderDlg, ZoneType zoneType) {
        this.mMainDialog = chartBuilderDlg;
        ChartCanvas chartCanvas = this.mMainDialog.getCanvas();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        boolean bl = chartCanvas.serializeOut(dataOutputStream);
        if (bl) {
            this.mBuffer = VizDataWriter.compressStream((ByteBuffer)ByteBuffer.wrap(byteArrayOutputStream.toByteArray()));
            this.mMainDialog.setCursor(Cursor.getPredefinedCursor(3));
            chartCanvas.getZoneMgr().addZone(chartCanvas, zoneType);
            chartCanvas.getImager().zoneChange(chartCanvas.getZoneMgr(), zoneType, ZoneChangeType.addZone);
            DropZone dropZone = chartCanvas.getZoneMgr().getZone(zoneType);
            if (dropZone.isStyleByZone()) {
                dropZone.setUsesColorStyling(chartCanvas.getImager().getUsesColorForStyleByType(zoneType));
            }
            DropZone.setRoleStatDisplay(chartCanvas.getZoneMgr().hasVariables());
            chartCanvas.getParentDlg().showElementProperties(true);
            chartCanvas.fireChangeEvent(CanvasChangeEvent.ChangeType.elementChange);
            this.mMainDialog.setCursor(null);
            if (this.isLegendItem(zoneType)) {
                chartBuilderDlg.selectEPItem(IPropEnum.ElementPanelType.ept_Legend, this.getLegendPos(zoneType));
            }
            chartCanvas.requestFocusInWindow();
            undoManager.addEdit(this);
        }
    }

    @Override
    public String getPresentationName() {
        return this.mMainDialog.getResString("IDS_ADD_ZONE");
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.doAction();
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.doAction();
    }

    @Override
    public void die() {
        super.die();
        this.mBuffer = null;
    }

    private void doAction() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        boolean bl = this.mMainDialog.getCanvas().serializeOut(dataOutputStream);
        if (bl) {
            ByteBuffer byteBuffer = VizDataWriter.compressStream((ByteBuffer)ByteBuffer.wrap(byteArrayOutputStream.toByteArray()));
            ByteBuffer byteBuffer2 = VizDataReader.decompressStream((ByteBuffer)this.mBuffer);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteBuffer2.array());
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            this.mMainDialog.getCanvas().serializeIn(dataInputStream);
            this.mBuffer = byteBuffer;
            this.mMainDialog.getCanvas().fireChangeEvent(CanvasChangeEvent.ChangeType.coordinateChange);
        }
    }

    private boolean isLegendItem(ZoneType zoneType) {
        return zoneType == ZoneType.zt_cluster_x || zoneType == ZoneType.zt_cluster_z || zoneType == ZoneType.zt_group || zoneType == ZoneType.zt_slice_by || zoneType == ZoneType.zt_split_var;
    }

    private int getLegendPos(ZoneType zoneType) {
        int n = 0;
        if (zoneType == ZoneType.zt_cluster_z && this.mMainDialog.getCanvas().getZoneMgr().hasZone(ZoneType.zt_cluster_x)) {
            n = 1;
        } else if (zoneType == ZoneType.zt_group && (this.mMainDialog.getCanvas().getZoneMgr().hasZone(ZoneType.zt_cluster_x) || this.mMainDialog.getCanvas().getZoneMgr().hasZone(ZoneType.zt_cluster_z))) {
            n = 1;
        }
        return n;
    }
}

