/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.graphs.chart_builder.undo;

import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.CanvasChangeEvent;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ChartBuilderDlg;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ChartCanvas;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.DropZone;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.IndexVariable;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ZoneChangeType;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ZoneType;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs.SSVQueryDlg;
import com.spss.vizimager.VizDataReader;
import com.spss.vizimager.VizDataWriter;
import java.awt.Cursor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.nio.ByteBuffer;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;

public class AddVariablesEdit
extends AbstractUndoableEdit {
    private ChartBuilderDlg mMainDialog;
    private ByteBuffer mBuffer;

    public AddVariablesEdit(UndoManager undoManager, ChartBuilderDlg chartBuilderDlg, ZoneType zoneType, ISpssVariable[] iSpssVariableArray) {
        int n;
        this.mMainDialog = chartBuilderDlg;
        ChartCanvas chartCanvas = this.mMainDialog.getCanvas();
        ISpssVariable[] iSpssVariableArray2 = new ISpssVariable[iSpssVariableArray.length];
        try {
            for (n = 0; n < iSpssVariableArray.length; ++n) {
                iSpssVariableArray2[n] = iSpssVariableArray[n].clone();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
        }
        n = chartCanvas.getImager().isOverlayScatter() ? 1 : 0;
        boolean bl = chartCanvas.getImager().hasSSVs() || chartCanvas.getZoneMgr().getIndexVarZoneType() != null;
        DropZone dropZone = chartCanvas.getZoneMgr().getZone(zoneType);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        boolean bl2 = chartCanvas.serializeOut(dataOutputStream);
        if (bl2) {
            ZoneType zoneType2;
            boolean bl3;
            this.mBuffer = VizDataWriter.compressStream((ByteBuffer)ByteBuffer.wrap(byteArrayOutputStream.toByteArray()));
            this.mMainDialog.setCursor(Cursor.getPredefinedCursor(3));
            dropZone.dropVars(iSpssVariableArray2);
            boolean bl4 = chartCanvas.getImager().isOverlayScatter();
            if (n == 0 && bl4) {
                chartCanvas.adjustOverlayGrouping(true);
            }
            if (n != 0 || bl4) {
                chartCanvas.getImager().updateOverlayYXPairs();
            }
            boolean bl5 = bl3 = dropZone.getVariables().size() > 1 && !bl4 && (zoneType == ZoneType.zt_y || zoneType == ZoneType.zt_angle);
            if (!bl && bl3) {
                if (!this.checkForSSVs(zoneType, iSpssVariableArray2)) {
                    this.mMainDialog.setCursor(null);
                    return;
                }
            } else if (bl && (zoneType == ZoneType.zt_angle || zoneType == ZoneType.zt_y) && (zoneType2 = chartCanvas.getZoneMgr().getIndexVarZoneType()) != null) {
                DropZone dropZone2 = chartCanvas.getZoneMgr().getZone(zoneType2);
                DropZone.updateIndexValueLabelMap(chartCanvas, (IndexVariable)dropZone2.getVariables().get(0));
                chartCanvas.getImager().zoneChange(chartCanvas.getZoneMgr(), zoneType2, ZoneChangeType.addVariable);
                chartCanvas.getImager().addSSVVariables(iSpssVariableArray2);
            }
            chartCanvas.getImager().zoneChange(chartCanvas.getZoneMgr(), dropZone.getZoneType(), ZoneChangeType.addVariable);
            if (!chartCanvas.checkForHistogramChange(dropZone.getZoneType())) {
                chartCanvas.checkStatistic();
            }
            DropZone.setRoleStatDisplay(chartCanvas.getZoneMgr().hasVariables());
            chartCanvas.fireChangeEvent(CanvasChangeEvent.ChangeType.variableChange);
            chartCanvas.getZoneMgr().setFocusZone(dropZone);
            chartCanvas.requestFocusInWindow();
            undoManager.addEdit(this);
        }
        this.mMainDialog.setCursor(null);
    }

    @Override
    public String getPresentationName() {
        return this.mMainDialog.getResString("IDS_ADD_VAR");
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.doAction();
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.doAction();
    }

    @Override
    public void die() {
        super.die();
        this.mBuffer = null;
    }

    private void doAction() {
        this.mMainDialog.setCursor(Cursor.getPredefinedCursor(3));
        ChartCanvas chartCanvas = this.mMainDialog.getCanvas();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        boolean bl = chartCanvas.serializeOut(dataOutputStream);
        if (bl) {
            ByteBuffer byteBuffer = VizDataWriter.compressStream((ByteBuffer)ByteBuffer.wrap(byteArrayOutputStream.toByteArray()));
            ByteBuffer byteBuffer2 = VizDataReader.decompressStream((ByteBuffer)this.mBuffer);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteBuffer2.array());
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            this.mMainDialog.getCanvas().serializeIn(dataInputStream);
            this.mBuffer = byteBuffer;
        }
        chartCanvas.repaint();
        chartCanvas.fireChangeEvent(CanvasChangeEvent.ChangeType.variableChange);
        this.mMainDialog.setCursor(null);
        chartCanvas.requestFocusInWindow();
    }

    private boolean checkForSSVs(ZoneType zoneType, ISpssVariable[] iSpssVariableArray) {
        if (zoneType != ZoneType.zt_y && zoneType != ZoneType.zt_angle) {
            return true;
        }
        return SSVQueryDlg.runDialog(this.mMainDialog, zoneType, iSpssVariableArray);
    }
}

