/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.graphs.chart_builder.undo;

import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.CanvasChangeEvent;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ChartBuilderDlg;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ChartCanvas;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.Coords;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.DropZone;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.Elements;
import com.spss.vizimager.VizDataReader;
import com.spss.vizimager.VizDataWriter;
import java.awt.Cursor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.nio.ByteBuffer;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;

public class AddElementEdit
extends AbstractUndoableEdit {
    private ChartBuilderDlg mMainDialog;
    private ByteBuffer mBuffer;

    public AddElementEdit(UndoManager undoManager, ChartBuilderDlg chartBuilderDlg, Elements elements) {
        this.mMainDialog = chartBuilderDlg;
        ChartCanvas chartCanvas = this.mMainDialog.getCanvas();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        boolean bl = chartCanvas.serializeOut(dataOutputStream);
        if (bl) {
            this.mBuffer = VizDataWriter.compressStream((ByteBuffer)ByteBuffer.wrap(byteArrayOutputStream.toByteArray()));
            this.mMainDialog.setCursor(Cursor.getPredefinedCursor(3));
            Coords coords = chartCanvas.getImager().getCoordinates();
            chartCanvas.getImager().addDataElement(elements);
            chartCanvas.rebuildZones(coords, false);
            chartCanvas.checkStatistic();
            chartCanvas.recalcLayout();
            DropZone.setRoleStatDisplay(chartCanvas.getZoneMgr().hasVariables());
            chartCanvas.getParentDlg().showElementProperties(true);
            chartCanvas.fireChangeEvent(CanvasChangeEvent.ChangeType.elementChange);
            this.mMainDialog.setCursor(null);
            chartCanvas.requestFocusInWindow();
            undoManager.addEdit(this);
        }
    }

    @Override
    public String getPresentationName() {
        return this.mMainDialog.getResString("IDS_ADD_ELEMENT");
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.doAction();
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.doAction();
    }

    @Override
    public void die() {
        super.die();
        this.mBuffer = null;
    }

    private void doAction() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        boolean bl = this.mMainDialog.getCanvas().serializeOut(dataOutputStream);
        if (bl) {
            ByteBuffer byteBuffer = VizDataWriter.compressStream((ByteBuffer)ByteBuffer.wrap(byteArrayOutputStream.toByteArray()));
            ByteBuffer byteBuffer2 = VizDataReader.decompressStream((ByteBuffer)this.mBuffer);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteBuffer2.array());
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            this.mMainDialog.getCanvas().serializeIn(dataInputStream);
            this.mBuffer = byteBuffer;
            this.mMainDialog.getCanvas().fireChangeEvent(CanvasChangeEvent.ChangeType.coordinateChange);
        }
    }
}

