/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.ui.controls.FocusableTextArea;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ChartCanvas;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs.IModListener;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs.PropertiesPanel;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs.SidePropertiesPanel;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.properties.ChartProps;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.properties.IPropEnum;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.properties.Props;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.res.CommonDlgResBundle;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.uitools.controls.SpssTextArea;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.basic.BasicGraphicsUtils;

public class TitlesPanel
extends PropertiesPanel
implements DocumentListener {
    private static final int AUTO = 0;
    private static final int CUSTOM = 1;
    private static final int NONE = 2;
    private Props.TitleProps mTitleProp = null;
    private JLabel mTextTypeLabel;
    private TheFocusableTextArea mAutoContentEdit;
    private SpssTextArea mCustomContentEdit;
    private JRadioButton[] mRadioBtns = new JRadioButton[3];
    private SpssButtonGroup mButtonGroup;
    private boolean mInReload = false;
    private JPanel mInfoPanel;
    private FocusableTextArea mInfoText;

    public TitlesPanel(ChartCanvas chartCanvas, IModListener iModListener) {
        super(chartCanvas, iModListener);
        this.init();
        this.mCustomContentEdit.getDocument().addDocumentListener(this);
        this.mCustomContentEdit.addFocusListener((FocusListener)this);
    }

    @Override
    public String getPanelId() {
        return "titles_panel";
    }

    @Override
    protected void addTabTraversalComponents(Vector<Object> vector) {
        vector.add(this.mButtonGroup);
        vector.add((Object)this.mAutoContentEdit);
        vector.add(this.mCustomContentEdit);
        vector.add(this.mInfoText);
    }

    @Override
    void initialize(ChartProps chartProps, Props props) {
        this.mInReload = true;
        if (props instanceof Props.TitleProps) {
            SidePropertiesPanel sidePropertiesPanel = this.mCanvas.getParentDlg().getSidePropertiesPanel();
            String string = this.mCanvas.getImager().getChartAppearanceOption().getTemplateTitle(this.mCanvas.titleFlagToTitleType(((Props.TitleProps)props).getTitleType()));
            if (string != null && string.length() > 0) {
                for (JRadioButton jRadioButton : this.mRadioBtns) {
                    jRadioButton.setEnabled(false);
                }
                this.mRadioBtns[0].setSelected(true);
                this.mAutoContentEdit.setText(string);
                this.mAutoContentEdit.setEnabled(false);
                this.mInfoPanel.setVisible(true);
            } else {
                this.mTitleProp = (Props.TitleProps)props;
                this.mRadioBtns[1].setEnabled(true);
                this.mRadioBtns[2].setEnabled(true);
                this.mTextTypeLabel.setText(sidePropertiesPanel.getCurrentListItemTitle());
                int n = this.mTitleProp.getUseIndex();
                String string2 = this.mTitleProp.getTitleType() == IPropEnum.TitleFlag.tf_Title1 ? this.mCanvas.composeDefaultTitle() : this.mCanvas.composeDefaultFootnote();
                boolean bl = (this.mTitleProp.getFlags() & 0x8002) != 0;
                this.mRadioBtns[0].setEnabled(bl);
                this.mAutoContentEdit.setEnabled(bl);
                this.mAutoContentEdit.setText(bl ? string2 : "");
                this.mCustomContentEdit.setText(this.mTitleProp.getStrTitle());
                if (n > -1) {
                    this.mRadioBtns[n].setSelected(true);
                    if (n == 1) {
                        this.mCustomContentEdit.setText(this.mTitleProp.getStrTitle());
                    }
                } else {
                    int n2 = bl && this.mTitleProp.getStrTitle().length() > 0 ? 1 : (!bl ? 1 : 0);
                    this.mRadioBtns[n2].setSelected(true);
                }
                this.mCustomContentEdit.setEnabled(this.mRadioBtns[1].isEnabled() && this.mRadioBtns[1].isSelected());
                this.mInfoPanel.setVisible(false);
            }
        }
        this.mInReload = false;
    }

    @Override
    boolean applyChanges() {
        if (this.mTitleProp != null) {
            int n = this.mRadioBtns[0].isEnabled() ? 32770 : -32771;
            this.mTitleProp.setFlags(this.mTitleProp.getFlags() & n);
            if (this.mRadioBtns[1].isSelected()) {
                this.mTitleProp.setStrTitle(this.mCustomContentEdit.getText());
            } else {
                this.mTitleProp.setStrTitle("");
            }
            int n2 = this.mRadioBtns[0].isSelected() ? 0 : (this.mRadioBtns[1].isSelected() ? 1 : 2);
            this.mTitleProp.setUseIndex(n2);
        }
        this.mIsEditFieldDirty = false;
        return true;
    }

    @Override
    protected String getDlgHelpId() {
        return "idh_idc_cg_help_title_props";
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        if (this.mInReload) {
            return;
        }
        this.mIsEditFieldDirty = true;
        this.mTitleProp.setFlags(this.mTitleProp.getFlags() & 0xFFFF7FFF);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        if (this.mInReload) {
            return;
        }
        this.mIsEditFieldDirty = true;
        this.mTitleProp.setFlags(this.mTitleProp.getFlags() & 0xFFFF7FFF);
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        if (this.mInReload) {
            return;
        }
        this.mIsEditFieldDirty = true;
        this.mTitleProp.setFlags(this.mTitleProp.getFlags() & 0xFFFF7FFF);
    }

    private void init() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        JLabel jLabel = new JLabel(this.mCanvas.getResources().getResString("IDS_TEXT_TYPE"));
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(n2 * 3, 3, n2, 2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(this, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        this.mTextTypeLabel = new JLabel("");
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        insets = new Insets(n2 * 3, 0, n2, 3);
        DialogUtil.addUsingGBL(this, this.mTextTypeLabel, gridBagConstraints, 1, 0, 1, 1, n, insets);
        this.mRadioBtns[0] = new JRadioButton(new TheRadioAction("IDS_TITLE_AUTOMATIC", "IDK_TITLE_AUTOMATIC_KEY"));
        DialogUtil.addUsingGBL(this, this.mRadioBtns[0], gridBagConstraints, 0, 1, 2, 1, n, insets);
        this.mAutoContentEdit = new TheFocusableTextArea(6, 6, ComponentState.getCurrentCharset());
        this.mAutoContentEdit.setLineWrap(true);
        this.mAutoContentEdit.setWrapStyleWord(true);
        this.mAutoContentEdit.setOpaque(false);
        this.mAutoContentEdit.setEditable(false);
        this.mAutoContentEdit.setRows(3);
        insets = new Insets(0, 3, n2, 3);
        DialogUtil.addUsingGBL(this, (JComponent)((Object)this.mAutoContentEdit), gridBagConstraints, 0, 2, 2, 1, n, insets);
        insets = new Insets(3, 3, 1, 3);
        this.mRadioBtns[1] = new JRadioButton(new TheRadioAction("IDS_TITLE_CUSTOM", "IDK_TITLE_CUSTOM_KEY"));
        DialogUtil.addUsingGBL(this, this.mRadioBtns[1], gridBagConstraints, 0, 3, 2, 1, n, insets);
        this.mCustomContentEdit = new SpssTextArea(6, 6, ComponentState.getCurrentCharset());
        this.mCustomContentEdit.setLineWrap(true);
        this.mCustomContentEdit.setWrapStyleWord(true);
        this.mCustomContentEdit.setFocusTraversalKeys(0, null);
        this.mCustomContentEdit.setFocusTraversalKeys(1, null);
        JScrollPane jScrollPane = new JScrollPane((Component)this.mCustomContentEdit, 21, 31);
        jScrollPane.setPreferredSize(new Dimension(80, 60));
        insets = new Insets(0, 3, n2, 3);
        DialogUtil.addUsingGBL(this, jScrollPane, gridBagConstraints, 0, 4, 2, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        this.mRadioBtns[2] = new JRadioButton(new TheRadioAction("IDS_TITLE_NONE", "IDK_TITLE_NONE_KEY"));
        DialogUtil.addUsingGBL(this, this.mRadioBtns[2], gridBagConstraints, 0, 5, 2, 1, n, insets);
        this.mButtonGroup = new SpssButtonGroup();
        for (int i = 0; i <= 2; ++i) {
            this.mButtonGroup.add(this.mRadioBtns[i]);
        }
        ResourceBundle resourceBundle = ResUtil.getBundle(CommonDlgResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
        URL uRL = ResUtil.getImageResourceFullPath(CommonDlgResBundle.getImageFolder() + ResUtil.getString(resourceBundle, "IDS_INFO_DOT_IMAGE"));
        JLabel jLabel2 = new JLabel(new ImageIcon(uRL));
        this.mInfoText = new FocusableTextArea(this.mCanvas.getResources().getResString("IDS_TITLE_INFO_TEXT"), null);
        this.mInfoText.setPreferredSize(new Dimension(300, 42));
        this.mInfoPanel = new JPanel(new FlowLayout(0));
        this.mInfoPanel.add(jLabel2);
        this.mInfoPanel.add(this.mInfoText);
        insets.top += 5;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(this, this.mInfoPanel, gridBagConstraints, 0, 6, 2, 1, n, insets);
    }

    class TheRadioAction
    extends AbstractAction {
        TheRadioAction(String string, String string2) {
            this.putValue("Name", TitlesPanel.this.mCanvas.getResources().getResString(string));
            this.putValue("MnemonicKey", TitlesPanel.this.mCanvas.getResources().getDlgAccessKey(string2));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TitlesPanel.this.mCustomContentEdit.setEnabled(TitlesPanel.this.mRadioBtns[1].isEnabled() && TitlesPanel.this.mRadioBtns[1].isSelected());
            Object object = actionEvent.getSource();
            if (object == TitlesPanel.this.mRadioBtns[0] && TitlesPanel.this.mAutoContentEdit.getText().length() == 0) {
                TitlesPanel.this.mAutoContentEdit.setText(TitlesPanel.this.mCanvas.composeDefaultTitle());
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TitlesPanel.this.mModListener.itemModified();
                }
            });
        }
    }

    class TheFocusableTextArea
    extends SpssTextArea {
        public TheFocusableTextArea(int n, int n2, Charset charset) {
            super(n, n2, charset);
            this.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    TheFocusableTextArea.this.repaint();
                }

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    TheFocusableTextArea.this.repaint();
                }
            });
            this.setFocusable(true);
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            if (this.hasFocus()) {
                this.paintFocus(graphics);
            }
        }

        private void paintFocus(Graphics graphics) {
            Color color = UIManager.getColor("ToggleButton.focus");
            graphics.setColor(color);
            Rectangle rectangle = new Rectangle(0, 0, this.getBounds().width, this.getBounds().height);
            BasicGraphicsUtils.drawDashedRect(graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }
}

