/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ChartBuilderDlg;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ChartCanvas;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.Coords;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.Elements;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.Statistics;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs.IModListener;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs.IStatChangeListener;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.dialogs.ParametersDlg;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.properties.ChartProps;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.properties.ElementStat;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.properties.IPropEnum;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.properties.Props;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class StatisticsPanel
extends JPanel
implements ActionListener {
    protected ChartCanvas mCanvas;
    protected JLabel mVarPrompt;
    protected JLabel mVarLabel;
    protected JLabel mStatLabel;
    protected JComboBox mStatsList;
    protected JButton mParametersButton;
    protected boolean mInReload;
    protected IModListener mModListener;
    protected Props.ElProps mElProp;
    protected ElementStat mElStat;
    protected ElementStat mWorkStat;
    protected HashMap<Statistics, StringPair> mParameters = new HashMap();
    protected Vector<IStatChangeListener> mStatChangeListeners = new Vector();
    protected boolean mHasErrorBars = false;

    public StatisticsPanel(ChartCanvas chartCanvas, IModListener iModListener) {
        super(new GridBagLayout(), true);
        this.mCanvas = chartCanvas;
        this.mModListener = iModListener;
        this.mInReload = false;
        this.initControls();
        this.enableControls(false);
        this.mStatsList.addActionListener(this);
    }

    public void setVarName(String string, Icon icon) {
        this.mVarPrompt.setEnabled(string != null && string.length() > 0);
        this.mVarLabel.setIcon(icon);
        if (ComponentState.isBtdRtlOrLtr()) {
            this.mVarLabel.setText(ComponentState.prepareStringForBidiRendering((String)string));
        } else {
            this.mVarLabel.setText(string);
        }
    }

    public void enableStatisticsList(boolean bl) {
        this.mStatLabel.setEnabled(bl);
        this.mStatsList.setEnabled(bl);
        this.mParametersButton.setEnabled(bl && !this.isErrorBarPct());
    }

    public void addStatChangeListener(IStatChangeListener iStatChangeListener) {
        if (!this.mStatChangeListeners.contains(iStatChangeListener)) {
            this.mStatChangeListeners.add(iStatChangeListener);
        }
    }

    public void removeStatChangeListener(IStatChangeListener iStatChangeListener) {
        this.mStatChangeListeners.remove(iStatChangeListener);
    }

    void addTabTraversalComponents(Vector<Object> vector) {
        vector.add(this.mVarPrompt);
        vector.add(this.mVarLabel);
        vector.add(this.mStatsList);
        vector.add(this.mParametersButton);
    }

    void initialize(ChartProps chartProps, Props.ElProps elProps) {
        this.mInReload = true;
        this.mHasErrorBars = false;
        this.mParameters.clear();
        this.mElProp = elProps;
        this.mElStat = elProps.getStatistic();
        try {
            this.mWorkStat = new ElementStat(elProps.clone());
            this.mWorkStat.assign(this.mElStat);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
        }
        String string = this.mElStat.getVarLabel();
        ISpssVariable iSpssVariable = this.mElStat.getVariable();
        boolean bl = iSpssVariable != null;
        this.mVarPrompt.setEnabled(bl);
        this.mVarLabel.setIcon(bl ? VariableList.getStandardIcon(iSpssVariable) : null);
        if (ComponentState.isBtdRtlOrLtr()) {
            this.mVarLabel.setText(ComponentState.prepareStringForBidiRendering((String)string));
        } else {
            this.mVarLabel.setText(string);
        }
        this.mVarLabel.setToolTipText(string);
        Statistics statistics = Statistics.Value;
        this.loadStatsList(chartProps);
        this.enableControls(true);
        if (elProps.getElement() == Elements.schema) {
            this.mStatsList.insertItemAt(new StatItem(Statistics.Boxplot), 0);
            this.selectStat(Statistics.Boxplot);
            this.mStatLabel.setEnabled(false);
            this.mStatsList.setEnabled(false);
        } else if (elProps.getElement() == Elements.point && chartProps.getCoords() == Coords.coords_1D) {
            this.mStatsList.insertItemAt(new StatItem(Statistics.Dotplot), 0);
            this.selectStat(Statistics.Dotplot);
            this.mStatLabel.setEnabled(false);
            this.mStatsList.setEnabled(false);
        } else if (elProps.getElement() == Elements.splom) {
            this.selectStat(Statistics.Value);
            this.mStatLabel.setEnabled(false);
            this.mStatsList.setEnabled(false);
        } else {
            statistics = this.mElStat.getStat();
            this.selectStat(statistics);
        }
        this.updateCurrentStatisticParms();
        this.mParametersButton.setEnabled((this.parameterCount(statistics) > 0 || this.isHistogram(statistics)) && !this.isErrorBarPct());
        this.mInReload = false;
    }

    boolean isHistogram(Statistics statistics) {
        return statistics == Statistics.Histogram || statistics == Statistics.HistogramPct;
    }

    boolean applyChanges() {
        StatItem statItem = (StatItem)this.mStatsList.getSelectedItem();
        if (statItem == null) {
            return false;
        }
        this.mElStat.setStrParm1(this.mWorkStat.getStrParm1());
        this.mElStat.setStrParm2(this.mWorkStat.getStrParm2());
        this.mElStat.setPctBaseType(this.mWorkStat.getPctBaseType());
        this.mElStat.setStat(statItem.getStat());
        if (this.isHistogram(statItem.getStat())) {
            this.mElStat.setAnchorType(this.mWorkStat.getAnchorType());
            this.mElStat.setBinSize(this.mWorkStat.getBinSize());
            this.mElStat.setBinSizeCustom(this.mWorkStat.getBinSizeCustom());
        } else if (this.parameterCount(statItem.getStat()) == 0) {
            this.mElStat.setStrParm1("");
            this.mElStat.setStrParm2("");
            this.mElStat.setPctBaseType(IPropEnum.PercentageBaseType.pbt_GrandTotal);
        }
        return true;
    }

    void enableControls(boolean bl) {
        this.mVarPrompt.setEnabled(bl);
        if (this.mVarLabel != null) {
            this.mVarLabel.setEnabled(bl);
        }
        if (this.mStatLabel != null) {
            this.mStatLabel.setEnabled(bl);
        }
        this.mStatsList.setEnabled(bl);
        this.mParametersButton.setEnabled(bl && !this.isErrorBarPct());
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.mInReload) {
            return;
        }
        int n = this.mStatsList.getSelectedIndex();
        if (n > -1) {
            StatItem statItem = (StatItem)this.mStatsList.getModel().getSelectedItem();
            this.mWorkStat.setStat(statItem.getStat());
            this.mWorkStat.setPctBaseType(IPropEnum.PercentageBaseType.pbt_GrandTotal);
            StringPair stringPair = this.mParameters.get((Object)statItem.getStat());
            if (stringPair != null) {
                this.mWorkStat.setStrParm1(stringPair.mString1);
                this.mWorkStat.setStrParm2(stringPair.mString2);
            } else {
                this.mWorkStat.setStrParm1("");
                this.mWorkStat.setStrParm2("");
            }
            if (this.isHistogram(statItem.getStat())) {
                this.mWorkStat.setAnchorType(0);
                this.mWorkStat.setBinSize(0);
                this.mWorkStat.setBinSizeCustom(0);
            }
            this.mParametersButton.setEnabled((this.parameterCount(statItem.getStat()) > 0 || this.isHistogram(statItem.getStat())) && !this.isErrorBarPct());
            if (this.mWorkStat.getStat() == Statistics.PctOfCases) {
                this.updateCurrentStatisticParms();
            }
            this.fireStatChange();
            if (this.mStatsList.getSelectedItem().toString().indexOf(63) == -1) {
                this.mModListener.itemModified();
            } else {
                this.mModListener.clearModFlag();
            }
        }
    }

    protected void fireStatChange() {
        int n = this.mStatsList.getSelectedIndex();
        if (n > -1) {
            StatItem statItem = (StatItem)this.mStatsList.getModel().getSelectedItem();
            for (IStatChangeListener iStatChangeListener : this.mStatChangeListeners) {
                iStatChangeListener.statisticChanged(statItem.getStat());
            }
        }
    }

    protected void selectStat(Statistics statistics) {
        int n = -1;
        for (int i = 0; i < this.mStatsList.getModel().getSize(); ++i) {
            StatItem statItem = (StatItem)this.mStatsList.getModel().getElementAt(i);
            if (statistics != statItem.getStat()) continue;
            n = i;
            break;
        }
        this.mStatsList.setSelectedIndex(n);
    }

    protected void loadStatsList(ChartProps chartProps) {
        Statistics[] statisticsArray = new Statistics[]{Statistics.Histogram, Statistics.HistogramPct, Statistics.Count, Statistics.CumCount, Statistics.PctOfCases, Statistics.CumPct, Statistics.Value, Statistics.Mean, Statistics.Median, Statistics.GMedian, Statistics.Mode, Statistics.Minimum, Statistics.Maximum, Statistics.ValidN, Statistics.Sum, Statistics.CumSum, Statistics.PTile, Statistics.GPTile, Statistics.StdDev, Statistics.Variance, Statistics.PctBelow, Statistics.PctAbove, Statistics.NumBelow, Statistics.NumAbove, Statistics.PctInside, Statistics.NumInside, Statistics.Responses, Statistics.CumResponses, Statistics.ResponsePct, Statistics.CumResponsePct};
        int n = this.mElProp == chartProps.getElementProp(1) ? 1 : 0;
        this.mStatsList.removeAllItems();
        for (Statistics statistics : statisticsArray) {
            if (!this.mCanvas.legalStat(chartProps, statistics, n)) continue;
            this.mStatsList.addItem(new StatItem(statistics));
        }
    }

    protected void initControls() {
        this.setBorder(BorderFactory.createTitledBorder(this.mCanvas.getResources().getResString("IDS_STATISTICS")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(0, n2, 0, n2);
        this.mVarPrompt = new JLabel(this.mCanvas.getResources().getResString("IDS_VARIABLE"));
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(this, this.mVarPrompt, gridBagConstraints, 0, 0, 1, 1, n, insets);
        this.mVarLabel = new JLabel();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(this, this.mVarLabel, gridBagConstraints, 1, 0, 1, 1, n, insets);
        this.mStatLabel = new JLabel(this.mCanvas.getResources().getResString("IDS_STATISTIC_COLON"));
        this.mStatLabel.setDisplayedMnemonic(this.mCanvas.getResources().getDlgAccessKey("IDK_STATISTIC_COLON_KEY"));
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(this, this.mStatLabel, gridBagConstraints, 0, 1, 2, 1, n, insets);
        this.mStatsList = new JComboBox();
        DialogUtil.addUsingGBL(this, this.mStatsList, gridBagConstraints, 0, 2, 2, 1, n, insets);
        this.mStatLabel.setLabelFor(this.mStatsList);
        this.mParametersButton = new JButton(new SetParmsAction());
        n = 26;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(this, this.mParametersButton, gridBagConstraints, 1, 3, 1, 1, n, new Insets(2, 0, 0, n2));
        this.mParametersButton.setMargin(new Insets(0, n2, 0, n2));
    }

    int parameterCount(Statistics statistics) {
        int n = 0;
        if (statistics == Statistics.PctOfCases || statistics == Statistics.PTile || statistics == Statistics.GPTile || statistics == Statistics.NumAbove || statistics == Statistics.NumBelow || statistics == Statistics.PctAbove || statistics == Statistics.PctBelow) {
            n = 1;
        } else if (statistics == Statistics.NumInside || statistics == Statistics.PctInside) {
            n = 2;
        }
        return n;
    }

    ChartBuilderDlg getParentDlg() {
        Container container;
        for (container = this.getParent(); container != null && !(container instanceof ChartBuilderDlg); container = container.getParent()) {
        }
        return container != null ? (ChartBuilderDlg)((Object)container) : null;
    }

    void updateCurrentStatisticParms() {
        int n = this.mStatsList.getSelectedIndex();
        if (n > -1) {
            StatItem statItem = (StatItem)this.mStatsList.getModel().getSelectedItem();
            statItem.updateNameString(this.mWorkStat);
            this.mParameters.put(this.mWorkStat.getStat(), new StringPair(this.mWorkStat.getStrParm1(), this.mWorkStat.getStrParm2()));
            this.mStatsList.repaint();
        }
    }

    public void updateForErrorBars(boolean bl) {
        this.mHasErrorBars = bl;
        if (this.isErrorBarPct() && this.mWorkStat.getPctBaseType() != IPropEnum.PercentageBaseType.pbt_GrandTotal) {
            this.mWorkStat.setPctBaseType(IPropEnum.PercentageBaseType.pbt_GrandTotal);
            SpssAlertOptionPane.showInformationMessageDialog(this, this.mCanvas.getParentDlg().getResString("IDS_RESET_PCT_BASE"), VersionInfo.getAppVersionString());
        }
        this.mParametersButton.setEnabled((this.parameterCount(this.mWorkStat.getStat()) > 0 || this.isHistogram(this.mWorkStat.getStat())) && !this.isErrorBarPct());
    }

    private boolean isErrorBarPct() {
        return this.mWorkStat != null && this.mWorkStat.getStat() == Statistics.PctOfCases && this.mHasErrorBars;
    }

    class StringPair {
        String mString1 = "";
        String mString2 = "";

        public StringPair(String string, String string2) {
            this.mString1 = string;
            this.mString2 = string2;
        }
    }

    class StatItem {
        private Statistics mStat;
        private String mName;

        StatItem(Statistics statistics) {
            this.mStat = statistics;
            int n = StatisticsPanel.this.parameterCount(this.mStat);
            if (n == 1) {
                String string = this.mStat.getUserString(StatisticsPanel.this.mCanvas.getResources());
                this.mName = String.format(string, "?");
            } else if (n == 2) {
                String string = this.mStat.getUserString(StatisticsPanel.this.mCanvas.getResources());
                this.mName = String.format(string, "?", "?");
            } else {
                this.mName = this.mStat.getUserString(StatisticsPanel.this.mCanvas.getResources());
            }
        }

        Statistics getStat() {
            return this.mStat;
        }

        void updateNameString(ElementStat elementStat) {
            int n = StatisticsPanel.this.parameterCount(this.mStat);
            if (n == 1) {
                String string = this.mStat.getUserString(StatisticsPanel.this.mCanvas.getResources());
                this.mName = String.format(string, elementStat.getStrParm1());
            } else if (n == 2) {
                String string = this.mStat.getUserString(StatisticsPanel.this.mCanvas.getResources());
                this.mName = String.format(string, elementStat.getStrParm1(), elementStat.getStrParm2());
            } else {
                this.mName = this.mStat.getUserString(StatisticsPanel.this.mCanvas.getResources());
            }
        }

        public String toString() {
            return this.mName;
        }
    }

    class SetParmsAction
    extends AbstractAction {
        SetParmsAction() {
            this.putValue("Name", StatisticsPanel.this.mCanvas.getResources().getResString("IDS_SET_PARAMETERS"));
            this.putValue("MnemonicKey", StatisticsPanel.this.mCanvas.getResources().getDlgAccessKey("IDK_SET_PARAMETERS_KEY"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ParametersDlg parametersDlg = new ParametersDlg(StatisticsPanel.this.getParentDlg(), StatisticsPanel.this.mWorkStat);
            parametersDlg.setVisible(true);
            if (parametersDlg.getContentModified()) {
                StatisticsPanel.this.updateCurrentStatisticParms();
                StatisticsPanel.this.mModListener.itemModified();
            }
        }
    }
}

